/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.ResolvedSwapLeg;
import com.opengamma.strata.product.swap.SwapLegType;
import java.time.LocalDate;

public interface SwapLeg
extends Resolvable<ResolvedSwapLeg> {
    public SwapLegType getType();

    public PayReceive getPayReceive();

    public AdjustableDate getStartDate();

    public AdjustableDate getEndDate();

    public Currency getCurrency();

    default public ImmutableSet<Currency> allCurrencies() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.collectCurrencies((ImmutableSet.Builder<Currency>)builder);
        return builder.build();
    }

    public void collectCurrencies(ImmutableSet.Builder<Currency> var1);

    default public ImmutableSet<Index> allIndices() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.collectIndices((ImmutableSet.Builder<Index>)builder);
        return builder.build();
    }

    public void collectIndices(ImmutableSet.Builder<Index> var1);

    default public SwapLeg replaceStartDate(LocalDate adjustedStartDate) {
        throw new UnsupportedOperationException("Unable to change start date: " + this.getClass().getSimpleName());
    }

    public ResolvedSwapLeg resolve(ReferenceData var1);
}

