/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap;

import com.opengamma.strata.collect.named.EnumNames;
import com.opengamma.strata.collect.named.NamedEnum;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public enum SwapLegType implements NamedEnum
{
    FIXED,
    IBOR,
    OVERNIGHT,
    INFLATION,
    OTHER;

    private static final EnumNames<SwapLegType> NAMES;

    @FromString
    public static SwapLegType of(String name) {
        return (SwapLegType)NAMES.parse(name);
    }

    public boolean isFixed() {
        return this == FIXED;
    }

    public boolean isFloat() {
        return this == IBOR || this == OVERNIGHT || this == INFLATION;
    }

    @ToString
    public String toString() {
        return NAMES.format((Enum)this);
    }

    static {
        NAMES = EnumNames.of(SwapLegType.class);
    }
}

