/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.FixedFloatSwapConvention;
import com.opengamma.strata.product.swap.type.FixedIborSwapConventions;
import com.opengamma.strata.product.swap.type.FixedIborSwapTemplate;
import com.opengamma.strata.product.swap.type.IborRateSwapLegConvention;
import java.time.LocalDate;
import java.time.Period;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface FixedIborSwapConvention
extends FixedFloatSwapConvention,
Named {
    @FromString
    public static FixedIborSwapConvention of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (FixedIborSwapConvention)FixedIborSwapConvention.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<FixedIborSwapConvention> extendedEnum() {
        return FixedIborSwapConventions.ENUM_LOOKUP;
    }

    @Override
    public IborRateSwapLegConvention getFloatingLeg();

    @Override
    default public SwapTrade createTrade(LocalDate tradeDate, Tenor tenor, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        return FixedFloatSwapConvention.super.createTrade(tradeDate, tenor, buySell, notional, fixedRate, refData);
    }

    @Override
    default public SwapTrade createTrade(LocalDate tradeDate, Period periodToStart, Tenor tenor, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        return FixedFloatSwapConvention.super.createTrade(tradeDate, periodToStart, tenor, buySell, notional, fixedRate, refData);
    }

    @Override
    default public SwapTrade toTrade(LocalDate tradeDate, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double fixedRate) {
        return FixedFloatSwapConvention.super.toTrade(tradeDate, startDate, endDate, buySell, notional, fixedRate);
    }

    @Override
    public SwapTrade toTrade(TradeInfo var1, LocalDate var2, LocalDate var3, BuySell var4, double var5, double var7);

    @Override
    default public LocalDate calculateSpotDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        return this.getSpotDateOffset().adjust(tradeDate, refData);
    }

    @Override
    default public FixedIborSwapTemplate toTemplate(Tenor tenor) {
        return FixedIborSwapTemplate.of(tenor, this);
    }

    @Override
    @ToString
    public String getName();
}

