/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.FixedFloatSwapTemplate;
import com.opengamma.strata.product.swap.type.FixedOvernightSwapConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FixedOvernightSwapTemplate
implements FixedFloatSwapTemplate,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Period periodToStart;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final Tenor tenor;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FixedOvernightSwapConvention convention;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.isFalse((boolean)this.periodToStart.isNegative(), (String)"Period to start must not be negative");
    }

    public static FixedOvernightSwapTemplate of(Tenor tenor, FixedOvernightSwapConvention convention) {
        return FixedOvernightSwapTemplate.of(Period.ZERO, tenor, convention);
    }

    public static FixedOvernightSwapTemplate of(Period periodToStart, Tenor tenor, FixedOvernightSwapConvention convention) {
        return FixedOvernightSwapTemplate.builder().periodToStart(periodToStart).tenor(tenor).convention(convention).build();
    }

    @Override
    public SwapTrade createTrade(LocalDate tradeDate, BuySell buySell, double notional, double fixedRate, ReferenceData refData) {
        return this.convention.createTrade(tradeDate, this.periodToStart, this.tenor, buySell, notional, fixedRate, refData);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FixedOvernightSwapTemplate(Period periodToStart, Tenor tenor, FixedOvernightSwapConvention convention) {
        JodaBeanUtils.notNull((Object)periodToStart, (String)"periodToStart");
        JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
        JodaBeanUtils.notNull((Object)convention, (String)"convention");
        this.periodToStart = periodToStart;
        this.tenor = tenor;
        this.convention = convention;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Period getPeriodToStart() {
        return this.periodToStart;
    }

    @Override
    public Tenor getTenor() {
        return this.tenor;
    }

    @Override
    public FixedOvernightSwapConvention getConvention() {
        return this.convention;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FixedOvernightSwapTemplate other = (FixedOvernightSwapTemplate)obj;
            return JodaBeanUtils.equal((Object)this.periodToStart, (Object)other.periodToStart) && JodaBeanUtils.equal((Object)this.tenor, (Object)other.tenor) && JodaBeanUtils.equal((Object)this.convention, (Object)other.convention);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.periodToStart);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.tenor);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.convention);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("FixedOvernightSwapTemplate{");
        buf.append("periodToStart").append('=').append(JodaBeanUtils.toString((Object)this.periodToStart)).append(',').append(' ');
        buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
        buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FixedOvernightSwapTemplate> {
        private Period periodToStart;
        private Tenor tenor;
        private FixedOvernightSwapConvention convention;

        private Builder() {
        }

        private Builder(FixedOvernightSwapTemplate beanToCopy) {
            this.periodToStart = beanToCopy.getPeriodToStart();
            this.tenor = beanToCopy.getTenor();
            this.convention = beanToCopy.getConvention();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -574688858: {
                    return this.periodToStart;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -574688858: {
                    this.periodToStart = (Period)newValue;
                    break;
                }
                case 110246592: {
                    this.tenor = (Tenor)newValue;
                    break;
                }
                case 2039569265: {
                    this.convention = (FixedOvernightSwapConvention)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FixedOvernightSwapTemplate build() {
            return new FixedOvernightSwapTemplate(this.periodToStart, this.tenor, this.convention);
        }

        public Builder periodToStart(Period periodToStart) {
            JodaBeanUtils.notNull((Object)periodToStart, (String)"periodToStart");
            this.periodToStart = periodToStart;
            return this;
        }

        public Builder tenor(Tenor tenor) {
            JodaBeanUtils.notNull((Object)tenor, (String)"tenor");
            this.tenor = tenor;
            return this;
        }

        public Builder convention(FixedOvernightSwapConvention convention) {
            JodaBeanUtils.notNull((Object)convention, (String)"convention");
            this.convention = convention;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("FixedOvernightSwapTemplate.Builder{");
            buf.append("periodToStart").append('=').append(JodaBeanUtils.toString((Object)this.periodToStart)).append(',').append(' ');
            buf.append("tenor").append('=').append(JodaBeanUtils.toString((Object)this.tenor)).append(',').append(' ');
            buf.append("convention").append('=').append(JodaBeanUtils.toString((Object)this.convention));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Period> periodToStart = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"periodToStart", FixedOvernightSwapTemplate.class, Period.class);
        private final MetaProperty<Tenor> tenor = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"tenor", FixedOvernightSwapTemplate.class, Tenor.class);
        private final MetaProperty<FixedOvernightSwapConvention> convention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"convention", FixedOvernightSwapTemplate.class, FixedOvernightSwapConvention.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"periodToStart", "tenor", "convention"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -574688858: {
                    return this.periodToStart;
                }
                case 110246592: {
                    return this.tenor;
                }
                case 2039569265: {
                    return this.convention;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FixedOvernightSwapTemplate> beanType() {
            return FixedOvernightSwapTemplate.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Period> periodToStart() {
            return this.periodToStart;
        }

        public MetaProperty<Tenor> tenor() {
            return this.tenor;
        }

        public MetaProperty<FixedOvernightSwapConvention> convention() {
            return this.convention;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -574688858: {
                    return ((FixedOvernightSwapTemplate)bean).getPeriodToStart();
                }
                case 110246592: {
                    return ((FixedOvernightSwapTemplate)bean).getTenor();
                }
                case 2039569265: {
                    return ((FixedOvernightSwapTemplate)bean).getConvention();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

