/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.CompoundingMethod;
import com.opengamma.strata.product.swap.FixedAccrualMethod;
import com.opengamma.strata.product.swap.FixedRateCalculation;
import com.opengamma.strata.product.swap.FutureValueNotional;
import com.opengamma.strata.product.swap.NotionalSchedule;
import com.opengamma.strata.product.swap.PaymentSchedule;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.type.SwapLegConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class FixedRateSwapLegConvention
implements SwapLegConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final Currency currency;
    @PropertyDefinition(validate="notNull")
    private final DayCount dayCount;
    @PropertyDefinition(validate="notNull")
    private final Frequency accrualFrequency;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment accrualBusinessDayAdjustment;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment startDateBusinessDayAdjustment;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment endDateBusinessDayAdjustment;
    @PropertyDefinition(get="field")
    private final StubConvention stubConvention;
    @PropertyDefinition(get="field")
    private final RollConvention rollConvention;
    @PropertyDefinition(get="field")
    private final Frequency paymentFrequency;
    @PropertyDefinition(get="field")
    private final DaysAdjustment paymentDateOffset;
    @PropertyDefinition(get="field")
    private final CompoundingMethod compoundingMethod;
    @PropertyDefinition
    private final FixedAccrualMethod accrualMethod;
    private static final long serialVersionUID = 1L;

    public static FixedRateSwapLegConvention of(Currency currency, DayCount dayCount, Frequency accrualFrequency, BusinessDayAdjustment accrualBusinessDayAdjustment) {
        return FixedRateSwapLegConvention.builder().currency(currency).dayCount(dayCount).accrualFrequency(accrualFrequency).accrualBusinessDayAdjustment(accrualBusinessDayAdjustment).stubConvention(StubConvention.SMART_INITIAL).build();
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.accrualMethod = FixedAccrualMethod.DEFAULT;
    }

    public BusinessDayAdjustment getStartDateBusinessDayAdjustment() {
        return this.startDateBusinessDayAdjustment != null ? this.startDateBusinessDayAdjustment : this.accrualBusinessDayAdjustment;
    }

    public BusinessDayAdjustment getEndDateBusinessDayAdjustment() {
        return this.endDateBusinessDayAdjustment != null ? this.endDateBusinessDayAdjustment : this.accrualBusinessDayAdjustment;
    }

    public StubConvention getStubConvention() {
        return this.stubConvention != null ? this.stubConvention : StubConvention.SMART_INITIAL;
    }

    public RollConvention getRollConvention() {
        return this.rollConvention != null ? this.rollConvention : RollConventions.EOM;
    }

    public Frequency getPaymentFrequency() {
        return this.paymentFrequency != null ? this.paymentFrequency : this.accrualFrequency;
    }

    public DaysAdjustment getPaymentDateOffset() {
        return this.paymentDateOffset != null ? this.paymentDateOffset : DaysAdjustment.NONE;
    }

    public CompoundingMethod getCompoundingMethod() {
        return this.compoundingMethod != null ? this.compoundingMethod : CompoundingMethod.NONE;
    }

    public RateCalculationSwapLeg toLeg(LocalDate startDate, LocalDate endDate, PayReceive payReceive, double notional, double fixedRate) {
        return RateCalculationSwapLeg.builder().payReceive(payReceive).accrualSchedule(PeriodicSchedule.builder().startDate(startDate).endDate(endDate).frequency(this.accrualFrequency).businessDayAdjustment(this.accrualBusinessDayAdjustment).startDateBusinessDayAdjustment(this.startDateBusinessDayAdjustment).endDateBusinessDayAdjustment(this.endDateBusinessDayAdjustment).stubConvention(this.stubConvention).rollConvention(this.rollConvention).build()).paymentSchedule(PaymentSchedule.builder().paymentFrequency(this.getPaymentFrequency()).paymentDateOffset(this.getPaymentDateOffset()).compoundingMethod(this.getCompoundingMethod()).build()).notionalSchedule(NotionalSchedule.of(this.currency, notional)).calculation(FixedRateCalculation.builder().rate(ValueSchedule.of((double)fixedRate)).dayCount(this.dayCount).futureValueNotional(this.accrualMethod == FixedAccrualMethod.OVERNIGHT_COMPOUNDED_ANNUAL_RATE ? FutureValueNotional.autoCalculate() : null).build()).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private FixedRateSwapLegConvention(Currency currency, DayCount dayCount, Frequency accrualFrequency, BusinessDayAdjustment accrualBusinessDayAdjustment, BusinessDayAdjustment startDateBusinessDayAdjustment, BusinessDayAdjustment endDateBusinessDayAdjustment, StubConvention stubConvention, RollConvention rollConvention, Frequency paymentFrequency, DaysAdjustment paymentDateOffset, CompoundingMethod compoundingMethod, FixedAccrualMethod accrualMethod) {
        JodaBeanUtils.notNull((Object)currency, (String)"currency");
        JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
        JodaBeanUtils.notNull((Object)accrualFrequency, (String)"accrualFrequency");
        JodaBeanUtils.notNull((Object)accrualBusinessDayAdjustment, (String)"accrualBusinessDayAdjustment");
        this.currency = currency;
        this.dayCount = dayCount;
        this.accrualFrequency = accrualFrequency;
        this.accrualBusinessDayAdjustment = accrualBusinessDayAdjustment;
        this.startDateBusinessDayAdjustment = startDateBusinessDayAdjustment;
        this.endDateBusinessDayAdjustment = endDateBusinessDayAdjustment;
        this.stubConvention = stubConvention;
        this.rollConvention = rollConvention;
        this.paymentFrequency = paymentFrequency;
        this.paymentDateOffset = paymentDateOffset;
        this.compoundingMethod = compoundingMethod;
        this.accrualMethod = accrualMethod;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public DayCount getDayCount() {
        return this.dayCount;
    }

    public Frequency getAccrualFrequency() {
        return this.accrualFrequency;
    }

    public BusinessDayAdjustment getAccrualBusinessDayAdjustment() {
        return this.accrualBusinessDayAdjustment;
    }

    public FixedAccrualMethod getAccrualMethod() {
        return this.accrualMethod;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            FixedRateSwapLegConvention other = (FixedRateSwapLegConvention)obj;
            return JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.accrualFrequency, (Object)other.accrualFrequency) && JodaBeanUtils.equal((Object)this.accrualBusinessDayAdjustment, (Object)other.accrualBusinessDayAdjustment) && JodaBeanUtils.equal((Object)this.startDateBusinessDayAdjustment, (Object)other.startDateBusinessDayAdjustment) && JodaBeanUtils.equal((Object)this.endDateBusinessDayAdjustment, (Object)other.endDateBusinessDayAdjustment) && JodaBeanUtils.equal((Object)this.stubConvention, (Object)other.stubConvention) && JodaBeanUtils.equal((Object)this.rollConvention, (Object)other.rollConvention) && JodaBeanUtils.equal((Object)this.paymentFrequency, (Object)other.paymentFrequency) && JodaBeanUtils.equal((Object)this.paymentDateOffset, (Object)other.paymentDateOffset) && JodaBeanUtils.equal((Object)((Object)this.compoundingMethod), (Object)((Object)other.compoundingMethod)) && JodaBeanUtils.equal((Object)((Object)this.accrualMethod), (Object)((Object)other.accrualMethod));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.accrualFrequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.accrualBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDateBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDateBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stubConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rollConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentFrequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.compoundingMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.accrualMethod));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(416);
        buf.append("FixedRateSwapLegConvention{");
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("accrualFrequency").append('=').append(JodaBeanUtils.toString((Object)this.accrualFrequency)).append(',').append(' ');
        buf.append("accrualBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.accrualBusinessDayAdjustment)).append(',').append(' ');
        buf.append("startDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.startDateBusinessDayAdjustment)).append(',').append(' ');
        buf.append("endDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.endDateBusinessDayAdjustment)).append(',').append(' ');
        buf.append("stubConvention").append('=').append(JodaBeanUtils.toString((Object)this.stubConvention)).append(',').append(' ');
        buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
        buf.append("paymentFrequency").append('=').append(JodaBeanUtils.toString((Object)this.paymentFrequency)).append(',').append(' ');
        buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
        buf.append("compoundingMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.compoundingMethod))).append(',').append(' ');
        buf.append("accrualMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.accrualMethod)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<FixedRateSwapLegConvention> {
        private Currency currency;
        private DayCount dayCount;
        private Frequency accrualFrequency;
        private BusinessDayAdjustment accrualBusinessDayAdjustment;
        private BusinessDayAdjustment startDateBusinessDayAdjustment;
        private BusinessDayAdjustment endDateBusinessDayAdjustment;
        private StubConvention stubConvention;
        private RollConvention rollConvention;
        private Frequency paymentFrequency;
        private DaysAdjustment paymentDateOffset;
        private CompoundingMethod compoundingMethod;
        private FixedAccrualMethod accrualMethod;

        private Builder() {
            FixedRateSwapLegConvention.applyDefaults(this);
        }

        private Builder(FixedRateSwapLegConvention beanToCopy) {
            this.currency = beanToCopy.getCurrency();
            this.dayCount = beanToCopy.getDayCount();
            this.accrualFrequency = beanToCopy.getAccrualFrequency();
            this.accrualBusinessDayAdjustment = beanToCopy.getAccrualBusinessDayAdjustment();
            this.startDateBusinessDayAdjustment = beanToCopy.startDateBusinessDayAdjustment;
            this.endDateBusinessDayAdjustment = beanToCopy.endDateBusinessDayAdjustment;
            this.stubConvention = beanToCopy.stubConvention;
            this.rollConvention = beanToCopy.rollConvention;
            this.paymentFrequency = beanToCopy.paymentFrequency;
            this.paymentDateOffset = beanToCopy.paymentDateOffset;
            this.compoundingMethod = beanToCopy.compoundingMethod;
            this.accrualMethod = beanToCopy.getAccrualMethod();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 945206381: {
                    return this.accrualFrequency;
                }
                case 896049114: {
                    return this.accrualBusinessDayAdjustment;
                }
                case 429197561: {
                    return this.startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return this.endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return this.stubConvention;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 863656438: {
                    return this.paymentFrequency;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case -1376171496: {
                    return this.compoundingMethod;
                }
                case -1335729296: {
                    return this.accrualMethod;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 945206381: {
                    this.accrualFrequency = (Frequency)newValue;
                    break;
                }
                case 896049114: {
                    this.accrualBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 429197561: {
                    this.startDateBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -734327136: {
                    this.endDateBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -31408449: {
                    this.stubConvention = (StubConvention)newValue;
                    break;
                }
                case -10223666: {
                    this.rollConvention = (RollConvention)newValue;
                    break;
                }
                case 863656438: {
                    this.paymentFrequency = (Frequency)newValue;
                    break;
                }
                case -716438393: {
                    this.paymentDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case -1376171496: {
                    this.compoundingMethod = (CompoundingMethod)((Object)newValue);
                    break;
                }
                case -1335729296: {
                    this.accrualMethod = (FixedAccrualMethod)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public FixedRateSwapLegConvention build() {
            return new FixedRateSwapLegConvention(this.currency, this.dayCount, this.accrualFrequency, this.accrualBusinessDayAdjustment, this.startDateBusinessDayAdjustment, this.endDateBusinessDayAdjustment, this.stubConvention, this.rollConvention, this.paymentFrequency, this.paymentDateOffset, this.compoundingMethod, this.accrualMethod);
        }

        public Builder currency(Currency currency) {
            JodaBeanUtils.notNull((Object)currency, (String)"currency");
            this.currency = currency;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            JodaBeanUtils.notNull((Object)dayCount, (String)"dayCount");
            this.dayCount = dayCount;
            return this;
        }

        public Builder accrualFrequency(Frequency accrualFrequency) {
            JodaBeanUtils.notNull((Object)accrualFrequency, (String)"accrualFrequency");
            this.accrualFrequency = accrualFrequency;
            return this;
        }

        public Builder accrualBusinessDayAdjustment(BusinessDayAdjustment accrualBusinessDayAdjustment) {
            JodaBeanUtils.notNull((Object)accrualBusinessDayAdjustment, (String)"accrualBusinessDayAdjustment");
            this.accrualBusinessDayAdjustment = accrualBusinessDayAdjustment;
            return this;
        }

        public Builder startDateBusinessDayAdjustment(BusinessDayAdjustment startDateBusinessDayAdjustment) {
            this.startDateBusinessDayAdjustment = startDateBusinessDayAdjustment;
            return this;
        }

        public Builder endDateBusinessDayAdjustment(BusinessDayAdjustment endDateBusinessDayAdjustment) {
            this.endDateBusinessDayAdjustment = endDateBusinessDayAdjustment;
            return this;
        }

        public Builder stubConvention(StubConvention stubConvention) {
            this.stubConvention = stubConvention;
            return this;
        }

        public Builder rollConvention(RollConvention rollConvention) {
            this.rollConvention = rollConvention;
            return this;
        }

        public Builder paymentFrequency(Frequency paymentFrequency) {
            this.paymentFrequency = paymentFrequency;
            return this;
        }

        public Builder paymentDateOffset(DaysAdjustment paymentDateOffset) {
            this.paymentDateOffset = paymentDateOffset;
            return this;
        }

        public Builder compoundingMethod(CompoundingMethod compoundingMethod) {
            this.compoundingMethod = compoundingMethod;
            return this;
        }

        public Builder accrualMethod(FixedAccrualMethod accrualMethod) {
            this.accrualMethod = accrualMethod;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(416);
            buf.append("FixedRateSwapLegConvention.Builder{");
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("accrualFrequency").append('=').append(JodaBeanUtils.toString((Object)this.accrualFrequency)).append(',').append(' ');
            buf.append("accrualBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.accrualBusinessDayAdjustment)).append(',').append(' ');
            buf.append("startDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.startDateBusinessDayAdjustment)).append(',').append(' ');
            buf.append("endDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.endDateBusinessDayAdjustment)).append(',').append(' ');
            buf.append("stubConvention").append('=').append(JodaBeanUtils.toString((Object)this.stubConvention)).append(',').append(' ');
            buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
            buf.append("paymentFrequency").append('=').append(JodaBeanUtils.toString((Object)this.paymentFrequency)).append(',').append(' ');
            buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
            buf.append("compoundingMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.compoundingMethod))).append(',').append(' ');
            buf.append("accrualMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.accrualMethod)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", FixedRateSwapLegConvention.class, Currency.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", FixedRateSwapLegConvention.class, DayCount.class);
        private final MetaProperty<Frequency> accrualFrequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualFrequency", FixedRateSwapLegConvention.class, Frequency.class);
        private final MetaProperty<BusinessDayAdjustment> accrualBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualBusinessDayAdjustment", FixedRateSwapLegConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> startDateBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDateBusinessDayAdjustment", FixedRateSwapLegConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> endDateBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDateBusinessDayAdjustment", FixedRateSwapLegConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<StubConvention> stubConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stubConvention", FixedRateSwapLegConvention.class, StubConvention.class);
        private final MetaProperty<RollConvention> rollConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rollConvention", FixedRateSwapLegConvention.class, RollConvention.class);
        private final MetaProperty<Frequency> paymentFrequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentFrequency", FixedRateSwapLegConvention.class, Frequency.class);
        private final MetaProperty<DaysAdjustment> paymentDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDateOffset", FixedRateSwapLegConvention.class, DaysAdjustment.class);
        private final MetaProperty<CompoundingMethod> compoundingMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"compoundingMethod", FixedRateSwapLegConvention.class, CompoundingMethod.class);
        private final MetaProperty<FixedAccrualMethod> accrualMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualMethod", FixedRateSwapLegConvention.class, FixedAccrualMethod.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"currency", "dayCount", "accrualFrequency", "accrualBusinessDayAdjustment", "startDateBusinessDayAdjustment", "endDateBusinessDayAdjustment", "stubConvention", "rollConvention", "paymentFrequency", "paymentDateOffset", "compoundingMethod", "accrualMethod"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return this.currency;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 945206381: {
                    return this.accrualFrequency;
                }
                case 896049114: {
                    return this.accrualBusinessDayAdjustment;
                }
                case 429197561: {
                    return this.startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return this.endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return this.stubConvention;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 863656438: {
                    return this.paymentFrequency;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case -1376171496: {
                    return this.compoundingMethod;
                }
                case -1335729296: {
                    return this.accrualMethod;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends FixedRateSwapLegConvention> beanType() {
            return FixedRateSwapLegConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<Frequency> accrualFrequency() {
            return this.accrualFrequency;
        }

        public MetaProperty<BusinessDayAdjustment> accrualBusinessDayAdjustment() {
            return this.accrualBusinessDayAdjustment;
        }

        public MetaProperty<BusinessDayAdjustment> startDateBusinessDayAdjustment() {
            return this.startDateBusinessDayAdjustment;
        }

        public MetaProperty<BusinessDayAdjustment> endDateBusinessDayAdjustment() {
            return this.endDateBusinessDayAdjustment;
        }

        public MetaProperty<StubConvention> stubConvention() {
            return this.stubConvention;
        }

        public MetaProperty<RollConvention> rollConvention() {
            return this.rollConvention;
        }

        public MetaProperty<Frequency> paymentFrequency() {
            return this.paymentFrequency;
        }

        public MetaProperty<DaysAdjustment> paymentDateOffset() {
            return this.paymentDateOffset;
        }

        public MetaProperty<CompoundingMethod> compoundingMethod() {
            return this.compoundingMethod;
        }

        public MetaProperty<FixedAccrualMethod> accrualMethod() {
            return this.accrualMethod;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 575402001: {
                    return ((FixedRateSwapLegConvention)bean).getCurrency();
                }
                case 1905311443: {
                    return ((FixedRateSwapLegConvention)bean).getDayCount();
                }
                case 945206381: {
                    return ((FixedRateSwapLegConvention)bean).getAccrualFrequency();
                }
                case 896049114: {
                    return ((FixedRateSwapLegConvention)bean).getAccrualBusinessDayAdjustment();
                }
                case 429197561: {
                    return ((FixedRateSwapLegConvention)bean).startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return ((FixedRateSwapLegConvention)bean).endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return ((FixedRateSwapLegConvention)bean).stubConvention;
                }
                case -10223666: {
                    return ((FixedRateSwapLegConvention)bean).rollConvention;
                }
                case 863656438: {
                    return ((FixedRateSwapLegConvention)bean).paymentFrequency;
                }
                case -716438393: {
                    return ((FixedRateSwapLegConvention)bean).paymentDateOffset;
                }
                case -1376171496: {
                    return ((FixedRateSwapLegConvention)bean).compoundingMethod;
                }
                case -1335729296: {
                    return ((FixedRateSwapLegConvention)bean).getAccrualMethod();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

