/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.basics.value.ValueSchedule;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.CompoundingMethod;
import com.opengamma.strata.product.swap.FixingRelativeTo;
import com.opengamma.strata.product.swap.IborRateCalculation;
import com.opengamma.strata.product.swap.NotionalSchedule;
import com.opengamma.strata.product.swap.PaymentSchedule;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.type.FloatRateSwapLegConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class IborRateSwapLegConvention
implements FloatRateSwapLegConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborIndex index;
    @PropertyDefinition(get="field")
    private final Currency currency;
    @PropertyDefinition(get="field")
    private final DayCount dayCount;
    @PropertyDefinition(get="field")
    private final Frequency accrualFrequency;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment accrualBusinessDayAdjustment;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment startDateBusinessDayAdjustment;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment endDateBusinessDayAdjustment;
    @PropertyDefinition(get="field")
    private final StubConvention stubConvention;
    @PropertyDefinition(get="field")
    private final RollConvention rollConvention;
    @PropertyDefinition(get="field")
    private final FixingRelativeTo fixingRelativeTo;
    @PropertyDefinition(get="field")
    private final DaysAdjustment fixingDateOffset;
    @PropertyDefinition(get="field")
    private final Frequency paymentFrequency;
    @PropertyDefinition(get="field")
    private final DaysAdjustment paymentDateOffset;
    @PropertyDefinition(get="field")
    private final CompoundingMethod compoundingMethod;
    @PropertyDefinition
    private final boolean notionalExchange;
    private static final long serialVersionUID = 1L;

    public static IborRateSwapLegConvention of(IborIndex index) {
        return IborRateSwapLegConvention.builder().index(index).stubConvention(StubConvention.SMART_INITIAL).build();
    }

    @Override
    public Currency getCurrency() {
        return this.currency != null ? this.currency : this.index.getCurrency();
    }

    @Override
    public DayCount getDayCount() {
        return this.dayCount != null ? this.dayCount : this.index.getDayCount();
    }

    public Frequency getAccrualFrequency() {
        return this.accrualFrequency != null ? this.accrualFrequency : Frequency.of((Period)this.index.getTenor().getPeriod());
    }

    @Override
    public BusinessDayAdjustment getAccrualBusinessDayAdjustment() {
        return this.accrualBusinessDayAdjustment != null ? this.accrualBusinessDayAdjustment : BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)this.index.getFixingCalendar());
    }

    @Override
    public BusinessDayAdjustment getStartDateBusinessDayAdjustment() {
        return this.startDateBusinessDayAdjustment != null ? this.startDateBusinessDayAdjustment : this.getAccrualBusinessDayAdjustment();
    }

    @Override
    public BusinessDayAdjustment getEndDateBusinessDayAdjustment() {
        return this.endDateBusinessDayAdjustment != null ? this.endDateBusinessDayAdjustment : this.getAccrualBusinessDayAdjustment();
    }

    public StubConvention getStubConvention() {
        return this.stubConvention != null ? this.stubConvention : StubConvention.SMART_INITIAL;
    }

    public RollConvention getRollConvention() {
        return this.rollConvention != null ? this.rollConvention : RollConventions.EOM;
    }

    public FixingRelativeTo getFixingRelativeTo() {
        return this.fixingRelativeTo != null ? this.fixingRelativeTo : FixingRelativeTo.PERIOD_START;
    }

    public DaysAdjustment getFixingDateOffset() {
        return this.fixingDateOffset != null ? this.fixingDateOffset : this.index.getFixingDateOffset();
    }

    public Frequency getPaymentFrequency() {
        return this.paymentFrequency != null ? this.paymentFrequency : this.getAccrualFrequency();
    }

    @Override
    public DaysAdjustment getPaymentDateOffset() {
        return this.paymentDateOffset != null ? this.paymentDateOffset : DaysAdjustment.NONE;
    }

    public CompoundingMethod getCompoundingMethod() {
        return this.compoundingMethod != null ? this.compoundingMethod : CompoundingMethod.NONE;
    }

    public RateCalculationSwapLeg toLeg(LocalDate startDate, LocalDate endDate, PayReceive payReceive, double notional) {
        return this.toLeg(startDate, endDate, payReceive, notional, 0.0);
    }

    public RateCalculationSwapLeg toLeg(LocalDate startDate, LocalDate endDate, PayReceive payReceive, double notional, double spread) {
        return RateCalculationSwapLeg.builder().payReceive(payReceive).accrualSchedule(PeriodicSchedule.builder().startDate(startDate).endDate(endDate).frequency(this.getAccrualFrequency()).businessDayAdjustment(this.getAccrualBusinessDayAdjustment()).startDateBusinessDayAdjustment(this.startDateBusinessDayAdjustment).endDateBusinessDayAdjustment(this.endDateBusinessDayAdjustment).stubConvention(this.stubConvention).rollConvention(this.rollConvention).build()).paymentSchedule(PaymentSchedule.builder().paymentFrequency(this.getPaymentFrequency()).paymentDateOffset(this.getPaymentDateOffset()).compoundingMethod(this.getCompoundingMethod()).build()).notionalSchedule(NotionalSchedule.builder().currency(this.getCurrency()).finalExchange(this.notionalExchange).initialExchange(this.notionalExchange).amount(ValueSchedule.of((double)notional)).build()).calculation(IborRateCalculation.builder().index(this.index).dayCount(this.getDayCount()).fixingRelativeTo(this.getFixingRelativeTo()).fixingDateOffset(this.getFixingDateOffset()).spread(spread != 0.0 ? ValueSchedule.of((double)spread) : null).build()).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private IborRateSwapLegConvention(IborIndex index, Currency currency, DayCount dayCount, Frequency accrualFrequency, BusinessDayAdjustment accrualBusinessDayAdjustment, BusinessDayAdjustment startDateBusinessDayAdjustment, BusinessDayAdjustment endDateBusinessDayAdjustment, StubConvention stubConvention, RollConvention rollConvention, FixingRelativeTo fixingRelativeTo, DaysAdjustment fixingDateOffset, Frequency paymentFrequency, DaysAdjustment paymentDateOffset, CompoundingMethod compoundingMethod, boolean notionalExchange) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        this.index = index;
        this.currency = currency;
        this.dayCount = dayCount;
        this.accrualFrequency = accrualFrequency;
        this.accrualBusinessDayAdjustment = accrualBusinessDayAdjustment;
        this.startDateBusinessDayAdjustment = startDateBusinessDayAdjustment;
        this.endDateBusinessDayAdjustment = endDateBusinessDayAdjustment;
        this.stubConvention = stubConvention;
        this.rollConvention = rollConvention;
        this.fixingRelativeTo = fixingRelativeTo;
        this.fixingDateOffset = fixingDateOffset;
        this.paymentFrequency = paymentFrequency;
        this.paymentDateOffset = paymentDateOffset;
        this.compoundingMethod = compoundingMethod;
        this.notionalExchange = notionalExchange;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public IborIndex getIndex() {
        return this.index;
    }

    public boolean isNotionalExchange() {
        return this.notionalExchange;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            IborRateSwapLegConvention other = (IborRateSwapLegConvention)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.currency, (Object)other.currency) && JodaBeanUtils.equal((Object)this.dayCount, (Object)other.dayCount) && JodaBeanUtils.equal((Object)this.accrualFrequency, (Object)other.accrualFrequency) && JodaBeanUtils.equal((Object)this.accrualBusinessDayAdjustment, (Object)other.accrualBusinessDayAdjustment) && JodaBeanUtils.equal((Object)this.startDateBusinessDayAdjustment, (Object)other.startDateBusinessDayAdjustment) && JodaBeanUtils.equal((Object)this.endDateBusinessDayAdjustment, (Object)other.endDateBusinessDayAdjustment) && JodaBeanUtils.equal((Object)this.stubConvention, (Object)other.stubConvention) && JodaBeanUtils.equal((Object)this.rollConvention, (Object)other.rollConvention) && JodaBeanUtils.equal((Object)((Object)this.fixingRelativeTo), (Object)((Object)other.fixingRelativeTo)) && JodaBeanUtils.equal((Object)this.fixingDateOffset, (Object)other.fixingDateOffset) && JodaBeanUtils.equal((Object)this.paymentFrequency, (Object)other.paymentFrequency) && JodaBeanUtils.equal((Object)this.paymentDateOffset, (Object)other.paymentDateOffset) && JodaBeanUtils.equal((Object)((Object)this.compoundingMethod), (Object)((Object)other.compoundingMethod)) && this.notionalExchange == other.notionalExchange;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.currency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dayCount);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.accrualFrequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.accrualBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDateBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDateBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.stubConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rollConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.fixingRelativeTo));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixingDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentFrequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.compoundingMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.notionalExchange);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(512);
        buf.append("IborRateSwapLegConvention{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
        buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
        buf.append("accrualFrequency").append('=').append(JodaBeanUtils.toString((Object)this.accrualFrequency)).append(',').append(' ');
        buf.append("accrualBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.accrualBusinessDayAdjustment)).append(',').append(' ');
        buf.append("startDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.startDateBusinessDayAdjustment)).append(',').append(' ');
        buf.append("endDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.endDateBusinessDayAdjustment)).append(',').append(' ');
        buf.append("stubConvention").append('=').append(JodaBeanUtils.toString((Object)this.stubConvention)).append(',').append(' ');
        buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
        buf.append("fixingRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.fixingRelativeTo))).append(',').append(' ');
        buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
        buf.append("paymentFrequency").append('=').append(JodaBeanUtils.toString((Object)this.paymentFrequency)).append(',').append(' ');
        buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
        buf.append("compoundingMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.compoundingMethod))).append(',').append(' ');
        buf.append("notionalExchange").append('=').append(JodaBeanUtils.toString((Object)this.notionalExchange));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<IborRateSwapLegConvention> {
        private IborIndex index;
        private Currency currency;
        private DayCount dayCount;
        private Frequency accrualFrequency;
        private BusinessDayAdjustment accrualBusinessDayAdjustment;
        private BusinessDayAdjustment startDateBusinessDayAdjustment;
        private BusinessDayAdjustment endDateBusinessDayAdjustment;
        private StubConvention stubConvention;
        private RollConvention rollConvention;
        private FixingRelativeTo fixingRelativeTo;
        private DaysAdjustment fixingDateOffset;
        private Frequency paymentFrequency;
        private DaysAdjustment paymentDateOffset;
        private CompoundingMethod compoundingMethod;
        private boolean notionalExchange;

        private Builder() {
        }

        private Builder(IborRateSwapLegConvention beanToCopy) {
            this.index = beanToCopy.getIndex();
            this.currency = beanToCopy.currency;
            this.dayCount = beanToCopy.dayCount;
            this.accrualFrequency = beanToCopy.accrualFrequency;
            this.accrualBusinessDayAdjustment = beanToCopy.accrualBusinessDayAdjustment;
            this.startDateBusinessDayAdjustment = beanToCopy.startDateBusinessDayAdjustment;
            this.endDateBusinessDayAdjustment = beanToCopy.endDateBusinessDayAdjustment;
            this.stubConvention = beanToCopy.stubConvention;
            this.rollConvention = beanToCopy.rollConvention;
            this.fixingRelativeTo = beanToCopy.fixingRelativeTo;
            this.fixingDateOffset = beanToCopy.fixingDateOffset;
            this.paymentFrequency = beanToCopy.paymentFrequency;
            this.paymentDateOffset = beanToCopy.paymentDateOffset;
            this.compoundingMethod = beanToCopy.compoundingMethod;
            this.notionalExchange = beanToCopy.isNotionalExchange();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 945206381: {
                    return this.accrualFrequency;
                }
                case 896049114: {
                    return this.accrualBusinessDayAdjustment;
                }
                case 429197561: {
                    return this.startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return this.endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return this.stubConvention;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 232554996: {
                    return this.fixingRelativeTo;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 863656438: {
                    return this.paymentFrequency;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case -1376171496: {
                    return this.compoundingMethod;
                }
                case -159410813: {
                    return this.notionalExchange;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (IborIndex)newValue;
                    break;
                }
                case 575402001: {
                    this.currency = (Currency)newValue;
                    break;
                }
                case 1905311443: {
                    this.dayCount = (DayCount)newValue;
                    break;
                }
                case 945206381: {
                    this.accrualFrequency = (Frequency)newValue;
                    break;
                }
                case 896049114: {
                    this.accrualBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 429197561: {
                    this.startDateBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -734327136: {
                    this.endDateBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -31408449: {
                    this.stubConvention = (StubConvention)newValue;
                    break;
                }
                case -10223666: {
                    this.rollConvention = (RollConvention)newValue;
                    break;
                }
                case 232554996: {
                    this.fixingRelativeTo = (FixingRelativeTo)((Object)newValue);
                    break;
                }
                case 873743726: {
                    this.fixingDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 863656438: {
                    this.paymentFrequency = (Frequency)newValue;
                    break;
                }
                case -716438393: {
                    this.paymentDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case -1376171496: {
                    this.compoundingMethod = (CompoundingMethod)((Object)newValue);
                    break;
                }
                case -159410813: {
                    this.notionalExchange = (Boolean)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public IborRateSwapLegConvention build() {
            return new IborRateSwapLegConvention(this.index, this.currency, this.dayCount, this.accrualFrequency, this.accrualBusinessDayAdjustment, this.startDateBusinessDayAdjustment, this.endDateBusinessDayAdjustment, this.stubConvention, this.rollConvention, this.fixingRelativeTo, this.fixingDateOffset, this.paymentFrequency, this.paymentDateOffset, this.compoundingMethod, this.notionalExchange);
        }

        public Builder index(IborIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public Builder dayCount(DayCount dayCount) {
            this.dayCount = dayCount;
            return this;
        }

        public Builder accrualFrequency(Frequency accrualFrequency) {
            this.accrualFrequency = accrualFrequency;
            return this;
        }

        public Builder accrualBusinessDayAdjustment(BusinessDayAdjustment accrualBusinessDayAdjustment) {
            this.accrualBusinessDayAdjustment = accrualBusinessDayAdjustment;
            return this;
        }

        public Builder startDateBusinessDayAdjustment(BusinessDayAdjustment startDateBusinessDayAdjustment) {
            this.startDateBusinessDayAdjustment = startDateBusinessDayAdjustment;
            return this;
        }

        public Builder endDateBusinessDayAdjustment(BusinessDayAdjustment endDateBusinessDayAdjustment) {
            this.endDateBusinessDayAdjustment = endDateBusinessDayAdjustment;
            return this;
        }

        public Builder stubConvention(StubConvention stubConvention) {
            this.stubConvention = stubConvention;
            return this;
        }

        public Builder rollConvention(RollConvention rollConvention) {
            this.rollConvention = rollConvention;
            return this;
        }

        public Builder fixingRelativeTo(FixingRelativeTo fixingRelativeTo) {
            this.fixingRelativeTo = fixingRelativeTo;
            return this;
        }

        public Builder fixingDateOffset(DaysAdjustment fixingDateOffset) {
            this.fixingDateOffset = fixingDateOffset;
            return this;
        }

        public Builder paymentFrequency(Frequency paymentFrequency) {
            this.paymentFrequency = paymentFrequency;
            return this;
        }

        public Builder paymentDateOffset(DaysAdjustment paymentDateOffset) {
            this.paymentDateOffset = paymentDateOffset;
            return this;
        }

        public Builder compoundingMethod(CompoundingMethod compoundingMethod) {
            this.compoundingMethod = compoundingMethod;
            return this;
        }

        public Builder notionalExchange(boolean notionalExchange) {
            this.notionalExchange = notionalExchange;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(512);
            buf.append("IborRateSwapLegConvention.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("currency").append('=').append(JodaBeanUtils.toString((Object)this.currency)).append(',').append(' ');
            buf.append("dayCount").append('=').append(JodaBeanUtils.toString((Object)this.dayCount)).append(',').append(' ');
            buf.append("accrualFrequency").append('=').append(JodaBeanUtils.toString((Object)this.accrualFrequency)).append(',').append(' ');
            buf.append("accrualBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.accrualBusinessDayAdjustment)).append(',').append(' ');
            buf.append("startDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.startDateBusinessDayAdjustment)).append(',').append(' ');
            buf.append("endDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.endDateBusinessDayAdjustment)).append(',').append(' ');
            buf.append("stubConvention").append('=').append(JodaBeanUtils.toString((Object)this.stubConvention)).append(',').append(' ');
            buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
            buf.append("fixingRelativeTo").append('=').append(JodaBeanUtils.toString((Object)((Object)this.fixingRelativeTo))).append(',').append(' ');
            buf.append("fixingDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.fixingDateOffset)).append(',').append(' ');
            buf.append("paymentFrequency").append('=').append(JodaBeanUtils.toString((Object)this.paymentFrequency)).append(',').append(' ');
            buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
            buf.append("compoundingMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.compoundingMethod))).append(',').append(' ');
            buf.append("notionalExchange").append('=').append(JodaBeanUtils.toString((Object)this.notionalExchange));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<IborIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", IborRateSwapLegConvention.class, IborIndex.class);
        private final MetaProperty<Currency> currency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"currency", IborRateSwapLegConvention.class, Currency.class);
        private final MetaProperty<DayCount> dayCount = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dayCount", IborRateSwapLegConvention.class, DayCount.class);
        private final MetaProperty<Frequency> accrualFrequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualFrequency", IborRateSwapLegConvention.class, Frequency.class);
        private final MetaProperty<BusinessDayAdjustment> accrualBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualBusinessDayAdjustment", IborRateSwapLegConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> startDateBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDateBusinessDayAdjustment", IborRateSwapLegConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> endDateBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDateBusinessDayAdjustment", IborRateSwapLegConvention.class, BusinessDayAdjustment.class);
        private final MetaProperty<StubConvention> stubConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stubConvention", IborRateSwapLegConvention.class, StubConvention.class);
        private final MetaProperty<RollConvention> rollConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rollConvention", IborRateSwapLegConvention.class, RollConvention.class);
        private final MetaProperty<FixingRelativeTo> fixingRelativeTo = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingRelativeTo", IborRateSwapLegConvention.class, FixingRelativeTo.class);
        private final MetaProperty<DaysAdjustment> fixingDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixingDateOffset", IborRateSwapLegConvention.class, DaysAdjustment.class);
        private final MetaProperty<Frequency> paymentFrequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentFrequency", IborRateSwapLegConvention.class, Frequency.class);
        private final MetaProperty<DaysAdjustment> paymentDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDateOffset", IborRateSwapLegConvention.class, DaysAdjustment.class);
        private final MetaProperty<CompoundingMethod> compoundingMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"compoundingMethod", IborRateSwapLegConvention.class, CompoundingMethod.class);
        private final MetaProperty<Boolean> notionalExchange = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notionalExchange", IborRateSwapLegConvention.class, Boolean.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "currency", "dayCount", "accrualFrequency", "accrualBusinessDayAdjustment", "startDateBusinessDayAdjustment", "endDateBusinessDayAdjustment", "stubConvention", "rollConvention", "fixingRelativeTo", "fixingDateOffset", "paymentFrequency", "paymentDateOffset", "compoundingMethod", "notionalExchange"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 575402001: {
                    return this.currency;
                }
                case 1905311443: {
                    return this.dayCount;
                }
                case 945206381: {
                    return this.accrualFrequency;
                }
                case 896049114: {
                    return this.accrualBusinessDayAdjustment;
                }
                case 429197561: {
                    return this.startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return this.endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return this.stubConvention;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 232554996: {
                    return this.fixingRelativeTo;
                }
                case 873743726: {
                    return this.fixingDateOffset;
                }
                case 863656438: {
                    return this.paymentFrequency;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case -1376171496: {
                    return this.compoundingMethod;
                }
                case -159410813: {
                    return this.notionalExchange;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends IborRateSwapLegConvention> beanType() {
            return IborRateSwapLegConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<IborIndex> index() {
            return this.index;
        }

        public MetaProperty<Currency> currency() {
            return this.currency;
        }

        public MetaProperty<DayCount> dayCount() {
            return this.dayCount;
        }

        public MetaProperty<Frequency> accrualFrequency() {
            return this.accrualFrequency;
        }

        public MetaProperty<BusinessDayAdjustment> accrualBusinessDayAdjustment() {
            return this.accrualBusinessDayAdjustment;
        }

        public MetaProperty<BusinessDayAdjustment> startDateBusinessDayAdjustment() {
            return this.startDateBusinessDayAdjustment;
        }

        public MetaProperty<BusinessDayAdjustment> endDateBusinessDayAdjustment() {
            return this.endDateBusinessDayAdjustment;
        }

        public MetaProperty<StubConvention> stubConvention() {
            return this.stubConvention;
        }

        public MetaProperty<RollConvention> rollConvention() {
            return this.rollConvention;
        }

        public MetaProperty<FixingRelativeTo> fixingRelativeTo() {
            return this.fixingRelativeTo;
        }

        public MetaProperty<DaysAdjustment> fixingDateOffset() {
            return this.fixingDateOffset;
        }

        public MetaProperty<Frequency> paymentFrequency() {
            return this.paymentFrequency;
        }

        public MetaProperty<DaysAdjustment> paymentDateOffset() {
            return this.paymentDateOffset;
        }

        public MetaProperty<CompoundingMethod> compoundingMethod() {
            return this.compoundingMethod;
        }

        public MetaProperty<Boolean> notionalExchange() {
            return this.notionalExchange;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((IborRateSwapLegConvention)bean).getIndex();
                }
                case 575402001: {
                    return ((IborRateSwapLegConvention)bean).currency;
                }
                case 1905311443: {
                    return ((IborRateSwapLegConvention)bean).dayCount;
                }
                case 945206381: {
                    return ((IborRateSwapLegConvention)bean).accrualFrequency;
                }
                case 896049114: {
                    return ((IborRateSwapLegConvention)bean).accrualBusinessDayAdjustment;
                }
                case 429197561: {
                    return ((IborRateSwapLegConvention)bean).startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return ((IborRateSwapLegConvention)bean).endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return ((IborRateSwapLegConvention)bean).stubConvention;
                }
                case -10223666: {
                    return ((IborRateSwapLegConvention)bean).rollConvention;
                }
                case 232554996: {
                    return ((IborRateSwapLegConvention)bean).fixingRelativeTo;
                }
                case 873743726: {
                    return ((IborRateSwapLegConvention)bean).fixingDateOffset;
                }
                case 863656438: {
                    return ((IborRateSwapLegConvention)bean).paymentFrequency;
                }
                case -716438393: {
                    return ((IborRateSwapLegConvention)bean).paymentDateOffset;
                }
                case -1376171496: {
                    return ((IborRateSwapLegConvention)bean).compoundingMethod;
                }
                case -159410813: {
                    return ((IborRateSwapLegConvention)bean).isNotionalExchange();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

