/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.Swap;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.FixedIborSwapConvention;
import com.opengamma.strata.product.swap.type.FixedRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.IborRateSwapLegConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableFixedIborSwapConvention
implements FixedIborSwapConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FixedRateSwapLegConvention fixedLeg;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborRateSwapLegConvention floatingLeg;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment spotDateOffset;
    private static final long serialVersionUID = 1L;

    public static ImmutableFixedIborSwapConvention of(String name, FixedRateSwapLegConvention fixedLeg, IborRateSwapLegConvention floatingLeg) {
        return ImmutableFixedIborSwapConvention.of(name, fixedLeg, floatingLeg, floatingLeg.getIndex().getEffectiveDateOffset());
    }

    public static ImmutableFixedIborSwapConvention of(String name, FixedRateSwapLegConvention fixedLeg, IborRateSwapLegConvention floatingLeg, DaysAdjustment spotDateOffset) {
        return new ImmutableFixedIborSwapConvention(name, fixedLeg, floatingLeg, spotDateOffset);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)this.fixedLeg.getCurrency().equals((Object)this.floatingLeg.getCurrency()), (String)"Conventions must have same currency");
    }

    @Override
    public SwapTrade toTrade(TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double fixedRate) {
        Optional<LocalDate> tradeDate = tradeInfo.getTradeDate();
        if (tradeDate.isPresent()) {
            ArgChecker.inOrderOrEqual((Comparable)tradeDate.get(), (Object)startDate, (String)"tradeDate", (String)"startDate");
        }
        RateCalculationSwapLeg leg1 = this.fixedLeg.toLeg(startDate, endDate, PayReceive.ofPay(buySell.isBuy()), notional, fixedRate);
        RateCalculationSwapLeg leg2 = this.floatingLeg.toLeg(startDate, endDate, PayReceive.ofPay(buySell.isSell()), notional);
        return SwapTrade.builder().info(tradeInfo).product(Swap.of(leg1, leg2)).build();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableFixedIborSwapConvention(String name, FixedRateSwapLegConvention fixedLeg, IborRateSwapLegConvention floatingLeg, DaysAdjustment spotDateOffset) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)fixedLeg, (String)"fixedLeg");
        JodaBeanUtils.notNull((Object)floatingLeg, (String)"floatingLeg");
        JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
        this.name = name;
        this.fixedLeg = fixedLeg;
        this.floatingLeg = floatingLeg;
        this.spotDateOffset = spotDateOffset;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FixedRateSwapLegConvention getFixedLeg() {
        return this.fixedLeg;
    }

    @Override
    public IborRateSwapLegConvention getFloatingLeg() {
        return this.floatingLeg;
    }

    @Override
    public DaysAdjustment getSpotDateOffset() {
        return this.spotDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableFixedIborSwapConvention other = (ImmutableFixedIborSwapConvention)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.fixedLeg, (Object)other.fixedLeg) && JodaBeanUtils.equal((Object)this.floatingLeg, (Object)other.floatingLeg) && JodaBeanUtils.equal((Object)this.spotDateOffset, (Object)other.spotDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.fixedLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.floatingLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spotDateOffset);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableFixedIborSwapConvention> {
        private String name;
        private FixedRateSwapLegConvention fixedLeg;
        private IborRateSwapLegConvention floatingLeg;
        private DaysAdjustment spotDateOffset;

        private Builder() {
        }

        private Builder(ImmutableFixedIborSwapConvention beanToCopy) {
            this.name = beanToCopy.getName();
            this.fixedLeg = beanToCopy.getFixedLeg();
            this.floatingLeg = beanToCopy.getFloatingLeg();
            this.spotDateOffset = beanToCopy.getSpotDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -391537158: {
                    return this.fixedLeg;
                }
                case -1177101272: {
                    return this.floatingLeg;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case -391537158: {
                    this.fixedLeg = (FixedRateSwapLegConvention)newValue;
                    break;
                }
                case -1177101272: {
                    this.floatingLeg = (IborRateSwapLegConvention)newValue;
                    break;
                }
                case 746995843: {
                    this.spotDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableFixedIborSwapConvention build() {
            return new ImmutableFixedIborSwapConvention(this.name, this.fixedLeg, this.floatingLeg, this.spotDateOffset);
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder fixedLeg(FixedRateSwapLegConvention fixedLeg) {
            JodaBeanUtils.notNull((Object)fixedLeg, (String)"fixedLeg");
            this.fixedLeg = fixedLeg;
            return this;
        }

        public Builder floatingLeg(IborRateSwapLegConvention floatingLeg) {
            JodaBeanUtils.notNull((Object)floatingLeg, (String)"floatingLeg");
            this.floatingLeg = floatingLeg;
            return this;
        }

        public Builder spotDateOffset(DaysAdjustment spotDateOffset) {
            JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
            this.spotDateOffset = spotDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ImmutableFixedIborSwapConvention.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("fixedLeg").append('=').append(JodaBeanUtils.toString((Object)this.fixedLeg)).append(',').append(' ');
            buf.append("floatingLeg").append('=').append(JodaBeanUtils.toString((Object)this.floatingLeg)).append(',').append(' ');
            buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableFixedIborSwapConvention.class, String.class);
        private final MetaProperty<FixedRateSwapLegConvention> fixedLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"fixedLeg", ImmutableFixedIborSwapConvention.class, FixedRateSwapLegConvention.class);
        private final MetaProperty<IborRateSwapLegConvention> floatingLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"floatingLeg", ImmutableFixedIborSwapConvention.class, IborRateSwapLegConvention.class);
        private final MetaProperty<DaysAdjustment> spotDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spotDateOffset", ImmutableFixedIborSwapConvention.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "fixedLeg", "floatingLeg", "spotDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case -391537158: {
                    return this.fixedLeg;
                }
                case -1177101272: {
                    return this.floatingLeg;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableFixedIborSwapConvention> beanType() {
            return ImmutableFixedIborSwapConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<FixedRateSwapLegConvention> fixedLeg() {
            return this.fixedLeg;
        }

        public MetaProperty<IborRateSwapLegConvention> floatingLeg() {
            return this.floatingLeg;
        }

        public MetaProperty<DaysAdjustment> spotDateOffset() {
            return this.spotDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableFixedIborSwapConvention)bean).getName();
                }
                case -391537158: {
                    return ((ImmutableFixedIborSwapConvention)bean).getFixedLeg();
                }
                case -1177101272: {
                    return ((ImmutableFixedIborSwapConvention)bean).getFloatingLeg();
                }
                case 746995843: {
                    return ((ImmutableFixedIborSwapConvention)bean).getSpotDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

