/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.Swap;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.IborIborSwapConvention;
import com.opengamma.strata.product.swap.type.IborRateSwapLegConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableIborIborSwapConvention
implements IborIborSwapConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborRateSwapLegConvention spreadLeg;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborRateSwapLegConvention flatLeg;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment spotDateOffset;
    private static final long serialVersionUID = 1L;

    public static ImmutableIborIborSwapConvention of(String name, IborRateSwapLegConvention spreadLeg, IborRateSwapLegConvention flatLeg) {
        return ImmutableIborIborSwapConvention.of(name, spreadLeg, flatLeg, spreadLeg.getIndex().getEffectiveDateOffset());
    }

    public static ImmutableIborIborSwapConvention of(String name, IborRateSwapLegConvention spreadLeg, IborRateSwapLegConvention flatLeg, DaysAdjustment spotDateOffset) {
        return new ImmutableIborIborSwapConvention(name, spreadLeg, flatLeg, spotDateOffset);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)this.spreadLeg.getCurrency().equals((Object)this.flatLeg.getCurrency()), (String)"Conventions must have same currency");
    }

    @Override
    public SwapTrade toTrade(TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double spread) {
        Optional<LocalDate> tradeDate = tradeInfo.getTradeDate();
        if (tradeDate.isPresent()) {
            ArgChecker.inOrderOrEqual((Comparable)tradeDate.get(), (Object)startDate, (String)"tradeDate", (String)"startDate");
        }
        RateCalculationSwapLeg leg1 = this.spreadLeg.toLeg(startDate, endDate, PayReceive.ofPay(buySell.isBuy()), notional, spread);
        RateCalculationSwapLeg leg2 = this.flatLeg.toLeg(startDate, endDate, PayReceive.ofPay(buySell.isSell()), notional);
        return SwapTrade.builder().info(tradeInfo).product(Swap.of(leg1, leg2)).build();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableIborIborSwapConvention(String name, IborRateSwapLegConvention spreadLeg, IborRateSwapLegConvention flatLeg, DaysAdjustment spotDateOffset) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)spreadLeg, (String)"spreadLeg");
        JodaBeanUtils.notNull((Object)flatLeg, (String)"flatLeg");
        JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
        this.name = name;
        this.spreadLeg = spreadLeg;
        this.flatLeg = flatLeg;
        this.spotDateOffset = spotDateOffset;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IborRateSwapLegConvention getSpreadLeg() {
        return this.spreadLeg;
    }

    @Override
    public IborRateSwapLegConvention getFlatLeg() {
        return this.flatLeg;
    }

    @Override
    public DaysAdjustment getSpotDateOffset() {
        return this.spotDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableIborIborSwapConvention other = (ImmutableIborIborSwapConvention)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.spreadLeg, (Object)other.spreadLeg) && JodaBeanUtils.equal((Object)this.flatLeg, (Object)other.flatLeg) && JodaBeanUtils.equal((Object)this.spotDateOffset, (Object)other.spotDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spreadLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.flatLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spotDateOffset);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableIborIborSwapConvention> {
        private String name;
        private IborRateSwapLegConvention spreadLeg;
        private IborRateSwapLegConvention flatLeg;
        private DaysAdjustment spotDateOffset;

        private Builder() {
        }

        private Builder(ImmutableIborIborSwapConvention beanToCopy) {
            this.name = beanToCopy.getName();
            this.spreadLeg = beanToCopy.getSpreadLeg();
            this.flatLeg = beanToCopy.getFlatLeg();
            this.spotDateOffset = beanToCopy.getSpotDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1302781851: {
                    return this.spreadLeg;
                }
                case -778843179: {
                    return this.flatLeg;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 1302781851: {
                    this.spreadLeg = (IborRateSwapLegConvention)newValue;
                    break;
                }
                case -778843179: {
                    this.flatLeg = (IborRateSwapLegConvention)newValue;
                    break;
                }
                case 746995843: {
                    this.spotDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableIborIborSwapConvention build() {
            return new ImmutableIborIborSwapConvention(this.name, this.spreadLeg, this.flatLeg, this.spotDateOffset);
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder spreadLeg(IborRateSwapLegConvention spreadLeg) {
            JodaBeanUtils.notNull((Object)spreadLeg, (String)"spreadLeg");
            this.spreadLeg = spreadLeg;
            return this;
        }

        public Builder flatLeg(IborRateSwapLegConvention flatLeg) {
            JodaBeanUtils.notNull((Object)flatLeg, (String)"flatLeg");
            this.flatLeg = flatLeg;
            return this;
        }

        public Builder spotDateOffset(DaysAdjustment spotDateOffset) {
            JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
            this.spotDateOffset = spotDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ImmutableIborIborSwapConvention.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("spreadLeg").append('=').append(JodaBeanUtils.toString((Object)this.spreadLeg)).append(',').append(' ');
            buf.append("flatLeg").append('=').append(JodaBeanUtils.toString((Object)this.flatLeg)).append(',').append(' ');
            buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableIborIborSwapConvention.class, String.class);
        private final MetaProperty<IborRateSwapLegConvention> spreadLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spreadLeg", ImmutableIborIborSwapConvention.class, IborRateSwapLegConvention.class);
        private final MetaProperty<IborRateSwapLegConvention> flatLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"flatLeg", ImmutableIborIborSwapConvention.class, IborRateSwapLegConvention.class);
        private final MetaProperty<DaysAdjustment> spotDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spotDateOffset", ImmutableIborIborSwapConvention.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "spreadLeg", "flatLeg", "spotDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1302781851: {
                    return this.spreadLeg;
                }
                case -778843179: {
                    return this.flatLeg;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableIborIborSwapConvention> beanType() {
            return ImmutableIborIborSwapConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<IborRateSwapLegConvention> spreadLeg() {
            return this.spreadLeg;
        }

        public MetaProperty<IborRateSwapLegConvention> flatLeg() {
            return this.flatLeg;
        }

        public MetaProperty<DaysAdjustment> spotDateOffset() {
            return this.spotDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableIborIborSwapConvention)bean).getName();
                }
                case 1302781851: {
                    return ((ImmutableIborIborSwapConvention)bean).getSpreadLeg();
                }
                case -778843179: {
                    return ((ImmutableIborIborSwapConvention)bean).getFlatLeg();
                }
                case 746995843: {
                    return ((ImmutableIborIborSwapConvention)bean).getSpotDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

