/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.Swap;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.IborRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.OvernightIborSwapConvention;
import com.opengamma.strata.product.swap.type.OvernightRateSwapLegConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableOvernightIborSwapConvention
implements OvernightIborSwapConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final OvernightRateSwapLegConvention overnightLeg;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborRateSwapLegConvention iborLeg;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment spotDateOffset;
    private static final long serialVersionUID = 1L;

    public static ImmutableOvernightIborSwapConvention of(String name, OvernightRateSwapLegConvention overnightLeg, IborRateSwapLegConvention iborLeg) {
        return new ImmutableOvernightIborSwapConvention(name, overnightLeg, iborLeg, iborLeg.getIndex().getEffectiveDateOffset());
    }

    public static ImmutableOvernightIborSwapConvention of(String name, OvernightRateSwapLegConvention overnightLeg, IborRateSwapLegConvention iborLeg, DaysAdjustment spotDateOffset) {
        return new ImmutableOvernightIborSwapConvention(name, overnightLeg, iborLeg, spotDateOffset);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)this.overnightLeg.getCurrency().equals((Object)this.iborLeg.getCurrency()), (String)"Conventions must have same currency");
    }

    @Override
    public SwapTrade toTrade(TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double spread) {
        Optional<LocalDate> tradeDate = tradeInfo.getTradeDate();
        if (tradeDate.isPresent()) {
            ArgChecker.inOrderOrEqual((Comparable)tradeDate.get(), (Object)startDate, (String)"tradeDate", (String)"startDate");
        }
        RateCalculationSwapLeg leg1 = this.overnightLeg.toLeg(startDate, endDate, PayReceive.ofPay(buySell.isBuy()), notional, spread);
        RateCalculationSwapLeg leg2 = this.iborLeg.toLeg(startDate, endDate, PayReceive.ofPay(buySell.isSell()), notional);
        return SwapTrade.builder().info(tradeInfo).product(Swap.of(leg1, leg2)).build();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableOvernightIborSwapConvention(String name, OvernightRateSwapLegConvention overnightLeg, IborRateSwapLegConvention iborLeg, DaysAdjustment spotDateOffset) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)overnightLeg, (String)"overnightLeg");
        JodaBeanUtils.notNull((Object)iborLeg, (String)"iborLeg");
        JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
        this.name = name;
        this.overnightLeg = overnightLeg;
        this.iborLeg = iborLeg;
        this.spotDateOffset = spotDateOffset;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public OvernightRateSwapLegConvention getOvernightLeg() {
        return this.overnightLeg;
    }

    @Override
    public IborRateSwapLegConvention getIborLeg() {
        return this.iborLeg;
    }

    @Override
    public DaysAdjustment getSpotDateOffset() {
        return this.spotDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableOvernightIborSwapConvention other = (ImmutableOvernightIborSwapConvention)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.overnightLeg, (Object)other.overnightLeg) && JodaBeanUtils.equal((Object)this.iborLeg, (Object)other.iborLeg) && JodaBeanUtils.equal((Object)this.spotDateOffset, (Object)other.spotDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.overnightLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.iborLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spotDateOffset);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableOvernightIborSwapConvention> {
        private String name;
        private OvernightRateSwapLegConvention overnightLeg;
        private IborRateSwapLegConvention iborLeg;
        private DaysAdjustment spotDateOffset;

        private Builder() {
        }

        private Builder(ImmutableOvernightIborSwapConvention beanToCopy) {
            this.name = beanToCopy.getName();
            this.overnightLeg = beanToCopy.getOvernightLeg();
            this.iborLeg = beanToCopy.getIborLeg();
            this.spotDateOffset = beanToCopy.getSpotDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1774606250: {
                    return this.overnightLeg;
                }
                case 1610246066: {
                    return this.iborLeg;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 1774606250: {
                    this.overnightLeg = (OvernightRateSwapLegConvention)newValue;
                    break;
                }
                case 1610246066: {
                    this.iborLeg = (IborRateSwapLegConvention)newValue;
                    break;
                }
                case 746995843: {
                    this.spotDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableOvernightIborSwapConvention build() {
            return new ImmutableOvernightIborSwapConvention(this.name, this.overnightLeg, this.iborLeg, this.spotDateOffset);
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder overnightLeg(OvernightRateSwapLegConvention overnightLeg) {
            JodaBeanUtils.notNull((Object)overnightLeg, (String)"overnightLeg");
            this.overnightLeg = overnightLeg;
            return this;
        }

        public Builder iborLeg(IborRateSwapLegConvention iborLeg) {
            JodaBeanUtils.notNull((Object)iborLeg, (String)"iborLeg");
            this.iborLeg = iborLeg;
            return this;
        }

        public Builder spotDateOffset(DaysAdjustment spotDateOffset) {
            JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
            this.spotDateOffset = spotDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(160);
            buf.append("ImmutableOvernightIborSwapConvention.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("overnightLeg").append('=').append(JodaBeanUtils.toString((Object)this.overnightLeg)).append(',').append(' ');
            buf.append("iborLeg").append('=').append(JodaBeanUtils.toString((Object)this.iborLeg)).append(',').append(' ');
            buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableOvernightIborSwapConvention.class, String.class);
        private final MetaProperty<OvernightRateSwapLegConvention> overnightLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"overnightLeg", ImmutableOvernightIborSwapConvention.class, OvernightRateSwapLegConvention.class);
        private final MetaProperty<IborRateSwapLegConvention> iborLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"iborLeg", ImmutableOvernightIborSwapConvention.class, IborRateSwapLegConvention.class);
        private final MetaProperty<DaysAdjustment> spotDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spotDateOffset", ImmutableOvernightIborSwapConvention.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "overnightLeg", "iborLeg", "spotDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1774606250: {
                    return this.overnightLeg;
                }
                case 1610246066: {
                    return this.iborLeg;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableOvernightIborSwapConvention> beanType() {
            return ImmutableOvernightIborSwapConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<OvernightRateSwapLegConvention> overnightLeg() {
            return this.overnightLeg;
        }

        public MetaProperty<IborRateSwapLegConvention> iborLeg() {
            return this.iborLeg;
        }

        public MetaProperty<DaysAdjustment> spotDateOffset() {
            return this.spotDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableOvernightIborSwapConvention)bean).getName();
                }
                case 1774606250: {
                    return ((ImmutableOvernightIborSwapConvention)bean).getOvernightLeg();
                }
                case 1610246066: {
                    return ((ImmutableOvernightIborSwapConvention)bean).getIborLeg();
                }
                case 746995843: {
                    return ((ImmutableOvernightIborSwapConvention)bean).getSpotDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

