/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.Swap;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.FixedRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.IborRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.ThreeLegBasisSwapConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ImmutableThreeLegBasisSwapConvention
implements ThreeLegBasisSwapConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final String name;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final FixedRateSwapLegConvention spreadLeg;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborRateSwapLegConvention spreadFloatingLeg;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final IborRateSwapLegConvention flatFloatingLeg;
    @PropertyDefinition(validate="notNull", overrideGet=true)
    private final DaysAdjustment spotDateOffset;
    private static final long serialVersionUID = 1L;

    public static ImmutableThreeLegBasisSwapConvention of(String name, FixedRateSwapLegConvention spreadLeg, IborRateSwapLegConvention spreadFloatingLeg, IborRateSwapLegConvention flatFloatingLeg) {
        return ImmutableThreeLegBasisSwapConvention.of(name, spreadLeg, spreadFloatingLeg, flatFloatingLeg, spreadFloatingLeg.getIndex().getEffectiveDateOffset());
    }

    public static ImmutableThreeLegBasisSwapConvention of(String name, FixedRateSwapLegConvention spreadLeg, IborRateSwapLegConvention spreadFloatingLeg, IborRateSwapLegConvention flatFloatingLeg, DaysAdjustment spotDateOffset) {
        return new ImmutableThreeLegBasisSwapConvention(name, spreadLeg, spreadFloatingLeg, flatFloatingLeg, spotDateOffset);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)this.spreadFloatingLeg.getCurrency().equals((Object)this.spreadLeg.getCurrency()), (String)"Conventions must have same currency");
        ArgChecker.isTrue((boolean)this.spreadFloatingLeg.getCurrency().equals((Object)this.flatFloatingLeg.getCurrency()), (String)"Conventions must have same currency");
    }

    @Override
    public SwapTrade toTrade(TradeInfo tradeInfo, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double spread) {
        Optional<LocalDate> tradeDate = tradeInfo.getTradeDate();
        if (tradeDate.isPresent()) {
            ArgChecker.inOrderOrEqual((Comparable)tradeDate.get(), (Object)startDate, (String)"tradeDate", (String)"startDate");
        }
        RateCalculationSwapLeg leg1 = this.spreadLeg.toLeg(startDate, endDate, PayReceive.ofPay(buySell.isBuy()), notional, spread);
        RateCalculationSwapLeg leg2 = this.spreadFloatingLeg.toLeg(startDate, endDate, PayReceive.ofPay(buySell.isBuy()), notional);
        RateCalculationSwapLeg leg3 = this.flatFloatingLeg.toLeg(startDate, endDate, PayReceive.ofPay(buySell.isSell()), notional);
        return SwapTrade.builder().info(tradeInfo).product(Swap.of(leg1, leg2, leg3)).build();
    }

    public String toString() {
        return this.getName();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ImmutableThreeLegBasisSwapConvention(String name, FixedRateSwapLegConvention spreadLeg, IborRateSwapLegConvention spreadFloatingLeg, IborRateSwapLegConvention flatFloatingLeg, DaysAdjustment spotDateOffset) {
        JodaBeanUtils.notNull((Object)name, (String)"name");
        JodaBeanUtils.notNull((Object)spreadLeg, (String)"spreadLeg");
        JodaBeanUtils.notNull((Object)spreadFloatingLeg, (String)"spreadFloatingLeg");
        JodaBeanUtils.notNull((Object)flatFloatingLeg, (String)"flatFloatingLeg");
        JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
        this.name = name;
        this.spreadLeg = spreadLeg;
        this.spreadFloatingLeg = spreadFloatingLeg;
        this.flatFloatingLeg = flatFloatingLeg;
        this.spotDateOffset = spotDateOffset;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FixedRateSwapLegConvention getSpreadLeg() {
        return this.spreadLeg;
    }

    @Override
    public IborRateSwapLegConvention getSpreadFloatingLeg() {
        return this.spreadFloatingLeg;
    }

    @Override
    public IborRateSwapLegConvention getFlatFloatingLeg() {
        return this.flatFloatingLeg;
    }

    @Override
    public DaysAdjustment getSpotDateOffset() {
        return this.spotDateOffset;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ImmutableThreeLegBasisSwapConvention other = (ImmutableThreeLegBasisSwapConvention)obj;
            return JodaBeanUtils.equal((Object)this.name, (Object)other.name) && JodaBeanUtils.equal((Object)this.spreadLeg, (Object)other.spreadLeg) && JodaBeanUtils.equal((Object)this.spreadFloatingLeg, (Object)other.spreadFloatingLeg) && JodaBeanUtils.equal((Object)this.flatFloatingLeg, (Object)other.flatFloatingLeg) && JodaBeanUtils.equal((Object)this.spotDateOffset, (Object)other.spotDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.name);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spreadLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spreadFloatingLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.flatFloatingLeg);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.spotDateOffset);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ImmutableThreeLegBasisSwapConvention> {
        private String name;
        private FixedRateSwapLegConvention spreadLeg;
        private IborRateSwapLegConvention spreadFloatingLeg;
        private IborRateSwapLegConvention flatFloatingLeg;
        private DaysAdjustment spotDateOffset;

        private Builder() {
        }

        private Builder(ImmutableThreeLegBasisSwapConvention beanToCopy) {
            this.name = beanToCopy.getName();
            this.spreadLeg = beanToCopy.getSpreadLeg();
            this.spreadFloatingLeg = beanToCopy.getSpreadFloatingLeg();
            this.flatFloatingLeg = beanToCopy.getFlatFloatingLeg();
            this.spotDateOffset = beanToCopy.getSpotDateOffset();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1302781851: {
                    return this.spreadLeg;
                }
                case -1969210187: {
                    return this.spreadFloatingLeg;
                }
                case 274878191: {
                    return this.flatFloatingLeg;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    this.name = (String)newValue;
                    break;
                }
                case 1302781851: {
                    this.spreadLeg = (FixedRateSwapLegConvention)newValue;
                    break;
                }
                case -1969210187: {
                    this.spreadFloatingLeg = (IborRateSwapLegConvention)newValue;
                    break;
                }
                case 274878191: {
                    this.flatFloatingLeg = (IborRateSwapLegConvention)newValue;
                    break;
                }
                case 746995843: {
                    this.spotDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ImmutableThreeLegBasisSwapConvention build() {
            return new ImmutableThreeLegBasisSwapConvention(this.name, this.spreadLeg, this.spreadFloatingLeg, this.flatFloatingLeg, this.spotDateOffset);
        }

        public Builder name(String name) {
            JodaBeanUtils.notNull((Object)name, (String)"name");
            this.name = name;
            return this;
        }

        public Builder spreadLeg(FixedRateSwapLegConvention spreadLeg) {
            JodaBeanUtils.notNull((Object)spreadLeg, (String)"spreadLeg");
            this.spreadLeg = spreadLeg;
            return this;
        }

        public Builder spreadFloatingLeg(IborRateSwapLegConvention spreadFloatingLeg) {
            JodaBeanUtils.notNull((Object)spreadFloatingLeg, (String)"spreadFloatingLeg");
            this.spreadFloatingLeg = spreadFloatingLeg;
            return this;
        }

        public Builder flatFloatingLeg(IborRateSwapLegConvention flatFloatingLeg) {
            JodaBeanUtils.notNull((Object)flatFloatingLeg, (String)"flatFloatingLeg");
            this.flatFloatingLeg = flatFloatingLeg;
            return this;
        }

        public Builder spotDateOffset(DaysAdjustment spotDateOffset) {
            JodaBeanUtils.notNull((Object)spotDateOffset, (String)"spotDateOffset");
            this.spotDateOffset = spotDateOffset;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ImmutableThreeLegBasisSwapConvention.Builder{");
            buf.append("name").append('=').append(JodaBeanUtils.toString((Object)this.name)).append(',').append(' ');
            buf.append("spreadLeg").append('=').append(JodaBeanUtils.toString((Object)this.spreadLeg)).append(',').append(' ');
            buf.append("spreadFloatingLeg").append('=').append(JodaBeanUtils.toString((Object)this.spreadFloatingLeg)).append(',').append(' ');
            buf.append("flatFloatingLeg").append('=').append(JodaBeanUtils.toString((Object)this.flatFloatingLeg)).append(',').append(' ');
            buf.append("spotDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.spotDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<String> name = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"name", ImmutableThreeLegBasisSwapConvention.class, String.class);
        private final MetaProperty<FixedRateSwapLegConvention> spreadLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spreadLeg", ImmutableThreeLegBasisSwapConvention.class, FixedRateSwapLegConvention.class);
        private final MetaProperty<IborRateSwapLegConvention> spreadFloatingLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spreadFloatingLeg", ImmutableThreeLegBasisSwapConvention.class, IborRateSwapLegConvention.class);
        private final MetaProperty<IborRateSwapLegConvention> flatFloatingLeg = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"flatFloatingLeg", ImmutableThreeLegBasisSwapConvention.class, IborRateSwapLegConvention.class);
        private final MetaProperty<DaysAdjustment> spotDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"spotDateOffset", ImmutableThreeLegBasisSwapConvention.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"name", "spreadLeg", "spreadFloatingLeg", "flatFloatingLeg", "spotDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return this.name;
                }
                case 1302781851: {
                    return this.spreadLeg;
                }
                case -1969210187: {
                    return this.spreadFloatingLeg;
                }
                case 274878191: {
                    return this.flatFloatingLeg;
                }
                case 746995843: {
                    return this.spotDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ImmutableThreeLegBasisSwapConvention> beanType() {
            return ImmutableThreeLegBasisSwapConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<String> name() {
            return this.name;
        }

        public MetaProperty<FixedRateSwapLegConvention> spreadLeg() {
            return this.spreadLeg;
        }

        public MetaProperty<IborRateSwapLegConvention> spreadFloatingLeg() {
            return this.spreadFloatingLeg;
        }

        public MetaProperty<IborRateSwapLegConvention> flatFloatingLeg() {
            return this.flatFloatingLeg;
        }

        public MetaProperty<DaysAdjustment> spotDateOffset() {
            return this.spotDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 3373707: {
                    return ((ImmutableThreeLegBasisSwapConvention)bean).getName();
                }
                case 1302781851: {
                    return ((ImmutableThreeLegBasisSwapConvention)bean).getSpreadLeg();
                }
                case -1969210187: {
                    return ((ImmutableThreeLegBasisSwapConvention)bean).getSpreadFloatingLeg();
                }
                case 274878191: {
                    return ((ImmutableThreeLegBasisSwapConvention)bean).getFlatFloatingLeg();
                }
                case 746995843: {
                    return ((ImmutableThreeLegBasisSwapConvention)bean).getSpotDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

