/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.PeriodicSchedule;
import com.opengamma.strata.product.common.PayReceive;
import com.opengamma.strata.product.swap.InflationRateCalculation;
import com.opengamma.strata.product.swap.NotionalSchedule;
import com.opengamma.strata.product.swap.PaymentSchedule;
import com.opengamma.strata.product.swap.PriceIndexCalculationMethod;
import com.opengamma.strata.product.swap.RateCalculationSwapLeg;
import com.opengamma.strata.product.swap.type.SwapLegConvention;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableDefaults;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class InflationRateSwapLegConvention
implements SwapLegConvention,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final PriceIndex index;
    @PropertyDefinition(validate="notNull")
    private final Period lag;
    @PropertyDefinition(validate="notNull")
    private final PriceIndexCalculationMethod indexCalculationMethod;
    @PropertyDefinition
    private final boolean notionalExchange;
    @PropertyDefinition(get="field")
    private final DaysAdjustment paymentDateOffset;
    @PropertyDefinition(get="field")
    private final BusinessDayAdjustment accrualBusinessDayAdjustment;
    private static final long serialVersionUID = 1L;

    public static InflationRateSwapLegConvention of(PriceIndex index, Period lag, PriceIndexCalculationMethod priceIndexCalculationMethod, BusinessDayAdjustment businessDayAdjustment) {
        return new InflationRateSwapLegConvention(index, lag, priceIndexCalculationMethod, false, DaysAdjustment.NONE, businessDayAdjustment);
    }

    @ImmutableDefaults
    private static void applyDefaults(Builder builder) {
        builder.indexCalculationMethod = PriceIndexCalculationMethod.MONTHLY;
    }

    public Currency getCurrency() {
        return this.index.getCurrency();
    }

    public RateCalculationSwapLeg toLeg(LocalDate startDate, LocalDate endDate, PayReceive payReceive, double notional) {
        return RateCalculationSwapLeg.builder().payReceive(payReceive).accrualSchedule(PeriodicSchedule.builder().startDate(startDate).endDate(endDate).frequency(Frequency.TERM).businessDayAdjustment(this.accrualBusinessDayAdjustment).build()).paymentSchedule(PaymentSchedule.builder().paymentFrequency(Frequency.TERM).paymentDateOffset(this.paymentDateOffset).build()).calculation(InflationRateCalculation.builder().index(this.index).indexCalculationMethod(this.indexCalculationMethod).lag(this.lag).build()).notionalSchedule(NotionalSchedule.of(this.getCurrency(), notional)).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private InflationRateSwapLegConvention(PriceIndex index, Period lag, PriceIndexCalculationMethod indexCalculationMethod, boolean notionalExchange, DaysAdjustment paymentDateOffset, BusinessDayAdjustment accrualBusinessDayAdjustment) {
        JodaBeanUtils.notNull((Object)index, (String)"index");
        JodaBeanUtils.notNull((Object)lag, (String)"lag");
        JodaBeanUtils.notNull((Object)((Object)indexCalculationMethod), (String)"indexCalculationMethod");
        this.index = index;
        this.lag = lag;
        this.indexCalculationMethod = indexCalculationMethod;
        this.notionalExchange = notionalExchange;
        this.paymentDateOffset = paymentDateOffset;
        this.accrualBusinessDayAdjustment = accrualBusinessDayAdjustment;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public PriceIndex getIndex() {
        return this.index;
    }

    public Period getLag() {
        return this.lag;
    }

    public PriceIndexCalculationMethod getIndexCalculationMethod() {
        return this.indexCalculationMethod;
    }

    public boolean isNotionalExchange() {
        return this.notionalExchange;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            InflationRateSwapLegConvention other = (InflationRateSwapLegConvention)obj;
            return JodaBeanUtils.equal((Object)this.index, (Object)other.index) && JodaBeanUtils.equal((Object)this.lag, (Object)other.lag) && JodaBeanUtils.equal((Object)((Object)this.indexCalculationMethod), (Object)((Object)other.indexCalculationMethod)) && this.notionalExchange == other.notionalExchange && JodaBeanUtils.equal((Object)this.paymentDateOffset, (Object)other.paymentDateOffset) && JodaBeanUtils.equal((Object)this.accrualBusinessDayAdjustment, (Object)other.accrualBusinessDayAdjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.index);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lag);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.indexCalculationMethod));
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.notionalExchange);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.paymentDateOffset);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.accrualBusinessDayAdjustment);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(224);
        buf.append("InflationRateSwapLegConvention{");
        buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
        buf.append("lag").append('=').append(JodaBeanUtils.toString((Object)this.lag)).append(',').append(' ');
        buf.append("indexCalculationMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.indexCalculationMethod))).append(',').append(' ');
        buf.append("notionalExchange").append('=').append(JodaBeanUtils.toString((Object)this.notionalExchange)).append(',').append(' ');
        buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
        buf.append("accrualBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.accrualBusinessDayAdjustment));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<InflationRateSwapLegConvention> {
        private PriceIndex index;
        private Period lag;
        private PriceIndexCalculationMethod indexCalculationMethod;
        private boolean notionalExchange;
        private DaysAdjustment paymentDateOffset;
        private BusinessDayAdjustment accrualBusinessDayAdjustment;

        private Builder() {
            InflationRateSwapLegConvention.applyDefaults(this);
        }

        private Builder(InflationRateSwapLegConvention beanToCopy) {
            this.index = beanToCopy.getIndex();
            this.lag = beanToCopy.getLag();
            this.indexCalculationMethod = beanToCopy.getIndexCalculationMethod();
            this.notionalExchange = beanToCopy.isNotionalExchange();
            this.paymentDateOffset = beanToCopy.paymentDateOffset;
            this.accrualBusinessDayAdjustment = beanToCopy.accrualBusinessDayAdjustment;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 106898: {
                    return this.lag;
                }
                case -1409010088: {
                    return this.indexCalculationMethod;
                }
                case -159410813: {
                    return this.notionalExchange;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case 896049114: {
                    return this.accrualBusinessDayAdjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    this.index = (PriceIndex)newValue;
                    break;
                }
                case 106898: {
                    this.lag = (Period)newValue;
                    break;
                }
                case -1409010088: {
                    this.indexCalculationMethod = (PriceIndexCalculationMethod)((Object)newValue);
                    break;
                }
                case -159410813: {
                    this.notionalExchange = (Boolean)newValue;
                    break;
                }
                case -716438393: {
                    this.paymentDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                case 896049114: {
                    this.accrualBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public InflationRateSwapLegConvention build() {
            return new InflationRateSwapLegConvention(this.index, this.lag, this.indexCalculationMethod, this.notionalExchange, this.paymentDateOffset, this.accrualBusinessDayAdjustment);
        }

        public Builder index(PriceIndex index) {
            JodaBeanUtils.notNull((Object)index, (String)"index");
            this.index = index;
            return this;
        }

        public Builder lag(Period lag) {
            JodaBeanUtils.notNull((Object)lag, (String)"lag");
            this.lag = lag;
            return this;
        }

        public Builder indexCalculationMethod(PriceIndexCalculationMethod indexCalculationMethod) {
            JodaBeanUtils.notNull((Object)((Object)indexCalculationMethod), (String)"indexCalculationMethod");
            this.indexCalculationMethod = indexCalculationMethod;
            return this;
        }

        public Builder notionalExchange(boolean notionalExchange) {
            this.notionalExchange = notionalExchange;
            return this;
        }

        public Builder paymentDateOffset(DaysAdjustment paymentDateOffset) {
            this.paymentDateOffset = paymentDateOffset;
            return this;
        }

        public Builder accrualBusinessDayAdjustment(BusinessDayAdjustment accrualBusinessDayAdjustment) {
            this.accrualBusinessDayAdjustment = accrualBusinessDayAdjustment;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(224);
            buf.append("InflationRateSwapLegConvention.Builder{");
            buf.append("index").append('=').append(JodaBeanUtils.toString((Object)this.index)).append(',').append(' ');
            buf.append("lag").append('=').append(JodaBeanUtils.toString((Object)this.lag)).append(',').append(' ');
            buf.append("indexCalculationMethod").append('=').append(JodaBeanUtils.toString((Object)((Object)this.indexCalculationMethod))).append(',').append(' ');
            buf.append("notionalExchange").append('=').append(JodaBeanUtils.toString((Object)this.notionalExchange)).append(',').append(' ');
            buf.append("paymentDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.paymentDateOffset)).append(',').append(' ');
            buf.append("accrualBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.accrualBusinessDayAdjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<PriceIndex> index = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"index", InflationRateSwapLegConvention.class, PriceIndex.class);
        private final MetaProperty<Period> lag = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lag", InflationRateSwapLegConvention.class, Period.class);
        private final MetaProperty<PriceIndexCalculationMethod> indexCalculationMethod = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"indexCalculationMethod", InflationRateSwapLegConvention.class, PriceIndexCalculationMethod.class);
        private final MetaProperty<Boolean> notionalExchange = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"notionalExchange", InflationRateSwapLegConvention.class, Boolean.TYPE);
        private final MetaProperty<DaysAdjustment> paymentDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"paymentDateOffset", InflationRateSwapLegConvention.class, DaysAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> accrualBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"accrualBusinessDayAdjustment", InflationRateSwapLegConvention.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"index", "lag", "indexCalculationMethod", "notionalExchange", "paymentDateOffset", "accrualBusinessDayAdjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return this.index;
                }
                case 106898: {
                    return this.lag;
                }
                case -1409010088: {
                    return this.indexCalculationMethod;
                }
                case -159410813: {
                    return this.notionalExchange;
                }
                case -716438393: {
                    return this.paymentDateOffset;
                }
                case 896049114: {
                    return this.accrualBusinessDayAdjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends InflationRateSwapLegConvention> beanType() {
            return InflationRateSwapLegConvention.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<PriceIndex> index() {
            return this.index;
        }

        public MetaProperty<Period> lag() {
            return this.lag;
        }

        public MetaProperty<PriceIndexCalculationMethod> indexCalculationMethod() {
            return this.indexCalculationMethod;
        }

        public MetaProperty<Boolean> notionalExchange() {
            return this.notionalExchange;
        }

        public MetaProperty<DaysAdjustment> paymentDateOffset() {
            return this.paymentDateOffset;
        }

        public MetaProperty<BusinessDayAdjustment> accrualBusinessDayAdjustment() {
            return this.accrualBusinessDayAdjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 100346066: {
                    return ((InflationRateSwapLegConvention)bean).getIndex();
                }
                case 106898: {
                    return ((InflationRateSwapLegConvention)bean).getLag();
                }
                case -1409010088: {
                    return ((InflationRateSwapLegConvention)bean).getIndexCalculationMethod();
                }
                case -159410813: {
                    return ((InflationRateSwapLegConvention)bean).isNotionalExchange();
                }
                case -716438393: {
                    return ((InflationRateSwapLegConvention)bean).paymentDateOffset;
                }
                case 896049114: {
                    return ((InflationRateSwapLegConvention)bean).accrualBusinessDayAdjustment;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

