/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.TradeConvention;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.FixedIborSwapConvention;
import com.opengamma.strata.product.swap.type.FixedInflationSwapConvention;
import com.opengamma.strata.product.swap.type.FixedOvernightSwapConvention;
import com.opengamma.strata.product.swap.type.IborIborSwapConvention;
import com.opengamma.strata.product.swap.type.OvernightIborSwapConvention;
import com.opengamma.strata.product.swap.type.ThreeLegBasisSwapConvention;
import java.time.LocalDate;
import java.time.Period;
import java.util.function.Supplier;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface SingleCurrencySwapConvention
extends TradeConvention,
Named {
    @FromString
    public static SingleCurrencySwapConvention of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (SingleCurrencySwapConvention)Guavate.firstNonEmpty((Supplier[])new Supplier[]{() -> FixedIborSwapConvention.extendedEnum().find(uniqueName), () -> IborIborSwapConvention.extendedEnum().find(uniqueName), () -> FixedOvernightSwapConvention.extendedEnum().find(uniqueName), () -> OvernightIborSwapConvention.extendedEnum().find(uniqueName), () -> FixedInflationSwapConvention.extendedEnum().find(uniqueName), () -> ThreeLegBasisSwapConvention.extendedEnum().find(uniqueName)}).orElseThrow(() -> new IllegalArgumentException("SingleCurrencySwapConvention not found: " + uniqueName));
    }

    public DaysAdjustment getSpotDateOffset();

    default public SwapTrade createTrade(LocalDate tradeDate, Tenor tenor, BuySell buySell, double notional, double fixedRateOrSpread, ReferenceData refData) {
        return this.createTrade(tradeDate, Period.ZERO, tenor, buySell, notional, fixedRateOrSpread, refData);
    }

    default public SwapTrade createTrade(LocalDate tradeDate, Period periodToStart, Tenor tenor, BuySell buySell, double notional, double fixedRateOrSpread, ReferenceData refData) {
        LocalDate spotValue = this.calculateSpotDateFromTradeDate(tradeDate, refData);
        LocalDate startDate = spotValue.plus(periodToStart);
        LocalDate endDate = startDate.plus(tenor.getPeriod());
        return this.toTrade(tradeDate, startDate, endDate, buySell, notional, fixedRateOrSpread);
    }

    default public SwapTrade toTrade(LocalDate tradeDate, LocalDate startDate, LocalDate endDate, BuySell buySell, double notional, double fixedRateOrSpread) {
        TradeInfo tradeInfo = TradeInfo.of(tradeDate);
        return this.toTrade(tradeInfo, startDate, endDate, buySell, notional, fixedRateOrSpread);
    }

    public SwapTrade toTrade(TradeInfo var1, LocalDate var2, LocalDate var3, BuySell var4, double var5, double var7);

    default public LocalDate calculateSpotDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        return this.getSpotDateOffset().adjust(tradeDate, refData);
    }

    @ToString
    public String getName();
}

