/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.index.IborIndices;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.product.swap.type.FixedIborSwapConvention;
import com.opengamma.strata.product.swap.type.FixedRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.IborRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.ImmutableFixedIborSwapConvention;

final class StandardFixedIborSwapConventions {
    private static final HolidayCalendarId GBLO_USNY = HolidayCalendarIds.GBLO.combinedWith(HolidayCalendarIds.USNY);
    private static final HolidayCalendarId GBLO_CHZU = HolidayCalendarIds.GBLO.combinedWith(HolidayCalendarIds.CHZU);
    private static final HolidayCalendarId GBLO_JPTO = HolidayCalendarIds.GBLO.combinedWith(HolidayCalendarIds.JPTO);
    public static final FixedIborSwapConvention USD_FIXED_6M_LIBOR_3M = ImmutableFixedIborSwapConvention.of("USD-FIXED-6M-LIBOR-3M", FixedRateSwapLegConvention.of(Currency.USD, DayCounts.THIRTY_U_360, Frequency.P6M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)GBLO_USNY)), IborRateSwapLegConvention.of(IborIndices.USD_LIBOR_3M));
    public static final FixedIborSwapConvention USD_FIXED_1Y_LIBOR_3M = ImmutableFixedIborSwapConvention.of("USD-FIXED-1Y-LIBOR-3M", FixedRateSwapLegConvention.of(Currency.USD, DayCounts.ACT_360, Frequency.P12M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)GBLO_USNY)), IborRateSwapLegConvention.of(IborIndices.USD_LIBOR_3M));
    public static final FixedIborSwapConvention EUR_FIXED_1Y_EURIBOR_3M = ImmutableFixedIborSwapConvention.of("EUR-FIXED-1Y-EURIBOR-3M", FixedRateSwapLegConvention.of(Currency.EUR, DayCounts.THIRTY_U_360, Frequency.P12M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.EUTA)), IborRateSwapLegConvention.of(IborIndices.EUR_EURIBOR_3M));
    public static final FixedIborSwapConvention EUR_FIXED_1Y_EURIBOR_6M = ImmutableFixedIborSwapConvention.of("EUR-FIXED-1Y-EURIBOR-6M", FixedRateSwapLegConvention.of(Currency.EUR, DayCounts.THIRTY_U_360, Frequency.P12M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.EUTA)), IborRateSwapLegConvention.of(IborIndices.EUR_EURIBOR_6M));
    public static final FixedIborSwapConvention EUR_FIXED_1Y_LIBOR_3M = ImmutableFixedIborSwapConvention.of("EUR-FIXED-1Y-LIBOR-3M", FixedRateSwapLegConvention.of(Currency.EUR, DayCounts.THIRTY_U_360, Frequency.P12M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.EUTA)), IborRateSwapLegConvention.of(IborIndices.EUR_LIBOR_3M));
    public static final FixedIborSwapConvention EUR_FIXED_1Y_LIBOR_6M = ImmutableFixedIborSwapConvention.of("EUR-FIXED-1Y-LIBOR-6M", FixedRateSwapLegConvention.of(Currency.EUR, DayCounts.THIRTY_U_360, Frequency.P12M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.EUTA)), IborRateSwapLegConvention.of(IborIndices.EUR_LIBOR_6M));
    public static final FixedIborSwapConvention GBP_FIXED_1Y_LIBOR_3M = ImmutableFixedIborSwapConvention.of("GBP-FIXED-1Y-LIBOR-3M", FixedRateSwapLegConvention.of(Currency.GBP, DayCounts.ACT_365F, Frequency.P12M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.GBLO)), IborRateSwapLegConvention.of(IborIndices.GBP_LIBOR_3M));
    public static final FixedIborSwapConvention GBP_FIXED_6M_LIBOR_6M = ImmutableFixedIborSwapConvention.of("GBP-FIXED-6M-LIBOR-6M", FixedRateSwapLegConvention.of(Currency.GBP, DayCounts.ACT_365F, Frequency.P6M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.GBLO)), IborRateSwapLegConvention.of(IborIndices.GBP_LIBOR_6M));
    public static final FixedIborSwapConvention GBP_FIXED_3M_LIBOR_3M = ImmutableFixedIborSwapConvention.of("GBP-FIXED-3M-LIBOR-3M", FixedRateSwapLegConvention.of(Currency.GBP, DayCounts.ACT_365F, Frequency.P3M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.GBLO)), IborRateSwapLegConvention.of(IborIndices.GBP_LIBOR_3M));
    public static final FixedIborSwapConvention CHF_FIXED_1Y_LIBOR_3M = ImmutableFixedIborSwapConvention.of("CHF-FIXED-1Y-LIBOR-3M", FixedRateSwapLegConvention.of(Currency.CHF, DayCounts.THIRTY_U_360, Frequency.P12M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)GBLO_CHZU)), IborRateSwapLegConvention.of(IborIndices.CHF_LIBOR_3M));
    public static final FixedIborSwapConvention CHF_FIXED_1Y_LIBOR_6M = ImmutableFixedIborSwapConvention.of("CHF-FIXED-1Y-LIBOR-6M", FixedRateSwapLegConvention.of(Currency.CHF, DayCounts.THIRTY_U_360, Frequency.P12M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)GBLO_CHZU)), IborRateSwapLegConvention.of(IborIndices.CHF_LIBOR_6M));
    public static final FixedIborSwapConvention JPY_FIXED_6M_TIBORJ_3M = ImmutableFixedIborSwapConvention.of("JPY-FIXED-6M-TIBOR-JAPAN-3M", FixedRateSwapLegConvention.of(Currency.JPY, DayCounts.ACT_365F, Frequency.P6M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.JPTO)), IborRateSwapLegConvention.of(IborIndices.JPY_TIBOR_JAPAN_3M));
    public static final FixedIborSwapConvention JPY_FIXED_6M_LIBOR_6M = ImmutableFixedIborSwapConvention.of("JPY-FIXED-6M-LIBOR-6M", FixedRateSwapLegConvention.of(Currency.JPY, DayCounts.ACT_365F, Frequency.P6M, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)GBLO_JPTO)), IborRateSwapLegConvention.of(IborIndices.JPY_LIBOR_6M));

    private StandardFixedIborSwapConventions() {
    }
}

