/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.index.PriceIndices;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.product.swap.CompoundingMethod;
import com.opengamma.strata.product.swap.PriceIndexCalculationMethod;
import com.opengamma.strata.product.swap.type.FixedInflationSwapConvention;
import com.opengamma.strata.product.swap.type.FixedRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.ImmutableFixedInflationSwapConvention;
import com.opengamma.strata.product.swap.type.InflationRateSwapLegConvention;
import java.time.Period;

final class StandardFixedInflationSwapConventions {
    private static final Period LAG_3M = Period.ofMonths(3);
    private static final Period LAG_2M = Period.ofMonths(2);
    public static final FixedInflationSwapConvention GBP_FIXED_ZC_GB_HICP = ImmutableFixedInflationSwapConvention.of("GBP-FIXED-ZC-GB-HICP", StandardFixedInflationSwapConventions.fixedLegZcConvention(Currency.GBP, HolidayCalendarIds.GBLO), InflationRateSwapLegConvention.of(PriceIndices.GB_HICP, LAG_2M, PriceIndexCalculationMethod.MONTHLY, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.GBLO)), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)HolidayCalendarIds.GBLO));
    public static final FixedInflationSwapConvention GBP_FIXED_ZC_GB_RPI = ImmutableFixedInflationSwapConvention.of("GBP-FIXED-ZC-GB-RPI", StandardFixedInflationSwapConventions.fixedLegZcConvention(Currency.GBP, HolidayCalendarIds.GBLO), InflationRateSwapLegConvention.of(PriceIndices.GB_RPI, LAG_2M, PriceIndexCalculationMethod.MONTHLY, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.GBLO)), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)HolidayCalendarIds.GBLO));
    public static final FixedInflationSwapConvention GBP_FIXED_ZC_GB_RPIX = ImmutableFixedInflationSwapConvention.of("GBP-FIXED-ZC-GB-RPIX", StandardFixedInflationSwapConventions.fixedLegZcConvention(Currency.GBP, HolidayCalendarIds.GBLO), InflationRateSwapLegConvention.of(PriceIndices.GB_RPIX, LAG_2M, PriceIndexCalculationMethod.MONTHLY, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.GBLO)), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)HolidayCalendarIds.GBLO));
    public static final FixedInflationSwapConvention CHF_FIXED_ZC_CH_CPI = ImmutableFixedInflationSwapConvention.of("CHF-FIXED-ZC-CH-CPI", StandardFixedInflationSwapConventions.fixedLegZcConvention(Currency.CHF, HolidayCalendarIds.CHZU), InflationRateSwapLegConvention.of(PriceIndices.CH_CPI, LAG_3M, PriceIndexCalculationMethod.MONTHLY, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.CHZU)), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)HolidayCalendarIds.CHZU));
    public static final FixedInflationSwapConvention EUR_FIXED_ZC_EU_AI_CPI = ImmutableFixedInflationSwapConvention.of("EUR-FIXED-ZC-EU-AI-CPI", StandardFixedInflationSwapConventions.fixedLegZcConvention(Currency.EUR, HolidayCalendarIds.EUTA), InflationRateSwapLegConvention.of(PriceIndices.EU_AI_CPI, LAG_3M, PriceIndexCalculationMethod.MONTHLY, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.EUTA)), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)HolidayCalendarIds.EUTA));
    public static final FixedInflationSwapConvention EUR_FIXED_ZC_EU_EXT_CPI = ImmutableFixedInflationSwapConvention.of("EUR-FIXED-ZC-EU-EXT-CPI", StandardFixedInflationSwapConventions.fixedLegZcConvention(Currency.EUR, HolidayCalendarIds.EUTA), InflationRateSwapLegConvention.of(PriceIndices.EU_EXT_CPI, LAG_3M, PriceIndexCalculationMethod.MONTHLY, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.EUTA)), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)HolidayCalendarIds.EUTA));
    public static final FixedInflationSwapConvention JPY_FIXED_ZC_JP_CPI = ImmutableFixedInflationSwapConvention.of("JPY-FIXED-ZC-JP-CPI", StandardFixedInflationSwapConventions.fixedLegZcConvention(Currency.JPY, HolidayCalendarIds.JPTO), InflationRateSwapLegConvention.of(PriceIndices.JP_CPI_EXF, LAG_3M, PriceIndexCalculationMethod.INTERPOLATED_JAPAN, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.JPTO)), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)HolidayCalendarIds.JPTO));
    public static final FixedInflationSwapConvention USD_FIXED_ZC_US_CPI = ImmutableFixedInflationSwapConvention.of("USD-FIXED-ZC-US-CPI", StandardFixedInflationSwapConventions.fixedLegZcConvention(Currency.USD, HolidayCalendarIds.USNY), InflationRateSwapLegConvention.of(PriceIndices.US_CPI_U, LAG_3M, PriceIndexCalculationMethod.INTERPOLATED, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.USNY)), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)HolidayCalendarIds.USNY));
    public static final FixedInflationSwapConvention EUR_FIXED_ZC_FR_CPI = ImmutableFixedInflationSwapConvention.of("EUR-FIXED-ZC-FR-CPI", StandardFixedInflationSwapConventions.fixedLegZcConvention(Currency.EUR, HolidayCalendarIds.EUTA), InflationRateSwapLegConvention.of(PriceIndices.FR_EXT_CPI, LAG_3M, PriceIndexCalculationMethod.MONTHLY, BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)HolidayCalendarIds.FRPA)), DaysAdjustment.ofBusinessDays((int)2, (HolidayCalendarId)HolidayCalendarIds.EUTA));

    private static FixedRateSwapLegConvention fixedLegZcConvention(Currency ccy, HolidayCalendarId cal) {
        return FixedRateSwapLegConvention.builder().paymentFrequency(Frequency.TERM).accrualFrequency(Frequency.P12M).accrualBusinessDayAdjustment(BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)cal)).startDateBusinessDayAdjustment(BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)cal)).endDateBusinessDayAdjustment(BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)cal)).compoundingMethod(CompoundingMethod.STRAIGHT).dayCount(DayCounts.ONE_ONE).currency(ccy).build();
    }

    private StandardFixedInflationSwapConventions() {
    }
}

