/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.BusinessDayConvention;
import com.opengamma.strata.basics.date.BusinessDayConventions;
import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndices;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.product.swap.OvernightAccrualMethod;
import com.opengamma.strata.product.swap.type.FixedOvernightSwapConvention;
import com.opengamma.strata.product.swap.type.FixedRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.ImmutableFixedOvernightSwapConvention;
import com.opengamma.strata.product.swap.type.OvernightRateSwapLegConvention;

final class StandardFixedOvernightSwapConventions {
    public static final FixedOvernightSwapConvention USD_FIXED_TERM_FED_FUND_OIS = StandardFixedOvernightSwapConventions.makeConvention("USD-FIXED-TERM-FED-FUND-OIS", OvernightIndices.USD_FED_FUND, DayCounts.ACT_360, Frequency.TERM, 2, 2);
    public static final FixedOvernightSwapConvention USD_FIXED_1Y_FED_FUND_OIS = StandardFixedOvernightSwapConventions.makeConvention("USD-FIXED-1Y-FED-FUND-OIS", OvernightIndices.USD_FED_FUND, DayCounts.ACT_360, Frequency.P12M, 2, 2);
    public static final FixedOvernightSwapConvention CHF_FIXED_TERM_SARON_OIS = StandardFixedOvernightSwapConventions.makeConvention("CHF-FIXED-TERM-SARON-OIS", OvernightIndices.CHF_SARON, DayCounts.ACT_360, Frequency.TERM, 2, 2);
    public static final FixedOvernightSwapConvention CHF_FIXED_1Y_SARON_OIS = StandardFixedOvernightSwapConventions.makeConvention("CHF-FIXED-1Y-SARON-OIS", OvernightIndices.CHF_SARON, DayCounts.ACT_360, Frequency.P12M, 2, 2);
    public static final FixedOvernightSwapConvention USD_FIXED_TERM_SOFR_OIS = StandardFixedOvernightSwapConventions.makeConvention("USD-FIXED-TERM-SOFR-OIS", OvernightIndices.USD_SOFR, DayCounts.ACT_360, Frequency.TERM, 2, 2);
    public static final FixedOvernightSwapConvention USD_FIXED_1Y_SOFR_OIS = StandardFixedOvernightSwapConventions.makeConvention("USD-FIXED-1Y-SOFR-OIS", OvernightIndices.USD_SOFR, DayCounts.ACT_360, Frequency.P12M, 2, 2);
    public static final FixedOvernightSwapConvention EUR_FIXED_TERM_EONIA_OIS = StandardFixedOvernightSwapConventions.makeConvention("EUR-FIXED-TERM-EONIA-OIS", OvernightIndices.EUR_EONIA, DayCounts.ACT_360, Frequency.TERM, 1, 2);
    public static final FixedOvernightSwapConvention EUR_FIXED_1Y_EONIA_OIS = StandardFixedOvernightSwapConventions.makeConvention("EUR-FIXED-1Y-EONIA-OIS", OvernightIndices.EUR_EONIA, DayCounts.ACT_360, Frequency.P12M, 1, 2);
    public static final FixedOvernightSwapConvention EUR_FIXED_TERM_ESTR_OIS = StandardFixedOvernightSwapConventions.makeConvention("EUR-FIXED-TERM-ESTR-OIS", OvernightIndices.EUR_ESTR, DayCounts.ACT_360, Frequency.TERM, 2, 2);
    public static final FixedOvernightSwapConvention EUR_FIXED_1Y_ESTR_OIS = StandardFixedOvernightSwapConventions.makeConvention("EUR-FIXED-1Y-ESTR-OIS", OvernightIndices.EUR_ESTR, DayCounts.ACT_360, Frequency.P12M, 2, 2);
    public static final FixedOvernightSwapConvention GBP_FIXED_TERM_SONIA_OIS = StandardFixedOvernightSwapConventions.makeConvention("GBP-FIXED-TERM-SONIA-OIS", OvernightIndices.GBP_SONIA, DayCounts.ACT_365F, Frequency.TERM, 0, 0);
    public static final FixedOvernightSwapConvention GBP_FIXED_1Y_SONIA_OIS = StandardFixedOvernightSwapConventions.makeConvention("GBP-FIXED-1Y-SONIA-OIS", OvernightIndices.GBP_SONIA, DayCounts.ACT_365F, Frequency.P12M, 0, 0);
    public static final FixedOvernightSwapConvention JPY_FIXED_TERM_TONAR_OIS = StandardFixedOvernightSwapConventions.makeConvention("JPY-FIXED-TERM-TONAR-OIS", OvernightIndices.JPY_TONAR, DayCounts.ACT_365F, Frequency.TERM, 2, 2);
    public static final FixedOvernightSwapConvention JPY_FIXED_1Y_TONAR_OIS = StandardFixedOvernightSwapConventions.makeConvention("JPY-FIXED-1Y-TONAR-OIS", OvernightIndices.JPY_TONAR, DayCounts.ACT_365F, Frequency.P12M, 2, 2);

    private static FixedOvernightSwapConvention makeConvention(String name, OvernightIndex index, DayCount dayCount, Frequency frequency, int paymentLag, int spotLag) {
        HolidayCalendarId calendar = index.getFixingCalendar();
        DaysAdjustment paymentDateOffset = DaysAdjustment.ofBusinessDays((int)paymentLag, (HolidayCalendarId)calendar);
        DaysAdjustment spotDateOffset = DaysAdjustment.ofBusinessDays((int)spotLag, (HolidayCalendarId)calendar);
        return ImmutableFixedOvernightSwapConvention.of(name, FixedRateSwapLegConvention.builder().currency(index.getCurrency()).dayCount(dayCount).accrualFrequency(frequency).accrualBusinessDayAdjustment(BusinessDayAdjustment.of((BusinessDayConvention)BusinessDayConventions.MODIFIED_FOLLOWING, (HolidayCalendarId)calendar)).paymentFrequency(frequency).paymentDateOffset(paymentDateOffset).stubConvention(StubConvention.SMART_INITIAL).build(), OvernightRateSwapLegConvention.builder().index(index).accrualMethod(OvernightAccrualMethod.COMPOUNDED).accrualFrequency(frequency).paymentFrequency(frequency).paymentDateOffset(paymentDateOffset).stubConvention(StubConvention.SMART_INITIAL).build(), spotDateOffset);
    }

    private StandardFixedOvernightSwapConventions() {
    }
}

