/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.date.DayCount;
import com.opengamma.strata.basics.date.DayCounts;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.IborIndices;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.OvernightIndices;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.product.swap.OvernightAccrualMethod;
import com.opengamma.strata.product.swap.type.IborRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.ImmutableOvernightIborSwapConvention;
import com.opengamma.strata.product.swap.type.OvernightIborSwapConvention;
import com.opengamma.strata.product.swap.type.OvernightRateSwapLegConvention;

final class StandardOvernightIborSwapConventions {
    public static final OvernightIborSwapConvention USD_FED_FUND_AA_LIBOR_3M = StandardOvernightIborSwapConventions.makeConvention("USD-FED-FUND-AA-LIBOR-3M", OvernightIndices.USD_FED_FUND, IborIndices.USD_LIBOR_3M, DayCounts.ACT_360, Frequency.P3M, 0, 2, OvernightAccrualMethod.AVERAGED);
    public static final OvernightIborSwapConvention GBP_SONIA_OIS_1Y_LIBOR_3M = StandardOvernightIborSwapConventions.makeConvention("GBP-SONIA-OIS-1Y-LIBOR-3M", OvernightIndices.GBP_SONIA, IborIndices.GBP_LIBOR_3M, DayCounts.ACT_365F, Frequency.P12M, 0, 0, OvernightAccrualMethod.COMPOUNDED);

    private static OvernightIborSwapConvention makeConvention(String name, OvernightIndex onIndex, IborIndex iborIndex, DayCount dayCount, Frequency frequency, int paymentLag, int cutOffDays, OvernightAccrualMethod accrual) {
        HolidayCalendarId calendarOn = onIndex.getFixingCalendar();
        DaysAdjustment paymentDateOffset = DaysAdjustment.ofBusinessDays((int)paymentLag, (HolidayCalendarId)calendarOn);
        return ImmutableOvernightIborSwapConvention.of(name, OvernightRateSwapLegConvention.builder().index(onIndex).accrualMethod(accrual).accrualFrequency(frequency).paymentFrequency(frequency).paymentDateOffset(paymentDateOffset).stubConvention(StubConvention.SMART_INITIAL).rateCutOffDays(cutOffDays).build(), IborRateSwapLegConvention.of(iborIndex));
    }

    private StandardOvernightIborSwapConventions() {
    }
}

