/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swap.type;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import com.opengamma.strata.product.TradeConvention;
import com.opengamma.strata.product.TradeInfo;
import com.opengamma.strata.product.common.BuySell;
import com.opengamma.strata.product.swap.SwapTrade;
import com.opengamma.strata.product.swap.type.OvernightRateSwapLegConvention;
import com.opengamma.strata.product.swap.type.XCcyOvernightOvernightSwapConventions;
import java.time.LocalDate;
import java.time.Period;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface XCcyOvernightOvernightSwapConvention
extends TradeConvention,
Named {
    @FromString
    public static XCcyOvernightOvernightSwapConvention of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (XCcyOvernightOvernightSwapConvention)XCcyOvernightOvernightSwapConvention.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<XCcyOvernightOvernightSwapConvention> extendedEnum() {
        return XCcyOvernightOvernightSwapConventions.ENUM_LOOKUP;
    }

    public OvernightRateSwapLegConvention getSpreadLeg();

    public OvernightRateSwapLegConvention getFlatLeg();

    public DaysAdjustment getSpotDateOffset();

    default public CurrencyPair getCurrencyPair() {
        return CurrencyPair.of((Currency)this.getSpreadLeg().getCurrency(), (Currency)this.getFlatLeg().getCurrency());
    }

    default public SwapTrade createTrade(LocalDate tradeDate, Tenor tenor, BuySell buySell, double notionalSpreadLeg, double notionalFlatLeg, double spread, ReferenceData refData) {
        return this.createTrade(tradeDate, Period.ZERO, tenor, buySell, notionalSpreadLeg, notionalFlatLeg, spread, refData);
    }

    default public SwapTrade createTrade(LocalDate tradeDate, Period periodToStart, Tenor tenor, BuySell buySell, double notionalSpreadLeg, double notionalFlatLeg, double spread, ReferenceData refData) {
        LocalDate spotValue = this.calculateSpotDateFromTradeDate(tradeDate, refData);
        LocalDate startDate = spotValue.plus(periodToStart);
        LocalDate endDate = startDate.plus(tenor.getPeriod());
        return this.toTrade(tradeDate, startDate, endDate, buySell, notionalSpreadLeg, notionalFlatLeg, spread);
    }

    default public SwapTrade toTrade(LocalDate tradeDate, LocalDate startDate, LocalDate endDate, BuySell buySell, double notionalSpreadLeg, double notionalFlatLeg, double spread) {
        TradeInfo tradeInfo = TradeInfo.of(tradeDate);
        return this.toTrade(tradeInfo, startDate, endDate, buySell, notionalSpreadLeg, notionalFlatLeg, spread);
    }

    public SwapTrade toTrade(TradeInfo var1, LocalDate var2, LocalDate var3, BuySell var4, double var5, double var7, double var9);

    default public LocalDate calculateSpotDateFromTradeDate(LocalDate tradeDate, ReferenceData refData) {
        return this.getSpotDateOffset().adjust(tradeDate, refData);
    }

    @ToString
    public String getName();
}

