/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swaption;

import com.opengamma.strata.product.common.SettlementType;
import com.opengamma.strata.product.swaption.CashSwaptionSettlementMethod;
import com.opengamma.strata.product.swaption.SwaptionSettlement;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class CashSwaptionSettlement
implements SwaptionSettlement,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate settlementDate;
    @PropertyDefinition(validate="notNull")
    private final CashSwaptionSettlementMethod method;
    private static final long serialVersionUID = 1L;

    public static CashSwaptionSettlement of(LocalDate settlementDate, CashSwaptionSettlementMethod method) {
        return new CashSwaptionSettlement(settlementDate, method);
    }

    @Override
    public SettlementType getSettlementType() {
        return SettlementType.CASH;
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private CashSwaptionSettlement(LocalDate settlementDate, CashSwaptionSettlementMethod method) {
        JodaBeanUtils.notNull((Object)settlementDate, (String)"settlementDate");
        JodaBeanUtils.notNull((Object)((Object)method), (String)"method");
        this.settlementDate = settlementDate;
        this.method = method;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalDate getSettlementDate() {
        return this.settlementDate;
    }

    public CashSwaptionSettlementMethod getMethod() {
        return this.method;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            CashSwaptionSettlement other = (CashSwaptionSettlement)obj;
            return JodaBeanUtils.equal((Object)this.settlementDate, (Object)other.settlementDate) && JodaBeanUtils.equal((Object)((Object)this.method), (Object)((Object)other.method));
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.settlementDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.method));
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("CashSwaptionSettlement{");
        buf.append("settlementDate").append('=').append(JodaBeanUtils.toString((Object)this.settlementDate)).append(',').append(' ');
        buf.append("method").append('=').append(JodaBeanUtils.toString((Object)((Object)this.method)));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<CashSwaptionSettlement> {
        private LocalDate settlementDate;
        private CashSwaptionSettlementMethod method;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -295948169: {
                    return this.settlementDate;
                }
                case -1077554975: {
                    return this.method;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -295948169: {
                    this.settlementDate = (LocalDate)newValue;
                    break;
                }
                case -1077554975: {
                    this.method = (CashSwaptionSettlementMethod)((Object)newValue);
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public CashSwaptionSettlement build() {
            return new CashSwaptionSettlement(this.settlementDate, this.method);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("CashSwaptionSettlement.Builder{");
            buf.append("settlementDate").append('=').append(JodaBeanUtils.toString((Object)this.settlementDate)).append(',').append(' ');
            buf.append("method").append('=').append(JodaBeanUtils.toString((Object)((Object)this.method)));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> settlementDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"settlementDate", CashSwaptionSettlement.class, LocalDate.class);
        private final MetaProperty<CashSwaptionSettlementMethod> method = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"method", CashSwaptionSettlement.class, CashSwaptionSettlementMethod.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"settlementDate", "method"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -295948169: {
                    return this.settlementDate;
                }
                case -1077554975: {
                    return this.method;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends CashSwaptionSettlement> builder() {
            return new Builder();
        }

        public Class<? extends CashSwaptionSettlement> beanType() {
            return CashSwaptionSettlement.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> settlementDate() {
            return this.settlementDate;
        }

        public MetaProperty<CashSwaptionSettlementMethod> method() {
            return this.method;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -295948169: {
                    return ((CashSwaptionSettlement)bean).getSettlementDate();
                }
                case -1077554975: {
                    return ((CashSwaptionSettlement)bean).getMethod();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

