/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swaption;

import com.google.common.collect.Iterables;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.product.ResolvedProduct;
import com.opengamma.strata.product.common.LongShort;
import com.opengamma.strata.product.swap.ResolvedSwap;
import com.opengamma.strata.product.swaption.SwaptionExerciseDate;
import com.opengamma.strata.product.swaption.SwaptionExerciseDates;
import com.opengamma.strata.product.swaption.SwaptionSettlement;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutablePreBuild;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class ResolvedSwaption
implements ResolvedProduct,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LongShort longShort;
    @PropertyDefinition(validate="notNull")
    private final SwaptionSettlement swaptionSettlement;
    @PropertyDefinition(validate="notNull")
    private final SwaptionExerciseDates exerciseInfo;
    @PropertyDefinition(validate="notNull")
    private final ZonedDateTime expiry;
    @PropertyDefinition(validate="notNull")
    private final ResolvedSwap underlying;
    private static final long serialVersionUID = 1L;

    @ImmutablePreBuild
    private static void preBuild(Builder builder) {
        if (builder.exerciseInfo == null && builder.expiry != null && builder.underlying != null) {
            LocalDate exerciseDate = builder.expiry.toLocalDate();
            LocalDate swapStartDate = builder.underlying.getStartDate();
            builder.exerciseInfo = SwaptionExerciseDates.ofEuropean(SwaptionExerciseDate.of(exerciseDate, exerciseDate, swapStartDate));
        }
    }

    public LocalDate getExpiryDate() {
        return this.expiry.toLocalDate();
    }

    public Currency getCurrency() {
        return (Currency)Iterables.getOnlyElement(this.underlying.allPaymentCurrencies());
    }

    public RateIndex getIndex() {
        return (RateIndex)this.underlying.allIndices().iterator().next();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private ResolvedSwaption(LongShort longShort, SwaptionSettlement swaptionSettlement, SwaptionExerciseDates exerciseInfo, ZonedDateTime expiry, ResolvedSwap underlying) {
        JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
        JodaBeanUtils.notNull((Object)swaptionSettlement, (String)"swaptionSettlement");
        JodaBeanUtils.notNull((Object)exerciseInfo, (String)"exerciseInfo");
        JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        this.longShort = longShort;
        this.swaptionSettlement = swaptionSettlement;
        this.exerciseInfo = exerciseInfo;
        this.expiry = expiry;
        this.underlying = underlying;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LongShort getLongShort() {
        return this.longShort;
    }

    public SwaptionSettlement getSwaptionSettlement() {
        return this.swaptionSettlement;
    }

    public SwaptionExerciseDates getExerciseInfo() {
        return this.exerciseInfo;
    }

    public ZonedDateTime getExpiry() {
        return this.expiry;
    }

    public ResolvedSwap getUnderlying() {
        return this.underlying;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            ResolvedSwaption other = (ResolvedSwaption)obj;
            return JodaBeanUtils.equal((Object)((Object)this.longShort), (Object)((Object)other.longShort)) && JodaBeanUtils.equal((Object)this.swaptionSettlement, (Object)other.swaptionSettlement) && JodaBeanUtils.equal((Object)this.exerciseInfo, (Object)other.exerciseInfo) && JodaBeanUtils.equal((Object)this.expiry, (Object)other.expiry) && JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.longShort));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.swaptionSettlement);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.exerciseInfo);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiry);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(192);
        buf.append("ResolvedSwaption{");
        buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
        buf.append("swaptionSettlement").append('=').append(JodaBeanUtils.toString((Object)this.swaptionSettlement)).append(',').append(' ');
        buf.append("exerciseInfo").append('=').append(JodaBeanUtils.toString((Object)this.exerciseInfo)).append(',').append(' ');
        buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<ResolvedSwaption> {
        private LongShort longShort;
        private SwaptionSettlement swaptionSettlement;
        private SwaptionExerciseDates exerciseInfo;
        private ZonedDateTime expiry;
        private ResolvedSwap underlying;

        private Builder() {
        }

        private Builder(ResolvedSwaption beanToCopy) {
            this.longShort = beanToCopy.getLongShort();
            this.swaptionSettlement = beanToCopy.getSwaptionSettlement();
            this.exerciseInfo = beanToCopy.getExerciseInfo();
            this.expiry = beanToCopy.getExpiry();
            this.underlying = beanToCopy.getUnderlying();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1937554512: {
                    return this.swaptionSettlement;
                }
                case -466669914: {
                    return this.exerciseInfo;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    this.longShort = (LongShort)((Object)newValue);
                    break;
                }
                case -1937554512: {
                    this.swaptionSettlement = (SwaptionSettlement)newValue;
                    break;
                }
                case -466669914: {
                    this.exerciseInfo = (SwaptionExerciseDates)newValue;
                    break;
                }
                case -1289159373: {
                    this.expiry = (ZonedDateTime)newValue;
                    break;
                }
                case -1770633379: {
                    this.underlying = (ResolvedSwap)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public ResolvedSwaption build() {
            ResolvedSwaption.preBuild(this);
            return new ResolvedSwaption(this.longShort, this.swaptionSettlement, this.exerciseInfo, this.expiry, this.underlying);
        }

        public Builder longShort(LongShort longShort) {
            JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
            this.longShort = longShort;
            return this;
        }

        public Builder swaptionSettlement(SwaptionSettlement swaptionSettlement) {
            JodaBeanUtils.notNull((Object)swaptionSettlement, (String)"swaptionSettlement");
            this.swaptionSettlement = swaptionSettlement;
            return this;
        }

        public Builder exerciseInfo(SwaptionExerciseDates exerciseInfo) {
            JodaBeanUtils.notNull((Object)exerciseInfo, (String)"exerciseInfo");
            this.exerciseInfo = exerciseInfo;
            return this;
        }

        public Builder expiry(ZonedDateTime expiry) {
            JodaBeanUtils.notNull((Object)expiry, (String)"expiry");
            this.expiry = expiry;
            return this;
        }

        public Builder underlying(ResolvedSwap underlying) {
            JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
            this.underlying = underlying;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(192);
            buf.append("ResolvedSwaption.Builder{");
            buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
            buf.append("swaptionSettlement").append('=').append(JodaBeanUtils.toString((Object)this.swaptionSettlement)).append(',').append(' ');
            buf.append("exerciseInfo").append('=').append(JodaBeanUtils.toString((Object)this.exerciseInfo)).append(',').append(' ');
            buf.append("expiry").append('=').append(JodaBeanUtils.toString((Object)this.expiry)).append(',').append(' ');
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LongShort> longShort = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longShort", ResolvedSwaption.class, LongShort.class);
        private final MetaProperty<SwaptionSettlement> swaptionSettlement = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"swaptionSettlement", ResolvedSwaption.class, SwaptionSettlement.class);
        private final MetaProperty<SwaptionExerciseDates> exerciseInfo = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"exerciseInfo", ResolvedSwaption.class, SwaptionExerciseDates.class);
        private final MetaProperty<ZonedDateTime> expiry = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiry", ResolvedSwaption.class, ZonedDateTime.class);
        private final MetaProperty<ResolvedSwap> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", ResolvedSwaption.class, ResolvedSwap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"longShort", "swaptionSettlement", "exerciseInfo", "expiry", "underlying"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1937554512: {
                    return this.swaptionSettlement;
                }
                case -466669914: {
                    return this.exerciseInfo;
                }
                case -1289159373: {
                    return this.expiry;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends ResolvedSwaption> beanType() {
            return ResolvedSwaption.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LongShort> longShort() {
            return this.longShort;
        }

        public MetaProperty<SwaptionSettlement> swaptionSettlement() {
            return this.swaptionSettlement;
        }

        public MetaProperty<SwaptionExerciseDates> exerciseInfo() {
            return this.exerciseInfo;
        }

        public MetaProperty<ZonedDateTime> expiry() {
            return this.expiry;
        }

        public MetaProperty<ResolvedSwap> underlying() {
            return this.underlying;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return ((ResolvedSwaption)bean).getLongShort();
                }
                case -1937554512: {
                    return ((ResolvedSwaption)bean).getSwaptionSettlement();
                }
                case -466669914: {
                    return ((ResolvedSwaption)bean).getExerciseInfo();
                }
                case -1289159373: {
                    return ((ResolvedSwaption)bean).getExpiry();
                }
                case -1770633379: {
                    return ((ResolvedSwaption)bean).getUnderlying();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

