/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swaption;

import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.Resolvable;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.index.RateIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.Product;
import com.opengamma.strata.product.common.LongShort;
import com.opengamma.strata.product.swap.Swap;
import com.opengamma.strata.product.swap.SwapLegType;
import com.opengamma.strata.product.swaption.ResolvedSwaption;
import com.opengamma.strata.product.swaption.SwaptionExercise;
import com.opengamma.strata.product.swaption.SwaptionExerciseDate;
import com.opengamma.strata.product.swaption.SwaptionExerciseDates;
import com.opengamma.strata.product.swaption.SwaptionSettlement;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class Swaption
implements Product,
Resolvable<ResolvedSwaption>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LongShort longShort;
    @PropertyDefinition(validate="notNull")
    private final SwaptionSettlement swaptionSettlement;
    @PropertyDefinition(get="optional")
    private final SwaptionExercise exerciseInfo;
    @PropertyDefinition(validate="notNull")
    private final AdjustableDate expiryDate;
    @PropertyDefinition(validate="notNull")
    private final LocalTime expiryTime;
    @PropertyDefinition(validate="notNull")
    private final ZoneId expiryZone;
    @PropertyDefinition(validate="notNull")
    private final Swap underlying;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((!this.underlying.isCrossCurrency() ? 1 : 0) != 0, (String)"Underlying swap must not be cross-currency");
        ArgChecker.isTrue((this.underlying.getLegs(SwapLegType.FIXED).size() == 1 ? 1 : 0) != 0, (String)"Underlying swap must have one fixed leg");
        ArgChecker.isTrue((this.underlying.getLegs(SwapLegType.IBOR).size() == 1 || this.underlying.getLegs(SwapLegType.OVERNIGHT).size() == 1 ? 1 : 0) != 0, (String)"Underlying swap must have one Ibor or Overnight leg");
        ArgChecker.isTrue((this.underlying.allIndices().size() == 1 ? 1 : 0) != 0, (String)"Underlying swap must have one index");
    }

    public ZonedDateTime getExpiry() {
        return this.expiryDate.getUnadjusted().atTime(this.expiryTime).atZone(this.expiryZone);
    }

    public Currency getCurrency() {
        return this.underlying.getLegs().stream().map(leg -> leg.getCurrency()).distinct().reduce(Guavate.ensureOnlyOne()).get();
    }

    @Override
    public ImmutableSet<Currency> allCurrencies() {
        return ImmutableSet.of((Object)this.getCurrency());
    }

    public RateIndex getIndex() {
        return (RateIndex)this.underlying.allIndices().iterator().next();
    }

    public Swaption selectExerciseDate(LocalDate exerciseDate, ReferenceData refData) {
        if (this.exerciseInfo == null) {
            LocalDate adjustedExpiryDate = this.expiryDate.adjusted(refData);
            if (exerciseDate.equals(adjustedExpiryDate)) {
                if (this.expiryDate.getUnadjusted().equals(exerciseDate)) {
                    return this;
                }
                return this.toBuilder().expiryDate(AdjustableDate.of((LocalDate)adjustedExpiryDate)).build();
            }
            if (exerciseDate.equals(this.expiryDate.getUnadjusted())) {
                return this;
            }
            throw new IllegalArgumentException("Unable to exercise swaption, valid exercise dates unknown: " + exerciseDate);
        }
        AdjustableDate adjutableExerciseDate = this.exerciseInfo.selectDate(exerciseDate, refData);
        LocalDate adjustedExerciseDate = adjutableExerciseDate.adjusted(refData);
        LocalDate swapStartDate = this.exerciseInfo.getSwapStartDateOffset().adjust(adjustedExerciseDate, refData);
        return this.toBuilder().exerciseInfo(null).expiryDate(adjutableExerciseDate).underlying(this.underlying.replaceStartDate(swapStartDate)).build();
    }

    public Swap exercise(LocalDate exerciseDate, ReferenceData refData) {
        return this.selectExerciseDate(exerciseDate, refData).getUnderlying();
    }

    public ResolvedSwaption resolve(ReferenceData refData) {
        SwaptionExerciseDates exerciseDates;
        LocalDate unadjustedExpiry = this.expiryDate.getUnadjusted();
        LocalDate adjustedExpiry = this.expiryDate.adjusted(refData);
        if (this.exerciseInfo == null) {
            LocalDate swapStartDate = this.underlying.getStartDate().adjusted(refData);
            SwaptionExerciseDate exercise = SwaptionExerciseDate.of(adjustedExpiry, unadjustedExpiry, swapStartDate);
            exerciseDates = SwaptionExerciseDates.ofEuropean(exercise);
        } else {
            exerciseDates = this.exerciseInfo.resolve(refData);
        }
        return ResolvedSwaption.builder().expiry(unadjustedExpiry.atTime(this.expiryTime).atZone(this.expiryZone)).longShort(this.longShort).swaptionSettlement(this.swaptionSettlement).exerciseInfo(exerciseDates).underlying(this.underlying.resolve(refData)).build();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private Swaption(LongShort longShort, SwaptionSettlement swaptionSettlement, SwaptionExercise exerciseInfo, AdjustableDate expiryDate, LocalTime expiryTime, ZoneId expiryZone, Swap underlying) {
        JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
        JodaBeanUtils.notNull((Object)swaptionSettlement, (String)"swaptionSettlement");
        JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
        JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
        JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
        JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
        this.longShort = longShort;
        this.swaptionSettlement = swaptionSettlement;
        this.exerciseInfo = exerciseInfo;
        this.expiryDate = expiryDate;
        this.expiryTime = expiryTime;
        this.expiryZone = expiryZone;
        this.underlying = underlying;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LongShort getLongShort() {
        return this.longShort;
    }

    public SwaptionSettlement getSwaptionSettlement() {
        return this.swaptionSettlement;
    }

    public Optional<SwaptionExercise> getExerciseInfo() {
        return Optional.ofNullable(this.exerciseInfo);
    }

    public AdjustableDate getExpiryDate() {
        return this.expiryDate;
    }

    public LocalTime getExpiryTime() {
        return this.expiryTime;
    }

    public ZoneId getExpiryZone() {
        return this.expiryZone;
    }

    public Swap getUnderlying() {
        return this.underlying;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            Swaption other = (Swaption)obj;
            return JodaBeanUtils.equal((Object)((Object)this.longShort), (Object)((Object)other.longShort)) && JodaBeanUtils.equal((Object)this.swaptionSettlement, (Object)other.swaptionSettlement) && JodaBeanUtils.equal((Object)this.exerciseInfo, (Object)other.exerciseInfo) && JodaBeanUtils.equal((Object)this.expiryDate, (Object)other.expiryDate) && JodaBeanUtils.equal((Object)this.expiryTime, (Object)other.expiryTime) && JodaBeanUtils.equal((Object)this.expiryZone, (Object)other.expiryZone) && JodaBeanUtils.equal((Object)this.underlying, (Object)other.underlying);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.longShort));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.swaptionSettlement);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.exerciseInfo);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryTime);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.expiryZone);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.underlying);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("Swaption{");
        buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
        buf.append("swaptionSettlement").append('=').append(JodaBeanUtils.toString((Object)this.swaptionSettlement)).append(',').append(' ');
        buf.append("exerciseInfo").append('=').append(JodaBeanUtils.toString((Object)this.exerciseInfo)).append(',').append(' ');
        buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
        buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
        buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
        buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<Swaption> {
        private LongShort longShort;
        private SwaptionSettlement swaptionSettlement;
        private SwaptionExercise exerciseInfo;
        private AdjustableDate expiryDate;
        private LocalTime expiryTime;
        private ZoneId expiryZone;
        private Swap underlying;

        private Builder() {
        }

        private Builder(Swaption beanToCopy) {
            this.longShort = beanToCopy.getLongShort();
            this.swaptionSettlement = beanToCopy.getSwaptionSettlement();
            this.exerciseInfo = beanToCopy.exerciseInfo;
            this.expiryDate = beanToCopy.getExpiryDate();
            this.expiryTime = beanToCopy.getExpiryTime();
            this.expiryZone = beanToCopy.getExpiryZone();
            this.underlying = beanToCopy.getUnderlying();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1937554512: {
                    return this.swaptionSettlement;
                }
                case -466669914: {
                    return this.exerciseInfo;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    this.longShort = (LongShort)((Object)newValue);
                    break;
                }
                case -1937554512: {
                    this.swaptionSettlement = (SwaptionSettlement)newValue;
                    break;
                }
                case -466669914: {
                    this.exerciseInfo = (SwaptionExercise)newValue;
                    break;
                }
                case -816738431: {
                    this.expiryDate = (AdjustableDate)newValue;
                    break;
                }
                case -816254304: {
                    this.expiryTime = (LocalTime)newValue;
                    break;
                }
                case -816069761: {
                    this.expiryZone = (ZoneId)newValue;
                    break;
                }
                case -1770633379: {
                    this.underlying = (Swap)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public Swaption build() {
            return new Swaption(this.longShort, this.swaptionSettlement, this.exerciseInfo, this.expiryDate, this.expiryTime, this.expiryZone, this.underlying);
        }

        public Builder longShort(LongShort longShort) {
            JodaBeanUtils.notNull((Object)((Object)longShort), (String)"longShort");
            this.longShort = longShort;
            return this;
        }

        public Builder swaptionSettlement(SwaptionSettlement swaptionSettlement) {
            JodaBeanUtils.notNull((Object)swaptionSettlement, (String)"swaptionSettlement");
            this.swaptionSettlement = swaptionSettlement;
            return this;
        }

        public Builder exerciseInfo(SwaptionExercise exerciseInfo) {
            this.exerciseInfo = exerciseInfo;
            return this;
        }

        public Builder expiryDate(AdjustableDate expiryDate) {
            JodaBeanUtils.notNull((Object)expiryDate, (String)"expiryDate");
            this.expiryDate = expiryDate;
            return this;
        }

        public Builder expiryTime(LocalTime expiryTime) {
            JodaBeanUtils.notNull((Object)expiryTime, (String)"expiryTime");
            this.expiryTime = expiryTime;
            return this;
        }

        public Builder expiryZone(ZoneId expiryZone) {
            JodaBeanUtils.notNull((Object)expiryZone, (String)"expiryZone");
            this.expiryZone = expiryZone;
            return this;
        }

        public Builder underlying(Swap underlying) {
            JodaBeanUtils.notNull((Object)underlying, (String)"underlying");
            this.underlying = underlying;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("Swaption.Builder{");
            buf.append("longShort").append('=').append(JodaBeanUtils.toString((Object)((Object)this.longShort))).append(',').append(' ');
            buf.append("swaptionSettlement").append('=').append(JodaBeanUtils.toString((Object)this.swaptionSettlement)).append(',').append(' ');
            buf.append("exerciseInfo").append('=').append(JodaBeanUtils.toString((Object)this.exerciseInfo)).append(',').append(' ');
            buf.append("expiryDate").append('=').append(JodaBeanUtils.toString((Object)this.expiryDate)).append(',').append(' ');
            buf.append("expiryTime").append('=').append(JodaBeanUtils.toString((Object)this.expiryTime)).append(',').append(' ');
            buf.append("expiryZone").append('=').append(JodaBeanUtils.toString((Object)this.expiryZone)).append(',').append(' ');
            buf.append("underlying").append('=').append(JodaBeanUtils.toString((Object)this.underlying));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LongShort> longShort = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"longShort", Swaption.class, LongShort.class);
        private final MetaProperty<SwaptionSettlement> swaptionSettlement = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"swaptionSettlement", Swaption.class, SwaptionSettlement.class);
        private final MetaProperty<SwaptionExercise> exerciseInfo = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"exerciseInfo", Swaption.class, SwaptionExercise.class);
        private final MetaProperty<AdjustableDate> expiryDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryDate", Swaption.class, AdjustableDate.class);
        private final MetaProperty<LocalTime> expiryTime = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryTime", Swaption.class, LocalTime.class);
        private final MetaProperty<ZoneId> expiryZone = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"expiryZone", Swaption.class, ZoneId.class);
        private final MetaProperty<Swap> underlying = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"underlying", Swaption.class, Swap.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"longShort", "swaptionSettlement", "exerciseInfo", "expiryDate", "expiryTime", "expiryZone", "underlying"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return this.longShort;
                }
                case -1937554512: {
                    return this.swaptionSettlement;
                }
                case -466669914: {
                    return this.exerciseInfo;
                }
                case -816738431: {
                    return this.expiryDate;
                }
                case -816254304: {
                    return this.expiryTime;
                }
                case -816069761: {
                    return this.expiryZone;
                }
                case -1770633379: {
                    return this.underlying;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends Swaption> beanType() {
            return Swaption.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LongShort> longShort() {
            return this.longShort;
        }

        public MetaProperty<SwaptionSettlement> swaptionSettlement() {
            return this.swaptionSettlement;
        }

        public MetaProperty<SwaptionExercise> exerciseInfo() {
            return this.exerciseInfo;
        }

        public MetaProperty<AdjustableDate> expiryDate() {
            return this.expiryDate;
        }

        public MetaProperty<LocalTime> expiryTime() {
            return this.expiryTime;
        }

        public MetaProperty<ZoneId> expiryZone() {
            return this.expiryZone;
        }

        public MetaProperty<Swap> underlying() {
            return this.underlying;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 116685664: {
                    return ((Swaption)bean).getLongShort();
                }
                case -1937554512: {
                    return ((Swaption)bean).getSwaptionSettlement();
                }
                case -466669914: {
                    return ((Swaption)bean).exerciseInfo;
                }
                case -816738431: {
                    return ((Swaption)bean).getExpiryDate();
                }
                case -816254304: {
                    return ((Swaption)bean).getExpiryTime();
                }
                case -816069761: {
                    return ((Swaption)bean).getExpiryZone();
                }
                case -1770633379: {
                    return ((Swaption)bean).getUnderlying();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

