/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swaption;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.date.AdjustableDates;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.date.DateAdjuster;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.Guavate;
import com.opengamma.strata.product.swaption.SwaptionExerciseDate;
import com.opengamma.strata.product.swaption.SwaptionExerciseDates;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.Period;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class SwaptionExercise
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final AdjustableDates dateDefinition;
    @PropertyDefinition(get="optional")
    private final Frequency frequency;
    @PropertyDefinition(validate="notNull")
    private final DaysAdjustment swapStartDateOffset;
    private static final long serialVersionUID = 1L;

    public static SwaptionExercise ofEuropean(AdjustableDate exerciseDate, DaysAdjustment swapStartDateOffset) {
        AdjustableDates dates = AdjustableDates.of((BusinessDayAdjustment)exerciseDate.getAdjustment(), (LocalDate)exerciseDate.getUnadjusted(), (LocalDate[])new LocalDate[0]);
        return new SwaptionExercise(dates, null, swapStartDateOffset);
    }

    public static SwaptionExercise ofAmerican(LocalDate earliestExerciseDate, LocalDate latestExerciseDate, BusinessDayAdjustment dateAdjustment, DaysAdjustment swapStartDateOffset) {
        AdjustableDates dates = AdjustableDates.of((BusinessDayAdjustment)dateAdjustment, (LocalDate)earliestExerciseDate, (LocalDate[])new LocalDate[]{latestExerciseDate});
        return new SwaptionExercise(dates, Frequency.P1D, swapStartDateOffset);
    }

    public static SwaptionExercise ofBermudan(AdjustableDates exerciseDates, DaysAdjustment swapStartDateOffset) {
        return new SwaptionExercise(exerciseDates, null, swapStartDateOffset);
    }

    public static SwaptionExercise ofBermudan(LocalDate earliestExerciseDate, LocalDate latestExerciseDate, BusinessDayAdjustment dateAdjustment, Frequency frequency, DaysAdjustment swapStartDateOffset) {
        AdjustableDates dates = AdjustableDates.of((BusinessDayAdjustment)dateAdjustment, (LocalDate)earliestExerciseDate, (LocalDate[])new LocalDate[]{latestExerciseDate});
        Frequency normalizedFrequency = Frequency.of((Period)frequency.getPeriod().normalized());
        return new SwaptionExercise(dates, normalizedFrequency, swapStartDateOffset);
    }

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)Ordering.natural().isStrictlyOrdered((Iterable)this.dateDefinition.getUnadjusted()), (String)"Dates must be in order and without duplicates");
        if (this.frequency != null && this.dateDefinition.getUnadjusted().size() != 2) {
            throw new IllegalArgumentException("Frequency can only be used when there two exercise dates are defined");
        }
    }

    public boolean isEuropean() {
        return this.dateDefinition.getUnadjusted().size() == 1;
    }

    public boolean isAmerican() {
        return this.dateDefinition.getUnadjusted().size() == 2 && Frequency.P1D.equals((Object)this.frequency);
    }

    public boolean isBermudan() {
        return !this.isEuropean() && !this.isAmerican();
    }

    public AdjustableDates calculateDates() {
        if (this.frequency != null) {
            LocalDate start = (LocalDate)this.dateDefinition.getUnadjusted().get(0);
            LocalDate end = (LocalDate)this.dateDefinition.getUnadjusted().get(1);
            if (this.frequency.equals((Object)Frequency.P1D)) {
                ImmutableList dates = (ImmutableList)LongStream.rangeClosed(start.toEpochDay(), end.toEpochDay()).mapToObj(LocalDate::ofEpochDay).collect(Guavate.toImmutableList());
                return AdjustableDates.of((BusinessDayAdjustment)this.dateDefinition.getAdjustment(), (List)dates);
            }
            ImmutableList.Builder dates = ImmutableList.builder();
            dates.add((Object)start);
            int i = 1;
            while (true) {
                LocalDate date;
                if (!(date = start.plus(this.frequency.getPeriod().multipliedBy(i))).isBefore(end)) break;
                dates.add((Object)date);
                ++i;
            }
            dates.add((Object)end);
            return AdjustableDates.of((BusinessDayAdjustment)this.dateDefinition.getAdjustment(), (List)dates.build());
        }
        return this.dateDefinition;
    }

    SwaptionExerciseDates resolve(ReferenceData refData) {
        AdjustableDates defn = this.isBermudan() ? this.calculateDates() : this.dateDefinition;
        ImmutableList unadjusted = defn.getUnadjusted();
        ImmutableList adjusted = defn.adjusted(refData);
        DateAdjuster startDateOffset = this.swapStartDateOffset.resolve(refData);
        ImmutableList dates = (ImmutableList)Guavate.zip((Stream)adjusted.stream(), (Stream)unadjusted.stream()).map(pair -> SwaptionExerciseDate.builder().exerciseDate((LocalDate)pair.getFirst()).unadjustedExerciseDate((LocalDate)pair.getSecond()).swapStartDate(startDateOffset.adjust((LocalDate)pair.getFirst())).build()).collect(Guavate.toImmutableList());
        return SwaptionExerciseDates.of((List<SwaptionExerciseDate>)dates, this.isAmerican());
    }

    public AdjustableDate selectDate(LocalDate proposedExerciseDate, ReferenceData refData) {
        DateAdjuster adjuster = this.dateDefinition.getAdjustment().resolve(refData);
        if (Frequency.P1D.equals((Object)this.frequency)) {
            return this.selectAmerican(proposedExerciseDate, adjuster);
        }
        return this.selectStandard(proposedExerciseDate, adjuster);
    }

    private AdjustableDate selectAmerican(LocalDate proposedExerciseDate, DateAdjuster adjuster) {
        LocalDate end;
        LocalDate start = (LocalDate)this.dateDefinition.getUnadjusted().get(0);
        LocalDate unadjusted = end = (LocalDate)this.dateDefinition.getUnadjusted().get(1);
        while (!unadjusted.isBefore(start)) {
            if (adjuster.adjust(unadjusted).equals(proposedExerciseDate)) {
                return unadjusted.equals(proposedExerciseDate) ? AdjustableDate.of((LocalDate)proposedExerciseDate, (BusinessDayAdjustment)this.dateDefinition.getAdjustment()) : AdjustableDate.of((LocalDate)proposedExerciseDate);
            }
            unadjusted = unadjusted.minusDays(1L);
        }
        if (!proposedExerciseDate.isBefore(start) && !proposedExerciseDate.isAfter(end)) {
            return AdjustableDate.of((LocalDate)proposedExerciseDate, (BusinessDayAdjustment)this.dateDefinition.getAdjustment());
        }
        throw new IllegalArgumentException("Invalid exercise date: " + proposedExerciseDate);
    }

    private AdjustableDate selectStandard(LocalDate proposedExerciseDate, DateAdjuster adjuster) {
        AdjustableDates dates = this.calculateDates();
        for (LocalDate unadjusted : dates.getUnadjusted()) {
            if (!adjuster.adjust(unadjusted).equals(proposedExerciseDate)) continue;
            return unadjusted.equals(proposedExerciseDate) ? AdjustableDate.of((LocalDate)proposedExerciseDate, (BusinessDayAdjustment)this.dateDefinition.getAdjustment()) : AdjustableDate.of((LocalDate)proposedExerciseDate);
        }
        if (dates.getUnadjusted().contains((Object)proposedExerciseDate)) {
            return AdjustableDate.of((LocalDate)proposedExerciseDate, (BusinessDayAdjustment)this.dateDefinition.getAdjustment());
        }
        throw new IllegalArgumentException("Invalid exercise date: " + proposedExerciseDate);
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private SwaptionExercise(AdjustableDates dateDefinition, Frequency frequency, DaysAdjustment swapStartDateOffset) {
        JodaBeanUtils.notNull((Object)dateDefinition, (String)"dateDefinition");
        JodaBeanUtils.notNull((Object)swapStartDateOffset, (String)"swapStartDateOffset");
        this.dateDefinition = dateDefinition;
        this.frequency = frequency;
        this.swapStartDateOffset = swapStartDateOffset;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public AdjustableDates getDateDefinition() {
        return this.dateDefinition;
    }

    public Optional<Frequency> getFrequency() {
        return Optional.ofNullable(this.frequency);
    }

    public DaysAdjustment getSwapStartDateOffset() {
        return this.swapStartDateOffset;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SwaptionExercise other = (SwaptionExercise)obj;
            return JodaBeanUtils.equal((Object)this.dateDefinition, (Object)other.dateDefinition) && JodaBeanUtils.equal((Object)this.frequency, (Object)other.frequency) && JodaBeanUtils.equal((Object)this.swapStartDateOffset, (Object)other.swapStartDateOffset);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.dateDefinition);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.frequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.swapStartDateOffset);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("SwaptionExercise{");
        buf.append("dateDefinition").append('=').append(JodaBeanUtils.toString((Object)this.dateDefinition)).append(',').append(' ');
        buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
        buf.append("swapStartDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.swapStartDateOffset));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<SwaptionExercise> {
        private AdjustableDates dateDefinition;
        private Frequency frequency;
        private DaysAdjustment swapStartDateOffset;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 257736609: {
                    return this.dateDefinition;
                }
                case -70023844: {
                    return this.frequency;
                }
                case 1366770128: {
                    return this.swapStartDateOffset;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 257736609: {
                    this.dateDefinition = (AdjustableDates)newValue;
                    break;
                }
                case -70023844: {
                    this.frequency = (Frequency)newValue;
                    break;
                }
                case 1366770128: {
                    this.swapStartDateOffset = (DaysAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public SwaptionExercise build() {
            return new SwaptionExercise(this.dateDefinition, this.frequency, this.swapStartDateOffset);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("SwaptionExercise.Builder{");
            buf.append("dateDefinition").append('=').append(JodaBeanUtils.toString((Object)this.dateDefinition)).append(',').append(' ');
            buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
            buf.append("swapStartDateOffset").append('=').append(JodaBeanUtils.toString((Object)this.swapStartDateOffset));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<AdjustableDates> dateDefinition = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dateDefinition", SwaptionExercise.class, AdjustableDates.class);
        private final MetaProperty<Frequency> frequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"frequency", SwaptionExercise.class, Frequency.class);
        private final MetaProperty<DaysAdjustment> swapStartDateOffset = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"swapStartDateOffset", SwaptionExercise.class, DaysAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"dateDefinition", "frequency", "swapStartDateOffset"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 257736609: {
                    return this.dateDefinition;
                }
                case -70023844: {
                    return this.frequency;
                }
                case 1366770128: {
                    return this.swapStartDateOffset;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends SwaptionExercise> builder() {
            return new Builder();
        }

        public Class<? extends SwaptionExercise> beanType() {
            return SwaptionExercise.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<AdjustableDates> dateDefinition() {
            return this.dateDefinition;
        }

        public MetaProperty<Frequency> frequency() {
            return this.frequency;
        }

        public MetaProperty<DaysAdjustment> swapStartDateOffset() {
            return this.swapStartDateOffset;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 257736609: {
                    return ((SwaptionExercise)bean).getDateDefinition();
                }
                case -70023844: {
                    return ((SwaptionExercise)bean).frequency;
                }
                case 1366770128: {
                    return ((SwaptionExercise)bean).getSwapStartDateOffset();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

