/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swaption;

import com.google.common.collect.ComparisonChain;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.NoSuchElementException;
import java.util.function.Function;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.TypedMetaBean;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.MinimalMetaBean;

@BeanDefinition(style="minimal", factoryName="of")
public final class SwaptionExerciseDate
implements Comparable<SwaptionExerciseDate>,
ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate exerciseDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjustedExerciseDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate swapStartDate;
    private static final TypedMetaBean<SwaptionExerciseDate> META_BEAN = MinimalMetaBean.of(SwaptionExerciseDate.class, (String[])new String[]{"exerciseDate", "unadjustedExerciseDate", "swapStartDate"}, () -> new Builder(), (Function[])new Function[]{b -> b.getExerciseDate(), b -> b.getUnadjustedExerciseDate(), b -> b.getSwapStartDate()});
    private static final long serialVersionUID = 1L;

    @Override
    public int compareTo(SwaptionExerciseDate other) {
        return ComparisonChain.start().compare((Comparable)this.unadjustedExerciseDate, (Comparable)other.unadjustedExerciseDate).compare((Comparable)this.swapStartDate, (Comparable)other.swapStartDate).result();
    }

    public static TypedMetaBean<SwaptionExerciseDate> meta() {
        return META_BEAN;
    }

    public static SwaptionExerciseDate of(LocalDate exerciseDate, LocalDate unadjustedExerciseDate, LocalDate swapStartDate) {
        return new SwaptionExerciseDate(exerciseDate, unadjustedExerciseDate, swapStartDate);
    }

    public static Builder builder() {
        return new Builder();
    }

    private SwaptionExerciseDate(LocalDate exerciseDate, LocalDate unadjustedExerciseDate, LocalDate swapStartDate) {
        JodaBeanUtils.notNull((Object)exerciseDate, (String)"exerciseDate");
        JodaBeanUtils.notNull((Object)unadjustedExerciseDate, (String)"unadjustedExerciseDate");
        JodaBeanUtils.notNull((Object)swapStartDate, (String)"swapStartDate");
        this.exerciseDate = exerciseDate;
        this.unadjustedExerciseDate = unadjustedExerciseDate;
        this.swapStartDate = swapStartDate;
    }

    public TypedMetaBean<SwaptionExerciseDate> metaBean() {
        return META_BEAN;
    }

    public LocalDate getExerciseDate() {
        return this.exerciseDate;
    }

    public LocalDate getUnadjustedExerciseDate() {
        return this.unadjustedExerciseDate;
    }

    public LocalDate getSwapStartDate() {
        return this.swapStartDate;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SwaptionExerciseDate other = (SwaptionExerciseDate)obj;
            return JodaBeanUtils.equal((Object)this.exerciseDate, (Object)other.exerciseDate) && JodaBeanUtils.equal((Object)this.unadjustedExerciseDate, (Object)other.unadjustedExerciseDate) && JodaBeanUtils.equal((Object)this.swapStartDate, (Object)other.swapStartDate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.exerciseDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjustedExerciseDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.swapStartDate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(128);
        buf.append("SwaptionExerciseDate{");
        buf.append("exerciseDate").append('=').append(JodaBeanUtils.toString((Object)this.exerciseDate)).append(',').append(' ');
        buf.append("unadjustedExerciseDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedExerciseDate)).append(',').append(' ');
        buf.append("swapStartDate").append('=').append(JodaBeanUtils.toString((Object)this.swapStartDate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register(META_BEAN);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SwaptionExerciseDate> {
        private LocalDate exerciseDate;
        private LocalDate unadjustedExerciseDate;
        private LocalDate swapStartDate;

        private Builder() {
        }

        private Builder(SwaptionExerciseDate beanToCopy) {
            this.exerciseDate = beanToCopy.getExerciseDate();
            this.unadjustedExerciseDate = beanToCopy.getUnadjustedExerciseDate();
            this.swapStartDate = beanToCopy.getSwapStartDate();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -466830938: {
                    return this.exerciseDate;
                }
                case -2091106995: {
                    return this.unadjustedExerciseDate;
                }
                case -71742755: {
                    return this.swapStartDate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -466830938: {
                    this.exerciseDate = (LocalDate)newValue;
                    break;
                }
                case -2091106995: {
                    this.unadjustedExerciseDate = (LocalDate)newValue;
                    break;
                }
                case -71742755: {
                    this.swapStartDate = (LocalDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SwaptionExerciseDate build() {
            return new SwaptionExerciseDate(this.exerciseDate, this.unadjustedExerciseDate, this.swapStartDate);
        }

        public Builder exerciseDate(LocalDate exerciseDate) {
            JodaBeanUtils.notNull((Object)exerciseDate, (String)"exerciseDate");
            this.exerciseDate = exerciseDate;
            return this;
        }

        public Builder unadjustedExerciseDate(LocalDate unadjustedExerciseDate) {
            JodaBeanUtils.notNull((Object)unadjustedExerciseDate, (String)"unadjustedExerciseDate");
            this.unadjustedExerciseDate = unadjustedExerciseDate;
            return this;
        }

        public Builder swapStartDate(LocalDate swapStartDate) {
            JodaBeanUtils.notNull((Object)swapStartDate, (String)"swapStartDate");
            this.swapStartDate = swapStartDate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(128);
            buf.append("SwaptionExerciseDate.Builder{");
            buf.append("exerciseDate").append('=').append(JodaBeanUtils.toString((Object)this.exerciseDate)).append(',').append(' ');
            buf.append("unadjustedExerciseDate").append('=').append(JodaBeanUtils.toString((Object)this.unadjustedExerciseDate)).append(',').append(' ');
            buf.append("swapStartDate").append('=').append(JodaBeanUtils.toString((Object)this.swapStartDate));
            buf.append('}');
            return buf.toString();
        }
    }
}

