/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.product.swaption;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.product.swaption.SwaptionExerciseDate;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.ImmutableValidator;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition(factoryName="of")
public final class SwaptionExerciseDates
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notEmpty")
    private final ImmutableList<SwaptionExerciseDate> dates;
    @PropertyDefinition
    private final boolean allDates;
    private static final long serialVersionUID = 1L;

    @ImmutableValidator
    private void validate() {
        ArgChecker.isTrue((boolean)Ordering.natural().isStrictlyOrdered(this.dates), (String)"Dates must be in order and without duplicates");
        if (this.allDates && this.dates.size() != 2) {
            throw new IllegalArgumentException("All dates flag can only be used when two exercise dates are defined");
        }
    }

    static SwaptionExerciseDates ofEuropean(SwaptionExerciseDate exerciseDate) {
        return SwaptionExerciseDates.builder().dates(exerciseDate).build();
    }

    public boolean isEuropean() {
        return this.dates.size() == 1;
    }

    public boolean isAmerican() {
        return this.allDates;
    }

    public boolean isBermudan() {
        return !this.isEuropean() && !this.isAmerican();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static SwaptionExerciseDates of(List<SwaptionExerciseDate> dates, boolean allDates) {
        return new SwaptionExerciseDates(dates, allDates);
    }

    public static Builder builder() {
        return new Builder();
    }

    private SwaptionExerciseDates(List<SwaptionExerciseDate> dates, boolean allDates) {
        JodaBeanUtils.notEmpty(dates, (String)"dates");
        this.dates = ImmutableList.copyOf(dates);
        this.allDates = allDates;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public ImmutableList<SwaptionExerciseDate> getDates() {
        return this.dates;
    }

    public boolean isAllDates() {
        return this.allDates;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            SwaptionExerciseDates other = (SwaptionExerciseDates)obj;
            return JodaBeanUtils.equal(this.dates, other.dates) && this.allDates == other.allDates;
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode(this.dates);
        hash = hash * 31 + JodaBeanUtils.hashCode((boolean)this.allDates);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(96);
        buf.append("SwaptionExerciseDates{");
        buf.append("dates").append('=').append(JodaBeanUtils.toString(this.dates)).append(',').append(' ');
        buf.append("allDates").append('=').append(JodaBeanUtils.toString((Object)this.allDates));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<SwaptionExerciseDates> {
        private List<SwaptionExerciseDate> dates = ImmutableList.of();
        private boolean allDates;

        private Builder() {
        }

        private Builder(SwaptionExerciseDates beanToCopy) {
            this.dates = beanToCopy.getDates();
            this.allDates = beanToCopy.isAllDates();
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 95356549: {
                    return this.dates;
                }
                case 1772779876: {
                    return this.allDates;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 95356549: {
                    this.dates = (List)newValue;
                    break;
                }
                case 1772779876: {
                    this.allDates = (Boolean)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public SwaptionExerciseDates build() {
            return new SwaptionExerciseDates(this.dates, this.allDates);
        }

        public Builder dates(List<SwaptionExerciseDate> dates) {
            JodaBeanUtils.notEmpty(dates, (String)"dates");
            this.dates = dates;
            return this;
        }

        public Builder dates(SwaptionExerciseDate ... dates) {
            return this.dates((List<SwaptionExerciseDate>)ImmutableList.copyOf((Object[])dates));
        }

        public Builder allDates(boolean allDates) {
            this.allDates = allDates;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("SwaptionExerciseDates.Builder{");
            buf.append("dates").append('=').append(JodaBeanUtils.toString(this.dates)).append(',').append(' ');
            buf.append("allDates").append('=').append(JodaBeanUtils.toString((Object)this.allDates));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<ImmutableList<SwaptionExerciseDate>> dates = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"dates", SwaptionExerciseDates.class, ImmutableList.class);
        private final MetaProperty<Boolean> allDates = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"allDates", SwaptionExerciseDates.class, Boolean.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"dates", "allDates"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 95356549: {
                    return this.dates;
                }
                case 1772779876: {
                    return this.allDates;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends SwaptionExerciseDates> beanType() {
            return SwaptionExerciseDates.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<ImmutableList<SwaptionExerciseDate>> dates() {
            return this.dates;
        }

        public MetaProperty<Boolean> allDates() {
            return this.allDates;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 95356549: {
                    return ((SwaptionExerciseDates)bean).getDates();
                }
                case 1772779876: {
                    return ((SwaptionExerciseDates)bean).isAllDates();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

