/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.FlowingColumnBox;
import com.openhtmltopdf.render.PageBox;
import java.util.ArrayList;
import java.util.List;

public class FlowingColumnContainerBox
extends BlockBox {
    private FlowingColumnBox _child;

    private int findPageIndex(List<PageBox> pages, int y) {
        int idx = 0;
        for (PageBox page : pages) {
            if (y >= page.getTop() && y <= page.getBottom()) {
                return idx;
            }
            ++idx;
        }
        return idx - 1;
    }

    private int adjust(LayoutContext c, Box child, int colGap, int colWidth, int columnCount, int xStart) {
        int startY = this.getAbsY();
        List pages = c.getRootLayer().getPages();
        int pageIdx = this.findPageIndex(pages, startY);
        int colStart = startY;
        int colHeight = ((PageBox)pages.get(pageIdx)).getBottom();
        int colIdx = 0;
        int finalHeight = 0;
        ArrayList<ColumnPosition> cols = new ArrayList<ColumnPosition>();
        cols.add(new ColumnPosition(0, startY, colHeight, pageIdx));
        for (Object chld : child.getChildren()) {
            Box ch = (Box)chld;
            int yAdjust = ((ColumnPosition)cols.get(colIdx)).pasteY - ((ColumnPosition)cols.get(colIdx)).copyY;
            int yProposedFinal = ch.getY() + yAdjust;
            if (yProposedFinal + ch.getHeight() > ((ColumnPosition)cols.get(colIdx)).maxColHeight) {
                int newPageIdx;
                int newColIdx = colIdx + 1;
                int n = newPageIdx = newColIdx % columnCount == 0 ? ((ColumnPosition)cols.get(colIdx)).pageIdx + 1 : ((ColumnPosition)cols.get(colIdx)).pageIdx;
                if (newPageIdx >= pages.size()) {
                    c.getRootLayer().addPage(c);
                }
                int pasteY = newColIdx % columnCount == 0 ? ((PageBox)pages.get(newPageIdx)).getTop() : ((ColumnPosition)cols.get(colIdx)).pasteY;
                cols.add(new ColumnPosition(ch.getY(), pasteY, ((PageBox)pages.get(newPageIdx)).getBottom(), newPageIdx));
                yAdjust = ((ColumnPosition)cols.get(++colIdx)).pasteY - ((ColumnPosition)cols.get(colIdx)).copyY;
                yProposedFinal = ch.getY() + yAdjust;
            }
            ch.setY(yProposedFinal - colStart);
            finalHeight = Math.max(yProposedFinal - colStart + ch.getHeight(), finalHeight);
            int xAdjust = colIdx % columnCount * colWidth + colIdx % columnCount * colGap;
            ch.setX(ch.getX() + xAdjust + xStart);
        }
        return finalHeight;
    }

    @Override
    public void layout(LayoutContext c, int contentStart) {
        this.calcDimensions(c);
        int colCount = this.getStyle().columnCount();
        int colGapCount = colCount - 1;
        float colGap = this.getStyle().isIdent(CSSName.COLUMN_GAP, IdentValue.NORMAL) ? this.getStyle().getLineHeight(c) : this.getStyle().getFloatPropertyProportionalWidth(CSSName.COLUMN_GAP, this.getContentWidth(), c);
        float totalGap = colGap * (float)colGapCount;
        int colWidth = (int)(((float)this.getContentWidth() - totalGap) / (float)colCount);
        this._child.setContainingLayer(this.getContainingLayer());
        this._child.setContentWidth(colWidth);
        this._child.setColumnWidth(colWidth);
        this._child.setAbsX(this.getAbsX());
        this._child.setAbsY(this.getAbsY());
        c.setIsPrintOverride(false);
        this._child.layout(c, contentStart);
        c.setIsPrintOverride(null);
        int height = this.adjust(c, this._child, (int)colGap, colWidth, colCount, this.getLeftMBP() + this.getX());
        this._child.setHeight(0);
        this.setHeight(height);
        this._child.calcChildLocations();
    }

    public void setOnlyChild(LayoutContext c, FlowingColumnBox child) {
        this._child = child;
        this.addChild(child);
    }

    public FlowingColumnBox getChild() {
        return this._child;
    }

    private static class ColumnPosition {
        private final int copyY;
        private final int pasteY;
        private final int maxColHeight;
        private final int pageIdx;

        private ColumnPosition(int copyY, int pasteY, int maxColHeight, int pageIdx) {
            this.copyY = copyY;
            this.pasteY = pasteY;
            this.maxColHeight = maxColHeight;
            this.pageIdx = pageIdx;
        }
    }
}

