/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.resource;

import com.openhtmltopdf.resource.Resource;
import com.openhtmltopdf.util.XRLog;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.xml.sax.InputSource;

public abstract class AbstractResource
implements Resource {
    private final StreamType streamType;
    private InputSource inputSource;
    private InputStream inputStream;
    private Reader inputReader;
    private long createTimeStamp = System.currentTimeMillis();
    private long elapsedLoadTime;

    private AbstractResource(StreamType streamType) {
        this.streamType = streamType;
    }

    public AbstractResource(InputSource source) {
        this(StreamType.INPUT_SOURCE);
        this.inputSource = source;
    }

    public AbstractResource(Reader reader) {
        this(StreamType.READER);
        this.inputReader = reader;
    }

    public AbstractResource(InputStream is) {
        this(StreamType.STREAM);
        this.inputStream = is;
    }

    @Override
    public InputSource getResourceInputSource() {
        if (this.streamType == StreamType.STREAM && this.inputSource == null) {
            this.inputSource = new InputSource(new BufferedInputStream(this.inputStream));
        }
        return this.inputSource;
    }

    public Reader getResourceReader() {
        if (this.streamType == StreamType.STREAM && this.inputReader == null) {
            try {
                this.inputReader = new InputStreamReader(this.inputStream, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                XRLog.exception("Could not create reader for stream", e);
            }
        }
        return this.inputReader;
    }

    public InputStream getResourceInputStream() {
        return this.inputStream;
    }

    @Override
    public long getResourceLoadTimeStamp() {
        return this.createTimeStamp;
    }

    public long getElapsedLoadTime() {
        return this.elapsedLoadTime;
    }

    void setElapsedLoadTime(long elapsedLoadTime) {
        this.elapsedLoadTime = elapsedLoadTime;
    }

    private static enum StreamType {
        READER,
        STREAM,
        INPUT_SOURCE;

    }
}

