/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.displaylist;

import com.openhtmltopdf.layout.CollapsedBorderSide;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.newtable.CollapsedBorderValue;
import com.openhtmltopdf.newtable.TableBox;
import com.openhtmltopdf.newtable.TableCellBox;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.displaylist.ArrayDisplayListContainer;
import com.openhtmltopdf.render.displaylist.DisplayListContainer;
import com.openhtmltopdf.render.displaylist.DisplayListOperation;
import com.openhtmltopdf.render.displaylist.MapDisplayListContainer;
import com.openhtmltopdf.render.displaylist.PagedBoxCollector;
import com.openhtmltopdf.render.displaylist.PaintBackgroundAndBorders;
import com.openhtmltopdf.render.displaylist.PaintFixedLayer;
import com.openhtmltopdf.render.displaylist.PaintInlineContent;
import com.openhtmltopdf.render.displaylist.PaintLayerBackgroundAndBorder;
import com.openhtmltopdf.render.displaylist.PaintListMarkers;
import com.openhtmltopdf.render.displaylist.PaintPopClipRect;
import com.openhtmltopdf.render.displaylist.PaintPopTransformLayer;
import com.openhtmltopdf.render.displaylist.PaintPushClipRect;
import com.openhtmltopdf.render.displaylist.PaintPushTransformLayer;
import com.openhtmltopdf.render.displaylist.PaintReplacedElement;
import com.openhtmltopdf.render.displaylist.PaintReplacedElements;
import com.openhtmltopdf.render.displaylist.PaintRootElementBackground;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DisplayListCollector {
    private final List<PageBox> _pages;

    public DisplayListCollector(List<PageBox> pages) {
        this._pages = pages;
    }

    private void collectLayers(RenderingContext c, List<Layer> layers, DisplayListContainer dlPages, Set<CollectFlags> flags) {
        for (Layer layer : layers) {
            this.collect(c, layer, dlPages, flags);
        }
    }

    protected void addItem(DisplayListOperation item, int pgStart, int pgEnd, DisplayListContainer dlPages) {
        for (int i = pgStart; i <= pgEnd; ++i) {
            dlPages.getPageInstructions(i).addOp(item);
        }
    }

    protected void addItem(DisplayListOperation item, List<PagedBoxCollector.PageInfo> pages, DisplayListContainer dlPages) {
        for (PagedBoxCollector.PageInfo pg : pages) {
            if (pg.shadowPageNumber == -1) {
                dlPages.getPageInstructions(pg.pageNumber).addOp(item);
                continue;
            }
            dlPages.getPageInstructions(pg.pageNumber).getShadowPage(pg.shadowPageNumber).addOp(item);
        }
    }

    public DisplayListContainer collectRoot(RenderingContext c, Layer rootLayer) {
        if (!rootLayer.isRootLayer()) {
            return null;
        }
        rootLayer.propagateCurrentTransformationMatrix(c);
        ArrayDisplayListContainer displayList = new ArrayDisplayListContainer(0, this._pages.size() - 1);
        this.collect(c, rootLayer, displayList, EnumSet.noneOf(CollectFlags.class));
        return displayList;
    }

    protected void collect(RenderingContext c, Layer layer, DisplayListContainer dlPages, Set<CollectFlags> flags) {
        DisplayListOperation dlo;
        if (layer.getMaster().getStyle().isFixed() && !flags.contains((Object)CollectFlags.INCLUDE_FIXED_BOXES)) {
            PaintFixedLayer dlo2 = new PaintFixedLayer(layer);
            this.addItem(dlo2, 0, this._pages.size() - 1, dlPages);
            return;
        }
        List<PagedBoxCollector.PageInfo> layerPages = PagedBoxCollector.findLayerPages(c, layer, this._pages);
        int layerPageStart = this.findStartPage(c, layer);
        int layerPageEnd = this.findEndPage(c, layer);
        boolean pushedClip = false;
        Rectangle parentClip = layer.getMaster().getParentClipBox(c, layer.getParent());
        if (parentClip != null) {
            dlo = new PaintPushClipRect(parentClip);
            this.addItem(dlo, layerPages, dlPages);
            pushedClip = true;
        }
        if (layer.hasLocalTransform()) {
            dlo = new PaintPushTransformLayer(layer.getMaster());
            this.addItem(dlo, layerPages, dlPages);
        }
        if (layer.isRootLayer() && layer.getMaster().hasRootElementBackground(c)) {
            dlo = new PaintRootElementBackground(layer.getMaster());
            this.addItem(dlo, dlPages.getMinPage(), dlPages.getMaxPage(), dlPages);
        }
        if (!layer.isInline() && ((BlockBox)layer.getMaster()).isReplaced()) {
            this.collectReplacedElementLayer(c, layer, dlPages, layerPageStart, layerPageEnd);
        } else {
            PagedBoxCollector collector = this.createBoundedBoxCollector(layerPageStart, layerPageEnd);
            collector.collectFloats(c, layer);
            collector.collect(c, layer);
            if (!layer.isInline() && layer.getMaster() instanceof BlockBox) {
                this.collectLayerBackgroundAndBorder(c, layer, dlPages, layerPageStart, layerPageEnd);
            }
            if (layer.isRootLayer() || layer.isStackingContext()) {
                this.collectLayers(c, layer.getSortedLayers(3), dlPages, flags);
            }
            for (int pageNumber = layerPageStart; pageNumber <= layerPageEnd; ++pageNumber) {
                PagedBoxCollector.PageResult pg = collector.getPageResult(pageNumber);
                DisplayListContainer.DisplayListPageContainer dlPageList = dlPages.getPageInstructions(pageNumber);
                this.processPage(c, layer, pg, dlPageList, true, pageNumber, -1);
                this.processShadowPages(c, layer, pageNumber, pg, dlPageList, true);
            }
            if (layer.isRootLayer() || layer.isStackingContext()) {
                this.collectLayers(c, layer.collectLayers(4), dlPages, flags);
                this.collectLayers(c, layer.getSortedLayers(2), dlPages, flags);
                this.collectLayers(c, layer.getSortedLayers(1), dlPages, flags);
            }
        }
        if (layer.hasLocalTransform()) {
            dlo = new PaintPopTransformLayer(layer.getMaster());
            this.addItem(dlo, layerPages, dlPages);
        }
        if (pushedClip) {
            dlo = new PaintPopClipRect();
            this.addItem(dlo, layerPages, dlPages);
        }
    }

    protected void processPage(RenderingContext c, Layer layer, PagedBoxCollector.PageResult pg, DisplayListContainer.DisplayListPageContainer dlPageList, boolean includeFloats, int pageNumber, int shadowPageNumber) {
        DisplayListOperation dlo;
        if (!pg.blocks().isEmpty()) {
            Iterator<BlockBox> collapsedTableBorders = pg.tcells().isEmpty() ? null : DisplayListCollector.collectCollapsedTableBorders(c, pg.tcells());
            PaintBackgroundAndBorders dlo2 = new PaintBackgroundAndBorders(pg.blocks(), (Map<TableCellBox, List<CollapsedBorderSide>>)((Object)collapsedTableBorders));
            dlPageList.addOp(dlo2);
        }
        if (includeFloats) {
            for (BlockBox floater : pg.floats()) {
                this.collectFloatAsLayer(c, layer, floater, dlPageList, pageNumber, shadowPageNumber);
            }
        }
        if (!pg.listItems().isEmpty()) {
            dlo = new PaintListMarkers(pg.listItems());
            dlPageList.addOp(dlo);
        }
        if (!pg.inlines().isEmpty()) {
            dlo = new PaintInlineContent(pg.inlines());
            dlPageList.addOp(dlo);
        }
        if (!pg.replaceds().isEmpty()) {
            dlo = new PaintReplacedElements(pg.replaceds());
            dlPageList.addOp(dlo);
        }
    }

    private void processShadowPages(RenderingContext c, Layer layer, int pageNumber, PagedBoxCollector.PageResult pg, DisplayListContainer.DisplayListPageContainer dlPageList, boolean includeFloats) {
        int shadowCnt = 0;
        for (PagedBoxCollector.PageResult shadow : pg.shadowPages()) {
            DisplayListContainer.DisplayListPageContainer shadowPage = dlPageList.getShadowPage(shadowCnt);
            this.processPage(c, layer, shadow, shadowPage, includeFloats, pageNumber, shadowCnt);
            ++shadowCnt;
        }
    }

    private void collectFloatAsLayer(RenderingContext c, Layer layer, BlockBox floater, DisplayListContainer.DisplayListPageContainer pageInstructions, int pageNumber, int shadowPageNumber) {
        DisplayListOperation dlo;
        PagedBoxCollector collector = this.createBoundedBoxCollector(pageNumber, pageNumber);
        collector.collect(c, layer, floater, pageNumber, pageNumber, shadowPageNumber);
        PagedBoxCollector.PageResult pageBoxes = collector.getPageResult(pageNumber);
        if (shadowPageNumber >= 0 && pageBoxes.hasShadowPage(shadowPageNumber)) {
            pageBoxes = pageBoxes.shadowPages().get(shadowPageNumber);
        } else if (shadowPageNumber >= 0) {
            return;
        }
        boolean pushedClip = false;
        if (floater.getClipBox(c, floater.getContainingLayer()) != null) {
            dlo = new PaintPushClipRect(floater.getClipBox(c, floater.getContainingLayer()));
            pageInstructions.addOp(dlo);
            pushedClip = true;
        }
        this.processPage(c, layer, pageBoxes, pageInstructions, false, pageNumber, shadowPageNumber);
        if (pushedClip) {
            dlo = new PaintPopClipRect();
            pageInstructions.addOp(dlo);
        }
    }

    private void collectLayerBackgroundAndBorder(RenderingContext c, Layer layer, DisplayListContainer dlPages, int pgStart, int pgEnd) {
        PaintLayerBackgroundAndBorder dlo = new PaintLayerBackgroundAndBorder(layer.getMaster());
        this.addItem(dlo, pgStart, pgEnd, dlPages);
    }

    private void collectReplacedElementLayer(RenderingContext c, Layer layer, DisplayListContainer dlPages, int pgStart, int pgEnd) {
        PaintLayerBackgroundAndBorder dlo = new PaintLayerBackgroundAndBorder(layer.getMaster());
        this.addItem(dlo, pgStart, pgEnd, dlPages);
        PaintReplacedElement dlo2 = new PaintReplacedElement((BlockBox)layer.getMaster());
        this.addItem(dlo2, pgStart, pgEnd, dlPages);
    }

    public static Map<TableCellBox, List<CollapsedBorderSide>> collectCollapsedTableBorders(RenderingContext c, List<TableCellBox> tcells) {
        HashMap<TableBox, ArrayList<CollapsedBorderSide>> cellBordersByTable = new HashMap<TableBox, ArrayList<CollapsedBorderSide>>();
        HashMap<TableBox, TableCellBox> triggerCellsByTable = new HashMap<TableBox, TableCellBox>();
        HashSet<CollapsedBorderValue> all = new HashSet<CollapsedBorderValue>(0);
        for (TableCellBox cell : tcells) {
            ArrayList<CollapsedBorderSide> borders = (ArrayList<CollapsedBorderSide>)cellBordersByTable.get(cell.getTable());
            if (borders == null) {
                borders = new ArrayList<CollapsedBorderSide>();
                cellBordersByTable.put(cell.getTable(), borders);
            }
            triggerCellsByTable.put(cell.getTable(), cell);
            cell.addCollapsedBorders(all, borders);
        }
        if (triggerCellsByTable.isEmpty()) {
            return null;
        }
        HashMap<TableCellBox, List<CollapsedBorderSide>> result = new HashMap<TableCellBox, List<CollapsedBorderSide>>(triggerCellsByTable.size());
        for (TableCellBox cell : triggerCellsByTable.values()) {
            List borders = (List)cellBordersByTable.get(cell.getTable());
            Collections.sort(borders);
            result.put(cell, borders);
        }
        return result;
    }

    public DisplayListContainer.DisplayListPageContainer collectInlineBlock(RenderingContext c, BlockBox bb, EnumSet<CollectFlags> noneOf) {
        DisplayListContainer.DisplayListPageContainer pgInstructions = new DisplayListContainer.DisplayListPageContainer(null);
        PagedBoxCollector boxCollector = this.createBoundedBoxCollector(c.getPageNo(), c.getPageNo());
        boxCollector.collect(c, bb.getContainingLayer(), bb, c.getPageNo(), c.getPageNo(), -1);
        PagedBoxCollector.PageResult pgResult = boxCollector.getPageResult(c.getPageNo());
        this.processPage(c, bb.getContainingLayer(), pgResult, pgInstructions, false, c.getPageNo(), -1);
        return pgInstructions;
    }

    public DisplayListContainer collectFixed(RenderingContext c, Layer layer) {
        MapDisplayListContainer res = new MapDisplayListContainer(this._pages.size(), 1);
        this.collect(c, layer, res, EnumSet.of(CollectFlags.INCLUDE_FIXED_BOXES));
        return res;
    }

    protected PagedBoxCollector createBoundedBoxCollector(int pgStart, int pgEnd) {
        return new PagedBoxCollector(this._pages, pgStart, pgEnd);
    }

    protected int findStartPage(RenderingContext c, Layer layer) {
        int start = PagedBoxCollector.findStartPage(c, layer.getMaster(), this._pages);
        for (BlockBox floater : layer.getFloats()) {
            start = Math.min(start, PagedBoxCollector.findStartPage(c, floater, this._pages));
        }
        return start;
    }

    protected int findEndPage(RenderingContext c, Layer layer) {
        int end = PagedBoxCollector.findEndPage(c, layer.getMaster(), this._pages);
        for (BlockBox floater : layer.getFloats()) {
            end = Math.max(end, PagedBoxCollector.findEndPage(c, floater, this._pages));
        }
        return end;
    }

    protected static enum CollectFlags {
        INCLUDE_FIXED_BOXES;

    }
}

