/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.render.displaylist;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.parser.PropertyValue;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.css.style.FSDerivedValue;
import com.openhtmltopdf.css.style.derived.LengthValue;
import com.openhtmltopdf.css.style.derived.ListValue;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import java.awt.geom.AffineTransform;
import java.util.List;

public class TransformCreator {
    public static AffineTransform createPageCoordinatesTranform(RenderingContext c, Box box, PageBox page) {
        TransformYOrigin yOrigin = c.getOutputDevice().isPDF() ? TransformYOrigin.PAGE_BOTTOM : TransformYOrigin.PAGE_TOP;
        AffineTransform start = new AffineTransform();
        TransformCreator.createTransform(c, box, page, start, yOrigin);
        return start;
    }

    public static AffineTransform createPageMarginCoordinatesTransform(RenderingContext c, Box box, PageBox page, int xTranslate, int yTranslate) {
        float pageTranslateY;
        float pageTranslateX;
        FSDerivedValue transforms = box.getStyle().valueByName(CSSName.TRANSFORM);
        float relOriginX = box.getStyle().getFloatPropertyProportionalWidth(CSSName.FS_TRANSFORM_ORIGIN_X, box.getWidth(), c);
        float relOriginY = box.getStyle().getFloatPropertyProportionalHeight(CSSName.FS_TRANSFORM_ORIGIN_Y, box.getHeight(), c);
        float flipFactor = c.getOutputDevice().isPDF() ? -1.0f : 1.0f;
        float absTranslateX = relOriginX + (float)box.getAbsX();
        float absTranslateY = relOriginY + (float)box.getAbsY();
        if (c.getOutputDevice().isPDF()) {
            pageTranslateX = absTranslateX + (float)xTranslate;
            float topDownPageTranslateY = absTranslateY + (float)yTranslate;
            pageTranslateY = (float)page.getHeight(c) - topDownPageTranslateY;
        } else {
            pageTranslateX = absTranslateX + (float)xTranslate;
            pageTranslateY = absTranslateY + (float)yTranslate;
        }
        AffineTransform translateToOrigin = AffineTransform.getTranslateInstance(pageTranslateX, pageTranslateY);
        AffineTransform translateBackFromOrigin = AffineTransform.getTranslateInstance(-pageTranslateX, -pageTranslateY);
        List<PropertyValue> transformList = ((ListValue)transforms).getValues();
        AffineTransform result = new AffineTransform();
        result.concatenate(translateToOrigin);
        TransformCreator.applyTransformFunctions(flipFactor, transformList, result, box, c);
        result.concatenate(translateBackFromOrigin);
        return result;
    }

    public static AffineTransform createDocumentCoordinatesTransform(Box master, CssContext c, AffineTransform _parentCtm) {
        AffineTransform ctm = _parentCtm == null ? new AffineTransform() : (AffineTransform)_parentCtm.clone();
        TransformCreator.createTransform(c, master, null, ctm, TransformYOrigin.DOCUMENT_TOP);
        return ctm;
    }

    private static void createTransform(CssContext c, Box box, PageBox page, AffineTransform result, TransformYOrigin transformYOrigin) {
        AffineTransform translateBackFromOrigin;
        AffineTransform translateToOrigin;
        FSDerivedValue transforms = box.getStyle().valueByName(CSSName.TRANSFORM);
        float relOriginX = box.getStyle().getFloatPropertyProportionalWidth(CSSName.FS_TRANSFORM_ORIGIN_X, box.getWidth(), c);
        float relOriginY = box.getStyle().getFloatPropertyProportionalHeight(CSSName.FS_TRANSFORM_ORIGIN_Y, box.getHeight(), c);
        float flipFactor = transformYOrigin == TransformYOrigin.PAGE_BOTTOM ? -1.0f : 1.0f;
        float absTranslateX = relOriginX + (float)box.getAbsX();
        float absTranslateY = relOriginY + (float)box.getAbsY();
        if (transformYOrigin == TransformYOrigin.PAGE_BOTTOM || transformYOrigin == TransformYOrigin.PAGE_TOP) {
            float pageTranslateY;
            float pageTranslateX;
            if (transformYOrigin == TransformYOrigin.PAGE_BOTTOM) {
                pageTranslateX = absTranslateX + (float)page.getMarginBorderPadding(c, 1);
                float topDownPageTranslateY = absTranslateY + (float)page.getMarginBorderPadding(c, 3) - (float)page.getPaintingTop();
                pageTranslateY = (float)page.getHeight(c) - topDownPageTranslateY;
            } else {
                pageTranslateX = absTranslateX + (float)page.getMarginBorderPadding(c, 1);
                pageTranslateY = absTranslateY - (float)page.getPaintingTop() + (float)page.getMarginBorderPadding(c, 3);
            }
            translateToOrigin = AffineTransform.getTranslateInstance(pageTranslateX, pageTranslateY);
            translateBackFromOrigin = AffineTransform.getTranslateInstance(-pageTranslateX, -pageTranslateY);
        } else {
            translateToOrigin = AffineTransform.getTranslateInstance(absTranslateX, absTranslateY);
            translateBackFromOrigin = AffineTransform.getTranslateInstance(-absTranslateX, -absTranslateY);
        }
        List<PropertyValue> transformList = ((ListValue)transforms).getValues();
        result.concatenate(translateToOrigin);
        TransformCreator.applyTransformFunctions(flipFactor, transformList, result, box, c);
        result.concatenate(translateBackFromOrigin);
    }

    private static void applyTransformFunctions(float flipFactor, List<PropertyValue> transformList, AffineTransform result, Box box, CssContext ctx) {
        for (PropertyValue transform : transformList) {
            float translateX;
            float radians;
            String fName = transform.getFunction().getName();
            List<PropertyValue> params = transform.getFunction().getParameters();
            if ("rotate".equalsIgnoreCase(fName)) {
                radians = flipFactor * TransformCreator.convertAngleToRadians(params.get(0));
                result.concatenate(AffineTransform.getRotateInstance(radians));
                continue;
            }
            if ("scale".equalsIgnoreCase(fName) || "scalex".equalsIgnoreCase(fName) || "scaley".equalsIgnoreCase(fName)) {
                float scaleX = params.get(0).getFloatValue();
                float scaleY = params.get(0).getFloatValue();
                if (params.size() > 1) {
                    scaleY = params.get(1).getFloatValue();
                }
                if ("scalex".equalsIgnoreCase(fName)) {
                    scaleY = 1.0f;
                }
                if ("scaley".equalsIgnoreCase(fName)) {
                    scaleX = 1.0f;
                }
                result.concatenate(AffineTransform.getScaleInstance(scaleX, scaleY));
                continue;
            }
            if ("skew".equalsIgnoreCase(fName)) {
                float radiansX = flipFactor * TransformCreator.convertAngleToRadians(params.get(0));
                float radiansY = 0.0f;
                if (params.size() > 1) {
                    radiansY = TransformCreator.convertAngleToRadians(params.get(1));
                }
                result.concatenate(AffineTransform.getShearInstance(Math.tan(radiansX), Math.tan(radiansY)));
                continue;
            }
            if ("skewx".equalsIgnoreCase(fName)) {
                radians = flipFactor * TransformCreator.convertAngleToRadians(params.get(0));
                result.concatenate(AffineTransform.getShearInstance(Math.tan(radians), 0.0));
                continue;
            }
            if ("skewy".equalsIgnoreCase(fName)) {
                radians = flipFactor * TransformCreator.convertAngleToRadians(params.get(0));
                result.concatenate(AffineTransform.getShearInstance(0.0, Math.tan(radians)));
                continue;
            }
            if ("matrix".equalsIgnoreCase(fName)) {
                result.concatenate(new AffineTransform(params.get(0).getFloatValue(), params.get(1).getFloatValue(), params.get(2).getFloatValue(), params.get(3).getFloatValue(), params.get(4).getFloatValue(), params.get(5).getFloatValue()));
                continue;
            }
            if ("translate".equalsIgnoreCase(fName)) {
                translateX = LengthValue.calcFloatProportionalValue(box.getStyle(), null, null, params.get(0).getFloatValue(), params.get(0).getPrimitiveType(), box.getWidth(), ctx);
                float translateY = params.size() > 1 ? LengthValue.calcFloatProportionalValue(box.getStyle(), null, null, params.get(1).getFloatValue(), params.get(0).getPrimitiveType(), box.getWidth(), ctx) : translateX;
                result.concatenate(AffineTransform.getTranslateInstance(translateX, flipFactor * translateY));
                continue;
            }
            if ("translateX".equalsIgnoreCase(fName)) {
                translateX = LengthValue.calcFloatProportionalValue(box.getStyle(), null, null, params.get(0).getFloatValue(), params.get(0).getPrimitiveType(), box.getWidth(), ctx);
                result.concatenate(AffineTransform.getTranslateInstance(translateX, 0.0));
                continue;
            }
            if (!"translateY".equalsIgnoreCase(fName)) continue;
            float translateY = LengthValue.calcFloatProportionalValue(box.getStyle(), null, null, params.get(0).getFloatValue(), params.get(0).getPrimitiveType(), box.getHeight(), ctx);
            result.concatenate(AffineTransform.getTranslateInstance(0.0, flipFactor * translateY));
        }
    }

    private static float convertAngleToRadians(PropertyValue param) {
        if (param.getPrimitiveType() == 11) {
            return (float)Math.toRadians(param.getFloatValue());
        }
        if (param.getPrimitiveType() == 12) {
            return param.getFloatValue();
        }
        return (float)((double)param.getFloatValue() * 0.015707963267948967);
    }

    private static enum TransformYOrigin {
        DOCUMENT_TOP,
        PAGE_TOP,
        PAGE_BOTTOM;

    }
}

