/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.bidi;

import com.openhtmltopdf.bidi.BidiSplitter;
import com.openhtmltopdf.bidi.BidiTextRun;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.layout.LayoutContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class ParagraphSplitter {
    private final Map<Text, Paragraph> paragraphs = new HashMap<Text, Paragraph>();

    public Paragraph lookupParagraph(Text node) {
        return this.paragraphs.get(node);
    }

    public void splitRoot(LayoutContext c, Document doc) {
        Paragraph parent = new Paragraph();
        this.splitParagraphs(c, doc, parent);
    }

    public void runBidiOnParagraphs(LayoutContext c) {
        for (Paragraph p : this.paragraphs.values()) {
            p.runBidiSplitter(c.getBidiSplitterFactory().createBidiSplitter(), c);
        }
    }

    private void splitParagraphs(LayoutContext c, Node parent, Paragraph nearestBlock) {
        Node node = parent.getFirstChild();
        if (node == null) {
            return;
        }
        do {
            if (node.getNodeType() == 3) {
                String text = ((Text)node).getData();
                nearestBlock.add(text, (Text)node);
                this.paragraphs.put((Text)node, nearestBlock);
                continue;
            }
            if (node.getNodeType() != 1) continue;
            Element element = (Element)node;
            CalculatedStyle style = c.getSharedContext().getStyle(element);
            if (style.isSpecifiedAsBlock()) {
                this.splitParagraphs(c, element, new Paragraph());
                continue;
            }
            this.splitParagraphs(c, element, nearestBlock);
        } while ((node = node.getNextSibling()) != null);
    }

    public static class Paragraph {
        private final StringBuilder builder = new StringBuilder();
        private final List<Text> textNodes = new ArrayList<Text>();
        private final TreeMap<Integer, BidiTextRun> splitPoints = new TreeMap();

        private Paragraph() {
        }

        private void add(String text, Text textNode) {
            this.builder.append(text);
            this.textNodes.add(textNode);
        }

        private void runBidiSplitter(BidiSplitter splitter, LayoutContext c) {
            splitter.setParagraph(this.builder.toString(), c.getDefaultTextDirection());
            this.copySplitPointsFromBidiSplitter(splitter);
        }

        public int getFirstCharIndexInParagraph(Text text) {
            int position = 0;
            for (Text t : this.textNodes) {
                if (text == t) {
                    return position;
                }
                position += t.getLength();
            }
            assert (false);
            return -1;
        }

        private void copySplitPointsFromBidiSplitter(BidiSplitter splitter) {
            int length = splitter.countTextRuns();
            for (int i = 0; i < length; ++i) {
                BidiTextRun run = splitter.getVisualRun(i);
                this.splitPoints.put(run.getStart(), run);
            }
        }

        public BidiTextRun nextSplit(int startIndexInParagraph) {
            Map.Entry<Integer, BidiTextRun> entry = this.splitPoints.ceilingEntry(startIndexInParagraph);
            if (entry != null) {
                return entry.getValue();
            }
            return null;
        }

        public BidiTextRun prevSplit(int startIndexInParagraph) {
            Map.Entry<Integer, BidiTextRun> entry = this.splitPoints.floorEntry(startIndexInParagraph);
            if (entry != null) {
                return entry.getValue();
            }
            return null;
        }
    }
}

