/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.event.DocumentListener;
import com.openhtmltopdf.extend.HttpStream;
import com.openhtmltopdf.extend.HttpStreamFactory;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.resource.CSSResource;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.swing.AWTFSImage;
import com.openhtmltopdf.util.ImageUtil;
import com.openhtmltopdf.util.XRLog;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedHashMap;
import javax.imageio.ImageIO;

public class NaiveUserAgent
implements UserAgentCallback,
DocumentListener {
    private static final int DEFAULT_IMAGE_CACHE_SIZE = 16;
    protected LinkedHashMap<String, ImageResource> _imageCache;
    private int _imageCacheCapacity;
    private String _baseURL;
    private HttpStreamFactory _streamFactory = new DefaultHttpStreamFactory();

    public NaiveUserAgent() {
        this(16);
    }

    public NaiveUserAgent(int imgCacheSize) {
        this._imageCacheCapacity = imgCacheSize;
        this._imageCache = new LinkedHashMap(this._imageCacheCapacity, 0.75f, true);
    }

    public void setHttpStreamFactory(HttpStreamFactory factory) {
        this._streamFactory = factory;
    }

    public void shrinkImageCache() {
        int ovr = this._imageCache.size() - this._imageCacheCapacity;
        Iterator<String> it = this._imageCache.keySet().iterator();
        while (it.hasNext() && ovr-- > 0) {
            it.next();
            it.remove();
        }
    }

    public void clearImageCache() {
        this._imageCache.clear();
    }

    protected InputStream resolveAndOpenStream(String uri) {
        InputStream is = null;
        uri = this.resolveURI(uri);
        try {
            URL urlObj = new URL(uri);
            if (urlObj.getProtocol().equalsIgnoreCase("http") || urlObj.getProtocol().equalsIgnoreCase("https")) {
                return this._streamFactory.getUrl(uri).getStream();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
        }
        catch (MalformedURLException e2) {
            XRLog.exception("bad URL given: " + uri, e2);
        }
        return is;
    }

    protected Reader resolveAndOpenReader(String uri) {
        InputStream is = null;
        uri = this.resolveURI(uri);
        try {
            URL urlObj = new URL(uri);
            if (urlObj.getProtocol().equalsIgnoreCase("http") || urlObj.getProtocol().equalsIgnoreCase("https")) {
                return this._streamFactory.getUrl(uri).getReader();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
        }
        catch (MalformedURLException e2) {
            XRLog.exception("bad URL given: " + uri, e2);
        }
        try {
            return is == null ? null : new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            XRLog.exception("Failed to create stream reader", e);
            return null;
        }
    }

    @Override
    public CSSResource getCSSResource(String uri) {
        return new CSSResource(this.resolveAndOpenReader(uri));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageResource getImageResource(String uri) {
        ImageResource ir;
        if (ImageUtil.isEmbeddedBase64Image(uri)) {
            BufferedImage image = ImageUtil.loadEmbeddedBase64Image(uri);
            ir = this.createImageResource(null, image);
        } else {
            InputStream is;
            ir = this._imageCache.get(uri = this.resolveURI(uri));
            if (ir == null && (is = this.resolveAndOpenStream(uri)) != null) {
                try {
                    BufferedImage img = ImageIO.read(is);
                    if (img == null) {
                        throw new IOException("ImageIO.read() returned null");
                    }
                    ir = this.createImageResource(uri, img);
                    this._imageCache.put(uri, ir);
                }
                catch (FileNotFoundException e) {
                    XRLog.exception("Can't read image file; image at URI '" + uri + "' not found");
                }
                catch (IOException e) {
                    XRLog.exception("Can't read image file; unexpected problem for URI '" + uri + "'", e);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (IOException e) {}
                }
            }
            if (ir == null) {
                ir = this.createImageResource(uri, null);
            }
        }
        return ir;
    }

    protected ImageResource createImageResource(String uri, Image img) {
        return new ImageResource(uri, AWTFSImage.createImage(img));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLResource getXMLResource(String uri) {
        XMLResource xmlResource;
        Reader inputReader = this.resolveAndOpenReader(uri);
        try {
            xmlResource = XMLResource.load(inputReader);
        }
        finally {
            if (inputReader != null) {
                try {
                    inputReader.close();
                }
                catch (IOException e) {}
            }
        }
        return xmlResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBinaryResource(String uri) {
        InputStream is = this.resolveAndOpenStream(uri);
        if (is == null) {
            return null;
        }
        try {
            int i;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            while ((i = is.read(buf)) != -1) {
                result.write(buf, 0, i);
            }
            is.close();
            is = null;
            byte[] byArray = result.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @Override
    public boolean isVisited(String uri) {
        return false;
    }

    @Override
    public void setBaseURL(String url) {
        this._baseURL = url;
    }

    @Override
    public String resolveURI(String uri) {
        URI result;
        if (uri == null) {
            return null;
        }
        String ret = null;
        if (this._baseURL == null) {
            try {
                result = new URI(uri);
                if (result.isAbsolute()) {
                    this.setBaseURL(result.toString());
                }
            }
            catch (URISyntaxException e) {
                XRLog.exception("The default NaiveUserAgent could not use the URL as base url: " + uri, e);
            }
            if (this._baseURL == null) {
                try {
                    this.setBaseURL(new File(".").toURI().toURL().toExternalForm());
                }
                catch (Exception e1) {
                    XRLog.exception("The default NaiveUserAgent doesn't know how to resolve the base URL for " + uri);
                    return null;
                }
            }
        }
        try {
            result = new URI(uri);
            if (!result.isAbsolute()) {
                XRLog.load(uri + " is not a URL; may be relative. Testing using parent URL " + this._baseURL);
                result = new URI(this._baseURL).resolve(result);
            }
            ret = result.toString();
        }
        catch (URISyntaxException e) {
            XRLog.exception("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this._baseURL);
        }
        return ret;
    }

    @Override
    public String getBaseURL() {
        return this._baseURL;
    }

    @Override
    public void documentStarted() {
        this.shrinkImageCache();
    }

    @Override
    public void documentLoaded() {
    }

    @Override
    public void onLayoutException(Throwable t) {
    }

    @Override
    public void onRenderException(Throwable t) {
    }

    public static class DefaultHttpStreamFactory
    implements HttpStreamFactory {
        @Override
        public HttpStream getUrl(String uri) {
            InputStream is = null;
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
            return new DefaultHttpStream(is);
        }
    }

    public static class DefaultHttpStream
    implements HttpStream {
        private InputStream strm;

        public DefaultHttpStream(InputStream strm) {
            this.strm = strm;
        }

        @Override
        public InputStream getStream() {
            return this.strm;
        }

        @Override
        public Reader getReader() {
            try {
                return new InputStreamReader(this.strm, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                XRLog.exception("Exception when creating stream reader", e);
                return null;
            }
        }
    }
}

