/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.event.DocumentListener;
import com.openhtmltopdf.extend.FSCache;
import com.openhtmltopdf.extend.FSUriResolver;
import com.openhtmltopdf.extend.HttpStream;
import com.openhtmltopdf.extend.HttpStreamFactory;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.resource.CSSResource;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.swing.AWTFSImage;
import com.openhtmltopdf.swing.FSCacheKey;
import com.openhtmltopdf.util.ImageUtil;
import com.openhtmltopdf.util.XRLog;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.logging.Level;
import javax.imageio.ImageIO;

public class NaiveUserAgent
implements UserAgentCallback,
DocumentListener {
    protected final LinkedHashMap<String, ImageResource> _imageCache = new LinkedHashMap();
    private final FSUriResolver DEFAULT_URI_RESOLVER = new DefaultUriResolver(this);
    protected HttpStreamFactory _streamFactory = new DefaultHttpStreamFactory();
    protected FSCache _externalCache = new NullFSCache(false);
    protected FSUriResolver _resolver = this.DEFAULT_URI_RESOLVER;

    public void setHttpStreamFactory(HttpStreamFactory factory) {
        this._streamFactory = factory;
    }

    public void setExternalCache(FSCache cache) {
        this._externalCache = cache;
    }

    public void setUriResolver(FSUriResolver resolver) {
        this._resolver = resolver;
    }

    public FSUriResolver getDefaultUriResolver() {
        return this.DEFAULT_URI_RESOLVER;
    }

    public void clearImageCache() {
        this._imageCache.clear();
    }

    protected InputStream openStream(String uri) {
        InputStream is = null;
        try {
            URL urlObj = new URL(uri);
            if (urlObj.getProtocol().equalsIgnoreCase("http") || urlObj.getProtocol().equalsIgnoreCase("https")) {
                return this._streamFactory.getUrl(uri).getStream();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
        }
        catch (MalformedURLException e2) {
            XRLog.exception("bad URL given: " + uri, e2);
        }
        return is;
    }

    protected Reader openReader(String uri) {
        InputStream is = null;
        try {
            URL urlObj = new URL(uri);
            if (urlObj.getProtocol().equalsIgnoreCase("http") || urlObj.getProtocol().equalsIgnoreCase("https")) {
                return this._streamFactory.getUrl(uri).getReader();
            }
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
        }
        catch (MalformedURLException e2) {
            XRLog.exception("bad URL given: " + uri, e2);
        }
        try {
            return is == null ? null : new InputStreamReader(is, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            XRLog.exception("Failed to create stream reader", e);
            return null;
        }
    }

    @Override
    public CSSResource getCSSResource(String uri) {
        String resolved = this._resolver.resolveURI(uri);
        FSCacheKey cacheKey = new FSCacheKey(resolved, CSSResource.class);
        CSSResource res = (CSSResource)this._externalCache.get(cacheKey);
        if (res != null) {
            return res;
        }
        CSSResource res2 = new CSSResource(this.openReader(resolved));
        this._externalCache.put(cacheKey, res2);
        return res2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageResource getImageResource(String uri) {
        System.out.println("Getting image: " + uri);
        if (ImageUtil.isEmbeddedBase64Image(uri)) {
            BufferedImage image = ImageUtil.loadEmbeddedBase64Image(uri);
            return new ImageResource(null, AWTFSImage.createImage(image));
        }
        String resolved = this._resolver.resolveURI(uri);
        ImageResource ir = this._imageCache.get(resolved);
        if (ir != null) {
            return ir;
        }
        AWTFSImage fsImage = (AWTFSImage)this._externalCache.get(new FSCacheKey(resolved, AWTFSImage.class));
        if (fsImage != null) {
            return new ImageResource(resolved, fsImage);
        }
        InputStream is = this.openStream(resolved);
        if (is != null) {
            try {
                BufferedImage img = ImageIO.read(is);
                if (img == null) {
                    throw new IOException("ImageIO.read() returned null");
                }
                AWTFSImage fsImage2 = (AWTFSImage)AWTFSImage.createImage(img);
                this._externalCache.put(new FSCacheKey(resolved, AWTFSImage.class), fsImage2);
                ir = new ImageResource(resolved, fsImage2);
                this._imageCache.put(resolved, ir);
                ImageResource imageResource = ir;
                return imageResource;
            }
            catch (FileNotFoundException e) {
                XRLog.exception("Can't read image file; image at URI '" + resolved + "' not found");
            }
            catch (IOException e) {
                XRLog.exception("Can't read image file; unexpected problem for URI '" + resolved + "'", e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {}
            }
        }
        return new ImageResource(resolved, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLResource getXMLResource(String uri) {
        XMLResource xmlResource;
        String resolved = this._resolver.resolveURI(uri);
        XMLResource res = (XMLResource)this._externalCache.get(new FSCacheKey(resolved, XMLResource.class));
        if (res != null) {
            return res;
        }
        Reader inputReader = this.openReader(resolved);
        try {
            xmlResource = XMLResource.load(inputReader);
        }
        finally {
            if (inputReader != null) {
                try {
                    inputReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        this._externalCache.put(new FSCacheKey(resolved, XMLResource.class), xmlResource);
        return xmlResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBinaryResource(String uri) {
        String resolved = this._resolver.resolveURI(uri);
        byte[] bytes = (byte[])this._externalCache.get(new FSCacheKey(resolved, byte[].class));
        if (bytes != null) {
            return bytes;
        }
        InputStream is = this.openStream(resolved);
        if (is == null) {
            return null;
        }
        try {
            int i;
            ByteArrayOutputStream result = new ByteArrayOutputStream();
            byte[] buf = new byte[10240];
            while ((i = is.read(buf)) != -1) {
                result.write(buf, 0, i);
            }
            is.close();
            is = null;
            byte[] bytes2 = result.toByteArray();
            this._externalCache.put(new FSCacheKey(resolved, byte[].class), bytes2);
            byte[] byArray = bytes2;
            return byArray;
        }
        catch (IOException e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public boolean isVisited(String uri) {
        return false;
    }

    @Override
    public void setBaseURL(String url) {
        this._resolver.setBaseURL(url);
    }

    @Override
    public String getBaseURL() {
        return this._resolver.getBaseURL();
    }

    @Override
    public void documentStarted() {
        this.clearImageCache();
    }

    @Override
    public void documentLoaded() {
    }

    @Override
    public void onLayoutException(Throwable t) {
    }

    @Override
    public void onRenderException(Throwable t) {
    }

    @Override
    public String resolveURI(String uri) {
        return this._resolver.resolveURI(uri);
    }

    public static class DefaultUriResolver
    implements FSUriResolver {
        private final NaiveUserAgent _agent;
        private String _baseURI;

        private DefaultUriResolver(NaiveUserAgent agent) {
            this._agent = agent;
        }

        @Override
        public String resolveURI(String uri) {
            URI result;
            if (uri == null) {
                return null;
            }
            String ret = null;
            if (this._agent.getBaseURL() == null) {
                try {
                    result = new URI(uri);
                    if (result.isAbsolute()) {
                        this._agent.setBaseURL(result.toString());
                    }
                }
                catch (URISyntaxException e) {
                    XRLog.exception("The default NaiveUserAgent could not use the URL as base url: " + uri, e);
                }
                if (this._agent.getBaseURL() == null) {
                    try {
                        XRLog.load(Level.WARNING, "Using current working directiory as base uri.");
                        this._agent.setBaseURL(new File(".").toURI().toURL().toExternalForm());
                    }
                    catch (Exception e1) {
                        XRLog.exception("The default NaiveUserAgent doesn't know how to resolve the base URL for " + uri);
                        return null;
                    }
                }
            }
            try {
                result = new URI(uri);
                if (!result.isAbsolute()) {
                    XRLog.load(uri + " is not a URL; may be relative. Testing using parent URL " + this._agent.getBaseURL());
                    result = new URI(this._agent.getBaseURL()).resolve(result);
                }
                ret = result.toString();
            }
            catch (URISyntaxException e) {
                XRLog.exception("The default NaiveUserAgent cannot resolve the URL " + uri + " with base URL " + this._agent.getBaseURL());
            }
            return ret;
        }

        @Override
        public void setBaseURL(String uri) {
            this._baseURI = uri;
        }

        @Override
        public String getBaseURL() {
            return this._baseURI;
        }
    }

    public static class NullFSCache
    implements FSCache {
        private final boolean _log;

        public NullFSCache(boolean log) {
            this._log = log;
        }

        @Override
        public Object get(FSCacheKey cacheKey) {
            if (this._log) {
                XRLog.load(Level.INFO, "Trying to retrieve object from cache: " + cacheKey.toString());
            }
            return null;
        }

        @Override
        public void put(FSCacheKey cacheKey, Object obj) {
            if (this._log) {
                XRLog.load(Level.INFO, "Trying to put object in cache: " + cacheKey.toString());
            }
        }
    }

    public static class DefaultHttpStreamFactory
    implements HttpStreamFactory {
        @Override
        public HttpStream getUrl(String uri) {
            InputStream is = null;
            try {
                is = new URL(uri).openStream();
            }
            catch (MalformedURLException e) {
                XRLog.exception("bad URL given: " + uri, e);
            }
            catch (FileNotFoundException e) {
                XRLog.exception("item at URI " + uri + " not found");
            }
            catch (IOException e) {
                XRLog.exception("IO problem for " + uri, e);
            }
            return new DefaultHttpStream(is);
        }
    }

    public static class DefaultHttpStream
    implements HttpStream {
        private InputStream strm;

        public DefaultHttpStream(InputStream strm) {
            this.strm = strm;
        }

        @Override
        public InputStream getStream() {
            return this.strm;
        }

        @Override
        public Reader getReader() {
            try {
                return new InputStreamReader(this.strm, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                XRLog.exception("Exception when creating stream reader", e);
                return null;
            }
        }
    }
}

