/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.swing;

import com.openhtmltopdf.extend.FSImage;
import com.openhtmltopdf.resource.ImageResource;
import com.openhtmltopdf.swing.AWTFSImage;
import com.openhtmltopdf.swing.ImageLoadItem;
import com.openhtmltopdf.swing.ImageLoadQueue;
import com.openhtmltopdf.swing.ImageResourceLoader;
import com.openhtmltopdf.util.ImageUtil;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.awt.EventQueue;
import java.awt.image.BufferedImage;
import java.util.logging.Level;

class ImageLoadWorker
extends Thread {
    private static volatile int counter = 0;
    private final ImageLoadQueue queue;

    public ImageLoadWorker(ImageLoadQueue queue) {
        this.queue = queue;
        this.setDaemon(true);
        this.setPriority(1);
        this.setName("ImageLoadWorker(" + counter++ + ")");
    }

    @Override
    public void run() {
        try {
            ImageLoadItem loadItem;
            while (!ImageLoadQueue.isKillSwitch(loadItem = this.queue.getTask())) {
                boolean wasScaled;
                ImageResource ir = ImageResourceLoader.loadImageResourceFromUri(loadItem._uri);
                FSImage awtfsImage = ir.getImage();
                BufferedImage newImg = ((AWTFSImage)awtfsImage).getImage();
                XRLog.log(Level.FINE, LogMessageId.LogMessageId2Param.LOAD_IMAGE_LOAD_WORKER_LOADED_WITH_URI, (Object)this, (Object)loadItem._uri);
                loadItem._imageResourceLoader.loaded(ir, newImg.getWidth(), newImg.getHeight());
                if (loadItem.haveTargetDimensions() && !ir.hasDimensions(loadItem._targetWidth, loadItem._targetHeight)) {
                    XRLog.log(Level.FINE, LogMessageId.LogMessageId4Param.LOAD_IMAGE_LOADER_SCALING_URI_TO, (Object)this, (Object)loadItem._uri, (Object)loadItem._targetWidth, (Object)loadItem._targetHeight);
                    newImg = ImageUtil.getScaledInstance(newImg, loadItem._targetWidth, loadItem._targetHeight);
                    ImageResource sir = new ImageResource(ir.getImageUri(), AWTFSImage.createImage(newImg));
                    loadItem._imageResourceLoader.loaded(sir, newImg.getWidth(), newImg.getHeight());
                    wasScaled = true;
                } else {
                    wasScaled = false;
                }
                BufferedImage newImg1 = newImg;
                EventQueue.invokeLater(() -> loadItem._mfsImage.setImage(loadItem._uri, newImg1, wasScaled));
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

