/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.util;

public class GeneralUtil {
    public static void dumpShortException(Exception ex) {
        String s = ex.getMessage();
        if (s == null || s.trim().equals("null")) {
            s = "{no ex. message}";
        }
        System.out.println(s + ", " + ex.getClass());
        StackTraceElement[] stes = ex.getStackTrace();
        for (int i = 0; i < stes.length && i < 5; ++i) {
            StackTraceElement ste = stes[i];
            System.out.println("  " + ste.getClassName() + "." + ste.getMethodName() + "(ln " + ste.getLineNumber() + ")");
        }
    }

    public static int parseIntRelaxed(String s) {
        if (s == null || s.length() == 0 || s.trim().length() == 0) {
            return 0;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isDigit(c)) {
                buffer.append(c);
                continue;
            }
            if (buffer.length() > 0) break;
        }
        if (buffer.length() == 0) {
            return 0;
        }
        try {
            return Integer.parseInt(buffer.toString());
        }
        catch (NumberFormatException exception) {
            return Integer.MAX_VALUE;
        }
    }
}

