/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.java2d.api;

import com.openhtmltopdf.java2d.api.FSPage;
import com.openhtmltopdf.java2d.api.FSPageOutputStreamSupplier;
import com.openhtmltopdf.java2d.api.FSPageProcessor;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class DefaultPageProcessor
implements FSPageProcessor {
    private final FSPageOutputStreamSupplier _osFactory;
    private final int _imageType;
    private final String _imageFormat;

    public DefaultPageProcessor(FSPageOutputStreamSupplier osFactory, int imageType, String imageFormat) {
        this._osFactory = osFactory;
        this._imageType = imageType;
        this._imageFormat = imageFormat;
    }

    public Graphics2D createLayoutGraphics() {
        BufferedImage bf = new BufferedImage(1, 1, this._imageType);
        return bf.createGraphics();
    }

    @Override
    public FSPage createPage(int zeroBasedPageNumber, int width, int height) {
        return new DefaultPage(zeroBasedPageNumber, width, height, this._osFactory, this._imageType, this._imageFormat);
    }

    @Override
    public void finishPage(FSPage pg) {
        DefaultPage page = (DefaultPage)pg;
        page.getGraphics().dispose();
        page.save();
    }

    public static class DefaultPage
    implements FSPage {
        private final BufferedImage _img;
        private final Graphics2D _g2d;
        private final int _pgNo;
        private final FSPageOutputStreamSupplier _osf;
        private final String _imgFrmt;

        public DefaultPage(int pgNo, int w, int h, FSPageOutputStreamSupplier osFactory, int imageType, String imageFormat) {
            this._img = new BufferedImage(w, h, imageType);
            this._g2d = this._img.createGraphics();
            if (this._img.getColorModel().hasAlpha()) {
                this._g2d.setBackground(new Color(255, 255, 255, 0));
                this._g2d.clearRect(0, 0, this._img.getWidth(), this._img.getHeight());
            } else {
                this._g2d.setColor(Color.WHITE);
                this._g2d.fillRect(0, 0, this._img.getWidth(), this._img.getHeight());
            }
            this._pgNo = pgNo;
            this._osf = osFactory;
            this._imgFrmt = imageFormat;
        }

        @Override
        public Graphics2D getGraphics() {
            return this._g2d;
        }

        public void save() {
            OutputStream os = null;
            try {
                os = this._osf.supply(this._pgNo);
                ImageIO.write((RenderedImage)this._img, this._imgFrmt, os);
            }
            catch (IOException e) {
                throw new RuntimeException("Couldn't write page image to output stream", e);
            }
            finally {
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

