/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.pdfboxout;

import com.openhtmltopdf.bidi.BidiReorderer;
import com.openhtmltopdf.bidi.BidiSplitterFactory;
import com.openhtmltopdf.bidi.SimpleBidiReorderer;
import com.openhtmltopdf.context.StyleReference;
import com.openhtmltopdf.css.style.CssContext;
import com.openhtmltopdf.extend.FSCache;
import com.openhtmltopdf.extend.FSObjectDrawerFactory;
import com.openhtmltopdf.extend.FSUriResolver;
import com.openhtmltopdf.extend.FontContext;
import com.openhtmltopdf.extend.FontResolver;
import com.openhtmltopdf.extend.HttpStreamFactory;
import com.openhtmltopdf.extend.NamespaceHandler;
import com.openhtmltopdf.extend.OutputDevice;
import com.openhtmltopdf.extend.ReplacedElementFactory;
import com.openhtmltopdf.extend.SVGDrawer;
import com.openhtmltopdf.extend.TextRenderer;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.extend.UserInterface;
import com.openhtmltopdf.layout.BoxBuilder;
import com.openhtmltopdf.layout.Layer;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.outputdevice.helper.BaseDocument;
import com.openhtmltopdf.outputdevice.helper.PageDimensions;
import com.openhtmltopdf.outputdevice.helper.UnicodeImplementation;
import com.openhtmltopdf.pdfboxout.PDFCreationListener;
import com.openhtmltopdf.pdfboxout.PdfBoxFontContext;
import com.openhtmltopdf.pdfboxout.PdfBoxFontResolver;
import com.openhtmltopdf.pdfboxout.PdfBoxOutputDevice;
import com.openhtmltopdf.pdfboxout.PdfBoxReplacedElementFactory;
import com.openhtmltopdf.pdfboxout.PdfBoxTextRenderer;
import com.openhtmltopdf.pdfboxout.PdfBoxUserAgent;
import com.openhtmltopdf.render.BlockBox;
import com.openhtmltopdf.render.Box;
import com.openhtmltopdf.render.PageBox;
import com.openhtmltopdf.render.RenderingContext;
import com.openhtmltopdf.render.ViewportBox;
import com.openhtmltopdf.resource.XMLResource;
import com.openhtmltopdf.simple.extend.XhtmlNamespaceHandler;
import com.openhtmltopdf.util.Configuration;
import com.openhtmltopdf.util.ThreadCtx;
import com.openhtmltopdf.util.XRLog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.encryption.PDEncryption;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class PdfBoxRenderer {
    private static final float DEFAULT_DOTS_PER_POINT = 26.666666f;
    private static final int DEFAULT_DOTS_PER_PIXEL = 20;
    private static final int DEFAULT_PDF_POINTS_PER_INCH = 72;
    private final SharedContext _sharedContext;
    private final PdfBoxOutputDevice _outputDevice;
    private Document _doc;
    private BlockBox _root;
    private final float _dotsPerPoint;
    private PDDocument _pdfDoc = new PDDocument();
    private PDEncryption _pdfEncryption;
    private float _pdfVersion;
    private boolean _testMode;
    private PDFCreationListener _listener;
    private OutputStream _os;
    private SVGDrawer _svgImpl;
    private BidiSplitterFactory _splitterFactory;
    private byte _defaultTextDirection = 0;
    private BidiReorderer _reorderer;

    @Deprecated
    public PdfBoxRenderer(boolean testMode) {
        this(26.666666f, 20, true, testMode, null, null, null, null);
    }

    @Deprecated
    public PdfBoxRenderer(float dotsPerPoint, int dotsPerPixel, boolean useSubsets, boolean testMode, HttpStreamFactory factory, FSUriResolver _resolver, FSCache _cache, SVGDrawer svgImpl) {
        this._svgImpl = svgImpl;
        this._dotsPerPoint = dotsPerPoint;
        this._testMode = testMode;
        this._outputDevice = new PdfBoxOutputDevice(dotsPerPoint, testMode);
        this._outputDevice.setWriter(this._pdfDoc);
        PdfBoxUserAgent userAgent = new PdfBoxUserAgent(this._outputDevice);
        if (factory != null) {
            userAgent.setHttpStreamFactory(factory);
        }
        if (_resolver != null) {
            userAgent.setUriResolver(_resolver);
        }
        if (_cache != null) {
            userAgent.setExternalCache(_cache);
        }
        this._sharedContext = new SharedContext();
        this._sharedContext.registerWithThread();
        this._sharedContext.setUserAgentCallback((UserAgentCallback)userAgent);
        this._sharedContext.setCss(new StyleReference((UserAgentCallback)userAgent));
        userAgent.setSharedContext(this._sharedContext);
        this._outputDevice.setSharedContext(this._sharedContext);
        PdfBoxFontResolver fontResolver = new PdfBoxFontResolver(this._sharedContext, this._pdfDoc);
        this._sharedContext.setFontResolver((FontResolver)fontResolver);
        PdfBoxReplacedElementFactory replacedElementFactory = new PdfBoxReplacedElementFactory(this._outputDevice, svgImpl, null);
        this._sharedContext.setReplacedElementFactory((ReplacedElementFactory)replacedElementFactory);
        this._sharedContext.setTextRenderer((TextRenderer)new PdfBoxTextRenderer());
        this._sharedContext.setDPI(72.0f * this._dotsPerPoint);
        this._sharedContext.setDotsPerPixel(dotsPerPixel);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
    }

    PdfBoxRenderer(BaseDocument doc, UnicodeImplementation unicode, HttpStreamFactory httpStreamFactory, OutputStream os, FSUriResolver resolver, FSCache cache, SVGDrawer svgImpl, PageDimensions pageSize, float pdfVersion, String replacementText, boolean testMode, FSObjectDrawerFactory objectDrawerFactory) {
        this._pdfDoc.setVersion(pdfVersion);
        this._svgImpl = svgImpl;
        this._dotsPerPoint = 26.666666f;
        this._testMode = testMode;
        this._outputDevice = new PdfBoxOutputDevice(26.666666f, testMode);
        this._outputDevice.setWriter(this._pdfDoc);
        PdfBoxUserAgent userAgent = new PdfBoxUserAgent(this._outputDevice);
        if (httpStreamFactory != null) {
            userAgent.setHttpStreamFactory(httpStreamFactory);
        }
        if (resolver != null) {
            userAgent.setUriResolver(resolver);
        }
        if (cache != null) {
            userAgent.setExternalCache(cache);
        }
        this._sharedContext = new SharedContext();
        this._sharedContext.registerWithThread();
        this._sharedContext.setUserAgentCallback((UserAgentCallback)userAgent);
        this._sharedContext.setCss(new StyleReference((UserAgentCallback)userAgent));
        userAgent.setSharedContext(this._sharedContext);
        this._outputDevice.setSharedContext(this._sharedContext);
        PdfBoxFontResolver fontResolver = new PdfBoxFontResolver(this._sharedContext, this._pdfDoc);
        this._sharedContext.setFontResolver((FontResolver)fontResolver);
        PdfBoxReplacedElementFactory replacedElementFactory = new PdfBoxReplacedElementFactory(this._outputDevice, svgImpl, objectDrawerFactory);
        this._sharedContext.setReplacedElementFactory((ReplacedElementFactory)replacedElementFactory);
        this._sharedContext.setTextRenderer((TextRenderer)new PdfBoxTextRenderer());
        this._sharedContext.setDPI(72.0f * this._dotsPerPoint);
        this._sharedContext.setDotsPerPixel(20);
        this._sharedContext.setPrint(true);
        this._sharedContext.setInteractive(false);
        this.getSharedContext().setDefaultPageSize(pageSize.w, pageSize.h, pageSize.isSizeInches);
        if (replacementText != null) {
            this.getSharedContext().setReplacementText(replacementText);
        }
        if (unicode.splitterFactory != null) {
            this._splitterFactory = unicode.splitterFactory;
        }
        if (unicode.reorderer != null) {
            this._reorderer = unicode.reorderer;
            this._outputDevice.setBidiReorderer(this._reorderer);
        }
        if (unicode.lineBreaker != null) {
            this._sharedContext.setLineBreaker(unicode.lineBreaker);
        }
        if (unicode.charBreaker != null) {
            this._sharedContext.setCharacterBreaker(unicode.charBreaker);
        }
        if (unicode.toLowerTransformer != null) {
            this._sharedContext.setUnicodeToLowerTransformer(unicode.toLowerTransformer);
        }
        if (unicode.toUpperTransformer != null) {
            this._sharedContext.setUnicodeToUpperTransformer(unicode.toUpperTransformer);
        }
        if (unicode.toTitleTransformer != null) {
            this._sharedContext.setUnicodeToTitleTransformer(unicode.toTitleTransformer);
        }
        byte by = this._defaultTextDirection = unicode.textDirection ? (byte)1 : 0;
        if (doc.html != null) {
            this.setDocumentFromStringP(doc.html, doc.baseUri);
        } else if (doc.document != null) {
            this.setDocumentP(doc.document, doc.baseUri);
        } else if (doc.uri != null) {
            this.setDocumentP(doc.uri);
        } else if (doc.file != null) {
            try {
                this.setDocumentP(doc.file);
            }
            catch (IOException e) {
                XRLog.exception((String)"Problem trying to read input XHTML file", (Throwable)e);
                throw new RuntimeException("File IO problem", e);
            }
        }
        this._os = os;
    }

    public Document getDocument() {
        return this._doc;
    }

    public PDDocument getPdfDocument() {
        return this._pdfDoc;
    }

    @Deprecated
    public void setBidiSplitter(BidiSplitterFactory splitterFactory) {
        this._splitterFactory = splitterFactory;
    }

    @Deprecated
    public void setBidiReorderer(BidiReorderer reorderer) {
        this._reorderer = reorderer;
        this._outputDevice.setBidiReorderer(reorderer);
    }

    @Deprecated
    public void setDefaultTextDirection(boolean rtl) {
        this._defaultTextDirection = rtl ? (byte)1 : 0;
    }

    public PdfBoxFontResolver getFontResolver() {
        return (PdfBoxFontResolver)this._sharedContext.getFontResolver();
    }

    private Document loadDocument(String uri) {
        return this._sharedContext.getUserAgentCallback().getXMLResource(uri).getDocument();
    }

    @Deprecated
    public void setDocument(String uri) {
        this.setDocumentP(this.loadDocument(uri), uri);
    }

    private void setDocumentP(String uri) {
        this.setDocumentP(this.loadDocument(uri), uri);
    }

    private void setDocumentP(Document doc, String url) {
        this.setDocumentP(doc, url, (NamespaceHandler)new XhtmlNamespaceHandler());
    }

    private void setDocumentP(File file) throws IOException {
        File parent = file.getAbsoluteFile().getParentFile();
        this.setDocumentP(this.loadDocument(file.toURI().toURL().toExternalForm()), parent == null ? "" : parent.toURI().toURL().toExternalForm());
    }

    private void setDocumentFromStringP(String content, String baseUrl) {
        InputSource is = new InputSource(new BufferedReader(new StringReader(content)));
        Document dom = XMLResource.load((InputSource)is).getDocument();
        this.setDocumentP(dom, baseUrl);
    }

    private void setDocumentP(Document doc, String url, NamespaceHandler nsh) {
        this._doc = doc;
        this.getFontResolver().flushFontFaceFonts();
        this._sharedContext.reset();
        if (Configuration.isTrue((String)"xr.cache.stylesheets", (boolean)true)) {
            this._sharedContext.getCss().flushStyleSheets();
        } else {
            this._sharedContext.getCss().flushAllStyleSheets();
        }
        this._sharedContext.setBaseURL(url);
        this._sharedContext.setNamespaceHandler(nsh);
        this._sharedContext.getCss().setDocumentContext(this._sharedContext, this._sharedContext.getNamespaceHandler(), doc, (UserInterface)new NullUserInterface());
        this.getFontResolver().importFontFaces(this._sharedContext.getCss().getFontFaceRules());
        if (this._svgImpl != null) {
            this._svgImpl.importFontFaceRules(this._sharedContext.getCss().getFontFaceRules(), this._sharedContext);
        }
    }

    @Deprecated
    public void setDocument(Document doc, String url) {
        this.setDocumentP(doc, url);
    }

    @Deprecated
    public void setDocument(File file) throws IOException {
        this.setDocumentP(file);
    }

    @Deprecated
    public void setDocumentFromString(String content) {
        this.setDocumentFromStringP(content, null);
    }

    @Deprecated
    public void setDocumentFromString(String content, String baseUrl) {
        this.setDocumentFromStringP(content, baseUrl);
    }

    @Deprecated
    public void setDocument(Document doc, String url, NamespaceHandler nsh) {
        this.setDocumentP(doc, url, nsh);
    }

    @Deprecated
    public void setPDFVersion(float v) {
        this._pdfDoc.setVersion(v);
        this._pdfVersion = v;
    }

    public float getPDFVersion() {
        return this._pdfVersion == 0.0f ? 1.7f : this._pdfVersion;
    }

    public void layout() {
        LayoutContext c = this.newLayoutContext();
        BlockBox root = BoxBuilder.createRootBox((LayoutContext)c, (Document)this._doc);
        root.setContainingBlock((Box)new ViewportBox(this.getInitialExtents(c)));
        root.layout(c);
        Dimension dim = root.getLayer().getPaintingDimension(c);
        root.getLayer().trimEmptyPages((CssContext)c, dim.height);
        root.getLayer().layoutPages(c);
        this._root = root;
    }

    private Rectangle getInitialExtents(LayoutContext c) {
        PageBox first = Layer.createPageBox((CssContext)c, (String)"first");
        return new Rectangle(0, 0, first.getContentWidth((CssContext)c), first.getContentHeight((CssContext)c));
    }

    private RenderingContext newRenderingContext() {
        RenderingContext result = this._sharedContext.newRenderingContextInstance();
        result.setFontContext((FontContext)new PdfBoxFontContext());
        result.setOutputDevice((OutputDevice)this._outputDevice);
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        this._outputDevice.setRenderingContext(result);
        this._sharedContext.getTextRenderer().setup(result.getFontContext());
        result.setRootLayer(this._root.getLayer());
        return result;
    }

    private LayoutContext newLayoutContext() {
        LayoutContext result = this._sharedContext.newLayoutContextInstance();
        result.setFontContext((FontContext)new PdfBoxFontContext());
        if (this._splitterFactory != null) {
            result.setBidiSplitterFactory(this._splitterFactory);
        }
        if (this._reorderer != null) {
            result.setBidiReorderer(this._reorderer);
        }
        result.setDefaultTextDirection(this._defaultTextDirection);
        ((PdfBoxTextRenderer)this._sharedContext.getTextRenderer()).setup(result.getFontContext(), (BidiReorderer)(this._reorderer != null ? this._reorderer : new SimpleBidiReorderer()));
        return result;
    }

    public void createPDF() throws IOException {
        this.createPDF(this._os);
    }

    public void createPDF(OutputStream os) throws IOException {
        this.createPDF(os, true, 0);
    }

    public void writeNextDocument() throws IOException {
        this.writeNextDocument(0);
    }

    public void writeNextDocument(int initialPageNo) throws IOException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(initialPageNo);
        PageBox firstPage = (PageBox)pages.get(0);
        Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)firstPage.getHeight((CssContext)c) / this._dotsPerPoint);
        this._outputDevice.setStartPageNo(this._pdfDoc.getNumberOfPages());
        this.writePDF(pages, c, firstPageSize, this._pdfDoc);
    }

    public void finishPDF() throws IOException {
        if (this._pdfDoc != null) {
            this.fireOnClose();
            this._pdfDoc.close();
        }
    }

    public void createPDF(OutputStream os, boolean finish) throws IOException {
        this.createPDF(os, finish, 0);
    }

    public void createPDF(OutputStream os, boolean finish, int initialPageNo) throws IOException {
        List pages = this._root.getLayer().getPages();
        RenderingContext c = this.newRenderingContext();
        c.setInitialPageNo(initialPageNo);
        PageBox firstPage = (PageBox)pages.get(0);
        Rectangle2D.Float firstPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)firstPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)firstPage.getHeight((CssContext)c) / this._dotsPerPoint);
        if (this._pdfVersion != 0.0f) {
            this._pdfDoc.setVersion(this._pdfVersion);
        }
        if (this._pdfEncryption != null) {
            this._pdfDoc.setEncryptionDictionary(this._pdfEncryption);
        }
        this.firePreOpen();
        this.writePDF(pages, c, firstPageSize, this._pdfDoc);
        if (finish) {
            this.fireOnClose();
            this._pdfDoc.save(os);
            this._pdfDoc.close();
        }
    }

    private void firePreOpen() {
        if (this._listener != null) {
            this._listener.preOpen(this);
        }
    }

    private void firePreWrite(int pageCount) {
        if (this._listener != null) {
            this._listener.preWrite(this, pageCount);
        }
    }

    private void fireOnClose() {
        if (this._listener != null) {
            this._listener.onClose(this);
        }
    }

    private void writePDF(List<PageBox> pages, RenderingContext c, Rectangle2D firstPageSize, PDDocument doc) throws IOException {
        this._outputDevice.setRoot((Box)this._root);
        this._outputDevice.start(this._doc);
        PDPage page = new PDPage(new PDRectangle((float)firstPageSize.getWidth(), (float)firstPageSize.getHeight()));
        PDPageContentStream cs = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, !this._testMode);
        doc.addPage(page);
        this._outputDevice.initializePage(cs, page, (float)firstPageSize.getHeight());
        this._root.getLayer().assignPagePaintingPositions((CssContext)c, (short)2);
        int pageCount = this._root.getLayer().getPages().size();
        c.setPageCount(pageCount);
        this.firePreWrite(pageCount);
        this.setDidValues(doc);
        for (int i = 0; i < pageCount; ++i) {
            PageBox currentPage = pages.get(i);
            c.setPage(i, currentPage);
            this.paintPage(c, currentPage);
            this._outputDevice.finishPage();
            if (i == pageCount - 1) continue;
            PageBox nextPage = pages.get(i + 1);
            Rectangle2D.Float nextPageSize = new Rectangle2D.Float(0.0f, 0.0f, (float)nextPage.getWidth((CssContext)c) / this._dotsPerPoint, (float)nextPage.getHeight((CssContext)c) / this._dotsPerPoint);
            PDPage pageNext = new PDPage(new PDRectangle((float)((RectangularShape)nextPageSize).getWidth(), (float)((RectangularShape)nextPageSize).getHeight()));
            PDPageContentStream csNext = new PDPageContentStream(doc, pageNext, PDPageContentStream.AppendMode.APPEND, !this._testMode);
            doc.addPage(pageNext);
            this._outputDevice.initializePage(csNext, pageNext, (float)((RectangularShape)nextPageSize).getHeight());
        }
        this._outputDevice.finish(c, (Box)this._root);
    }

    private void setDidValues(PDDocument doc) {
        PDDocumentInformation info = new PDDocumentInformation();
        info.setCreationDate(Calendar.getInstance());
        info.setProducer("openhtmltopdf.com");
        for (PdfBoxOutputDevice.Metadata metadata : this._outputDevice.getMetadata()) {
            String name = metadata.getName();
            String content = metadata.getContent();
            if (content == null) continue;
            if (name.equals("title")) {
                info.setTitle(content);
                continue;
            }
            if (name.equals("author")) {
                info.setAuthor(content);
                continue;
            }
            if (name.equals("subject")) {
                info.setSubject(content);
                continue;
            }
            if (name.equals("keywords")) {
                info.setKeywords(content);
                continue;
            }
            info.setCustomMetadataValue(name, content);
        }
        doc.setDocumentInformation(info);
    }

    private void paintPage(RenderingContext c, PageBox page) throws IOException {
        page.paintBackground(c, 0, (short)2);
        page.paintMarginAreas(c, 0, (short)2);
        page.paintBorder(c, 0, (short)2);
        Shape working = this._outputDevice.getClip();
        Rectangle content = page.getPrintClippingBounds((CssContext)c);
        this._outputDevice.clip(content);
        int top = -page.getPaintingTop() + page.getMarginBorderPadding((CssContext)c, 3);
        int left = page.getMarginBorderPadding((CssContext)c, 1);
        this._outputDevice.translate(left, top);
        this._root.getLayer().paint(c);
        this._outputDevice.translate(-left, -top);
        this._outputDevice.setClip(working);
    }

    private String stringfyMetadata(Element element) {
        Element target = PdfBoxRenderer.getFirstChildElement(element);
        if (target == null) {
            return null;
        }
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter output = new StringWriter();
            transformer.transform(new DOMSource(target), new StreamResult(output));
            return output.toString();
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
    }

    private static Element getFirstChildElement(Element element) {
        for (Node n = element.getFirstChild(); n != null; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            return (Element)n;
        }
        return null;
    }

    private String createXPacket(String metadata) {
        StringBuffer result = new StringBuffer(metadata.length() + 50);
        result.append("<?xpacket begin='\ufeff' id='W5M0MpCehiHzreSzNTczkc9d'?>\n");
        result.append(metadata);
        result.append("\n<?xpacket end='r'?>");
        return result.toString();
    }

    public PdfBoxOutputDevice getOutputDevice() {
        return this._outputDevice;
    }

    public SharedContext getSharedContext() {
        return this._sharedContext;
    }

    public void exportText(Writer writer) throws IOException {
        RenderingContext c = this.newRenderingContext();
        c.setPageCount(this._root.getLayer().getPages().size());
        this._root.exportText(c, writer);
    }

    public BlockBox getRootBox() {
        return this._root;
    }

    public float getDotsPerPoint() {
        return this._dotsPerPoint;
    }

    public List findPagePositionsByID(Pattern pattern) {
        return this._outputDevice.findPagePositionsByID((CssContext)this.newLayoutContext(), pattern);
    }

    public PDFCreationListener getListener() {
        return this._listener;
    }

    public void setListener(PDFCreationListener listener) {
        this._listener = listener;
    }

    public void cleanup() {
        this._sharedContext.removeFromThread();
        ThreadCtx.cleanup();
    }

    private static final class NullUserInterface
    implements UserInterface {
        private NullUserInterface() {
        }

        public boolean isHover(Element e) {
            return false;
        }

        public boolean isActive(Element e) {
            return false;
        }

        public boolean isFocus(Element e) {
            return false;
        }
    }
}

