/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.config;

import com.opensymphony.xwork2.config.Configuration;
import com.opensymphony.xwork2.config.ConfigurationException;
import com.opensymphony.xwork2.config.ConfigurationProvider;
import com.opensymphony.xwork2.config.ContainerProvider;
import com.opensymphony.xwork2.config.PackageProvider;
import com.opensymphony.xwork2.config.impl.DefaultConfiguration;
import com.opensymphony.xwork2.config.providers.XWorkConfigurationProvider;
import com.opensymphony.xwork2.config.providers.XmlConfigurationProvider;
import com.opensymphony.xwork2.util.FileManager;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManager {
    protected static final Logger LOG = LoggerFactory.getLogger(ConfigurationManager.class);
    protected Configuration configuration;
    protected Lock providerLock = new ReentrantLock();
    private List<ContainerProvider> containerProviders = new CopyOnWriteArrayList<ContainerProvider>();
    private List<PackageProvider> packageProviders = new CopyOnWriteArrayList<PackageProvider>();
    protected String defaultFrameworkBeanName;

    public ConfigurationManager() {
        this("xwork");
    }

    public ConfigurationManager(String name) {
        this.defaultFrameworkBeanName = name;
    }

    public synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.setConfiguration(new DefaultConfiguration(this.defaultFrameworkBeanName));
            try {
                this.configuration.reloadContainer(this.getContainerProviders());
            }
            catch (ConfigurationException e) {
                this.setConfiguration(null);
                throw new ConfigurationException("Unable to load configuration.", e);
            }
        } else {
            this.conditionalReload();
        }
        return this.configuration;
    }

    public synchronized void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public List<ConfigurationProvider> getConfigurationProviders() {
        List<ContainerProvider> contProviders = this.getContainerProviders();
        ArrayList<ConfigurationProvider> providers = new ArrayList<ConfigurationProvider>();
        for (ContainerProvider prov : contProviders) {
            if (!(prov instanceof ConfigurationProvider)) continue;
            providers.add((ConfigurationProvider)prov);
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ContainerProvider> getContainerProviders() {
        this.providerLock.lock();
        try {
            if (this.containerProviders.size() == 0) {
                this.containerProviders.add(new XWorkConfigurationProvider());
                this.containerProviders.add(new XmlConfigurationProvider("xwork.xml", false));
            }
            List<ContainerProvider> list = this.containerProviders;
            return list;
        }
        finally {
            this.providerLock.unlock();
        }
    }

    public void setConfigurationProviders(List<ConfigurationProvider> configurationProviders) {
        ArrayList<ContainerProvider> contProviders = new ArrayList<ContainerProvider>();
        contProviders.addAll(configurationProviders);
        this.setContainerProviders(contProviders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainerProviders(List<ContainerProvider> containerProviders) {
        this.providerLock.lock();
        try {
            this.containerProviders = new CopyOnWriteArrayList<ContainerProvider>(containerProviders);
        }
        finally {
            this.providerLock.unlock();
        }
    }

    public void addConfigurationProvider(ConfigurationProvider provider) {
        this.addContainerProvider(provider);
    }

    public void addContainerProvider(ContainerProvider provider) {
        if (!this.containerProviders.contains(provider)) {
            this.containerProviders.add(provider);
        }
    }

    public void clearConfigurationProviders() {
        this.clearContainerProviders();
    }

    public void clearContainerProviders() {
        for (ContainerProvider containerProvider : this.containerProviders) {
            try {
                containerProvider.destroy();
            }
            catch (Exception e) {
                LOG.warn("error while destroying container provider [" + containerProvider + "]", e, new String[0]);
            }
        }
        this.containerProviders.clear();
    }

    public synchronized void destroyConfiguration() {
        this.clearConfigurationProviders();
        this.containerProviders = new CopyOnWriteArrayList<ContainerProvider>();
        if (this.configuration != null) {
            this.configuration.destroy();
        }
        this.configuration = null;
    }

    public synchronized void conditionalReload() {
        if (FileManager.isReloadingConfigs()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Checking ConfigurationProviders for reload.", new String[0]);
            }
            boolean reload = false;
            List<ContainerProvider> providers = this.getContainerProviders();
            for (ContainerProvider containerProvider : providers) {
                if (!containerProvider.needsReload()) continue;
                if (LOG.isInfoEnabled()) {
                    LOG.info("Detected container provider " + containerProvider + " needs to be reloaded.  Reloading all providers.", new String[0]);
                }
                reload = true;
                break;
            }
            if (this.packageProviders != null && reload) {
                for (PackageProvider packageProvider : this.packageProviders) {
                    if (!packageProvider.needsReload()) continue;
                    if (LOG.isInfoEnabled()) {
                        LOG.info("Detected package provider " + packageProvider + " needs to be reloaded.  Reloading all providers.", new String[0]);
                    }
                    reload = true;
                    break;
                }
            }
            if (reload) {
                for (ContainerProvider containerProvider : this.containerProviders) {
                    try {
                        containerProvider.destroy();
                    }
                    catch (Exception e) {
                        LOG.warn("error while destroying configuration provider [" + containerProvider + "]", e, new String[0]);
                    }
                }
                this.packageProviders = this.configuration.reloadContainer(providers);
            }
        }
    }

    public synchronized void reload() {
        this.packageProviders = this.getConfiguration().reloadContainer(this.getContainerProviders());
    }
}

