/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.interceptor;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.ValidationAware;
import com.opensymphony.xwork2.inject.Inject;
import com.opensymphony.xwork2.interceptor.MethodFilterInterceptor;
import com.opensymphony.xwork2.interceptor.NoParameters;
import com.opensymphony.xwork2.interceptor.ParameterNameAware;
import com.opensymphony.xwork2.util.LocalizedTextUtil;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.util.reflection.ReflectionContextState;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ParametersInterceptor
extends MethodFilterInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(ParametersInterceptor.class);
    boolean ordered = false;
    Set<Pattern> excludeParams = Collections.EMPTY_SET;
    static boolean devMode = false;
    static final Comparator rbCollator = new Comparator(){

        public int compare(Object arg0, Object arg1) {
            int i;
            String s1 = (String)arg0;
            String s2 = (String)arg1;
            int l1 = 0;
            int l2 = 0;
            for (i = s1.length() - 1; i >= 0; --i) {
                if (s1.charAt(i) != '.') continue;
                ++l1;
            }
            for (i = s2.length() - 1; i >= 0; --i) {
                if (s2.charAt(i) != '.') continue;
                ++l2;
            }
            return l1 < l2 ? -1 : (l2 < l1 ? 1 : s1.compareTo(s2));
        }
    };

    @Inject(value="devMode")
    public static void setDevMode(String mode) {
        devMode = "true".equals(mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doIntercept(ActionInvocation invocation) throws Exception {
        Object action = invocation.getAction();
        if (!(action instanceof NoParameters)) {
            ActionContext ac = invocation.getInvocationContext();
            Map parameters = ac.getParameters();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Setting params " + this.getParameterLogMap(parameters), new String[0]);
            }
            if (parameters != null) {
                Map contextMap = ac.getContextMap();
                try {
                    ReflectionContextState.setCreatingNullObjects(contextMap, true);
                    ReflectionContextState.setDenyMethodExecution(contextMap, true);
                    ReflectionContextState.setReportingConversionErrors(contextMap, true);
                    ValueStack stack = ac.getValueStack();
                    this.setParameters(action, stack, parameters);
                }
                finally {
                    ReflectionContextState.setCreatingNullObjects(contextMap, false);
                    ReflectionContextState.setDenyMethodExecution(contextMap, false);
                    ReflectionContextState.setReportingConversionErrors(contextMap, false);
                }
            }
        }
        return invocation.invoke();
    }

    protected void setParameters(Object action, ValueStack stack, Map parameters) {
        ParameterNameAware parameterNameAware = action instanceof ParameterNameAware ? (ParameterNameAware)action : null;
        TreeMap params = null;
        if (this.ordered) {
            params = new TreeMap(this.getOrderedComparator());
            params.putAll(parameters);
        } else {
            params = new TreeMap(parameters);
        }
        for (Map.Entry entry : params.entrySet()) {
            String name = entry.getKey().toString();
            boolean acceptableName = this.acceptableName(name) && (parameterNameAware == null || parameterNameAware.acceptableParameterName(name));
            if (!acceptableName) continue;
            Object value = entry.getValue();
            try {
                stack.setValue(name, value);
            }
            catch (RuntimeException e) {
                if (devMode) {
                    String developerNotification = LocalizedTextUtil.findText(ParametersInterceptor.class, "devmode.notification", ActionContext.getContext().getLocale(), "Developer Notification:\n{0}", new Object[]{e.getMessage()});
                    LOG.error(developerNotification, new String[0]);
                    if (!(action instanceof ValidationAware)) continue;
                    ((ValidationAware)action).addActionMessage(developerNotification);
                    continue;
                }
                LOG.error("ParametersInterceptor - [setParameters]: Unexpected Exception caught setting '" + name + "' on '" + action.getClass() + ": " + e.getMessage(), new String[0]);
            }
        }
    }

    protected Comparator getOrderedComparator() {
        return rbCollator;
    }

    private String getParameterLogMap(Map parameters) {
        if (parameters == null) {
            return "NONE";
        }
        StringBuffer logEntry = new StringBuffer();
        for (Map.Entry entry : parameters.entrySet()) {
            logEntry.append(String.valueOf(entry.getKey()));
            logEntry.append(" => ");
            if (entry.getValue() instanceof Object[]) {
                Object[] valueArray = (Object[])entry.getValue();
                logEntry.append("[ ");
                for (int indexA = 0; indexA < valueArray.length - 1; ++indexA) {
                    Object valueAtIndex = valueArray[indexA];
                    logEntry.append(valueAtIndex);
                    logEntry.append(String.valueOf(valueAtIndex));
                    logEntry.append(", ");
                }
                logEntry.append(String.valueOf(valueArray[valueArray.length - 1]));
                logEntry.append(" ] ");
                continue;
            }
            logEntry.append(String.valueOf(entry.getValue()));
        }
        return logEntry.toString();
    }

    protected boolean acceptableName(String name) {
        return name.indexOf(61) == -1 && name.indexOf(44) == -1 && name.indexOf(35) == -1 && name.indexOf(58) == -1 && !this.isExcluded(name);
    }

    protected boolean isExcluded(String paramName) {
        if (!this.excludeParams.isEmpty()) {
            for (Pattern pattern : this.excludeParams) {
                Matcher matcher = pattern.matcher(paramName);
                if (!matcher.matches()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public void setOrdered(boolean ordered) {
        this.ordered = ordered;
    }

    protected Set getExcludeParamsSet() {
        return this.excludeParams;
    }

    public void setExcludeParams(String commaDelim) {
        Collection excludePatterns = this.asCollection(commaDelim);
        if (excludePatterns != null) {
            this.excludeParams = new HashSet<Pattern>();
            for (String pattern : excludePatterns) {
                this.excludeParams.add(Pattern.compile(pattern));
            }
        }
    }

    private Collection asCollection(String commaDelim) {
        if (commaDelim == null || commaDelim.trim().length() == 0) {
            return null;
        }
        return TextParseUtil.commaDelimitedStringToSet(commaDelim);
    }
}

