/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator;

import com.opensymphony.xwork2.ObjectFactory;
import com.opensymphony.xwork2.XWorkException;
import com.opensymphony.xwork2.util.ClassLoaderUtil;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.ShortCircuitableValidator;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorConfig;
import com.opensymphony.xwork2.validator.ValidatorFileParser;
import java.io.File;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class ValidatorFactory {
    private static Map<String, String> validators = new HashMap<String, String>();
    private static Logger LOG = LoggerFactory.getLogger(ValidatorFactory.class);

    private ValidatorFactory() {
    }

    public static Validator getValidator(ValidatorConfig cfg) {
        return ValidatorFactory.getValidator(cfg, ObjectFactory.getObjectFactory());
    }

    public static Validator getValidator(ValidatorConfig cfg, ObjectFactory objectFactory) {
        Validator validator;
        String className = ValidatorFactory.lookupRegisteredValidatorType(cfg.getType());
        try {
            validator = objectFactory.buildValidator(className, cfg.getParams(), null);
        }
        catch (Exception e) {
            String msg = "There was a problem creating a Validator of type " + className + " : caused by " + e.getMessage();
            throw new XWorkException(msg, e, cfg);
        }
        validator.setMessageKey(cfg.getMessageKey());
        validator.setDefaultMessage(cfg.getDefaultMessage());
        if (validator instanceof ShortCircuitableValidator) {
            ((ShortCircuitableValidator)((Object)validator)).setShortCircuit(cfg.isShortCircuit());
        }
        return validator;
    }

    public static void registerValidator(String name, String className) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Registering validator of class " + className + " with name " + name, new String[0]);
        }
        validators.put(name, className);
    }

    public static String lookupRegisteredValidatorType(String name) {
        String className = validators.get(name);
        if (className == null) {
            throw new IllegalArgumentException("There is no validator class mapped to the name " + name);
        }
        return className;
    }

    private static void parseValidators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Loading validator definitions.", new String[0]);
        }
        URL u = ClassLoaderUtil.getResource("", ValidatorFactory.class);
        File[] files = null;
        try {
            File f = new File(u.toURI());
            FilenameFilter filter = new FilenameFilter(){

                public boolean accept(File file, String fileName) {
                    return fileName.contains("-validators.xml");
                }
            };
            files = f.listFiles(filter);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
        String resourceName = "com/opensymphony/xwork2/validator/validators/default.xml";
        ValidatorFactory.retrieveValidatorConfiguration(resourceName);
        resourceName = "validators.xml";
        ValidatorFactory.retrieveValidatorConfiguration(resourceName);
        if (files != null && files.length > 0) {
            for (File file : files) {
                ValidatorFactory.retrieveValidatorConfiguration(file.getName());
            }
        }
    }

    private static void retrieveValidatorConfiguration(String resourceName) {
        InputStream is = ClassLoaderUtil.getResourceAsStream(resourceName, ValidatorFactory.class);
        if (is != null) {
            ValidatorFileParser.parseValidatorDefinitions(is, resourceName);
        }
    }

    static {
        ValidatorFactory.parseValidators();
    }
}

