/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.validator.validators;

import com.opensymphony.xwork2.ActionContext;
import com.opensymphony.xwork2.util.TextParseUtil;
import com.opensymphony.xwork2.util.ValueStack;
import com.opensymphony.xwork2.util.logging.Logger;
import com.opensymphony.xwork2.util.logging.LoggerFactory;
import com.opensymphony.xwork2.validator.DelegatingValidatorContext;
import com.opensymphony.xwork2.validator.ShortCircuitableValidator;
import com.opensymphony.xwork2.validator.ValidationException;
import com.opensymphony.xwork2.validator.Validator;
import com.opensymphony.xwork2.validator.ValidatorContext;

public abstract class ValidatorSupport
implements Validator,
ShortCircuitableValidator {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected String defaultMessage = "";
    protected String messageKey;
    private ValidatorContext validatorContext;
    private boolean shortCircuit;
    private boolean parse;
    private String type;

    public void setDefaultMessage(String message) {
        this.defaultMessage = message;
    }

    public String getDefaultMessage() {
        return this.defaultMessage;
    }

    public void setParse(boolean parse) {
        this.parse = parse;
    }

    public boolean getParse() {
        return this.parse;
    }

    public String getMessage(Object object) {
        String message;
        ValueStack stack = ActionContext.getContext().getValueStack();
        boolean pop = false;
        if (!stack.getRoot().contains(object)) {
            stack.push(object);
            pop = true;
        }
        stack.push(this);
        if (this.messageKey != null) {
            if (this.defaultMessage == null || this.defaultMessage.trim().equals("")) {
                this.defaultMessage = this.messageKey;
            }
            if (this.validatorContext == null) {
                this.validatorContext = new DelegatingValidatorContext(object);
            }
            message = this.validatorContext.getText(this.messageKey, this.defaultMessage);
        } else {
            message = this.defaultMessage;
        }
        message = TextParseUtil.translateVariables(message, stack);
        stack.pop();
        if (pop) {
            stack.pop();
        }
        return message;
    }

    public void setMessageKey(String key) {
        this.messageKey = key;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setShortCircuit(boolean shortcircuit) {
        this.shortCircuit = shortcircuit;
    }

    public boolean isShortCircuit() {
        return this.shortCircuit;
    }

    public void setValidatorContext(ValidatorContext validatorContext) {
        this.validatorContext = validatorContext;
    }

    public ValidatorContext getValidatorContext() {
        return this.validatorContext;
    }

    public void setValidatorType(String type) {
        this.type = type;
    }

    public String getValidatorType() {
        return this.type;
    }

    protected Object conditionalParse(String expression) {
        if (this.parse) {
            ValueStack stack = ActionContext.getContext().getValueStack();
            return TextParseUtil.translateVariables('$', expression, stack);
        }
        return expression;
    }

    protected Object getFieldValue(String name, Object object) throws ValidationException {
        ValueStack stack = ActionContext.getContext().getValueStack();
        boolean pop = false;
        if (!stack.getRoot().contains(object)) {
            stack.push(object);
            pop = true;
        }
        Object retVal = stack.findValue(name);
        if (pop) {
            stack.pop();
        }
        return retVal;
    }

    protected void addActionError(Object object) {
        this.validatorContext.addActionError(this.getMessage(object));
    }

    protected void addFieldError(String propertyName, Object object) {
        this.validatorContext.addFieldError(propertyName, this.getMessage(object));
    }
}

