/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.xwork2.util;

import com.opensymphony.xwork2.conversion.impl.XWorkConverter;
import com.opensymphony.xwork2.inject.Container;
import com.opensymphony.xwork2.util.TextUtils;
import com.opensymphony.xwork2.util.ValueStack;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextParseUtil {
    private static final int MAX_RECURSION = 1;

    public static String translateVariables(String expression, ValueStack stack) {
        return TextParseUtil.translateVariables(new char[]{'$', '%'}, expression, stack, String.class, null).toString();
    }

    public static String translateVariables(String expression, ValueStack stack, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariables(new char[]{'$', '%'}, expression, stack, String.class, evaluator).toString();
    }

    public static String translateVariables(char open, String expression, ValueStack stack) {
        return TextParseUtil.translateVariables(open, expression, stack, String.class, null).toString();
    }

    public static Object translateVariables(char open, String expression, ValueStack stack, Class asType) {
        return TextParseUtil.translateVariables(open, expression, stack, asType, null);
    }

    public static Object translateVariables(char open, String expression, ValueStack stack, Class asType, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariables(new char[]{open}, expression, stack, asType, evaluator, 1);
    }

    public static Object translateVariables(char[] openChars, String expression, ValueStack stack, Class asType, ParsedValueEvaluator evaluator) {
        return TextParseUtil.translateVariables(openChars, expression, stack, asType, evaluator, 1);
    }

    public static Object translateVariables(char open, String expression, ValueStack stack, Class asType, ParsedValueEvaluator evaluator, int maxLoopCount) {
        return TextParseUtil.translateVariables(new char[]{open}, expression, stack, asType, evaluator, maxLoopCount);
    }

    public static Object translateVariables(char[] openChars, String expression, ValueStack stack, Class asType, ParsedValueEvaluator evaluator, int maxLoopCount) {
        Object result = expression;
        block0: for (char open : openChars) {
            int loopCount = 1;
            int pos = 0;
            String lookupChars = open + "{";
            while (true) {
                int start;
                if ((start = expression.indexOf(lookupChars, pos)) == -1) {
                    pos = 0;
                    ++loopCount;
                    start = expression.indexOf(lookupChars);
                }
                if (loopCount > maxLoopCount) continue block0;
                int length = expression.length();
                int x = start + 2;
                int count = 1;
                while (start != -1 && x < length && count != 0) {
                    char c;
                    if ((c = expression.charAt(x++)) == '{') {
                        ++count;
                        continue;
                    }
                    if (c != '}') continue;
                    --count;
                }
                int end = x - 1;
                if (start == -1 || end == -1 || count != 0) continue block0;
                String var = expression.substring(start + 2, end);
                Object o = stack.findValue(var, asType);
                if (evaluator != null) {
                    o = evaluator.evaluate(o);
                }
                String left = expression.substring(0, start);
                String right = expression.substring(end + 1);
                String middle = null;
                if (o != null) {
                    middle = o.toString();
                    result = !TextUtils.stringSet(left) ? o : left.concat(middle);
                    if (TextUtils.stringSet(right)) {
                        result = result.toString().concat(right);
                    }
                    expression = left.concat(middle).concat(right);
                } else {
                    expression = left.concat(right);
                    result = expression;
                }
                pos = (left != null && left.length() > 0 ? left.length() - 1 : 0) + (middle != null && middle.length() > 0 ? middle.length() - 1 : 0) + 1;
                pos = Math.max(pos, 1);
            }
        }
        XWorkConverter conv = ((Container)stack.getContext().get("com.opensymphony.xwork2.ActionContext.container")).getInstance(XWorkConverter.class);
        return conv.convertValue(stack.getContext(), result, asType);
    }

    public static Set<String> commaDelimitedStringToSet(String s) {
        String[] split;
        HashSet<String> set = new HashSet<String>();
        for (String aSplit : split = s.split(",")) {
            String trimmed = aSplit.trim();
            if (trimmed.length() <= 0) continue;
            set.add(trimmed);
        }
        return set;
    }

    public static interface ParsedValueEvaluator {
        public Object evaluate(Object var1);
    }
}

