/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.junit;

import com.opentable.db.postgres.embedded.ConnectionInfo;
import com.opentable.db.postgres.embedded.DatabasePreparer;
import com.opentable.db.postgres.embedded.PreparedDbProvider;
import javax.sql.DataSource;
import org.junit.rules.ExternalResource;

public class PreparedDbRule
extends ExternalResource {
    private final DatabasePreparer preparer;
    private volatile DataSource dataSource;
    private volatile PreparedDbProvider provider;
    private volatile ConnectionInfo connectionInfo;

    protected PreparedDbRule(DatabasePreparer preparer) {
        if (preparer == null) {
            throw new IllegalStateException("null preparer");
        }
        this.preparer = preparer;
    }

    protected void before() throws Throwable {
        this.provider = PreparedDbProvider.forPreparer(this.preparer);
        this.connectionInfo = this.provider.createNewDatabase();
        this.dataSource = this.provider.createDataSourceFromConnectionInfo(this.connectionInfo);
    }

    protected void after() {
        this.dataSource = null;
        this.connectionInfo = null;
        this.provider = null;
    }

    public DataSource getTestDatabase() {
        if (this.dataSource == null) {
            throw new AssertionError((Object)"not initialized");
        }
        return this.dataSource;
    }

    public ConnectionInfo getConnectionInfo() {
        if (this.connectionInfo == null) {
            throw new AssertionError((Object)"not initialized");
        }
        return this.connectionInfo;
    }

    public PreparedDbProvider getDbProvider() {
        if (this.provider == null) {
            throw new AssertionError((Object)"not initialized");
        }
        return this.provider;
    }
}

