/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.ConnectionInfo;
import com.opentable.db.postgres.embedded.DatabasePreparer;
import com.opentable.db.postgres.embedded.EmbeddedPostgres;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import java.util.function.Consumer;
import javax.sql.DataSource;
import org.apache.commons.lang3.RandomStringUtils;
import org.postgresql.ds.PGSimpleDataSource;

public class PreparedDbProvider {
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%d/%s?user=%s";
    private static final Map<DatabasePreparer, PrepPipeline> CLUSTERS = new HashMap<DatabasePreparer, PrepPipeline>();
    private final PrepPipeline dbPreparer;
    private final Iterable<Consumer<EmbeddedPostgres.Builder>> customizers;

    public static PreparedDbProvider forPreparer(DatabasePreparer preparer) {
        return PreparedDbProvider.forPreparer(preparer, Collections.emptyList());
    }

    public static PreparedDbProvider forPreparer(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) {
        return new PreparedDbProvider(preparer, customizers);
    }

    private PreparedDbProvider(DatabasePreparer preparer, Iterable<Consumer<EmbeddedPostgres.Builder>> customizers) {
        this.customizers = customizers;
        try {
            this.dbPreparer = this.createOrFindPreparer(preparer);
        }
        catch (IOException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private synchronized PrepPipeline createOrFindPreparer(DatabasePreparer preparer) throws IOException, SQLException {
        PrepPipeline result = CLUSTERS.get(preparer);
        if (result != null) {
            return result;
        }
        EmbeddedPostgres.Builder builder = EmbeddedPostgres.builder();
        this.customizers.forEach(c -> c.accept(builder));
        EmbeddedPostgres pg = builder.start();
        preparer.prepare(pg.getTemplateDatabase());
        result = new PrepPipeline(pg).start();
        CLUSTERS.put(preparer, result);
        return result;
    }

    public String createDatabase() throws SQLException {
        return this.getJdbcUri(this.createNewDB());
    }

    private DbInfo createNewDB() throws SQLException {
        return this.dbPreparer.getNextDb();
    }

    public ConnectionInfo createNewDatabase() throws SQLException {
        DbInfo dbInfo = this.createNewDB();
        return dbInfo == null || !dbInfo.isSuccess() ? null : new ConnectionInfo(dbInfo.getDbName(), dbInfo.getPort(), dbInfo.getUser());
    }

    public DataSource createDataSourceFromConnectionInfo(ConnectionInfo connectionInfo) throws SQLException {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setPortNumber(connectionInfo.getPort());
        ds.setDatabaseName(connectionInfo.getDbName());
        ds.setUser(connectionInfo.getUser());
        return ds;
    }

    public DataSource createDataSource() throws SQLException {
        return this.createDataSourceFromConnectionInfo(this.createNewDatabase());
    }

    String getJdbcUri(DbInfo db) {
        return String.format(JDBC_FORMAT, db.port, db.dbName, db.user);
    }

    public Map<String, String> getConfigurationTweak(String dbModuleName) throws SQLException {
        DbInfo db = this.dbPreparer.getNextDb();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ot.db." + dbModuleName + ".uri", this.getJdbcUri(db));
        result.put("ot.db." + dbModuleName + ".ds.user", db.user);
        return result;
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
    private static void create(DataSource connectDb, String dbName, String userName) throws SQLException {
        if (dbName == null) {
            throw new IllegalStateException("the database name must not be null!");
        }
        if (userName == null) {
            throw new IllegalStateException("the user name must not be null!");
        }
        try (Connection c = connectDb.getConnection();
             PreparedStatement stmt = c.prepareStatement(String.format("CREATE DATABASE %s OWNER %s ENCODING = 'utf8'", dbName, userName));){
            stmt.execute();
        }
    }

    public static class DbInfo {
        private final String dbName;
        private final int port;
        private final String user;
        private final SQLException ex;

        public static DbInfo ok(String dbName, int port, String user) {
            return new DbInfo(dbName, port, user, null);
        }

        public static DbInfo error(SQLException e) {
            return new DbInfo(null, -1, null, e);
        }

        private DbInfo(String dbName, int port, String user, SQLException e) {
            this.dbName = dbName;
            this.port = port;
            this.user = user;
            this.ex = null;
        }

        public int getPort() {
            return this.port;
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getUser() {
            return this.user;
        }

        public SQLException getException() {
            return this.ex;
        }

        public boolean isSuccess() {
            return this.ex == null;
        }
    }

    private static class PrepPipeline
    implements Runnable {
        private final EmbeddedPostgres pg;
        private final SynchronousQueue<DbInfo> nextDatabase = new SynchronousQueue();

        PrepPipeline(EmbeddedPostgres pg) {
            this.pg = pg;
        }

        PrepPipeline start() {
            ExecutorService service = Executors.newSingleThreadExecutor(r -> {
                Thread t = new Thread(r);
                t.setDaemon(true);
                t.setName("cluster-" + this.pg + "-preparer");
                return t;
            });
            service.submit(this);
            service.shutdown();
            return this;
        }

        DbInfo getNextDb() throws SQLException {
            try {
                DbInfo next = this.nextDatabase.take();
                if (next.ex != null) {
                    throw next.ex;
                }
                return next;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void run() {
            while (true) {
                String newDbName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                SQLException failure = null;
                try {
                    PreparedDbProvider.create(this.pg.getPostgresDatabase(), newDbName, "postgres");
                }
                catch (SQLException e) {
                    failure = e;
                }
                try {
                    if (failure == null) {
                        this.nextDatabase.put(DbInfo.ok(newDbName, this.pg.getPort(), "postgres"));
                        continue;
                    }
                    this.nextDatabase.put(DbInfo.error(failure));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }
}

