/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.opentable.db.postgres.embedded.BundledPostgresBinaryResolver;
import com.opentable.db.postgres.embedded.PgBinaryResolver;
import com.opentable.db.postgres.embedded.ProcessOutputLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.postgresql.ds.PGSimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tukaani.xz.XZInputStream;

@SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE", "RCN_REDUNDANT_NULLCHECK_WOULD_HAVE_BEEN_A_NPE"})
public class EmbeddedPostgres
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(EmbeddedPostgres.class);
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%s/%s?user=%s";
    private static final String PG_STOP_MODE = "fast";
    private static final String PG_STOP_WAIT_S = "5";
    private static final String PG_SUPERUSER = "postgres";
    private static final Duration DEFAULT_PG_STARTUP_WAIT = Duration.ofSeconds(10L);
    private static final String LOCK_FILE_NAME = "epg-lock";
    private final File pgDir;
    private final Duration pgStartupWait;
    private final File dataDirectory;
    private final File lockFile;
    private final UUID instanceId = UUID.randomUUID();
    private final int port;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Map<String, String> postgresConfig;
    private final Map<String, String> localeConfig;
    private volatile FileOutputStream lockStream;
    private volatile FileLock lock;
    private final boolean cleanDataDirectory;
    private final ProcessBuilder.Redirect errorRedirector;
    private final ProcessBuilder.Redirect outputRedirector;
    private static final Lock PREPARE_BINARIES_LOCK = new ReentrantLock();
    private static final Map<PgBinaryResolver, File> PREPARE_BINARIES = new HashMap<PgBinaryResolver, File>();

    EmbeddedPostgres(File parentDirectory, File dataDirectory, boolean cleanDataDirectory, Map<String, String> postgresConfig, Map<String, String> localeConfig, int port, Map<String, String> connectConfig, PgBinaryResolver pgBinaryResolver, ProcessBuilder.Redirect errorRedirector, ProcessBuilder.Redirect outputRedirector) throws IOException {
        this(parentDirectory, dataDirectory, cleanDataDirectory, postgresConfig, localeConfig, port, connectConfig, pgBinaryResolver, errorRedirector, outputRedirector, DEFAULT_PG_STARTUP_WAIT);
    }

    EmbeddedPostgres(File parentDirectory, File dataDirectory, boolean cleanDataDirectory, Map<String, String> postgresConfig, Map<String, String> localeConfig, int port, Map<String, String> connectConfig, PgBinaryResolver pgBinaryResolver, ProcessBuilder.Redirect errorRedirector, ProcessBuilder.Redirect outputRedirector, Duration pgStartupWait) throws IOException {
        this.cleanDataDirectory = cleanDataDirectory;
        this.postgresConfig = new HashMap<String, String>(postgresConfig);
        this.localeConfig = new HashMap<String, String>(localeConfig);
        this.port = port;
        this.pgDir = EmbeddedPostgres.prepareBinaries(pgBinaryResolver);
        this.errorRedirector = errorRedirector;
        this.outputRedirector = outputRedirector;
        this.pgStartupWait = pgStartupWait;
        Objects.requireNonNull(this.pgStartupWait, "Wait time cannot be null");
        if (parentDirectory != null) {
            EmbeddedPostgres.mkdirs(parentDirectory);
            this.cleanOldDataDirectories(parentDirectory);
            this.dataDirectory = dataDirectory != null ? dataDirectory : new File(parentDirectory, this.instanceId.toString());
        } else {
            this.dataDirectory = dataDirectory;
        }
        if (this.dataDirectory == null) {
            throw new IllegalArgumentException("no data directory");
        }
        LOG.trace("{} postgres data directory is {}", (Object)this.instanceId, (Object)this.dataDirectory);
        EmbeddedPostgres.mkdirs(this.dataDirectory);
        this.lockFile = new File(this.dataDirectory, LOCK_FILE_NAME);
        if (cleanDataDirectory || !new File(dataDirectory, "postgresql.conf").exists()) {
            this.initdb();
        }
        this.lock();
        this.startPostmaster(connectConfig);
    }

    public DataSource getTemplateDatabase() {
        return this.getDatabase(PG_SUPERUSER, "template1");
    }

    public DataSource getTemplateDatabase(Map<String, String> properties) {
        return this.getDatabase(PG_SUPERUSER, "template1", properties);
    }

    public DataSource getPostgresDatabase() {
        return this.getDatabase(PG_SUPERUSER, PG_SUPERUSER);
    }

    public DataSource getPostgresDatabase(Map<String, String> properties) {
        return this.getDatabase(PG_SUPERUSER, PG_SUPERUSER, properties);
    }

    public DataSource getDatabase(String userName, String dbName) {
        return this.getDatabase(userName, dbName, Collections.emptyMap());
    }

    public DataSource getDatabase(String userName, String dbName, Map<String, String> properties) {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setServerName("localhost");
        ds.setPortNumber(this.port);
        ds.setDatabaseName(dbName);
        ds.setUser(userName);
        properties.forEach((propertyKey, propertyValue) -> {
            try {
                ds.setProperty(propertyKey, propertyValue);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        });
        return ds;
    }

    public String getJdbcUrl(String userName, String dbName) {
        return String.format(JDBC_FORMAT, this.port, dbName, userName);
    }

    public int getPort() {
        return this.port;
    }

    private static int detectPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    private void lock() throws IOException {
        this.lockStream = new FileOutputStream(this.lockFile);
        this.lock = this.lockStream.getChannel().tryLock();
        if (this.lock == null) {
            throw new IllegalStateException("could not lock " + this.lockFile);
        }
    }

    private void initdb() {
        StopWatch watch = new StopWatch();
        watch.start();
        ArrayList<String> command = new ArrayList<String>();
        command.addAll(Arrays.asList(this.pgBin("initdb"), "-A", "trust", "-U", PG_SUPERUSER, "-D", this.dataDirectory.getPath(), "-E", "UTF-8"));
        command.addAll(this.createLocaleOptions());
        this.system(command.toArray(new String[command.size()]));
        LOG.info("{} initdb completed in {}", (Object)this.instanceId, (Object)watch);
    }

    private void startPostmaster(Map<String, String> connectConfig) throws IOException {
        StopWatch watch = new StopWatch();
        watch.start();
        if (this.started.getAndSet(true)) {
            throw new IllegalStateException("Postmaster already started");
        }
        ArrayList<String> args = new ArrayList<String>();
        args.addAll(Arrays.asList(this.pgBin("pg_ctl"), "-D", this.dataDirectory.getPath(), "-o", this.createInitOptions().stream().collect(Collectors.joining(" ")), "start"));
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectErrorStream(true);
        builder.redirectError(this.errorRedirector);
        builder.redirectOutput(this.outputRedirector);
        Process postmaster = builder.start();
        if (this.outputRedirector.type() == ProcessBuilder.Redirect.Type.PIPE) {
            ProcessOutputLogger.logOutput(LOG, postmaster);
        }
        LOG.info("{} postmaster started as {} on port {}.  Waiting up to {} for server startup to finish.", new Object[]{this.instanceId, postmaster.toString(), this.port, this.pgStartupWait});
        Runtime.getRuntime().addShutdownHook(this.newCloserThread());
        this.waitForServerStartup(watch, connectConfig);
    }

    private List<String> createInitOptions() {
        ArrayList<String> initOptions = new ArrayList<String>();
        initOptions.addAll(Arrays.asList("-p", Integer.toString(this.port), "-F"));
        for (Map.Entry<String, String> config : this.postgresConfig.entrySet()) {
            initOptions.add("-c");
            initOptions.add(config.getKey() + "=" + config.getValue());
        }
        return initOptions;
    }

    private List<String> createLocaleOptions() {
        ArrayList<String> localeOptions = new ArrayList<String>();
        for (Map.Entry<String, String> config : this.localeConfig.entrySet()) {
            if (SystemUtils.IS_OS_WINDOWS) {
                localeOptions.add(String.format("--%s=%s", config.getKey(), config.getValue()));
                continue;
            }
            localeOptions.add("--" + config.getKey());
            localeOptions.add(config.getValue());
        }
        return localeOptions;
    }

    private void waitForServerStartup(StopWatch watch, Map<String, String> connectConfig) throws IOException {
        SQLException lastCause = null;
        long start = System.nanoTime();
        long maxWaitNs = TimeUnit.NANOSECONDS.convert(this.pgStartupWait.toMillis(), TimeUnit.MILLISECONDS);
        while (System.nanoTime() - start < maxWaitNs) {
            try {
                this.verifyReady(connectConfig);
                LOG.info("{} postmaster startup finished in {}", (Object)this.instanceId, (Object)watch);
                return;
            }
            catch (SQLException e) {
                lastCause = e;
                LOG.trace("While waiting for server startup", (Throwable)e);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e2) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
        throw new IOException("Gave up waiting for server to start after " + this.pgStartupWait.toMillis() + "ms", lastCause);
    }

    @SuppressFBWarnings(value={"OBL_UNSATISFIED_OBLIGATION"})
    private void verifyReady(Map<String, String> connectConfig) throws SQLException {
        Throwable throwable;
        InetAddress localhost = InetAddress.getLoopbackAddress();
        try {
            throwable = null;
            try (Socket sock = new Socket();){
                sock.setSoTimeout((int)Duration.ofMillis(500L).toMillis());
                sock.connect(new InetSocketAddress(localhost, this.port), (int)Duration.ofMillis(500L).toMillis());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new SQLException("connect failed", e);
        }
        throwable = null;
        try (Connection c = this.getPostgresDatabase(connectConfig).getConnection();
             Statement s = c.createStatement();
             ResultSet rs = s.executeQuery("SELECT 1");){
            if (!rs.next()) {
                throw new IllegalStateException("expecting single row");
            }
            if (1 != rs.getInt(1)) {
                throw new IllegalStateException("expecting 1");
            }
            if (rs.next()) {
                throw new IllegalStateException("expecting single row");
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
    }

    private Thread newCloserThread() {
        Thread closeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    EmbeddedPostgres.this.close();
                }
                catch (IOException ex) {
                    LOG.error("Unexpected IOException from Closeables.close", (Throwable)ex);
                }
            }
        });
        closeThread.setName("postgres-" + this.instanceId + "-closer");
        return closeThread;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            this.pgCtl(this.dataDirectory, "stop");
            LOG.info("{} shut down postmaster in {}", (Object)this.instanceId, (Object)watch);
        }
        catch (Exception e) {
            LOG.error("Could not stop postmaster " + this.instanceId, (Throwable)e);
        }
        if (this.lock != null) {
            this.lock.release();
        }
        try {
            this.lockStream.close();
        }
        catch (IOException e) {
            LOG.error("while closing lockStream", (Throwable)e);
        }
        if (this.cleanDataDirectory && System.getProperty("ot.epg.no-cleanup") == null) {
            try {
                FileUtils.deleteDirectory((File)this.dataDirectory);
            }
            catch (IOException e) {
                LOG.error("Could not clean up directory {}", (Object)this.dataDirectory.getAbsolutePath());
            }
        } else {
            LOG.info("Did not clean up directory {}", (Object)this.dataDirectory.getAbsolutePath());
        }
    }

    private void pgCtl(File dir, String action) {
        this.system(this.pgBin("pg_ctl"), "-D", dir.getPath(), action, "-m", PG_STOP_MODE, "-t", PG_STOP_WAIT_S, "-w");
    }

    private void cleanOldDataDirectories(File parentDirectory) {
        File[] children = parentDirectory.listFiles();
        if (children == null) {
            return;
        }
        for (File dir : children) {
            boolean isTooNew;
            if (!dir.isDirectory()) continue;
            File lockFile = new File(dir, LOCK_FILE_NAME);
            boolean bl = isTooNew = System.currentTimeMillis() - lockFile.lastModified() < 600000L;
            if (!lockFile.exists() || isTooNew) continue;
            try (FileOutputStream fos = new FileOutputStream(lockFile);
                 FileLock lock = fos.getChannel().tryLock();){
                if (lock == null) continue;
                LOG.info("Found stale data directory {}", (Object)dir);
                if (new File(dir, "postmaster.pid").exists()) {
                    try {
                        this.pgCtl(dir, "stop");
                        LOG.info("Shut down orphaned postmaster!");
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Failed to stop postmaster " + dir, (Throwable)e);
                        }
                        LOG.warn("Failed to stop postmaster " + dir + ": " + e.getMessage());
                    }
                }
                FileUtils.deleteDirectory((File)dir);
            }
            catch (OverlappingFileLockException e) {
                LOG.trace("While cleaning old data directories", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("While cleaning old data directories", (Throwable)e);
            }
        }
    }

    private String pgBin(String binaryName) {
        String extension = SystemUtils.IS_OS_WINDOWS ? ".exe" : "";
        return new File(this.pgDir, "bin/" + binaryName + extension).getPath();
    }

    private static File getWorkingDirectory() {
        File tempWorkingDirectory = new File(System.getProperty("java.io.tmpdir"), "embedded-pg");
        return new File(System.getProperty("ot.epg.working-dir", tempWorkingDirectory.getPath()));
    }

    public static EmbeddedPostgres start() throws IOException {
        return EmbeddedPostgres.builder().start();
    }

    public static Builder builder() {
        return new Builder();
    }

    private void system(String ... command) {
        try {
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectErrorStream(true);
            builder.redirectError(this.errorRedirector);
            builder.redirectOutput(this.outputRedirector);
            Process process = builder.start();
            if (this.outputRedirector.type() == ProcessBuilder.Redirect.Type.PIPE) {
                ProcessOutputLogger.logOutput(LOG, process);
            }
            if (0 != process.waitFor()) {
                throw new IllegalStateException(String.format("Process %s failed%n%s", Arrays.asList(command), IOUtils.toString((InputStream)process.getErrorStream())));
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void mkdirs(File dir) {
        if (!(dir.mkdirs() || dir.isDirectory() && dir.exists())) {
            throw new IllegalStateException("could not create " + dir);
        }
    }

    private static String getOS() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "Windows";
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            return "Darwin";
        }
        if (SystemUtils.IS_OS_LINUX) {
            return "Linux";
        }
        throw new UnsupportedOperationException("Unknown OS " + SystemUtils.OS_NAME);
    }

    private static String getArchitecture() {
        return "amd64".equals(SystemUtils.OS_ARCH) ? "x86_64" : SystemUtils.OS_ARCH;
    }

    private static void extractTxz(String tbzPath, String targetDir) throws IOException {
        try (InputStream in = Files.newInputStream(Paths.get(tbzPath, new String[0]), new OpenOption[0]);
             XZInputStream xzIn = new XZInputStream(in);
             TarArchiveInputStream tarIn = new TarArchiveInputStream((InputStream)xzIn);){
            TarArchiveEntry entry;
            while ((entry = tarIn.getNextTarEntry()) != null) {
                String individualFile = entry.getName();
                File fsObject = new File(targetDir + "/" + individualFile);
                if (entry.isSymbolicLink() || entry.isLink()) {
                    Path target = FileSystems.getDefault().getPath(entry.getLinkName(), new String[0]);
                    Files.createSymbolicLink(fsObject.toPath(), target, new FileAttribute[0]);
                } else if (entry.isFile()) {
                    byte[] content = new byte[(int)entry.getSize()];
                    int read = tarIn.read(content, 0, content.length);
                    if (read == -1) {
                        throw new IllegalStateException("could not read " + individualFile);
                    }
                    EmbeddedPostgres.mkdirs(fsObject.getParentFile());
                    try (FileOutputStream outputFile = new FileOutputStream(fsObject);){
                        IOUtils.write((byte[])content, (OutputStream)outputFile);
                    }
                } else if (entry.isDirectory()) {
                    EmbeddedPostgres.mkdirs(fsObject);
                } else {
                    throw new UnsupportedOperationException(String.format("Unsupported entry found: %s", individualFile));
                }
                if (!individualFile.startsWith("bin/") && !individualFile.startsWith("./bin/")) continue;
                fsObject.setExecutable(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File prepareBinaries(PgBinaryResolver pgBinaryResolver) {
        PREPARE_BINARIES_LOCK.lock();
        try {
            File pgDir;
            block74: {
                InputStream pgBinary;
                File pgTbz;
                if (PREPARE_BINARIES.containsKey(pgBinaryResolver)) {
                    File file = PREPARE_BINARIES.get(pgBinaryResolver);
                    return file;
                }
                String system = EmbeddedPostgres.getOS();
                String machineHardware = EmbeddedPostgres.getArchitecture();
                LOG.info("Detected a {} {} system", (Object)system, (Object)machineHardware);
                try {
                    pgTbz = File.createTempFile("pgpg", "pgpg");
                    pgBinary = pgBinaryResolver.getPgBinary(system, machineHardware);
                }
                catch (IOException e) {
                    throw new ExceptionInInitializerError(e);
                }
                if (pgBinary == null) {
                    throw new IllegalStateException("No Postgres binary found for " + system + " / " + machineHardware);
                }
                try (DigestInputStream pgArchiveData = new DigestInputStream(pgBinary, MessageDigest.getInstance("MD5"));
                     FileOutputStream os = new FileOutputStream(pgTbz);){
                    IOUtils.copy((InputStream)pgArchiveData, (OutputStream)os);
                    pgArchiveData.close();
                    os.close();
                    String pgDigest = Hex.encodeHexString((byte[])pgArchiveData.getMessageDigest().digest());
                    pgDir = new File(EmbeddedPostgres.getWorkingDirectory(), String.format("PG-%s", pgDigest));
                    EmbeddedPostgres.mkdirs(pgDir);
                    File unpackLockFile = new File(pgDir, LOCK_FILE_NAME);
                    File pgDirExists = new File(pgDir, ".exists");
                    if (pgDirExists.exists()) break block74;
                    try (FileOutputStream lockStream = new FileOutputStream(unpackLockFile);
                         FileLock unpackLock = lockStream.getChannel().tryLock();){
                        if (unpackLock != null) {
                            try {
                                if (pgDirExists.exists()) {
                                    throw new IllegalStateException("unpack lock acquired but .exists file is present " + pgDirExists);
                                }
                                LOG.info("Extracting Postgres...");
                                EmbeddedPostgres.extractTxz(pgTbz.getPath(), pgDir.getPath());
                                if (!pgDirExists.createNewFile()) {
                                    throw new IllegalStateException("couldn't make .exists file " + pgDirExists);
                                }
                                break block74;
                            }
                            catch (Exception e) {
                                LOG.error("while unpacking Postgres", (Throwable)e);
                            }
                            break block74;
                        }
                        int maxAttempts = 60;
                        while (!pgDirExists.exists() && --maxAttempts > 0) {
                            Thread.sleep(1000L);
                        }
                        if (!pgDirExists.exists()) {
                            throw new IllegalStateException("Waited 60 seconds for postgres to be unpacked but it never finished!");
                        }
                    }
                    finally {
                        if (unpackLockFile.exists() && !unpackLockFile.delete()) {
                            LOG.error("could not remove lock file {}", (Object)unpackLockFile.getAbsolutePath());
                        }
                    }
                }
                catch (IOException | NoSuchAlgorithmException e) {
                    throw new ExceptionInInitializerError(e);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    throw new ExceptionInInitializerError(ie);
                }
                finally {
                    if (!pgTbz.delete()) {
                        LOG.warn("could not delete {}", (Object)pgTbz);
                    }
                }
            }
            PREPARE_BINARIES.put(pgBinaryResolver, pgDir);
            LOG.info("Postgres binaries at {}", (Object)pgDir);
            File file = pgDir;
            return file;
        }
        finally {
            PREPARE_BINARIES_LOCK.unlock();
        }
    }

    public String toString() {
        return "EmbeddedPG-" + this.instanceId;
    }

    static /* synthetic */ File access$100() {
        return EmbeddedPostgres.getWorkingDirectory();
    }

    static /* synthetic */ Duration access$200() {
        return DEFAULT_PG_STARTUP_WAIT;
    }

    public static class Builder {
        private final File parentDirectory = EmbeddedPostgres.access$100();
        private File builderDataDirectory;
        private final Map<String, String> config = new HashMap<String, String>();
        private final Map<String, String> localeConfig = new HashMap<String, String>();
        private boolean builderCleanDataDirectory = true;
        private int builderPort = 0;
        private final Map<String, String> connectConfig = new HashMap<String, String>();
        private PgBinaryResolver pgBinaryResolver = new BundledPostgresBinaryResolver();
        private Duration pgStartupWait = EmbeddedPostgres.access$200();
        private ProcessBuilder.Redirect errRedirector = ProcessBuilder.Redirect.PIPE;
        private ProcessBuilder.Redirect outRedirector = ProcessBuilder.Redirect.PIPE;

        Builder() {
            this.config.put("timezone", "UTC");
            this.config.put("synchronous_commit", "off");
            this.config.put("max_connections", "300");
        }

        public Builder setPGStartupWait(Duration pgStartupWait) {
            Objects.requireNonNull(pgStartupWait);
            if (pgStartupWait.isNegative()) {
                throw new IllegalArgumentException("Negative durations are not permitted.");
            }
            this.pgStartupWait = pgStartupWait;
            return this;
        }

        public Builder setCleanDataDirectory(boolean cleanDataDirectory) {
            this.builderCleanDataDirectory = cleanDataDirectory;
            return this;
        }

        public Builder setDataDirectory(Path path) {
            return this.setDataDirectory(path.toFile());
        }

        public Builder setDataDirectory(File directory) {
            this.builderDataDirectory = directory;
            return this;
        }

        public Builder setDataDirectory(String path) {
            return this.setDataDirectory(new File(path));
        }

        public Builder setServerConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        public Builder setLocaleConfig(String key, String value) {
            this.localeConfig.put(key, value);
            return this;
        }

        public Builder setConnectConfig(String key, String value) {
            this.connectConfig.put(key, value);
            return this;
        }

        public Builder setPort(int port) {
            this.builderPort = port;
            return this;
        }

        public Builder setErrorRedirector(ProcessBuilder.Redirect errRedirector) {
            this.errRedirector = errRedirector;
            return this;
        }

        public Builder setOutputRedirector(ProcessBuilder.Redirect outRedirector) {
            this.outRedirector = outRedirector;
            return this;
        }

        public Builder setPgBinaryResolver(PgBinaryResolver pgBinaryResolver) {
            this.pgBinaryResolver = pgBinaryResolver;
            return this;
        }

        public EmbeddedPostgres start() throws IOException {
            if (this.builderPort == 0) {
                this.builderPort = EmbeddedPostgres.detectPort();
            }
            if (this.builderDataDirectory == null) {
                this.builderDataDirectory = Files.createTempDirectory("epg", new FileAttribute[0]).toFile();
            }
            return new EmbeddedPostgres(this.parentDirectory, this.builderDataDirectory, this.builderCleanDataDirectory, this.config, this.localeConfig, this.builderPort, this.connectConfig, this.pgBinaryResolver, this.errRedirector, this.outRedirector, this.pgStartupWait);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Builder builder = (Builder)o;
            return this.builderCleanDataDirectory == builder.builderCleanDataDirectory && this.builderPort == builder.builderPort && Objects.equals(this.parentDirectory, builder.parentDirectory) && Objects.equals(this.builderDataDirectory, builder.builderDataDirectory) && Objects.equals(this.config, builder.config) && Objects.equals(this.localeConfig, builder.localeConfig) && Objects.equals(this.connectConfig, builder.connectConfig) && Objects.equals(this.pgBinaryResolver, builder.pgBinaryResolver) && Objects.equals(this.pgStartupWait, builder.pgStartupWait) && Objects.equals(this.errRedirector, builder.errRedirector) && Objects.equals(this.outRedirector, builder.outRedirector);
        }

        public int hashCode() {
            return Objects.hash(this.parentDirectory, this.builderDataDirectory, this.config, this.localeConfig, this.builderCleanDataDirectory, this.builderPort, this.connectConfig, this.pgBinaryResolver, this.pgStartupWait, this.errRedirector, this.outRedirector);
        }
    }
}

