/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.slf4j.Logger;

final class ProcessOutputLogger
implements Runnable {
    private final Logger logger;
    private final Process process;
    private final BufferedReader reader;

    private ProcessOutputLogger(Logger logger, Process process) {
        this.logger = logger;
        this.process = process;
        this.reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (this.process.isAlive()) {
                try {
                    Optional.ofNullable(this.reader.readLine()).ifPresent(arg_0 -> ((Logger)this.logger).info(arg_0));
                }
                catch (IOException e) {
                    this.logger.error("while reading output", (Throwable)e);
                    try {
                        this.reader.close();
                        return;
                    }
                    catch (IOException e2) {
                        this.logger.error("caught i/o exception closing reader", (Throwable)e2);
                    }
                    return;
                }
            }
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                this.logger.error("caught i/o exception closing reader", (Throwable)e);
            }
        }
    }

    static void logOutput(Logger logger, Process process) {
        Thread t = new Thread(new ProcessOutputLogger(logger, process));
        t.setName("log:" + ProcessOutputLogger.describe(process));
        t.setDaemon(true);
        t.start();
    }

    @SuppressFBWarnings(value={"REC_CATCH_EXCEPTION"})
    private static String describe(Process process) {
        try {
            return String.format("pid(%s)", MethodHandles.lookup().findVirtual(Process.class, "pid", MethodType.methodType(Long.TYPE)).invoke(process));
        }
        catch (Throwable throwable) {
            try {
                Field pid = process.getClass().getDeclaredField("pid");
                pid.setAccessible(true);
                return String.format("pid(%s)", pid.getInt(process));
            }
            catch (Exception exception) {
                return process.toString();
            }
        }
    }
}

