/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.postgresql.jdbc2.optional.SimpleDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbeddedPostgreSQL
implements Closeable {
    private static final Logger LOG;
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%s/%s?user=%s";
    private static final String PG_STOP_MODE = "fast";
    private static final String PG_STOP_WAIT_S = "5";
    private static final String PG_SUPERUSER = "postgres";
    private static final int PG_STARTUP_WAIT_MS = 10000;
    private static final String PG_DIGEST;
    private static final String TMP_DIR_LOC;
    private static final File TMP_DIR;
    private static final String LOCK_FILE_NAME = "epg-lock";
    private static final String UNAME_S;
    private static final String UNAME_M;
    private static final File PG_DIR;
    private final File dataDirectory;
    private final File lockFile;
    private final UUID instanceId = UUID.randomUUID();
    private final int port;
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Map<String, String> postgresConfig;
    private volatile Process postmaster;
    private volatile FileOutputStream lockStream;
    private volatile FileLock lock;
    private final boolean cleanDataDirectory;

    EmbeddedPostgreSQL(File parentDirectory, File dataDirectory, boolean cleanDataDirectory, Map<String, String> postgresConfig) throws IOException {
        this.cleanDataDirectory = cleanDataDirectory;
        this.postgresConfig = ImmutableMap.copyOf(postgresConfig);
        this.port = this.detectPort();
        if (parentDirectory != null) {
            EmbeddedPostgreSQL.mkdirs(parentDirectory);
            this.cleanOldDataDirectories(parentDirectory);
            this.dataDirectory = (File)Objects.firstNonNull((Object)dataDirectory, (Object)new File(parentDirectory, this.instanceId.toString()));
        } else {
            this.dataDirectory = dataDirectory;
        }
        Preconditions.checkArgument((this.dataDirectory != null ? 1 : 0) != 0, (Object)"null data directory");
        LOG.trace("{} postgres data directory is {}", (Object)this.instanceId, (Object)this.dataDirectory);
        Preconditions.checkState((this.dataDirectory.exists() || this.dataDirectory.mkdir() ? 1 : 0) != 0, (String)"Failed to mkdir %s", (Object[])new Object[]{this.dataDirectory});
        this.lockFile = new File(this.dataDirectory, LOCK_FILE_NAME);
        if (cleanDataDirectory || !new File(dataDirectory, "postgresql.conf").exists()) {
            this.initdb();
        }
        this.lock();
        this.startPostmaster();
    }

    public DataSource getTemplateDatabase() {
        return this.getDatabase(PG_SUPERUSER, "template1");
    }

    public DataSource getPostgresDatabase() {
        return this.getDatabase(PG_SUPERUSER, PG_SUPERUSER);
    }

    public DataSource getDatabase(String userName, String dbName) {
        SimpleDataSource ds = new SimpleDataSource();
        ds.setServerName("localhost");
        ds.setPortNumber(this.port);
        ds.setDatabaseName(dbName);
        ds.setUser(userName);
        return ds;
    }

    public String getJdbcUrl(String userName, String dbName) {
        return String.format(JDBC_FORMAT, this.port, dbName, userName);
    }

    public int getPort() {
        return this.port;
    }

    private int detectPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    private void lock() throws IOException {
        this.lockStream = new FileOutputStream(this.lockFile);
        this.lock = this.lockStream.getChannel().tryLock();
        Preconditions.checkState((this.lock != null ? 1 : 0) != 0, (String)"could not lock %s", (Object[])new Object[]{this.lockFile});
    }

    private void initdb() {
        StopWatch watch = new StopWatch();
        watch.start();
        EmbeddedPostgreSQL.system(EmbeddedPostgreSQL.pgBin("initdb"), "-A", "trust", "-U", PG_SUPERUSER, "-D", this.dataDirectory.getPath(), "-E", "UTF-8");
        LOG.info("{} initdb completed in {}", (Object)this.instanceId, (Object)watch);
    }

    private void startPostmaster() throws IOException {
        StopWatch watch = new StopWatch();
        watch.start();
        Preconditions.checkState((!this.started.getAndSet(true) ? 1 : 0) != 0, (Object)"Postmaster already started");
        ArrayList args = Lists.newArrayList((Object[])new String[]{EmbeddedPostgreSQL.pgBin(PG_SUPERUSER), "-D", this.dataDirectory.getPath(), "-p", Integer.toString(this.port), "-i", "-F"});
        for (Map.Entry<String, String> config : this.postgresConfig.entrySet()) {
            args.add("-c");
            args.add(config.getKey() + "=" + config.getValue());
        }
        ProcessBuilder builder = new ProcessBuilder(args);
        builder.redirectErrorStream(true);
        builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        this.postmaster = builder.start();
        LOG.info("{} postmaster started as {} on port {}.  Waiting up to {}ms for server startup to finish.", new Object[]{this.instanceId, this.postmaster.toString(), this.port, 10000});
        Runtime.getRuntime().addShutdownHook(this.newCloserThread());
        this.waitForServerStartup(watch);
    }

    private void waitForServerStartup(StopWatch watch) throws UnknownHostException, IOException {
        SQLException lastCause = null;
        long start = System.nanoTime();
        long maxWaitNs = TimeUnit.NANOSECONDS.convert(10000L, TimeUnit.MILLISECONDS);
        while (System.nanoTime() - start < maxWaitNs) {
            try {
                this.checkReady();
                LOG.info("{} postmaster startup finished in {}", (Object)this.instanceId, (Object)watch);
                return;
            }
            catch (SQLException e) {
                lastCause = e;
                LOG.trace("While waiting for server startup", (Throwable)e);
                try {
                    throw new IOException(String.format("%s postmaster exited with value %d, check standard out for more detail!", this.instanceId, this.postmaster.exitValue()));
                }
                catch (IllegalThreadStateException e2) {
                    LOG.trace("While waiting for server startup", (Throwable)e2);
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e3) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            }
        }
        throw new IOException("Gave up waiting for server to start after 10000ms", lastCause);
    }

    private void checkReady() throws SQLException {
        try (Connection c = this.getPostgresDatabase().getConnection();
             Statement s = c.createStatement();
             ResultSet rs = s.executeQuery("SELECT 1");){
            Preconditions.checkState((rs.next() ? 1 : 0) != 0, (Object)"expecting single row");
            Preconditions.checkState((1 == rs.getInt(1) ? 1 : 0) != 0, (Object)"expecting 1");
            Preconditions.checkState((!rs.next() ? 1 : 0) != 0, (Object)"expecting single row");
        }
    }

    private Thread newCloserThread() {
        Thread closeThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Closeables.close((Closeable)EmbeddedPostgreSQL.this, (boolean)true);
                }
                catch (IOException ex) {
                    LOG.error("Unexpected IOException from Closeables.close", (Throwable)ex);
                }
            }
        });
        closeThread.setName("postgres-" + this.instanceId + "-closer");
        return closeThread;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.getAndSet(true)) {
            return;
        }
        StopWatch watch = new StopWatch();
        watch.start();
        try {
            this.pgCtl(this.dataDirectory, "stop");
            LOG.info("{} shut down postmaster in {}", (Object)this.instanceId, (Object)watch);
        }
        catch (Exception e) {
            LOG.error("Could not stop postmaster " + this.instanceId, (Throwable)e);
        }
        if (this.lock != null) {
            this.lock.release();
        }
        Closeables.close((Closeable)this.lockStream, (boolean)true);
        if (this.cleanDataDirectory && System.getProperty("ot.epg.no-cleanup") == null) {
            try {
                FileUtils.deleteDirectory((File)this.dataDirectory);
            }
            catch (IOException e) {
                LOG.error("Could not clean up directory {}", (Object)this.dataDirectory.getAbsolutePath());
            }
        } else {
            LOG.info("Did not clean up directory {}", (Object)this.dataDirectory.getAbsolutePath());
        }
    }

    private void pgCtl(File dir, String action) {
        EmbeddedPostgreSQL.system(EmbeddedPostgreSQL.pgBin("pg_ctl"), "-D", dir.getPath(), action, "-m", PG_STOP_MODE, "-t", PG_STOP_WAIT_S, "-w");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanOldDataDirectories(File parentDirectory) {
        for (File dir : parentDirectory.listFiles()) {
            boolean isTooNew;
            if (!dir.isDirectory()) continue;
            File lockFile = new File(dir, LOCK_FILE_NAME);
            boolean bl = isTooNew = System.currentTimeMillis() - lockFile.lastModified() < 600000L;
            if (!lockFile.exists() || isTooNew) continue;
            try (FileOutputStream fos = new FileOutputStream(lockFile);
                 FileLock lock = fos.getChannel().tryLock();){
                if (lock == null) continue;
                LOG.info("Found stale data directory {}", (Object)dir);
                if (new File(dir, "postmaster.pid").exists()) {
                    try {
                        this.pgCtl(dir, "stop");
                        LOG.info("Shut down orphaned postmaster!");
                    }
                    catch (Exception e) {
                        if (LOG.isDebugEnabled()) {
                            LOG.warn("Failed to stop postmaster " + dir, (Throwable)e);
                        }
                        LOG.warn("Failed to stop postmaster " + dir + ": " + e.getMessage());
                    }
                }
                FileUtils.deleteDirectory((File)dir);
            }
            catch (OverlappingFileLockException e) {
                LOG.trace("While cleaning old data directories", (Throwable)e);
            }
            catch (Exception e) {
                LOG.warn("While cleaning old data directories", (Throwable)e);
            }
        }
    }

    private static String pgBin(String binaryName) {
        return new File(PG_DIR, "bin/" + binaryName).getPath();
    }

    public static EmbeddedPostgreSQL start() throws IOException {
        return EmbeddedPostgreSQL.builder().start();
    }

    public static Builder builder() {
        return new Builder();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<String> system(String ... command) {
        try {
            Process process = new ProcessBuilder(command).start();
            Preconditions.checkState((0 == process.waitFor() ? 1 : 0) != 0, (String)"Process %s failed\n%s", (Object[])new Object[]{Arrays.asList(command), IOUtils.toString((InputStream)process.getErrorStream())});
            try (InputStream stream = process.getInputStream();){
                List list = IOUtils.readLines((InputStream)stream);
                return list;
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void mkdirs(File dir) {
        Preconditions.checkState((dir.mkdirs() || dir.isDirectory() && dir.exists() ? 1 : 0) != 0, (String)"could not create %s", (Object[])new Object[]{dir});
    }

    public String toString() {
        return "EmbeddedPG-" + this.instanceId;
    }

    static /* synthetic */ File access$100() {
        return TMP_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static {
        File pgTbz;
        block35: {
            LOG = LoggerFactory.getLogger(EmbeddedPostgreSQL.class);
            TMP_DIR_LOC = System.getProperty("java.io.tmpdir");
            TMP_DIR = new File(TMP_DIR_LOC, "embedded-pg");
            UNAME_S = EmbeddedPostgreSQL.system("uname", "-s").get(0);
            UNAME_M = EmbeddedPostgreSQL.system("uname", "-m").get(0);
            LOG.info("Detected a {} {} system", (Object)UNAME_S, (Object)UNAME_M);
            try {
                pgTbz = File.createTempFile("pgpg", "pgpg");
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError(e);
            }
            try {
                DigestInputStream pgArchiveData = new DigestInputStream(EmbeddedPostgreSQL.class.getResourceAsStream(String.format("/postgresql-%s-%s.tbz", UNAME_S, UNAME_M)), MessageDigest.getInstance("MD5"));
                FileOutputStream os = new FileOutputStream(pgTbz);
                IOUtils.copy((InputStream)pgArchiveData, (OutputStream)os);
                pgArchiveData.close();
                os.close();
                PG_DIGEST = Hex.encodeHexString((byte[])pgArchiveData.getMessageDigest().digest());
                PG_DIR = new File(TMP_DIR, String.format("PG-%s", PG_DIGEST));
                EmbeddedPostgreSQL.mkdirs(PG_DIR);
                File unpackLockFile = new File(PG_DIR, LOCK_FILE_NAME);
                File pgDirExists = new File(PG_DIR, ".exists");
                if (pgDirExists.exists()) break block35;
                try (FileOutputStream lockStream = new FileOutputStream(unpackLockFile);
                     FileLock unpackLock = lockStream.getChannel().tryLock();){
                    if (unpackLock != null) {
                        try {
                            Preconditions.checkState((!pgDirExists.exists() ? 1 : 0) != 0, (Object)"unpack lock acquired but .exists file is present.");
                            LOG.info("Extracting Postgres...");
                            EmbeddedPostgreSQL.system("tar", "-x", "-f", pgTbz.getPath(), "-C", PG_DIR.getPath());
                            Files.touch((File)pgDirExists);
                        }
                        catch (Throwable throwable) {
                            Preconditions.checkState((boolean)unpackLockFile.delete(), (String)"could not remove lock file %s", (Object[])new Object[]{unpackLockFile.getAbsolutePath()});
                            throw throwable;
                        }
                        Preconditions.checkState((boolean)unpackLockFile.delete(), (String)"could not remove lock file %s", (Object[])new Object[]{unpackLockFile.getAbsolutePath()});
                        break block35;
                    }
                    int maxAttempts = 60;
                    while (!pgDirExists.exists() && --maxAttempts > 0) {
                        Thread.sleep(1000L);
                    }
                    Preconditions.checkState((boolean)pgDirExists.exists(), (Object)"Waited 60 seconds for postgres to be unpacked but it never finished!");
                }
            }
            catch (IOException | NoSuchAlgorithmException e) {
                try {
                    throw new ExceptionInInitializerError(e);
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        throw new ExceptionInInitializerError(ie);
                    }
                }
                catch (Throwable throwable) {
                    Preconditions.checkState((boolean)pgTbz.delete(), (String)"could not delete %s", (Object[])new Object[]{pgTbz});
                    throw throwable;
                }
            }
        }
        Preconditions.checkState((boolean)pgTbz.delete(), (String)"could not delete %s", (Object[])new Object[]{pgTbz});
        LOG.info("Postgres binaries at {}", (Object)PG_DIR);
    }

    public static class Builder {
        private final File parentDirectory = new File(System.getProperty("ness.embedded-pg.dir", EmbeddedPostgreSQL.access$100().getPath()));
        private File dataDirectory;
        private final Map<String, String> config = Maps.newHashMap();
        private boolean cleanDataDirectory = true;

        Builder() {
            this.config.put("timezone", "UTC");
            this.config.put("synchronous_commit", "off");
            this.config.put("checkpoint_segments", "64");
            this.config.put("max_connections", "300");
        }

        public Builder setCleanDataDirectory(boolean cleanDataDirectory) {
            this.cleanDataDirectory = cleanDataDirectory;
            return this;
        }

        public Builder setDataDirectory(File directory) {
            this.dataDirectory = directory;
            return this;
        }

        public Builder setServerConfig(String key, String value) {
            this.config.put(key, value);
            return this;
        }

        public EmbeddedPostgreSQL start() throws IOException {
            return new EmbeddedPostgreSQL(this.parentDirectory, this.dataDirectory, this.cleanDataDirectory, this.config);
        }
    }
}

