/*
 * Decompiled with CFR 0.152.
 */
package com.opentable.db.postgres.embedded;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.nesscomputing.migratory.Migratory;
import com.nesscomputing.migratory.MigratoryConfig;
import com.nesscomputing.migratory.MigratoryContext;
import com.nesscomputing.migratory.MigratoryOption;
import com.nesscomputing.migratory.locator.AbstractSqlResourceLocator;
import com.nesscomputing.migratory.locator.MigrationLocator;
import com.nesscomputing.migratory.migration.MigrationPlan;
import com.opentable.config.Config;
import com.opentable.db.postgres.embedded.EmbeddedPostgreSQL;
import java.io.IOException;
import java.net.URI;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.SynchronousQueue;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import org.apache.commons.configuration.AbstractConfiguration;
import org.apache.commons.configuration.MapConfiguration;
import org.apache.commons.lang3.RandomStringUtils;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class EmbeddedPostgreSQLController {
    private static final String JDBC_FORMAT = "jdbc:postgresql://localhost:%d/%s";
    @GuardedBy(value="EmbeddedPostgreSQLController.class")
    private static final Map<Map.Entry<URI, Set<String>>, Cluster> CLUSTERS = Maps.newHashMap();
    private final Cluster cluster;

    public EmbeddedPostgreSQLController(URI baseUrl, String[] personalities) {
        try {
            this.cluster = EmbeddedPostgreSQLController.getCluster(baseUrl, personalities);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static synchronized Cluster getCluster(URI baseUrl, String[] personalities) throws IOException {
        Map.Entry key = Maps.immutableEntry((Object)baseUrl, (Object)ImmutableSet.copyOf((Object[])personalities));
        Cluster result = CLUSTERS.get(key);
        if (result != null) {
            return result;
        }
        result = new Cluster(EmbeddedPostgreSQL.start());
        DBI dbi = new DBI(result.getPg().getTemplateDatabase());
        Migratory migratory = new Migratory(new MigratoryConfig(){}, (IDBI)dbi, (IDBI)dbi);
        migratory.addLocator((MigrationLocator)new DatabasePreparerLocator((MigratoryContext)migratory, baseUrl));
        MigrationPlan plan = new MigrationPlan(new String[0]);
        int priority = 100;
        for (String personality : personalities) {
            plan.addMigration(personality, Integer.MAX_VALUE, priority--);
        }
        migratory.dbMigrate(plan, new MigratoryOption[0]);
        result.start();
        CLUSTERS.put(key, result);
        return result;
    }

    public Config getTweakedConfig(Config config, String dbModuleName) {
        return Config.getOverriddenConfig((Config)config, (AbstractConfiguration[])new AbstractConfiguration[]{new MapConfiguration(this.getConfigurationTweak(dbModuleName))});
    }

    public Config getTweakedConfig(String dbModuleName) {
        return this.getTweakedConfig(Config.getEmptyConfig(), dbModuleName);
    }

    public String getJdbcUri() {
        DbInfo db = this.cluster.getNextDb();
        return this.getJdbcUri(db);
    }

    private String getJdbcUri(DbInfo db) {
        return String.format(JDBC_FORMAT, db.port, db.dbName);
    }

    public ImmutableMap<String, String> getConfigurationTweak(String dbModuleName) {
        DbInfo db = this.cluster.getNextDb();
        return ImmutableMap.of((Object)("ot.db." + dbModuleName + ".uri"), (Object)this.getJdbcUri(db), (Object)("ot.db." + dbModuleName + ".ds.user"), (Object)db.user);
    }

    private static void create(DBI dbi, final @Nonnull String dbName, final @Nonnull String userName) {
        Preconditions.checkArgument((dbName != null ? 1 : 0) != 0, (Object)"the database name must not be null!");
        Preconditions.checkArgument((userName != null ? 1 : 0) != 0, (Object)"the user name must not be null!");
        dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) {
                handle.createStatement(String.format("CREATE DATABASE %s OWNER %s ENCODING = 'utf8'", dbName, userName)).execute();
                return null;
            }
        });
    }

    private static class DbInfo {
        private final String dbName;
        private final int port;
        private final String user;

        DbInfo(String dbName, int port, String user) {
            this.dbName = dbName;
            this.port = port;
            this.user = user;
        }
    }

    private static class Cluster
    implements Runnable {
        private final EmbeddedPostgreSQL pg;
        private final DBI pgDb;
        private final SynchronousQueue<DbInfo> nextDatabase = new SynchronousQueue();

        Cluster(EmbeddedPostgreSQL pg) {
            this.pg = pg;
            this.pgDb = new DBI(pg.getPostgresDatabase());
        }

        void start() {
            ExecutorService service = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("cluster-" + this.pg + "-preparer").build());
            service.submit(this);
            service.shutdown();
        }

        DbInfo getNextDb() {
            try {
                return this.nextDatabase.take();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IllegalStateException(e);
            }
        }

        EmbeddedPostgreSQL getPg() {
            return this.pg;
        }

        @Override
        public void run() {
            while (true) {
                String newDbName = RandomStringUtils.randomAlphabetic((int)12).toLowerCase(Locale.ENGLISH);
                EmbeddedPostgreSQLController.create(this.pgDb, newDbName, "postgres");
                try {
                    this.nextDatabase.put(new DbInfo(newDbName, this.pg.getPort(), "postgres"));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    return;
                }
            }
        }
    }

    private static class DatabasePreparerLocator
    extends AbstractSqlResourceLocator {
        private final URI baseUri;

        protected DatabasePreparerLocator(MigratoryContext migratoryContext, URI baseUri) {
            super(migratoryContext);
            this.baseUri = baseUri;
        }

        protected Map.Entry<URI, String> getBaseInformation(String personalityName, String databaseType) {
            return Maps.immutableEntry((Object)URI.create(this.baseUri.toString() + "/" + personalityName), (Object)".*\\.sql");
        }
    }
}

