/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import com.opentok.otc.otc_audio_device_settings;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

public abstract class BaseAudioDevice {
    private OutputMode outputMode = OutputMode.SpeakerPhone;
    private AudioBus audioBus;

    public abstract boolean initCapturer();

    public abstract boolean startCapturer();

    public abstract boolean stopCapturer();

    public abstract boolean destroyCapturer();

    public abstract boolean initRenderer();

    public abstract boolean startRenderer();

    public abstract boolean stopRenderer();

    public abstract boolean destroyRenderer();

    public abstract int getEstimatedCaptureDelay();

    public abstract int getEstimatedRenderDelay();

    public abstract AudioSettings getCaptureSettings();

    public abstract AudioSettings getRenderSettings();

    public abstract void onPause();

    public abstract void onResume();

    protected void finalize() {
        super.finalize();
    }

    public boolean setOutputMode(OutputMode outputMode) {
        this.outputMode = outputMode;
        return true;
    }

    public OutputMode getOutputMode() {
        return this.outputMode;
    }

    void setAudioBus(AudioBus audioBus) {
        this.audioBus = audioBus;
    }

    public AudioBus getAudioBus() {
        return this.audioBus;
    }

    public BluetoothState getBluetoothState() {
        throw new UnsupportedOperationException("Audio Device implementation does not support getting bluetooth state");
    }

    boolean getCaptureSettingsFromNative(long l2) {
        AudioSettings audioSettings = ((BaseAudioDevice)((Object)audioSettings)).getCaptureSettings();
        new otc_audio_settings(l2).updateWithSettings(audioSettings);
        return true;
    }

    boolean getRenderSettingsFromNative(long l2) {
        AudioSettings audioSettings = ((BaseAudioDevice)((Object)audioSettings)).getRenderSettings();
        new otc_audio_settings(l2).updateWithSettings(audioSettings);
        return true;
    }

    static class otc_audio_settings
    extends otc_audio_device_settings {
        otc_audio_settings(long l2) {
            super(l2, false);
        }

        void updateWithSettings(AudioSettings audioSettings) {
            this.setNumber_of_channels(audioSettings.getNumChannels());
            this.setSampling_rate(audioSettings.getSampleRate());
        }
    }

    public static class AudioBus {
        private BaseAudioDevice device;

        AudioBus(BaseAudioDevice baseAudioDevice) {
            this.device = baseAudioDevice;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void writeFromBuffer(Buffer buffer, int n) {
            if (!buffer.isDirect()) throw new RuntimeException("ByteBuffer should be allocated using allocateDirect method");
            try {
                this.writeDataNative(buffer, n);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        private int readToBuffer(Buffer buffer, int n) {
            if (buffer.isDirect()) {
                try {
                    return this.readDataNative(buffer, n);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return 0;
                }
            }
            throw new RuntimeException("ByteBuffer should be allocated using allocateDirect method");
        }

        private static byte[] adjustArray(byte[] byArray, int n) {
            if (byArray == null || byArray.length != n) {
                byArray = new byte[n];
            }
            return byArray;
        }

        private static native void buffer2ArrayNative(Buffer var0, byte[] var1);

        private static native void array2BufferNative(Buffer var0, byte[] var1);

        private native int readDataNative(Buffer var1, int var2);

        private native void writeDataNative(Buffer var1, int var2);

        public void writeCaptureData(ByteBuffer byteBuffer, int n) {
            this.writeFromBuffer(byteBuffer, n);
        }

        public void writeCaptureData(ShortBuffer shortBuffer, int n) {
            this.writeFromBuffer(shortBuffer, n);
        }

        public int readRenderData(ByteBuffer byteBuffer, int n) {
            return this.readToBuffer(byteBuffer, n);
        }

        public int readRenderData(ShortBuffer shortBuffer, int n) {
            return this.readToBuffer(shortBuffer, n);
        }
    }

    public static class AudioSettings {
        int sampleRate;
        int numChannels;

        public AudioSettings(int n, int n2) {
            this.sampleRate = n;
            this.numChannels = n2;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public int getNumChannels() {
            return this.numChannels;
        }

        public void setSampleRate(int n) {
            this.sampleRate = n;
        }

        public void setNumChannels(int n) {
            this.numChannels = n;
        }
    }

    public static final class BluetoothState
    extends Enum<BluetoothState> {
        public static final /* enum */ BluetoothState Connected;
        public static final /* enum */ BluetoothState Disconnected;
        private static final /* synthetic */ BluetoothState[] $VALUES;

        public static BluetoothState[] values() {
            return (BluetoothState[])$VALUES.clone();
        }

        public static BluetoothState valueOf(String string) {
            return Enum.valueOf(BluetoothState.class, string);
        }

        static {
            BluetoothState bluetoothState;
            Connected = new BluetoothState();
            BluetoothState bluetoothState2 = bluetoothState;
            Disconnected = new BluetoothState();
            $VALUES = new BluetoothState[]{Connected, bluetoothState2};
        }
    }

    public static final class OutputMode
    extends Enum<OutputMode> {
        public static final /* enum */ OutputMode SpeakerPhone;
        public static final /* enum */ OutputMode Handset;
        private static final /* synthetic */ OutputMode[] $VALUES;

        public static OutputMode[] values() {
            return (OutputMode[])$VALUES.clone();
        }

        public static OutputMode valueOf(String string) {
            return Enum.valueOf(OutputMode.class, string);
        }

        static {
            OutputMode outputMode;
            SpeakerPhone = new OutputMode();
            OutputMode outputMode2 = outputMode;
            Handset = new OutputMode();
            $VALUES = new OutputMode[]{SpeakerPhone, outputMode2};
        }
    }
}

