/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Build;
import android.os.Handler;
import com.opentok.android.BaseAudioDevice;
import com.opentok.android.DefaultAudioDevice;
import com.opentok.android.OtLog;

class BluetoothManager {
    public static final int MAX_SCO_CONNECTION_ATTEMPTS = 6;
    public static final int SCO_CONNECTION_ATTEMPT_DELAY = 25;
    private final OtLog.LogToken log;
    private State bluetoothConnectionState;
    private boolean isBluetoothBroadcastReceiverRegistered;
    private int scoConnectionAttempts;
    private BluetoothAdapter bluetoothAdapter;
    private BluetoothProfile bluetoothProfile;
    private AudioManager audioManager;
    private Context audioDeviceContext;
    private BaseAudioDevice.BluetoothState bluetoothState;
    private DefaultAudioDevice audioDevice;
    private BluetoothDevice bluetoothDevice;
    private final BluetoothProfile.ServiceListener bluetoothProfileServiceListener;
    private final BroadcastReceiver bluetoothBroadcastReceiver;

    static BluetoothManager create(Context context, DefaultAudioDevice defaultAudioDevice) {
        return new BluetoothManager(context, defaultAudioDevice);
    }

    protected BluetoothManager(Context context, DefaultAudioDevice defaultAudioDevice) {
        AudioManager audioManager;
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log = new OtLog.LogToken(this);
        bluetoothManager.scoConnectionAttempts = 0;
        bluetoothManager.bluetoothProfileServiceListener = new BluetoothProfile.ServiceListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void onServiceConnected(int var1_1, BluetoothProfile var2_3) {
                v0 = this;
                var3_4 = v0.BluetoothManager.this;
                synchronized (var3_4) {
                    block15: {
                        if (BluetoothManager.access$000(v0.BluetoothManager.this)) ** GOTO lbl10
                        return;
lbl10:
                        // 1 sources

                        v2 = BluetoothManager.access$100(BluetoothManager.this);
                        v2.d("BluetoothProfile.ServiceListener.onServiceConnected() enter.", new Object[0]);
                        if (1 != var1_1) ** GOTO lbl43
                        v3 = var2_3;
                        BluetoothManager.access$202(BluetoothManager.this, var2_3);
                        var1_2 = v3.getConnectedDevices();
                        if (var1_2.isEmpty()) ** GOTO lbl39
                        if (2 != var2_3.getConnectionState((BluetoothDevice)var1_2.get(0))) ** GOTO lbl39
                        v4 = this;
                        v5 = v4;
                        v6 = v4;
                        BluetoothManager.access$302(v4.BluetoothManager.this, (BluetoothDevice)var1_2.get(0));
                        BluetoothManager.access$100(v6.BluetoothManager.this).d("Connected to bluetooth headset " + BluetoothManager.access$300(BluetoothManager.this).getName(), new Object[0]);
                        var1_2 = v7;
                        new Intent("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED").putExtra("android.bluetooth.profile.extra.STATE", 2);
                        BluetoothManager.access$500(v5.BluetoothManager.this).onReceive(BluetoothManager.access$400(BluetoothManager.this), (Intent)var1_2);
                        ** GOTO lbl44
lbl39:
                        // 2 sources

                        v8 = BluetoothManager.access$100(BluetoothManager.this);
                        v8.d("No bluetooth headset connected.", new Object[0]);
                        break block15;
lbl43:
                        // 1 sources

                        BluetoothManager.access$100(BluetoothManager.this).d("profile = " + var1_1, new Object[0]);
                    }
                    v9 = var3_4;
                    v10 = BluetoothManager.access$100(BluetoothManager.this);
                    v10.d("BluetoothProfile.ServiceListener.onServiceConnected() exit.", new Object[0]);
                    // ** MonitorExit[v9] (shouldn't be in output)
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onServiceDisconnected(int n) {
                1 v0 = this;
                BluetoothManager bluetoothManager = v0.BluetoothManager.this;
                synchronized (bluetoothManager) {
                    v0.BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceDisconnected() enter.", new Object[0]);
                    if (n != 1) {
                        return;
                    }
                    BluetoothManager bluetoothManager2 = bluetoothManager;
                    1 v2 = this;
                    1 v3 = v2;
                    1 v4 = v2;
                    BluetoothManager.access$302(v2.BluetoothManager.this, null);
                    {
                        BluetoothManager.access$202(v4.BluetoothManager.this, null);
                    }
                    {
                        v3.BluetoothManager.this.log.d("BluetoothProfile.ServiceListener.onServiceDisconnected() exit.", new Object[0]);
                        // ** MonitorExit[v1] (shouldn't be in output)
                        return;
                    }
                }
            }
        };
        bluetoothManager.bluetoothBroadcastReceiver = new BroadcastReceiver(){

            /*
             * Exception decompiling
             */
            public void onReceive(Context var1_1, Intent var2_2) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 23[SWITCH]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        bluetoothManager.log.d("BluetoothManager constructor enter.", new Object[0]);
        this.audioManager = audioManager = (AudioManager)context.getSystemService("audio");
        if (!audioManager.isBluetoothScoAvailableOffCall()) {
            this.log.e("Bluetooth SCO audio is not available off call", new Object[0]);
            return;
        }
        BluetoothManager bluetoothManager2 = this;
        bluetoothManager2.audioDeviceContext = context;
        bluetoothManager2.audioDevice = defaultAudioDevice;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            this.log.w("Device does not support Bluetooth", new Object[0]);
            return;
        }
        BluetoothManager bluetoothManager3 = this;
        bluetoothManager3.setBluetoothState(State.SCO_DISCONNECTED);
        bluetoothManager3.registerBtReceiver();
        bluetoothManager3.audioManager.setBluetoothScoOn(true);
        bluetoothManager3.audioManagerStartBluetoothSCO();
        bluetoothManager3.log.d("BluetoothManager constructor exit.", new Object[0]);
    }

    private synchronized void setConnectionAttempts(int n) {
        this.scoConnectionAttempts = n;
        this.log.d("setConnectionAttempts(). scoConnectionAttempts set to " + n, new Object[0]);
    }

    private synchronized void tryStartBluetoothSCO() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("tryStartBluetoothSCO() enter <-", new Object[0]);
        State state = bluetoothManager.bluetoothConnectionState;
        if (state != State.SCO_CONNECTED && state != (state = State.SCO_CONNECT_ATTEMPT)) {
            double d2;
            Handler handler;
            BluetoothManager bluetoothManager2 = this;
            bluetoothManager2.setBluetoothState(state);
            state = handler;
            handler = new Handler();
            Runnable runnable = () -> {
                if (this.bluetoothConnectionState == State.SCO_CONNECTED) {
                    this.setConnectionAttempts(0);
                    return;
                }
                try {
                    BluetoothManager bluetoothManager = this;
                    bluetoothManager.audioManagerStopBluetoothSCO();
                    bluetoothManager.audioManagerStartBluetoothSCO();
                }
                catch (NullPointerException nullPointerException) {
                    this.log.e("tryStartBluetoothSco(): " + nullPointerException.getMessage(), new Object[0]);
                }
            };
            int n = bluetoothManager2.scoConnectionAttempts;
            if (n == 0) {
                d2 = 0.0;
            } else {
                double d3 = n;
                d2 = Math.pow(2.0, d3) * 25.0;
            }
            long l2 = (long)d2;
            BluetoothManager bluetoothManager3 = this;
            state.postDelayed(runnable, l2);
            bluetoothManager3.setConnectionAttempts(bluetoothManager3.scoConnectionAttempts + 1);
            bluetoothManager3.log.d("tryStartBluetoothSCO() exit ->", new Object[0]);
            return;
        }
    }

    private void audioManagerStartBluetoothSCO() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("audioManagerStartBluetoothSCO() enter <-", new Object[0]);
        bluetoothManager.audioManager.startBluetoothSco();
        bluetoothManager.log.d("audioManagerStartBluetoothSCO() exit <-", new Object[0]);
    }

    private boolean hasBluetoothPermission() {
        if (Build.VERSION.SDK_INT >= 31 && this.audioDeviceContext.checkSelfPermission("android.permission.BLUETOOTH_CONNECT") != 0) {
            this.log.e("Audio may not route through paired Bluetooth device unless the bluetooth permission has been granted explicitly in the App settings.", new Object[0]);
            return false;
        }
        return true;
    }

    static /* synthetic */ boolean access$000(BluetoothManager bluetoothManager) {
        return bluetoothManager.hasBluetoothPermission();
    }

    static /* synthetic */ BluetoothProfile access$202(BluetoothManager bluetoothManager, BluetoothProfile bluetoothProfile) {
        bluetoothManager.bluetoothProfile = bluetoothProfile;
        return bluetoothProfile;
    }

    static /* synthetic */ BluetoothDevice access$302(BluetoothManager bluetoothManager, BluetoothDevice bluetoothDevice) {
        bluetoothManager.bluetoothDevice = bluetoothDevice;
        return bluetoothDevice;
    }

    static /* synthetic */ BluetoothDevice access$300(BluetoothManager bluetoothManager) {
        return bluetoothManager.bluetoothDevice;
    }

    static /* synthetic */ Context access$400(BluetoothManager bluetoothManager) {
        return bluetoothManager.audioDeviceContext;
    }

    static /* synthetic */ BroadcastReceiver access$500(BluetoothManager bluetoothManager) {
        return bluetoothManager.bluetoothBroadcastReceiver;
    }

    static /* synthetic */ int access$600(BluetoothManager bluetoothManager) {
        return bluetoothManager.scoConnectionAttempts;
    }

    static /* synthetic */ void access$700(BluetoothManager bluetoothManager, int n) {
        bluetoothManager.setConnectionAttempts(n);
    }

    static /* synthetic */ DefaultAudioDevice access$800(BluetoothManager bluetoothManager) {
        return bluetoothManager.audioDevice;
    }

    static /* synthetic */ void access$900(BluetoothManager bluetoothManager) {
        bluetoothManager.tryStartBluetoothSCO();
    }

    protected void finalize() {
        BluetoothManager bluetoothManager = this;
        super.finalize();
        bluetoothManager.audioManager.setBluetoothScoOn(false);
        BluetoothProfile bluetoothProfile = bluetoothManager.bluetoothProfile;
        if (bluetoothProfile != null && (this = this.bluetoothAdapter) != null) {
            this.closeProfileProxy(1, bluetoothProfile);
        }
    }

    void onPause() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("onPause() enter.", new Object[0]);
        bluetoothManager.log.d("onPause() exit.", new Object[0]);
    }

    void onResume() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("onResume() enter.", new Object[0]);
        bluetoothManager.forceInvokeConnectBluetooth();
        bluetoothManager.log.d("onResume() exit.", new Object[0]);
    }

    void registerBtReceiver() {
        IntentFilter intentFilter;
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("isBluetoothBroadcastReceiverRegistered = " + this.isBluetoothBroadcastReceiverRegistered, new Object[0]);
        if (bluetoothManager.isBluetoothBroadcastReceiverRegistered) {
            return;
        }
        BluetoothManager bluetoothManager2 = this;
        bluetoothManager2.log.d("registerBtReceiver() enter.", new Object[0]);
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter().addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter2.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        bluetoothManager2.audioDeviceContext.registerReceiver(this.bluetoothBroadcastReceiver, intentFilter2);
        bluetoothManager2.isBluetoothBroadcastReceiverRegistered = true;
        bluetoothManager2.log.d("registerBtReceiver() exit", new Object[0]);
    }

    public synchronized void unregisterBtReceiver() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("isBluetoothBroadcastReceiverRegistered = " + this.isBluetoothBroadcastReceiverRegistered, new Object[0]);
        if (!bluetoothManager.isBluetoothBroadcastReceiverRegistered) {
            return;
        }
        BluetoothManager bluetoothManager2 = this;
        bluetoothManager2.log.d("unregisterBtReceiver() enter", new Object[0]);
        bluetoothManager2.audioDeviceContext.unregisterReceiver(this.bluetoothBroadcastReceiver);
        bluetoothManager2.isBluetoothBroadcastReceiverRegistered = false;
        bluetoothManager2.log.d("unregisterBtReceiver() exit", new Object[0]);
    }

    synchronized void startBluetoothSCO() {
        if (this.audioDevice.isWiredHeadSetConnected()) {
            this.log.e("Bluetooth cannot be turned on when wired headset is connected.", new Object[0]);
            return;
        }
        BluetoothManager bluetoothManager = this;
        bluetoothManager.setConnectionAttempts(0);
        bluetoothManager.tryStartBluetoothSCO();
    }

    synchronized void stopBluetoothSCO() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("stopBluetoothSCO() enter <-", new Object[0]);
        bluetoothManager.setConnectionAttempts(-1);
        if (bluetoothManager.bluetoothConnectionState == State.SCO_CONNECT_ATTEMPT) {
            return;
        }
        try {
            this.audioManagerStopBluetoothSCO();
        }
        catch (NullPointerException nullPointerException) {
            this.log.e("stopBluetoothSco(): " + nullPointerException.getMessage(), new Object[0]);
        }
        this.log.d("stopBluetoothSCO() exit ->", new Object[0]);
    }

    synchronized void audioManagerStopBluetoothSCO() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("audioManagerStopBluetoothSCO() enter <-", new Object[0]);
        bluetoothManager.audioManager.stopBluetoothSco();
        bluetoothManager.log.d("audioManagerStopBluetoothSCO() exit ->", new Object[0]);
    }

    public synchronized boolean isBluetoothConnected() {
        boolean bl = this.bluetoothDevice != null;
        this.log.d("isBluetoothConnected = " + bl, new Object[0]);
        return bl;
    }

    synchronized BaseAudioDevice.BluetoothState getBluetoothState() {
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("getBluetoothState(). Current bluetoothState = " + (Object)((Object)this.bluetoothConnectionState), new Object[0]);
        return bluetoothManager.bluetoothConnectionState == State.SCO_CONNECTED ? BaseAudioDevice.BluetoothState.Connected : BaseAudioDevice.BluetoothState.Disconnected;
    }

    synchronized void setBluetoothState(State state) {
        this.bluetoothConnectionState = state;
        this.log.d("setBluetoothState(). bluetoothState set to " + (Object)((Object)this.bluetoothConnectionState), new Object[0]);
    }

    synchronized void forceInvokeConnectBluetooth() {
        if (this.audioDevice == null) {
            return;
        }
        BluetoothManager bluetoothManager = this;
        bluetoothManager.log.d("forceInvokeConnectBluetooth() enter", new Object[0]);
        BluetoothAdapter bluetoothAdapter = bluetoothManager.bluetoothAdapter;
        if (bluetoothAdapter != null) {
            BluetoothAdapter bluetoothAdapter2 = bluetoothAdapter;
            BluetoothManager bluetoothManager2 = this;
            bluetoothAdapter = bluetoothManager2.audioDeviceContext;
            bluetoothAdapter2.getProfileProxy((Context)bluetoothAdapter, bluetoothManager2.bluetoothProfileServiceListener, 1);
        }
        this.log.d("forceInvokeConnectBluetooth() exit", new Object[0]);
    }

    private static final class State
    extends Enum<State> {
        public static final /* enum */ State SCO_DISCONNECTED;
        public static final /* enum */ State SCO_CONNECTING;
        public static final /* enum */ State SCO_CONNECT_ATTEMPT;
        public static final /* enum */ State SCO_CONNECTED;
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string) {
            return Enum.valueOf(State.class, string);
        }

        static {
            State state;
            SCO_DISCONNECTED = new State();
            SCO_CONNECTING = new State();
            SCO_CONNECT_ATTEMPT = new State();
            State state2 = state;
            SCO_CONNECTED = new State();
            $VALUES = new State[]{SCO_DISCONNECTED, SCO_CONNECTING, SCO_CONNECT_ATTEMPT, state2};
        }
    }
}

