/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Range;
import android.util.Size;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.Surface;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import com.opentok.android.BaseVideoCapturer;
import com.opentok.android.OtLog;
import com.opentok.android.Publisher;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

@TargetApi(value=21)
@RequiresApi(value=21)
class Camera2VideoCapturer
extends BaseVideoCapturer
implements BaseVideoCapturer.CaptureSwitch {
    private static final int PREFERRED_FACING_CAMERA = 0;
    private static final int PIXEL_FORMAT = 35;
    private static final SparseIntArray rotationTable = new SparseIntArray(){
        {
            1 v0 = this;
            v0.append(0, 0);
            v0.append(1, 90);
            v0.append(2, 180);
            v0.append(3, 270);
        }
    };
    private static final SparseArray<Size> resolutionTable = new SparseArray<Size>(){
        {
            2 v0 = this;
            v0.append(Publisher.CameraCaptureResolution.LOW.ordinal(), new Size(352, 288));
            v0.append(Publisher.CameraCaptureResolution.MEDIUM.ordinal(), new Size(640, 480));
            v0.append(Publisher.CameraCaptureResolution.HIGH.ordinal(), new Size(1280, 720));
            v0.append(Publisher.CameraCaptureResolution.HIGH_1080P.ordinal(), new Size(1920, 1080));
        }
    };
    private static final SparseIntArray frameRateTable = new SparseIntArray(){
        {
            3 v0 = this;
            v0.append(Publisher.CameraCaptureFrameRate.FPS_1.ordinal(), 1);
            v0.append(Publisher.CameraCaptureFrameRate.FPS_7.ordinal(), 7);
            v0.append(Publisher.CameraCaptureFrameRate.FPS_15.ordinal(), 15);
            v0.append(Publisher.CameraCaptureFrameRate.FPS_30.ordinal(), 30);
        }
    };
    private final CameraManager cameraManager;
    private CameraDevice camera;
    private HandlerThread cameraThread;
    private Handler cameraThreadHandler;
    private ImageReader cameraFrame;
    private CaptureRequest.Builder captureRequestBuilder;
    private CameraCaptureSession captureSession;
    private CameraInfoCache cameraInfoCache;
    private CameraState cameraState;
    private final Display display;
    private DisplayOrientationCache displayOrientationCache;
    private int cameraIndex;
    private final Size frameDimensions;
    private final int desiredFps;
    private Range<Integer> camFps;
    private final List<RuntimeException> runtimeExceptionList;
    private final OtLog.LogToken log;
    private Runnable executeAfterClosed;
    private Runnable executeAfterCameraOpened;
    private Runnable executeAfterCameraSessionConfigured;
    private final CameraDevice.StateCallback cameraObserver;
    private final ImageReader.OnImageAvailableListener frameObserver;
    private final CameraCaptureSession.StateCallback captureSessionObserver;
    private final CameraCaptureSession.CaptureCallback captureNotification;

    public Camera2VideoCapturer(Context object, Publisher.CameraCaptureResolution cameraCaptureResolution, Publisher.CameraCaptureFrameRate cameraCaptureFrameRate) {
        block5: {
            this.log = new OtLog.LogToken(this);
            this.cameraObserver = new CameraDevice.StateCallback(){

                public void onOpened(CameraDevice cameraDevice) {
                    4 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onOpened() enter", new Object[0]);
                    Camera2VideoCapturer.access$102(v0.Camera2VideoCapturer.this, CameraState.OPEN);
                    Camera2VideoCapturer.access$202(v0.Camera2VideoCapturer.this, cameraDevice);
                    if (v0.Camera2VideoCapturer.this.executeAfterCameraOpened != null) {
                        Camera2VideoCapturer.this.executeAfterCameraOpened.run();
                    }
                    4 v1 = this;
                    Camera2VideoCapturer.access$302(v1.Camera2VideoCapturer.this, null);
                    v1.Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onOpened() exit", new Object[0]);
                }

                public void onDisconnected(CameraDevice cameraDevice) {
                    4 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onDisconnected() enter", new Object[0]);
                    try {
                        Camera2VideoCapturer.access$402(v0.Camera2VideoCapturer.this, null);
                    }
                    catch (NullPointerException nullPointerException) {}
                    v0.Camera2VideoCapturer.this.camera.close();
                    Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onDisconnected() exit", new Object[0]);
                }

                public void onError(CameraDevice cameraDevice, int n) {
                    4 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onError() enter", new Object[0]);
                    try {
                        v0.Camera2VideoCapturer.this.camera.close();
                    }
                    catch (NullPointerException nullPointerException) {}
                    4 v2 = this;
                    v2.Camera2VideoCapturer.this.postAsyncException(new Camera2Exception("Camera Open Error: " + n));
                    v2.Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onError() exit", new Object[0]);
                }

                public void onClosed(CameraDevice cameraDevice) {
                    4 v0 = this;
                    Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onClosed() enter.", new Object[0]);
                    super.onClosed(cameraDevice);
                    Camera2VideoCapturer.access$102(v0.Camera2VideoCapturer.this, CameraState.CLOSED);
                    Camera2VideoCapturer.access$202(v0.Camera2VideoCapturer.this, null);
                    if (v0.Camera2VideoCapturer.this.executeAfterClosed != null) {
                        Camera2VideoCapturer.this.executeAfterClosed.run();
                    }
                    4 v1 = this;
                    Camera2VideoCapturer.access$402(v1.Camera2VideoCapturer.this, null);
                    v1.Camera2VideoCapturer.this.log.d("CameraDevice.StateCallback onClosed() exit.", new Object[0]);
                }
            };
            this.frameObserver = new ImageReader.OnImageAvailableListener(){

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void onImageAvailable(ImageReader imageReader) {
                    try {
                        imageReader = imageReader.acquireNextImage();
                        if (!(imageReader == null || imageReader.getPlanes().length > 0 && imageReader.getPlanes()[0].getBuffer() == null || imageReader.getPlanes().length > 1 && imageReader.getPlanes()[1].getBuffer() == null || imageReader.getPlanes().length > 2 && imageReader.getPlanes()[2].getBuffer() == null)) {
                            if (CameraState.CAPTURE == Camera2VideoCapturer.this.cameraState) {
                                ImageReader imageReader2 = imageReader;
                                ByteBuffer byteBuffer = imageReader2.getPlanes()[0].getBuffer();
                                ByteBuffer byteBuffer2 = imageReader2.getPlanes()[1].getBuffer();
                                ByteBuffer byteBuffer3 = imageReader2.getPlanes()[2].getBuffer();
                                int n = imageReader2.getPlanes()[0].getPixelStride();
                                int n2 = imageReader2.getPlanes()[0].getRowStride();
                                int n3 = imageReader2.getPlanes()[1].getPixelStride();
                                int n4 = imageReader2.getPlanes()[1].getRowStride();
                                int n5 = imageReader2.getPlanes()[2].getPixelStride();
                                int n6 = imageReader2.getPlanes()[2].getRowStride();
                                int n7 = imageReader2.getWidth();
                                int n8 = imageReader2.getHeight();
                                5 v1 = this;
                                int n9 = v1.Camera2VideoCapturer.this.calculateCamRotation();
                                boolean bl = v1.Camera2VideoCapturer.this.isFrontCamera();
                                Camera2VideoCapturer.this.provideBufferFramePlanar(byteBuffer, byteBuffer2, byteBuffer3, n, n2, n3, n4, n5, n6, n7, n8, n9, bl);
                            }
                            imageReader.close();
                            return;
                        }
                        Camera2VideoCapturer.this.log.d("onImageAvailable frame provided has no image data", new Object[0]);
                        return;
                    }
                    catch (IllegalStateException illegalStateException) {
                        Camera2VideoCapturer.this.log.e("ImageReader.acquireNextImage() throws error !", new Object[0]);
                        throw new Camera2Exception(illegalStateException.getMessage());
                    }
                }
            };
            this.captureSessionObserver = new CameraCaptureSession.StateCallback(){

                public void onConfigured(CameraCaptureSession cameraCaptureSession) {
                    6 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onConfigured() enter.", new Object[0]);
                    Camera2VideoCapturer.access$102(v0.Camera2VideoCapturer.this, CameraState.CAPTURE);
                    Camera2VideoCapturer.access$802(v0.Camera2VideoCapturer.this, cameraCaptureSession);
                    cameraCaptureSession = v0.Camera2VideoCapturer.this.captureRequestBuilder.build();
                    try {
                        v0.Camera2VideoCapturer.this.captureSession.setRepeatingRequest((CaptureRequest)cameraCaptureSession, Camera2VideoCapturer.this.captureNotification, null);
                    }
                    catch (CameraAccessException cameraAccessException) {
                        cameraAccessException.printStackTrace();
                    }
                    6 v2 = this;
                    v2.Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onConfigured() exit.", new Object[0]);
                    if (v2.Camera2VideoCapturer.this.executeAfterCameraSessionConfigured != null) {
                        6 v3 = this;
                        v3.Camera2VideoCapturer.this.executeAfterCameraSessionConfigured.run();
                        Camera2VideoCapturer.access$1102(v3.Camera2VideoCapturer.this, null);
                    }
                }

                public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
                    6 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onFailed() enter.", new Object[0]);
                    Camera2VideoCapturer.access$102(v0.Camera2VideoCapturer.this, CameraState.ERROR);
                    v0.Camera2VideoCapturer.this.postAsyncException(new Camera2Exception("Camera session configuration failed"));
                    v0.Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onFailed() exit.", new Object[0]);
                }

                public void onClosed(CameraCaptureSession cameraCaptureSession) {
                    6 v0 = this;
                    v0.Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onClosed() enter.", new Object[0]);
                    if (v0.Camera2VideoCapturer.this.camera != null) {
                        Camera2VideoCapturer.this.camera.close();
                    }
                    Camera2VideoCapturer.this.log.d("CameraCaptureSession.StateCallback onClosed() exit.", new Object[0]);
                }
            };
            this.captureNotification = new CameraCaptureSession.CaptureCallback(){

                public void onCaptureStarted(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, long l2, long l3) {
                    super.onCaptureStarted(cameraCaptureSession, captureRequest, l2, l3);
                }
            };
            this.cameraManager = (CameraManager)object.getSystemService("camera");
            this.display = ((WindowManager)object.getSystemService("window")).getDefaultDisplay();
            this.camera = null;
            this.cameraState = CameraState.CLOSED;
            this.frameDimensions = (Size)resolutionTable.get(cameraCaptureResolution.ordinal());
            this.desiredFps = frameRateTable.get(cameraCaptureFrameRate.ordinal());
            this.runtimeExceptionList = new ArrayList<RuntimeException>();
            try {
                object = this.selectCamera(0);
                if (object != null) break block5;
            }
            catch (CameraAccessException cameraAccessException) {
                throw new Camera2Exception(cameraAccessException.getMessage());
            }
            if (this.cameraManager.getCameraIdList().length <= 0) break block5;
            object = this.cameraManager.getCameraIdList()[0];
        }
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.cameraIndex = camera2VideoCapturer.findCameraIndex((String)object);
        camera2VideoCapturer.initCameraFrame();
    }

    private void doInit() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("doInit() enter", new Object[0]);
        camera2VideoCapturer.cameraInfoCache = null;
        camera2VideoCapturer.startCamThread();
        camera2VideoCapturer.startDisplayOrientationCache();
        camera2VideoCapturer.initCamera();
        camera2VideoCapturer.log.d("doInit() exit", new Object[0]);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int doStartCapture() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("doStartCapture() enter", new Object[0]);
        camera2VideoCapturer.cameraState = CameraState.CREATESESSION;
        try {
            void var1_5;
            CameraCaptureSession.StateCallback stateCallback;
            CameraDevice cameraDevice;
            if (camera2VideoCapturer.isFrontCamera()) {
                Camera2VideoCapturer camera2VideoCapturer2 = this;
                CaptureRequest.Builder builder = camera2VideoCapturer2.camera.createCaptureRequest(1);
                this.captureRequestBuilder = builder;
                builder.addTarget(this.cameraFrame.getSurface());
                CaptureRequest.Key key = CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE;
                camera2VideoCapturer2.captureRequestBuilder.set(key, this.camFps);
                camera2VideoCapturer2.captureRequestBuilder.set(CaptureRequest.CONTROL_MODE, (Object)2);
                camera2VideoCapturer2.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                camera2VideoCapturer2.captureRequestBuilder.set(CaptureRequest.CONTROL_SCENE_MODE, (Object)1);
                cameraDevice = camera2VideoCapturer2.camera;
                List<Surface> list = Arrays.asList(this.cameraFrame.getSurface());
                stateCallback = this.captureSessionObserver;
            } else {
                Camera2VideoCapturer camera2VideoCapturer3 = this;
                CaptureRequest.Builder builder = camera2VideoCapturer3.camera.createCaptureRequest(3);
                this.captureRequestBuilder = builder;
                builder.addTarget(this.cameraFrame.getSurface());
                CaptureRequest.Key key = CaptureRequest.CONTROL_AE_TARGET_FPS_RANGE;
                camera2VideoCapturer3.captureRequestBuilder.set(key, this.camFps);
                camera2VideoCapturer3.captureRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
                cameraDevice = camera2VideoCapturer3.camera;
                Camera2VideoCapturer camera2VideoCapturer4 = this;
                Surface[] surfaceArray = new Surface[1];
                surfaceArray[0] = this.cameraFrame.getSurface();
                List<Surface> list = Arrays.asList(surfaceArray);
                stateCallback = camera2VideoCapturer4.captureSessionObserver;
            }
            cameraDevice.createCaptureSession((List)var1_5, stateCallback, null);
            this.log.d("doStartCapture() exit", new Object[0]);
            return 0;
        }
        catch (CameraAccessException cameraAccessException) {
            throw new Camera2Exception(cameraAccessException.getMessage());
        }
    }

    private boolean isDepthOutputCamera(String object) {
        int[] nArray = (int[])this.cameraManager.getCameraCharacteristics((String)object).get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        object = nArray;
        if (nArray != null) {
            int n = ((Object)object).length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (object[i2] != 8) continue;
                this.log.d(" REQUEST_AVAILABLE_CAPABILITIES_DEPTH_OUTPUT => TRUE", new Object[0]);
                return true;
            }
        }
        this.log.d(" REQUEST_AVAILABLE_CAPABILITIES_DEPTH_OUTPUT => FALSE", new Object[0]);
        return false;
    }

    private boolean isBackwardCompatible(String object) {
        int[] nArray = (int[])this.cameraManager.getCameraCharacteristics((String)object).get(CameraCharacteristics.REQUEST_AVAILABLE_CAPABILITIES);
        object = nArray;
        if (nArray != null) {
            int n = ((Object)object).length;
            for (int i2 = 0; i2 < n; ++i2) {
                if (object[i2] != false) continue;
                this.log.d(" REQUEST_AVAILABLE_CAPABILITIES_BACKWARD_COMPATIBLE => TRUE", new Object[0]);
                return true;
            }
        }
        this.log.d(" REQUEST_AVAILABLE_CAPABILITIES_BACKWARD_COMPATIBLE => FALSE", new Object[0]);
        return false;
    }

    private Size[] getCameraOutputSizes(String string) {
        return ((StreamConfigurationMap)this.cameraManager.getCameraCharacteristics(string).get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP)).getOutputSizes(35);
    }

    private int getNextSupportedCameraIndex() {
        String[] stringArray = this.cameraManager.getCameraIdList();
        int n = stringArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            int n2;
            boolean bl = this.isDepthOutputCamera(stringArray[n2]);
            boolean bl2 = this.isBackwardCompatible(stringArray[n2]);
            n2 = (this.cameraIndex + i2 + 1) % n;
            Size[] sizeArray = this.getCameraOutputSizes(stringArray[n2]);
            if (!(sizeArray != null && sizeArray.length > 0) || !bl2 || bl) continue;
            return n2;
        }
        return -1;
    }

    private boolean isFrontCamera() {
        CameraInfoCache cameraInfoCache = ((Camera2VideoCapturer)((Object)cameraInfoCache)).cameraInfoCache;
        return cameraInfoCache != null && cameraInfoCache.isFrontFacing();
    }

    private void startCamThread() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("startCamThread() enter", new Object[0]);
        this.cameraThread = new HandlerThread("Camera2VideoCapturer-Camera-Thread");
        this.cameraThread.start();
        camera2VideoCapturer.cameraThreadHandler = new Handler(this.cameraThread.getLooper());
        camera2VideoCapturer.log.d("startCamThread() exit", new Object[0]);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stopCamThread() {
        block7: {
            block8: {
                v0 = this;
                v0.log.d("stopCamThread() enter", new Object[0]);
                v0.cameraThread.quitSafely();
                ** GOTO lbl14
                {
                    catch (Throwable v1) {
                        break block7;
                    }
                    catch (NullPointerException v2) lbl-1000:
                    // 2 sources

                    {
                        while (true) {
                            v3 = this;
                            v3.cameraThread = null;
                            v3.cameraThreadHandler = null;
                            break block8;
                            break;
                        }
                    }
lbl14:
                    // 1 sources

                    try {
                        v0.cameraThread.join();
                        v0.cameraThread = null;
                        v0.cameraThreadHandler = null;
                    }
                    catch (InterruptedException v4) {}
                    {
                        v4.printStackTrace();
                        ** continue;
                    }
                }
            }
            this.log.d("stopCamThread() exit", new Object[0]);
            return;
        }
        v5 = this;
        v5.cameraThread = null;
        v5.cameraThreadHandler = null;
        throw v1;
    }

    private String selectCamera(int n) {
        for (String string : this.cameraManager.getCameraIdList()) {
            CameraCharacteristics cameraCharacteristics = this.cameraManager.getCameraCharacteristics(string);
            if (n != (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING)) continue;
            this.log.d("selectCamera() Direction the camera faces relative to device screen: " + cameraCharacteristics.get(CameraCharacteristics.LENS_FACING), new Object[0]);
            return string;
        }
        return null;
    }

    private Range<Integer> selectCameraFpsRange(String range, final int n) {
        Object object = this.cameraManager.getCameraIdList();
        int n2 = ((String[])object).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            ArrayList arrayList;
            String string = object[i2];
            if (!string.equals(range)) continue;
            range = this.cameraManager.getCameraCharacteristics(string);
            object = arrayList;
            object();
            Collections.addAll(object, (Range[])range.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES));
            this.log.d("Supported fps ranges = " + object, new Object[0]);
            range = Collections.min(arrayList, new Comparator<Range<Integer>>(){

                private int calcError(Range<Integer> range) {
                    return Math.abs((Integer)range.getLower() - n) + Math.abs((Integer)range.getUpper() - n);
                }

                @Override
                public int compare(Range<Integer> range, Range<Integer> range2) {
                    return this.calcError(range) - this.calcError(range2);
                }
            });
            this.log.d("Desired fps = " + n + " || Selected frame rate range = " + range, new Object[0]);
            return range;
        }
        return null;
    }

    private int findCameraIndex(String string) {
        String[] stringArray = stringArray.cameraManager.getCameraIdList();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (!stringArray[i2].equals(string)) continue;
            return i2;
        }
        return -1;
    }

    private Size selectPreferredSize(String sizeArray, final int n, final int n2) {
        sizeArray = this.getCameraOutputSizes((String)sizeArray);
        ArrayList arrayList = new ArrayList();
        Collections.addAll(arrayList, sizeArray);
        return Collections.min(arrayList, new Comparator<Size>(){

            @Override
            public int compare(Size size, Size size2) {
                Size size3 = size2;
                int n3 = Math.abs(size3.getWidth() - n);
                int n22 = Math.abs(size3.getHeight() - n2);
                return Math.abs(size.getWidth() - n) + Math.abs(size.getHeight() - n2) - (n3 + n22);
            }
        });
    }

    private int calculateCamRotation() {
        if (this.cameraInfoCache != null) {
            Camera2VideoCapturer camera2VideoCapturer = this;
            int n = camera2VideoCapturer.displayOrientationCache.getOrientation();
            int n2 = camera2VideoCapturer.cameraInfoCache.sensorOrientation();
            if (!camera2VideoCapturer.cameraInfoCache.isFrontFacing()) {
                return Math.abs((n - n2) % 360);
            }
            return (n + n2 + 360) % 360;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initCameraFrame() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("initCameraFrame() enter.", new Object[0]);
        try {
            Camera2VideoCapturer camera2VideoCapturer2 = this;
            int n = camera2VideoCapturer2.frameDimensions.getWidth();
            Size size = camera2VideoCapturer.selectPreferredSize(camera2VideoCapturer.cameraManager.getCameraIdList()[this.cameraIndex], n, camera2VideoCapturer2.frameDimensions.getHeight());
            if (camera2VideoCapturer.cameraFrame != null) {
                this.cameraFrame.close();
            }
            this.cameraFrame = ImageReader.newInstance((int)size.getWidth(), (int)size.getHeight(), (int)35, (int)3);
            this.log.d("initCameraFrame() exit.", new Object[0]);
            return;
        }
        catch (CameraAccessException cameraAccessException) {
            throw new Camera2Exception(cameraAccessException.getMessage());
        }
    }

    @SuppressLint(value={"all"})
    private void initCamera() {
        String string;
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("initCamera() enter.", new Object[0]);
        try {
            camera2VideoCapturer.cameraState = CameraState.SETUP;
            string = camera2VideoCapturer.cameraManager.getCameraIdList()[this.cameraIndex];
        }
        catch (CameraAccessException cameraAccessException) {
            throw new Camera2Exception(cameraAccessException.getMessage());
        }
        camera2VideoCapturer.camFps = camera2VideoCapturer.selectCameraFpsRange(string, camera2VideoCapturer.desiredFps);
        ImageReader imageReader = camera2VideoCapturer.cameraFrame;
        Camera2VideoCapturer camera2VideoCapturer2 = this;
        Camera2VideoCapturer camera2VideoCapturer3 = camera2VideoCapturer2;
        ImageReader.OnImageAvailableListener onImageAvailableListener = camera2VideoCapturer2.frameObserver;
        imageReader.setOnImageAvailableListener(onImageAvailableListener, camera2VideoCapturer3.cameraThreadHandler);
        camera2VideoCapturer.cameraInfoCache = new CameraInfoCache(this.cameraManager.getCameraCharacteristics(string));
        camera2VideoCapturer.cameraManager.openCamera(string, this.cameraObserver, null);
        camera2VideoCapturer.log.d("initCamera() exit.", new Object[0]);
    }

    private void postAsyncException(RuntimeException runtimeException) {
        this.runtimeExceptionList.add(runtimeException);
    }

    private void startDisplayOrientationCache() {
        DisplayOrientationCache displayOrientationCache;
        Camera2VideoCapturer camera2VideoCapturer = camera2VideoCapturer3;
        DisplayOrientationCache displayOrientationCache2 = displayOrientationCache;
        Camera2VideoCapturer camera2VideoCapturer2 = camera2VideoCapturer3;
        Camera2VideoCapturer camera2VideoCapturer3 = camera2VideoCapturer2.display;
        displayOrientationCache = new DisplayOrientationCache((Display)camera2VideoCapturer3, camera2VideoCapturer2.cameraThreadHandler);
        camera2VideoCapturer.displayOrientationCache = displayOrientationCache2;
    }

    private void stopDisplayOrientationCache() {
        this.cameraThreadHandler.removeCallbacks((Runnable)this.displayOrientationCache);
    }

    static /* synthetic */ CameraState access$102(Camera2VideoCapturer camera2VideoCapturer, CameraState cameraState) {
        camera2VideoCapturer.cameraState = cameraState;
        return cameraState;
    }

    static /* synthetic */ CameraDevice access$202(Camera2VideoCapturer camera2VideoCapturer, CameraDevice cameraDevice) {
        camera2VideoCapturer.camera = cameraDevice;
        return cameraDevice;
    }

    static /* synthetic */ Runnable access$302(Camera2VideoCapturer camera2VideoCapturer, Runnable runnable) {
        camera2VideoCapturer.executeAfterCameraOpened = runnable;
        return runnable;
    }

    static /* synthetic */ Runnable access$402(Camera2VideoCapturer camera2VideoCapturer, Runnable runnable) {
        camera2VideoCapturer.executeAfterClosed = runnable;
        return runnable;
    }

    static /* synthetic */ CameraCaptureSession access$802(Camera2VideoCapturer camera2VideoCapturer, CameraCaptureSession cameraCaptureSession) {
        camera2VideoCapturer.captureSession = cameraCaptureSession;
        return cameraCaptureSession;
    }

    static /* synthetic */ Runnable access$1102(Camera2VideoCapturer camera2VideoCapturer, Runnable runnable) {
        camera2VideoCapturer.executeAfterCameraSessionConfigured = runnable;
        return runnable;
    }

    @Override
    public synchronized void init() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("init() enter", new Object[0]);
        camera2VideoCapturer.doInit();
        camera2VideoCapturer.cameraState = CameraState.SETUP;
        camera2VideoCapturer.log.d("init() exit", new Object[0]);
    }

    @Override
    public synchronized int startCapture() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("startCapture() enter (cameraState: " + (Object)((Object)this.cameraState) + ")", new Object[0]);
        Runnable runnable = () -> {
            Camera2VideoCapturer camera2VideoCapturer = this;
            camera2VideoCapturer.initCamera();
            camera2VideoCapturer.scheduleStartCapture();
        };
        CameraState cameraState = camera2VideoCapturer.cameraState;
        if (cameraState == CameraState.CLOSING) {
            this.executeAfterClosed = runnable;
        } else if (cameraState == CameraState.CLOSED) {
            runnable.run();
        } else {
            this.scheduleStartCapture();
        }
        this.log.d("startCapture() exit", new Object[0]);
        return 0;
    }

    public synchronized int scheduleStartCapture() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("scheduleStartCapture() enter (cameraState: " + (Object)((Object)this.cameraState) + ")", new Object[0]);
        if (camera2VideoCapturer.camera != null && CameraState.OPEN == this.cameraState) {
            return this.doStartCapture();
        }
        CameraState cameraState = this.cameraState;
        if (CameraState.SETUP == cameraState) {
            Camera2VideoCapturer camera2VideoCapturer2 = this;
            camera2VideoCapturer2.log.d("camera not yet ready, queuing the start until camera is opened.", new Object[0]);
            camera2VideoCapturer2.executeAfterCameraOpened = camera2VideoCapturer2::doStartCapture;
        } else if (CameraState.CREATESESSION == cameraState) {
            this.log.d("Camera session creation already requested", new Object[0]);
        } else {
            this.log.d("Start Capture called before init successfully completed.", new Object[0]);
        }
        this.log.d("scheduleStartCapture() exit", new Object[0]);
        return 0;
    }

    @Override
    public synchronized int stopCapture() {
        Object object;
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("stopCapture() enter (cameraState: " + (Object)((Object)this.cameraState) + ")", new Object[0]);
        if (camera2VideoCapturer.camera != null && (object = this.captureSession) != null && CameraState.CAPTURE == this.cameraState) {
            try {
                object.stopRepeating();
            }
            catch (CameraAccessException cameraAccessException) {
                cameraAccessException.printStackTrace();
            }
            this.captureSession.close();
            this.cameraInfoCache = null;
            this.cameraState = CameraState.CLOSING;
        } else {
            object = this.camera;
            if (object != null && CameraState.OPEN == this.cameraState) {
                this.cameraState = CameraState.CLOSING;
                object.close();
            } else {
                object = this.cameraState;
                if (CameraState.SETUP == object) {
                    this.executeAfterCameraOpened = () -> {
                        camera2VideoCapturer.cameraState = CameraState.CLOSING;
                        Camera2VideoCapturer camera2VideoCapturer = camera2VideoCapturer.camera;
                        if (camera2VideoCapturer != null) {
                            camera2VideoCapturer.close();
                        }
                    };
                } else if (CameraState.CREATESESSION == object) {
                    this.executeAfterCameraSessionConfigured = () -> {
                        this.captureSession.close();
                        this.cameraState = CameraState.CLOSING;
                        this.executeAfterCameraSessionConfigured = null;
                    };
                }
            }
        }
        this.log.d("stopCapture exit", new Object[0]);
        return 0;
    }

    @Override
    public synchronized void destroy() {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("destroy() enter", new Object[0]);
        camera2VideoCapturer.stopDisplayOrientationCache();
        camera2VideoCapturer.stopCamThread();
        camera2VideoCapturer.cameraFrame.close();
        camera2VideoCapturer.log.d("destroy() exit", new Object[0]);
    }

    @Override
    public boolean isCaptureStarted() {
        return this.cameraState == CameraState.CAPTURE;
    }

    @Override
    public synchronized BaseVideoCapturer.CaptureSettings getCaptureSettings() {
        BaseVideoCapturer.CaptureSettings captureSettings;
        BaseVideoCapturer.CaptureSettings captureSettings2 = captureSettings;
        captureSettings2();
        captureSettings.fps = this.desiredFps;
        ImageReader imageReader = this.cameraFrame;
        int n = imageReader != null ? imageReader.getWidth() : -1;
        captureSettings2.width = n;
        ImageReader imageReader2 = this.cameraFrame;
        int n2 = imageReader2 != null ? imageReader2.getHeight() : -1;
        BaseVideoCapturer.CaptureSettings captureSettings3 = captureSettings2;
        captureSettings3.height = n2;
        captureSettings3.format = 1;
        captureSettings3.expectedDelay = 0;
        captureSettings2.mirrorInLocalRender = this.frameMirrorX;
        return captureSettings2;
    }

    @Override
    public synchronized void onPause() {
    }

    @Override
    public void onResume() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void cycleCamera() {
        int n;
        try {
            n = this.getNextSupportedCameraIndex();
            if (!(n != -1)) throw new CameraAccessException(3, "No cameras with supported outputs found");
        }
        catch (CameraAccessException cameraAccessException) {
            cameraAccessException.printStackTrace();
            throw new Camera2Exception(cameraAccessException.getMessage());
        }
        this.cameraIndex = n;
        this.swapCamera(n);
    }

    @Override
    public int getCameraIndex() {
        return this.cameraIndex;
    }

    @Override
    public synchronized void swapCamera(int n) {
        Camera2VideoCapturer camera2VideoCapturer = this;
        camera2VideoCapturer.log.d("swapCamera() enter", new Object[0]);
        CameraState cameraState = camera2VideoCapturer.cameraState;
        if (10.$SwitchMap$com$opentok$android$Camera2VideoCapturer$CameraState[cameraState.ordinal()] == 1) {
            this.stopCapture();
        }
        Camera2VideoCapturer camera2VideoCapturer2 = this;
        this.cameraIndex = n;
        camera2VideoCapturer2.executeAfterClosed = () -> {
            if (10.$SwitchMap$com$opentok$android$Camera2VideoCapturer$CameraState[cameraState.ordinal()] == 1) {
                Camera2VideoCapturer camera2VideoCapturer = this;
                camera2VideoCapturer.initCameraFrame();
                camera2VideoCapturer.initCamera();
                camera2VideoCapturer.startCapture();
            }
        };
        camera2VideoCapturer2.log.d("swapCamera() exit", new Object[0]);
    }

    public static class Camera2Exception
    extends RuntimeException {
        public Camera2Exception(String string) {
            super(string);
        }
    }

    private static class DisplayOrientationCache
    implements Runnable {
        private static final int POLL_DELAY_MS = 750;
        private int displayRotation;
        private final Display display;
        private final Handler handler;

        public DisplayOrientationCache(Display display, Handler handler) {
            this.display = display;
            this.handler = handler;
            this.displayRotation = rotationTable.get(this.display.getRotation());
            this.handler.postDelayed((Runnable)this, 750L);
        }

        public int getOrientation() {
            return this.displayRotation;
        }

        @Override
        public void run() {
            this.displayRotation = rotationTable.get(this.display.getRotation());
            this.handler.postDelayed((Runnable)this, 750L);
        }
    }

    private static class CameraInfoCache {
        private final CameraCharacteristics info;
        private boolean frontFacing = false;
        private int sensorOrientation = 0;

        public CameraInfoCache(CameraCharacteristics cameraCharacteristics) {
            this.info = cameraCharacteristics;
            boolean bl = (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING) == 0;
            this.frontFacing = bl;
            this.sensorOrientation = (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
        }

        public <T> T get(CameraCharacteristics.Key<T> key) {
            return (T)this.info.get(key);
        }

        public boolean isFrontFacing() {
            return this.frontFacing;
        }

        public int sensorOrientation() {
            return this.sensorOrientation;
        }
    }

    private static final class CameraState
    extends Enum<CameraState> {
        public static final /* enum */ CameraState CLOSED;
        public static final /* enum */ CameraState CLOSING;
        public static final /* enum */ CameraState SETUP;
        public static final /* enum */ CameraState OPEN;
        public static final /* enum */ CameraState CAPTURE;
        public static final /* enum */ CameraState CREATESESSION;
        public static final /* enum */ CameraState ERROR;
        private static final /* synthetic */ CameraState[] $VALUES;

        public static CameraState[] values() {
            return (CameraState[])$VALUES.clone();
        }

        public static CameraState valueOf(String string) {
            return Enum.valueOf(CameraState.class, string);
        }

        static {
            CameraState cameraState;
            CLOSED = new CameraState();
            CLOSING = new CameraState();
            SETUP = new CameraState();
            OPEN = new CameraState();
            CAPTURE = new CameraState();
            CREATESESSION = new CameraState();
            CameraState cameraState2 = cameraState;
            ERROR = new CameraState();
            $VALUES = new CameraState[]{CLOSED, CLOSING, SETUP, OPEN, CAPTURE, CREATESESSION, cameraState2};
        }
    }
}

