/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Bundle;
import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.Surface;
import androidx.annotation.Keep;
import com.opentok.android.OtLog;
import com.vonage.webrtc.EglBase14;
import com.vonage.webrtc.GlRectDrawer;
import com.vonage.webrtc.ThreadUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@TargetApi(value=19)
@Keep
class MediaCodecVideoEncoder {
    private static final OtLog.LogToken log;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_TIMEOUT = 0;
    private static final int BITRATE_ADJUSTMENT_FPS = 30;
    private static final int MAXIMUM_INITIAL_FPS = 30;
    private static final double BITRATE_CORRECTION_SEC = 3.0;
    private static final double BITRATE_CORRECTION_MAX_SCALE = 4.0;
    private static final int BITRATE_CORRECTION_STEPS = 20;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000L;
    private static final long QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000L;
    private static MediaCodecVideoEncoder runningInstance;
    private static MediaCodecVideoEncoderErrorCallback errorCallback;
    private static int codecErrors;
    private static Set<String> hwEncoderDisabledTypes;
    private static final String VP8_MIME_TYPE = "video/x-vnd.on2.vp8";
    private static final String VP9_MIME_TYPE = "video/x-vnd.on2.vp9";
    private static final String H264_MIME_TYPE = "video/avc";
    private static final int VIDEO_AVCProfileHigh = 8;
    private static final int VIDEO_AVCLevel3 = 256;
    private static final SupportedEncoderRecord[] VP8_SUPPORT;
    private static final SupportedEncoderRecord[] VP9_SUPPORT;
    private static final SupportedEncoderRecord[] H264_SUPPORT;
    private static final SparseArray<Pair<String, SupportedEncoderRecord[]>> SupportedEncoderTbl;
    private static final SparseIntArray KeyFrameIntervalSecTbl;
    private static final String[] H264_BLACKLIST;
    private static final int VIDEO_ControlRateConstant = 2;
    private static final int COLOR_QCOM_FORMATYUV420PackedSemiPlanar32m = 2141391876;
    private static final int[] supportedColorList;
    private static final int[] supportedSurfaceColorList;
    private Thread mediaCodecThread;
    private MediaCodec mediaCodec;
    private ByteBuffer[] outputBuffers;
    private EglBase14 eglBase;
    private int profile;
    private int width;
    private int height;
    private Surface inputSurface;
    private GlRectDrawer drawer;
    private VideoCodecType type;
    private int colorFormat;
    private BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
    private double bitrateAccumulator;
    private double bitrateAccumulatorMax;
    private double bitrateObservationTimeMs;
    private int bitrateAdjustmentScaleExp;
    private int targetBitrateBps;
    private int targetFps;
    private long forcedKeyFrameMs;
    private long lastKeyFrameMs;
    private ByteBuffer configData = null;

    MediaCodecVideoEncoder() {
    }

    public static void setErrorCallback(MediaCodecVideoEncoderErrorCallback mediaCodecVideoEncoderErrorCallback) {
        log.d("Set error callback", new Object[0]);
        errorCallback = mediaCodecVideoEncoderErrorCallback;
    }

    public static void disableVp8HwCodec() {
        log.w("VP8 encoding is disabled by application.", new Object[0]);
        hwEncoderDisabledTypes.add(VP8_MIME_TYPE);
    }

    public static void disableVp9HwCodec() {
        log.w("VP9 encoding is disabled by application.", new Object[0]);
        hwEncoderDisabledTypes.add(VP9_MIME_TYPE);
    }

    public static void disableH264HwCodec() {
        log.w("H.264 encoding is disabled by application.", new Object[0]);
        hwEncoderDisabledTypes.add(H264_MIME_TYPE);
    }

    public static boolean isVp8HwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, VP8_SUPPORT, nArray = supportedColorList).length > 0;
    }

    public static boolean isVp9HwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, VP9_SUPPORT, nArray = supportedColorList).length > 0;
    }

    public static boolean isH264HwSupported() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, H264_SUPPORT, nArray = supportedColorList).length > 0;
    }

    public static boolean isH264HighProfileHwSupported() {
        Object[] objectArray = supportedColorList;
        EncoderProperties[] encoderPropertiesArray = MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, H264_SUPPORT, objectArray);
        objectArray = encoderPropertiesArray;
        return encoderPropertiesArray.length > 0 && objectArray[0].meta.containsKey("HighProfile") && Build.VERSION.SDK_INT >= objectArray[0].meta.get("HighProfile");
    }

    public static boolean isVp8HwSupportedUsingTextures() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP8_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP8_MIME_TYPE, VP8_SUPPORT, nArray = supportedSurfaceColorList).length > 0;
    }

    public static boolean isVp9HwSupportedUsingTextures() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(VP9_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(VP9_MIME_TYPE, VP9_SUPPORT, nArray = supportedSurfaceColorList).length > 0;
    }

    public static boolean isH264HwSupportedUsingTextures() {
        int[] nArray;
        return !hwEncoderDisabledTypes.contains(H264_MIME_TYPE) && MediaCodecVideoEncoder.findHwEncoder(H264_MIME_TYPE, H264_SUPPORT, nArray = supportedSurfaceColorList).length > 0;
    }

    private static MediaCodecInfo[] getCodecList() {
        Vector<MediaCodecInfo> vector;
        if (Build.VERSION.SDK_INT < 19) {
            return new MediaCodecInfo[0];
        }
        Vector<MediaCodecInfo> vector2 = vector;
        vector = new Vector<MediaCodecInfo>();
        for (int i2 = 0; i2 < MediaCodecList.getCodecCount(); ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (mediaCodecInfo == null || !mediaCodecInfo.isEncoder()) continue;
            vector2.add(mediaCodecInfo);
        }
        Vector<MediaCodecInfo> vector3 = vector2;
        return vector3.toArray(new MediaCodecInfo[vector3.size()]);
    }

    private static EncoderProperties[] findHwEncoder(String string, SupportedEncoderRecord[] objectArray, int[] object) {
        Vector<Pair> vector;
        log.d("Trying to find HW encoder for mime " + string, new Object[0]);
        Vector<Pair> vector2 = vector;
        vector = new Vector<Pair>();
        block15: for (MediaCodecInfo mediaCodecInfo : MediaCodecVideoEncoder.getCodecList()) {
            if (!Arrays.asList(mediaCodecInfo.getSupportedTypes()).contains(string)) continue;
            if (string.equals(H264_MIME_TYPE) && Arrays.asList(H264_BLACKLIST).contains(Build.MODEL)) {
                log.w("Model: " + Build.MODEL + " is blacklisted for H264.", new Object[0]);
                continue;
            }
            Object[] objectArray2 = objectArray;
            Object[] objectArray3 = MediaCodecVideoEncoder.createIntList(mediaCodecInfo.getCapabilitiesForType((String)string).colorFormats);
            int n = objectArray2.length;
            block16: for (int i2 = 0; i2 < n; ++i2) {
                int n2;
                Object object2 = objectArray[i2];
                if (Build.VERSION.SDK_INT < ((SupportedEncoderRecord)object2).supportedVersion) continue;
                if (!mediaCodecInfo.getName().startsWith(((SupportedEncoderRecord)object2).prefix)) continue;
                try {
                    n2 = ((Object)object).length;
                }
                catch (Exception exception) {
                    Object[] objectArray4 = new Object[1];
                    objectArray3 = objectArray4;
                    objectArray4[0] = exception;
                    log.e("general error", objectArray3);
                    exception.printStackTrace();
                    continue block15;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    Object[] objectArray5 = new Object[1];
                    objectArray3 = objectArray5;
                    objectArray5[0] = illegalArgumentException;
                    log.e("Cannot retreive decoder capabilities", objectArray3);
                    continue block15;
                }
                for (int i3 = 0; i3 < n2; ++i3) {
                    EncoderProperties encoderProperties;
                    Pair pair;
                    Object[] objectArray6 = objectArray3;
                    Object object3 = object[i3];
                    if (!objectArray6.contains((int)object3)) continue;
                    Vector<Pair> vector3 = vector2;
                    log.d("Found target encoder " + mediaCodecInfo.getName() + ". Color: 0x" + Integer.toHexString((int)object3) + ". Bitrate adjustment: " + (Object)((Object)((SupportedEncoderRecord)object2).bitrateAdjustmentType), new Object[0]);
                    Pair pair2 = pair;
                    Pair pair3 = pair;
                    Object object4 = object2;
                    EncoderProperties encoderProperties2 = encoderProperties;
                    Object object5 = object2;
                    Object object6 = object5;
                    Object object7 = object5;
                    object2 = mediaCodecInfo.getName();
                    BitrateAdjustmentType bitrateAdjustmentType = ((SupportedEncoderRecord)object6).bitrateAdjustmentType;
                    Map<String, Integer> map = ((SupportedEncoderRecord)object7).meta;
                    encoderProperties = new EncoderProperties((String)object2, (int)object3, bitrateAdjustmentType, map);
                    pair2((Object)encoderProperties2, (Object)((SupportedEncoderRecord)object4).priority);
                    vector3.add(pair3);
                    continue block16;
                }
                continue;
            }
        }
        Vector<Pair> vector4 = vector2;
        Collections.sort(vector4, new Comparator<Pair<EncoderProperties, SupportedEncoderRecord.Priority>>(){

            @Override
            public int compare(Pair<EncoderProperties, SupportedEncoderRecord.Priority> pair, Pair<EncoderProperties, SupportedEncoderRecord.Priority> pair2) {
                return ((SupportedEncoderRecord.Priority)((Object)pair.second)).ordinal() - ((SupportedEncoderRecord.Priority)((Object)pair2.second)).ordinal();
            }
        });
        int n = 0;
        objectArray = new EncoderProperties[vector4.size()];
        object = vector4.iterator();
        while (object.hasNext()) {
            objectArray[n++] = (EncoderProperties)((Pair)object.next()).first;
        }
        return objectArray;
    }

    private void checkOnMediaCodecThread() {
        if (this.mediaCodecThread.getId() == Thread.currentThread().getId()) {
            return;
        }
        throw new RuntimeException("MediaCodecVideoEncoder previously operated on " + this.mediaCodecThread + " but is now called on " + Thread.currentThread());
    }

    public static void printStackTrace() {
        Object object = runningInstance;
        if (object != null && (object = object.mediaCodecThread) != null && ((StackTraceElement[])(object = object.getStackTrace())).length > 0) {
            log.d("MediaCodecVideoEncoder stacks trace:", new Object[0]);
            int n = ((StackTraceElement[])object).length;
            for (int i2 = 0; i2 < n; ++i2) {
                log.d(object[i2].toString(), new Object[0]);
            }
        }
    }

    static MediaCodec createByCodecName(String string) {
        try {
            return MediaCodec.createByCodecName((String)string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean initEncoder(VideoCodecType videoCodecType, EncoderProperties encoderProperties, EglBase14.Context context, String string) {
        String string2;
        MediaFormat mediaFormat;
        MediaFormat mediaFormat2;
        boolean bl;
        int n = KeyFrameIntervalSecTbl.get(videoCodecType.ordinal());
        boolean bl2 = objectArray3.profile == H264Profile.CONSTRAINED_HIGH.getValue() && MediaCodecVideoEncoder.isH264HighProfileHwSupported();
        try {
            bl = bl2;
            int n2 = objectArray3.width;
            mediaFormat = mediaFormat2 = MediaFormat.createVideoFormat((String)string, (int)n2, (int)objectArray3.height);
            string2 = "bitrate";
        }
        catch (Exception exception) {
            Object[] objectArray = objectArray3;
            Object[] objectArray2 = new Object[1];
            Object[] objectArray3 = objectArray2;
            objectArray2[0] = exception;
            log.e("initEncode failed", objectArray3);
            objectArray.release();
            return false;
        }
        {
            mediaFormat.setInteger(string2, objectArray3.targetBitrateBps);
            mediaFormat.setInteger("bitrate-mode", 2);
            string2 = "color-format";
            mediaFormat2.setInteger(string2, encoderProperties.colorFormat);
            string2 = "frame-rate";
            mediaFormat2.setInteger(string2, objectArray3.targetFps);
            mediaFormat2.setInteger("i-frame-interval", n);
            if (bl) {
                MediaFormat mediaFormat3 = mediaFormat2;
                mediaFormat3.setInteger("profile", 8);
                mediaFormat3.setInteger("level", 256);
            }
            log.d("  Format: " + mediaFormat2, new Object[0]);
            encoderProperties = MediaCodecVideoEncoder.createByCodecName(encoderProperties.codecName);
        }
        {
            objectArray3.mediaCodec = encoderProperties;
            objectArray3.type = videoCodecType;
            if (encoderProperties == null) {
                log.e("Can not create media encoder", new Object[0]);
                objectArray3.release();
                return false;
            }
            encoderProperties.configure(mediaFormat2, null, null, 1);
            objectArray3.mediaCodec.start();
            objectArray3.outputBuffers = objectArray3.mediaCodec.getOutputBuffers();
            log.d("Output buffers: " + objectArray3.outputBuffers.length, new Object[0]);
            return true;
        }
    }

    private boolean setRates(int n, int n2) {
        Bundle bundle;
        MediaCodecVideoEncoder mediaCodecVideoEncoder;
        mediaCodecVideoEncoder2.checkOnMediaCodecThread();
        int n3 = n * 1000;
        if (mediaCodecVideoEncoder2.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            double d2 = n3;
            mediaCodecVideoEncoder2.bitrateAccumulatorMax = d2 / 8.0;
            int n4 = mediaCodecVideoEncoder2.targetBitrateBps;
            if (n4 > 0 && n3 < n4) {
                mediaCodecVideoEncoder2.bitrateAccumulator = mediaCodecVideoEncoder2.bitrateAccumulator * d2 / (double)n4;
            }
        }
        mediaCodecVideoEncoder2.targetBitrateBps = n3;
        mediaCodecVideoEncoder2.targetFps = n2;
        if (mediaCodecVideoEncoder2.bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT && n2 > 0) {
            n3 = n3 * 30 / n2;
            log.v("setRates: " + n + " -> " + n3 / 1000 + " kbps. Fps: " + mediaCodecVideoEncoder2.targetFps, new Object[0]);
        } else if (mediaCodecVideoEncoder2.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            log.v("setRates: " + n + " kbps. Fps: " + mediaCodecVideoEncoder2.targetFps + ". ExpScale: " + mediaCodecVideoEncoder2.bitrateAdjustmentScaleExp, new Object[0]);
            n = mediaCodecVideoEncoder2.bitrateAdjustmentScaleExp;
            if (n != 0) {
                n3 = (int)((double)n3 * mediaCodecVideoEncoder2.getBitrateScale(n));
            }
        } else {
            log.v("setRates: " + n + " kbps. Fps: " + mediaCodecVideoEncoder2.targetFps, new Object[0]);
        }
        try {
            mediaCodecVideoEncoder = mediaCodecVideoEncoder2;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("setRates failed", objectArray2);
            return false;
        }
        MediaCodecVideoEncoder mediaCodecVideoEncoder2 = bundle;
        new Bundle().putInt("video-bitrate", n3);
        mediaCodecVideoEncoder.mediaCodec.setParameters((Bundle)mediaCodecVideoEncoder2);
        return true;
    }

    private double getBitrateScale(int n) {
        double d2 = (double)n / 20.0;
        return Math.pow(4.0, d2);
    }

    private void reportEncodedFrame(int n) {
        int n2 = this.targetFps;
        if (n2 != 0 && this.bitrateAdjustmentType == BitrateAdjustmentType.DYNAMIC_ADJUSTMENT) {
            double d2;
            MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
            double d3 = (double)mediaCodecVideoEncoder.targetBitrateBps / ((double)n2 * 8.0);
            d3 = mediaCodecVideoEncoder.bitrateAccumulator + ((double)n - d3);
            MediaCodecVideoEncoder mediaCodecVideoEncoder2 = this;
            mediaCodecVideoEncoder2.bitrateAccumulator = d3;
            double d4 = n2;
            mediaCodecVideoEncoder2.bitrateObservationTimeMs += 1000.0 / d4;
            d4 = mediaCodecVideoEncoder2.bitrateAccumulatorMax * 3.0;
            this.bitrateAccumulator = d2 = Math.min(d3, d4);
            mediaCodecVideoEncoder.bitrateAccumulator = Math.max(d2, -d4);
            if (mediaCodecVideoEncoder.bitrateObservationTimeMs > 3000.0) {
                double d5;
                double d6;
                log.d("Acc: " + (int)this.bitrateAccumulator + ". Max: " + (int)this.bitrateAccumulatorMax + ". ExpScale: " + this.bitrateAdjustmentScaleExp, new Object[0]);
                n = 0;
                d4 = this.bitrateAccumulator;
                d2 = this.bitrateAccumulatorMax;
                if (d6 > d5) {
                    n = (int)(d4 / d2 + 0.5);
                    this.bitrateAdjustmentScaleExp -= n;
                    this.bitrateAccumulator = d2;
                    n = 1;
                } else if (d4 < -d2) {
                    n = (int)(-d4 / d2 + 0.5);
                    this.bitrateAdjustmentScaleExp += n;
                    this.bitrateAccumulator = -d2;
                    n = 1;
                }
                if (n != 0) {
                    MediaCodecVideoEncoder mediaCodecVideoEncoder3 = this;
                    this.bitrateAdjustmentScaleExp = Math.min(mediaCodecVideoEncoder3.bitrateAdjustmentScaleExp, 20);
                    mediaCodecVideoEncoder3.bitrateAdjustmentScaleExp = Math.max(this.bitrateAdjustmentScaleExp, -20);
                    MediaCodecVideoEncoder mediaCodecVideoEncoder4 = this;
                    log.d("Adjusting bitrate scale to " + this.bitrateAdjustmentScaleExp + ". Value: " + mediaCodecVideoEncoder4.getBitrateScale(mediaCodecVideoEncoder4.bitrateAdjustmentScaleExp), new Object[0]);
                    n = mediaCodecVideoEncoder3.targetBitrateBps / 1000;
                    mediaCodecVideoEncoder3.setRates(n, mediaCodecVideoEncoder3.targetFps);
                }
                this.bitrateObservationTimeMs = 0.0;
            }
            return;
        }
    }

    private static List<Integer> createIntList(int[] nArray) {
        Vector<Integer> vector;
        Vector<Integer> vector2 = vector;
        vector = new Vector<Integer>(nArray.length);
        int n = nArray.length;
        for (int i2 = 0; i2 < n; ++i2) {
            vector2.add(nArray[i2]);
        }
        return vector2;
    }

    static {
        SupportedEncoderRecord supportedEncoderRecord;
        SupportedEncoderRecord supportedEncoderRecord2;
        SupportedEncoderRecord supportedEncoderRecord3;
        HashMap<String, Integer> hashMap;
        SupportedEncoderRecord supportedEncoderRecord4;
        SupportedEncoderRecord supportedEncoderRecord5;
        SupportedEncoderRecord supportedEncoderRecord6;
        SupportedEncoderRecord supportedEncoderRecord7;
        log = OtLog.LogToken("[MediaCodecEncoder]");
        runningInstance = null;
        errorCallback = null;
        codecErrors = 0;
        hwEncoderDisabledTypes = new HashSet<String>();
        VP8_SUPPORT = new SupportedEncoderRecord[0];
        SupportedEncoderRecord[] supportedEncoderRecordArray = new SupportedEncoderRecord[2];
        SupportedEncoderRecord supportedEncoderRecord8 = supportedEncoderRecord7;
        SupportedEncoderRecord.Priority priority = SupportedEncoderRecord.Priority.HARDWARE;
        BitrateAdjustmentType bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        supportedEncoderRecord7 = new SupportedEncoderRecord("OMX.qcom.", 24, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray[0] = supportedEncoderRecord8;
        supportedEncoderRecord8 = supportedEncoderRecord6;
        priority = SupportedEncoderRecord.Priority.HARDWARE;
        bitrateAdjustmentType = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
        supportedEncoderRecord6 = new SupportedEncoderRecord("OMX.Exynos.", 24, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray[1] = supportedEncoderRecord8;
        VP9_SUPPORT = supportedEncoderRecordArray;
        SupportedEncoderRecord[] supportedEncoderRecordArray2 = new SupportedEncoderRecord[5];
        supportedEncoderRecord8 = supportedEncoderRecord5;
        priority = SupportedEncoderRecord.Priority.HARDWARE;
        bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        supportedEncoderRecord5 = new SupportedEncoderRecord("OMX.qcom.", 19, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray2[0] = supportedEncoderRecord8;
        supportedEncoderRecord8 = supportedEncoderRecord4;
        priority = SupportedEncoderRecord.Priority.HARDWARE;
        bitrateAdjustmentType = BitrateAdjustmentType.FRAMERATE_ADJUSTMENT;
        HashMap<String, Integer> hashMap2 = hashMap;
        hashMap = new HashMap<String, Integer>(){
            {
                1 v0 = this;
                v0.put("HighProfile", 23);
            }
        };
        supportedEncoderRecord4 = new SupportedEncoderRecord("OMX.Exynos.", 21, priority, bitrateAdjustmentType, (Map<String, Integer>)hashMap2);
        supportedEncoderRecordArray2[1] = supportedEncoderRecord8;
        supportedEncoderRecord8 = supportedEncoderRecord3;
        priority = SupportedEncoderRecord.Priority.HARDWARE;
        bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        supportedEncoderRecord3 = new SupportedEncoderRecord("OMX.IMG.", 19, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray2[2] = supportedEncoderRecord8;
        supportedEncoderRecord8 = supportedEncoderRecord2;
        priority = SupportedEncoderRecord.Priority.HARDWARE;
        bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        supportedEncoderRecord2 = new SupportedEncoderRecord("OMX.MTK.", 19, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray2[3] = supportedEncoderRecord8;
        supportedEncoderRecord8 = supportedEncoderRecord;
        priority = SupportedEncoderRecord.Priority.SOFTWARE;
        bitrateAdjustmentType = BitrateAdjustmentType.NO_ADJUSTMENT;
        supportedEncoderRecord = new SupportedEncoderRecord("OMX.google.h264.", 23, priority, bitrateAdjustmentType, null);
        supportedEncoderRecordArray2[4] = supportedEncoderRecord8;
        H264_SUPPORT = supportedEncoderRecordArray2;
        SupportedEncoderTbl = new SparseArray<Pair<String, SupportedEncoderRecord[]>>(){
            {
                2 v0 = this;
                v0.append(VideoCodecType.VIDEO_CODEC_VP8.ordinal(), new Pair((Object)MediaCodecVideoEncoder.VP8_MIME_TYPE, (Object)VP8_SUPPORT));
                v0.append(VideoCodecType.VIDEO_CODEC_VP9.ordinal(), new Pair((Object)MediaCodecVideoEncoder.VP9_MIME_TYPE, (Object)VP9_SUPPORT));
                v0.append(VideoCodecType.VIDEO_CODEC_H264.ordinal(), new Pair((Object)MediaCodecVideoEncoder.H264_MIME_TYPE, (Object)H264_SUPPORT));
            }
        };
        KeyFrameIntervalSecTbl = new SparseIntArray(){
            {
                3 v0 = this;
                v0.append(VideoCodecType.VIDEO_CODEC_VP8.ordinal(), 100);
                v0.append(VideoCodecType.VIDEO_CODEC_VP9.ordinal(), 100);
                v0.append(VideoCodecType.VIDEO_CODEC_H264.ordinal(), 20);
            }
        };
        H264_BLACKLIST = new String[]{"SAMSUNG-SGH-I337", "Nexus 7", "Nexus 4"};
        supportedColorList = new int[]{19, 21, 2141391872, 2141391876};
        supportedSurfaceColorList = new int[]{2130708361};
    }

    boolean initEncode(VideoCodecType videoCodecType, int n, int n2, int n3, int n4, int n5, EglBase14.Context context) {
        block5: {
            block6: {
                OtLog.LogToken logToken = log;
                EncoderProperties[] encoderPropertiesArray = new StringBuilder().append("Java initEncode: ").append((Object)videoCodecType).append(". Profile: ").append(n).append(" : ").append(n2).append(" x ").append(n3).append(". @ ").append(n4).append(" kbps. Fps: ").append(n5).append(". Encode from texture : ");
                boolean bl = context != null;
                logToken.d(encoderPropertiesArray.append(bl).toString(), new Object[0]);
                if (this.mediaCodecThread != null) break block5;
                logToken = (Pair)SupportedEncoderTbl.get(videoCodecType.ordinal());
                encoderPropertiesArray = (String)((Pair)logToken).first;
                SupportedEncoderRecord[] supportedEncoderRecordArray = (SupportedEncoderRecord[])((Pair)logToken).second;
                int[] nArray = context != null ? supportedSurfaceColorList : supportedColorList;
                if ((encoderPropertiesArray = MediaCodecVideoEncoder.findHwEncoder((String)encoderPropertiesArray, supportedEncoderRecordArray, nArray)) == null || encoderPropertiesArray.length == 0) break block6;
                MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
                this.profile = n;
                this.width = n2;
                this.height = n3;
                runningInstance = this;
                this.bitrateAccumulator = 0.0;
                this.bitrateObservationTimeMs = 0.0;
                this.bitrateAdjustmentScaleExp = 0;
                mediaCodecVideoEncoder.targetBitrateBps = n = n4 * 1000;
                mediaCodecVideoEncoder.bitrateAccumulatorMax = (double)n / 8.0;
                mediaCodecVideoEncoder.mediaCodecThread = Thread.currentThread();
                for (EncoderProperties encoderProperties : encoderPropertiesArray) {
                    block7: {
                        block8: {
                            block9: {
                                this.colorFormat = encoderProperties.colorFormat;
                                BitrateAdjustmentType bitrateAdjustmentType = encoderProperties.bitrateAdjustmentType;
                                MediaCodecVideoEncoder mediaCodecVideoEncoder2 = this;
                                mediaCodecVideoEncoder2.bitrateAdjustmentType = bitrateAdjustmentType;
                                mediaCodecVideoEncoder2.lastKeyFrameMs = -1L;
                                mediaCodecVideoEncoder2.forcedKeyFrameMs = 0L;
                                n4 = bitrateAdjustmentType == BitrateAdjustmentType.FRAMERATE_ADJUSTMENT ? 30 : Math.min(n5, 30);
                                this.targetFps = n4;
                                if (videoCodecType != VideoCodecType.VIDEO_CODEC_VP8 || !encoderProperties.codecName.startsWith("OMX.qcom.")) break block7;
                                n4 = Build.VERSION.SDK_INT;
                                if (n4 == 21 || n4 == 22) break block8;
                                if (n4 != 23) break block9;
                                this.forcedKeyFrameMs = 20000L;
                                break block7;
                            }
                            if (n4 <= 23) break block7;
                        }
                        this.forcedKeyFrameMs = 15000L;
                    }
                    log.d("Color format: " + this.colorFormat + ". Bitrate adjustment: " + (Object)((Object)this.bitrateAdjustmentType) + ". Key frame interval: " + this.forcedKeyFrameMs + " . Initial fps: " + n5, new Object[0]);
                    if (this.initEncoder(videoCodecType, encoderProperties, context, (String)((Pair)logToken).first)) {
                        log.d("[h.264] using encoder: " + encoderProperties.codecName, new Object[0]);
                        return true;
                    }
                    this.mediaCodecThread = Thread.currentThread();
                    log.d("[h.264] encoder init failed: " + encoderProperties.codecName, new Object[0]);
                }
                return false;
            }
            throw new RuntimeException("Can not find HW encoder for " + (Object)((Object)videoCodecType));
        }
        throw new RuntimeException("Forgot to release()?");
    }

    ByteBuffer[] getInputBuffers() {
        ByteBuffer[] byteBufferArray = byteBufferArray.mediaCodec.getInputBuffers();
        log.d("Input buffers: " + byteBufferArray.length, new Object[0]);
        return byteBufferArray;
    }

    void checkKeyFrameRequired(boolean bl, long l2) {
        long l3;
        l2 = (l2 + 500L) / 1000L;
        if (mediaCodecVideoEncoder3.lastKeyFrameMs < 0L) {
            mediaCodecVideoEncoder3.lastKeyFrameMs = l2;
        }
        boolean bl2 = false;
        if (!bl && (l3 = mediaCodecVideoEncoder3.forcedKeyFrameMs) > 0L && l2 > mediaCodecVideoEncoder3.lastKeyFrameMs + l3) {
            bl2 = true;
        }
        if (bl || bl2) {
            Bundle bundle;
            if (bl) {
                log.d("Sync frame request", new Object[0]);
            } else {
                log.d("Sync frame forced", new Object[0]);
            }
            MediaCodecVideoEncoder mediaCodecVideoEncoder = mediaCodecVideoEncoder3;
            MediaCodecVideoEncoder mediaCodecVideoEncoder2 = mediaCodecVideoEncoder3;
            MediaCodecVideoEncoder mediaCodecVideoEncoder3 = bundle;
            new Bundle().putInt("request-sync", 0);
            mediaCodecVideoEncoder2.mediaCodec.setParameters((Bundle)mediaCodecVideoEncoder3);
            mediaCodecVideoEncoder.lastKeyFrameMs = l2;
        }
    }

    boolean encodeBuffer(boolean bl, int n, int n2, long l2) {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        this.checkOnMediaCodecThread();
        try {
            mediaCodecVideoEncoder.checkKeyFrameRequired(bl, l2);
            mediaCodecVideoEncoder.mediaCodec.queueInputBuffer(n, 0, n2, l2, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("encodeBuffer failed", objectArray2);
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    boolean encodeTexture(boolean bl, int n, float[] fArray, long l2) {
        int n2;
        MediaCodecVideoEncoder mediaCodecVideoEncoder;
        MediaCodecVideoEncoder mediaCodecVideoEncoder2;
        MediaCodecVideoEncoder mediaCodecVideoEncoder3;
        void v3;
        void v2;
        int n3;
        GlRectDrawer glRectDrawer;
        void var4_9;
        MediaCodecVideoEncoder mediaCodecVideoEncoder4 = this;
        this.checkOnMediaCodecThread();
        try {
            void n4;
            mediaCodecVideoEncoder4.checkKeyFrameRequired(bl, (long)var4_9);
            mediaCodecVideoEncoder4.eglBase.makeCurrent();
            GLES20.glClear((int)16384);
            glRectDrawer = mediaCodecVideoEncoder4.drawer;
            v2 = n3;
            v3 = n4;
            MediaCodecVideoEncoder mediaCodecVideoEncoder5 = this;
            mediaCodecVideoEncoder3 = mediaCodecVideoEncoder5;
            mediaCodecVideoEncoder2 = mediaCodecVideoEncoder5;
            mediaCodecVideoEncoder = mediaCodecVideoEncoder5;
            n2 = mediaCodecVideoEncoder5.width;
        }
        catch (RuntimeException runtimeException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = runtimeException;
            log.e("encodeTexture failed", objectArray2);
            return false;
        }
        int objectArray2 = mediaCodecVideoEncoder3.height;
        n3 = 0;
        int n4 = 0;
        int n5 = mediaCodecVideoEncoder2.width;
        int n6 = mediaCodecVideoEncoder.height;
        glRectDrawer.drawOes((int)v2, (float[])v3, n2, objectArray2, n3, n4, n5, n6);
        mediaCodecVideoEncoder4.eglBase.swapBuffers(TimeUnit.MICROSECONDS.toNanos((long)var4_9));
        return true;
    }

    void release() {
        CountDownLatch countDownLatch;
        CaughtException caughtException;
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        log.d("Java releaseEncoder", new Object[0]);
        mediaCodecVideoEncoder.checkOnMediaCodecThread();
        final CaughtException caughtException2 = caughtException;
        class CaughtException {
            Exception e;

            CaughtException() {
            }
        }
        caughtException = new CaughtException();
        boolean bl = false;
        if (mediaCodecVideoEncoder.mediaCodec != null) {
            Runnable runnable;
            CountDownLatch countDownLatch2;
            countDownLatch = countDownLatch2;
            countDownLatch2 = new CountDownLatch(1);
            Runnable runnable2 = runnable;
            runnable = new Runnable(){
                {
                }

                @Override
                public void run() {
                    Object[] objectArray;
                    log.d("Java releaseEncoder on release thread", new Object[0]);
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.stop();
                    }
                    catch (Exception exception) {
                        Object[] objectArray2 = new Object[1];
                        objectArray = objectArray2;
                        objectArray2[0] = exception;
                        log.e("Media encoder stop failed", objectArray);
                    }
                    try {
                        MediaCodecVideoEncoder.this.mediaCodec.release();
                    }
                    catch (Exception exception) {
                        Object[] objectArray3 = new Object[1];
                        objectArray = objectArray3;
                        objectArray3[0] = exception;
                        log.e("Media encoder release failed", objectArray);
                        caughtException2.e = exception;
                    }
                    log.d("Java releaseEncoder on release thread done", new Object[0]);
                    countDownLatch.countDown();
                }
            };
            new Thread(runnable2).start();
            if (!ThreadUtils.awaitUninterruptibly((CountDownLatch)countDownLatch2, (long)5000L)) {
                log.e("Media encoder release timeout", new Object[0]);
                bl = true;
            }
            this.mediaCodec = null;
        }
        this.mediaCodecThread = null;
        countDownLatch = this.drawer;
        if (countDownLatch != null) {
            countDownLatch.release();
            this.drawer = null;
        }
        if ((countDownLatch = this.eglBase) != null) {
            countDownLatch.release();
            this.eglBase = null;
        }
        if ((countDownLatch = this.inputSurface) != null) {
            countDownLatch.release();
            this.inputSurface = null;
        }
        runningInstance = null;
        if (bl) {
            ++codecErrors;
            if (errorCallback != null) {
                log.e("Invoke codec error callback. Errors: " + codecErrors, new Object[0]);
                errorCallback.onMediaCodecVideoEncoderCriticalError(codecErrors);
            }
            throw new RuntimeException("Media encoder release timeout.");
        }
        if (caughtException2.e == null) {
            log.d("Java releaseEncoder done", new Object[0]);
            return;
        }
        throw new RuntimeException(caughtException2.e);
    }

    int dequeueInputBuffer() {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        mediaCodecVideoEncoder.checkOnMediaCodecThread();
        try {
            return mediaCodecVideoEncoder.mediaCodec.dequeueInputBuffer(0L);
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("dequeueIntputBuffer failed", objectArray2);
            return -2;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    OutputBufferInfo dequeueOutputBuffer() {
        block42: {
            block41: {
                block38: {
                    v0 = this;
                    v0.checkOnMediaCodecThread();
                    var1_2 = v1;
                    v1 = new MediaCodec.BufferInfo();
                    var2_4 = v0.mediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)var1_2, 0L);
                    if (var2_4 < 0) break block38;
                    if (!((var1_2.flags & 2) != 0)) break block38;
                    v2 = this;
                    v3 = v2;
                    v4 = v2;
                    MediaCodecVideoEncoder.log.d("Config frame generated. Offset: " + var1_2.offset + ". Size: " + var1_2.size, new Object[0]);
                    v2.configData = ByteBuffer.allocateDirect(var1_2.size);
                    v2.outputBuffers[var2_4].position(var1_2.offset);
                    v5 = v3.outputBuffers[var2_4];
                    v6 = var1_2.offset + var1_2.size;
                    v5.limit(v6);
                    v4.configData.put(this.outputBuffers[var2_4]);
                    var3_5 = "";
                    var4_6 = false;
                    while (true) {
                        block40: {
                            block39: {
                                if (var1_2.size >= 8) break block39;
                                var5_7 = var1_2.size;
                                break block40;
                            }
                            var5_7 = 8 != 0;
                        }
                        if (var4_6 >= var5_7) break;
                        v7 = new StringBuilder().append((String)var3_5);
                        v8 = this.configData.get((int)var4_6);
                        var3_5 = v7.append(Integer.toHexString(v8 & 255)).append(" ").toString();
                        var4_6 += 1;
                        continue;
                        break;
                    }
                    try {
                        v9 = this;
                        MediaCodecVideoEncoder.log.d((String)var3_5, new Object[0]);
                        v9.mediaCodec.releaseOutputBuffer(var2_4, false);
                        var2_4 = v9.mediaCodec.dequeueOutputBuffer((MediaCodec.BufferInfo)var1_2, 0L);
                    }
                    catch (IllegalStateException var0_1) {
                        v10 = new Object[1];
                        var1_2 = v10;
                        v10[0] = var0_1;
                        MediaCodecVideoEncoder.log.e("dequeueOutputBuffer failed", var1_2);
                        return new OutputBufferInfo(-1, null, false, -1L);
                    }
                }
                if (var2_4 < 0) break block42;
                v11 = var1_2;
                v12 = this;
                v13 = var1_2;
                var3_5 = this.outputBuffers[var2_4].duplicate();
                v14 = var1_2;
                var3_5.position(var1_2.offset);
                v15 = v14.offset + var1_2.size;
                var3_5.limit(v15);
                v12.reportEncodedFrame(v13.size);
                var4_6 = (v11.flags & 1) != 0;
                if (!var4_6) break block41;
                v16 = MediaCodecVideoEncoder.log;
                v16.d("Sync frame generated", new Object[0]);
            }
            if (!var4_6) ** GOTO lbl108
            if (this.type != VideoCodecType.VIDEO_CODEC_H264) ** GOTO lbl108
            MediaCodecVideoEncoder.log.d("Appending config frame of size " + this.configData.capacity() + " to output buffer with offset " + var1_2.offset + ", size " + var1_2.size, new Object[0]);
            v17 = this.configData.capacity() + var1_2.size;
            var5_8 = ByteBuffer.allocateDirect(v17);
            v18 = var3_5;
            v19 = var5_8;
            v20 = this;
            v21 = v20;
            v20.configData.rewind();
            v19.put(v21.configData);
            var5_8.put((ByteBuffer)v18);
            var5_8.position(0);
            return new OutputBufferInfo(var2_4, var5_8, var4_6, var1_2.presentationTimeUs);
lbl108:
            // 2 sources

            v22 = v23;
            v24 = v23;
            v25 = var2_4;
            v26 = var1_2;
            this = var3_5.slice();
            var1_3 = v26.presentationTimeUs;
            v22(v25, this, var4_6, var1_3);
            return v24;
        }
        if (var2_4 == -3) {
            v27 = this;
            v27.outputBuffers = v27.mediaCodec.getOutputBuffers();
            return v27.dequeueOutputBuffer();
        }
        if (var2_4 == -2) {
            return this.dequeueOutputBuffer();
        }
        if (var2_4 == -1) {
            return null;
        }
        throw new RuntimeException("dequeueOutputBuffer: " + var2_4);
    }

    boolean releaseOutputBuffer(int n) {
        MediaCodecVideoEncoder mediaCodecVideoEncoder = this;
        mediaCodecVideoEncoder.checkOnMediaCodecThread();
        try {
            mediaCodecVideoEncoder.mediaCodec.releaseOutputBuffer(n, false);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = illegalStateException;
            log.e("releaseOutputBuffer failed", objectArray2);
            return false;
        }
    }

    static class OutputBufferInfo {
        public final int index;
        public final ByteBuffer buffer;
        public final boolean isKeyFrame;
        public final long presentationTimestampUs;

        public OutputBufferInfo(int n, ByteBuffer byteBuffer, boolean bl, long l2) {
            this.index = n;
            this.buffer = byteBuffer;
            this.isKeyFrame = bl;
            this.presentationTimestampUs = l2;
        }
    }

    public static class EncoderProperties {
        public final String codecName;
        public final int colorFormat;
        public final BitrateAdjustmentType bitrateAdjustmentType;
        public final Map<String, Integer> meta;

        public EncoderProperties(String string, int n, BitrateAdjustmentType bitrateAdjustmentType, Map<String, Integer> map) {
            this.codecName = string;
            this.colorFormat = n;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
            this.meta = map;
        }
    }

    public static interface MediaCodecVideoEncoderErrorCallback {
        public void onMediaCodecVideoEncoderCriticalError(int var1);
    }

    private static class SupportedEncoderRecord {
        public final String prefix;
        public final int supportedVersion;
        public final Priority priority;
        public final Map<String, Integer> meta;
        public final BitrateAdjustmentType bitrateAdjustmentType;

        public SupportedEncoderRecord(String string, int n, Priority priority, BitrateAdjustmentType bitrateAdjustmentType, Map<String, Integer> hashMap) {
            this.prefix = string;
            this.supportedVersion = n;
            this.priority = priority;
            this.bitrateAdjustmentType = bitrateAdjustmentType;
            if (hashMap == null) {
                HashMap hashMap2;
                hashMap = hashMap2;
                hashMap2 = new HashMap();
            }
            this.meta = hashMap;
        }

        public static final class Priority
        extends Enum<Priority> {
            public static final /* enum */ Priority HARDWARE;
            public static final /* enum */ Priority SOFTWARE;
            private static final /* synthetic */ Priority[] $VALUES;
            private final int priority;

            public static Priority[] values() {
                return (Priority[])$VALUES.clone();
            }

            public static Priority valueOf(String string) {
                return Enum.valueOf(Priority.class, string);
            }

            private Priority(int n2) {
                this.priority = n2;
            }

            static {
                Priority priority;
                HARDWARE = new Priority(100);
                Priority priority2 = priority;
                SOFTWARE = new Priority(10);
                $VALUES = new Priority[]{HARDWARE, priority2};
            }
        }
    }

    public static final class H264Profile
    extends Enum<H264Profile> {
        public static final /* enum */ H264Profile CONSTRAINED_BASELINE;
        public static final /* enum */ H264Profile BASELINE;
        public static final /* enum */ H264Profile MAIN;
        public static final /* enum */ H264Profile CONSTRAINED_HIGH;
        public static final /* enum */ H264Profile HIGH;
        private static final /* synthetic */ H264Profile[] $VALUES;
        private final int value;

        public static H264Profile[] values() {
            return (H264Profile[])$VALUES.clone();
        }

        public static H264Profile valueOf(String string) {
            return Enum.valueOf(H264Profile.class, string);
        }

        private H264Profile(int n2) {
            this.value = n2;
        }

        static {
            H264Profile h264Profile;
            CONSTRAINED_BASELINE = new H264Profile(0);
            BASELINE = new H264Profile(1);
            MAIN = new H264Profile(2);
            CONSTRAINED_HIGH = new H264Profile(3);
            H264Profile h264Profile2 = h264Profile;
            HIGH = new H264Profile(4);
            $VALUES = new H264Profile[]{CONSTRAINED_BASELINE, BASELINE, MAIN, CONSTRAINED_HIGH, h264Profile2};
        }

        public int getValue() {
            return this.value;
        }
    }

    public static final class BitrateAdjustmentType
    extends Enum<BitrateAdjustmentType> {
        public static final /* enum */ BitrateAdjustmentType NO_ADJUSTMENT;
        public static final /* enum */ BitrateAdjustmentType FRAMERATE_ADJUSTMENT;
        public static final /* enum */ BitrateAdjustmentType DYNAMIC_ADJUSTMENT;
        private static final /* synthetic */ BitrateAdjustmentType[] $VALUES;

        public static BitrateAdjustmentType[] values() {
            return (BitrateAdjustmentType[])$VALUES.clone();
        }

        public static BitrateAdjustmentType valueOf(String string) {
            return Enum.valueOf(BitrateAdjustmentType.class, string);
        }

        static {
            BitrateAdjustmentType bitrateAdjustmentType;
            NO_ADJUSTMENT = new BitrateAdjustmentType();
            FRAMERATE_ADJUSTMENT = new BitrateAdjustmentType();
            BitrateAdjustmentType bitrateAdjustmentType2 = bitrateAdjustmentType;
            DYNAMIC_ADJUSTMENT = new BitrateAdjustmentType();
            $VALUES = new BitrateAdjustmentType[]{NO_ADJUSTMENT, FRAMERATE_ADJUSTMENT, bitrateAdjustmentType2};
        }
    }

    public static final class VideoCodecType
    extends Enum<VideoCodecType> {
        public static final /* enum */ VideoCodecType VIDEO_CODEC_GENERIC;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP8;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_VP9;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_AV1;
        public static final /* enum */ VideoCodecType VIDEO_CODEC_H264;
        private static final /* synthetic */ VideoCodecType[] $VALUES;

        public static VideoCodecType[] values() {
            return (VideoCodecType[])$VALUES.clone();
        }

        public static VideoCodecType valueOf(String string) {
            return Enum.valueOf(VideoCodecType.class, string);
        }

        static {
            VideoCodecType videoCodecType;
            VIDEO_CODEC_GENERIC = new VideoCodecType();
            VIDEO_CODEC_VP8 = new VideoCodecType();
            VIDEO_CODEC_VP9 = new VideoCodecType();
            VIDEO_CODEC_AV1 = new VideoCodecType();
            VideoCodecType videoCodecType2 = videoCodecType;
            VIDEO_CODEC_H264 = new VideoCodecType();
            $VALUES = new VideoCodecType[]{VIDEO_CODEC_GENERIC, VIDEO_CODEC_VP8, VIDEO_CODEC_VP9, VIDEO_CODEC_AV1, videoCodecType2};
        }
    }
}

