/*
 * Decompiled with CFR 0.152.
 */
package com.opentok.android;

import com.opentok.impl.a;

public class OpentokError {
    protected Domain errorDomain;
    protected ErrorCode errorCode;
    protected String errorMessage;
    protected Exception exception;

    public OpentokError(Domain domain, int n, String string) {
        if (string == null) {
            string = "(null description)";
        }
        this.errorMessage = string;
        this.errorDomain = domain;
        this.errorCode = ErrorCode.fromTypeCode(n);
    }

    public OpentokError(Domain domain, int n, Exception exception) {
        this.errorMessage = "(null description)";
        this.errorDomain = domain;
        this.errorCode = ErrorCode.fromTypeCode(n);
        this.exception = exception;
        if (exception == null) {
            this.errorMessage = a.a(n);
        }
    }

    public Domain getErrorDomain() {
        return this.errorDomain;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.errorMessage;
    }

    public Exception getException() {
        return this.exception;
    }

    public static final class Domain
    extends Enum<Domain> {
        public static final /* enum */ Domain SessionErrorDomain;
        public static final /* enum */ Domain PublisherErrorDomain;
        public static final /* enum */ Domain SubscriberErrorDomain;
        private static final /* synthetic */ Domain[] $VALUES;

        public static Domain[] values() {
            return (Domain[])$VALUES.clone();
        }

        public static Domain valueOf(String string) {
            return Enum.valueOf(Domain.class, string);
        }

        static {
            Domain domain;
            SessionErrorDomain = new Domain();
            PublisherErrorDomain = new Domain();
            Domain domain2 = domain;
            SubscriberErrorDomain = new Domain();
            $VALUES = new Domain[]{SessionErrorDomain, PublisherErrorDomain, domain2};
        }
    }

    public static final class ErrorCode
    extends Enum<ErrorCode> {
        public static final /* enum */ ErrorCode UnknownError;
        public static final /* enum */ ErrorCode AuthorizationFailure;
        public static final /* enum */ ErrorCode InvalidSessionId;
        public static final /* enum */ ErrorCode ConnectionFailed;
        public static final /* enum */ ErrorCode NoMessagingServer;
        public static final /* enum */ ErrorCode ConnectionRefused;
        public static final /* enum */ ErrorCode SessionStateFailed;
        public static final /* enum */ ErrorCode P2PSessionMaxParticipants;
        public static final /* enum */ ErrorCode SessionConnectionTimeout;
        public static final /* enum */ ErrorCode SessionInternalError;
        public static final /* enum */ ErrorCode SessionInvalidSignalType;
        public static final /* enum */ ErrorCode SessionSignalDataTooLong;
        public static final /* enum */ ErrorCode SessionSignalTypeTooLong;
        public static final /* enum */ ErrorCode SessionUnableToForceMute;
        public static final /* enum */ ErrorCode ConnectionDropped;
        public static final /* enum */ ErrorCode SessionDisconnected;
        public static final /* enum */ ErrorCode PublisherInternalError;
        public static final /* enum */ ErrorCode PublisherWebRTCError;
        public static final /* enum */ ErrorCode PublisherUnableToPublish;
        public static final /* enum */ ErrorCode PublisherUnexpectedPeerConnectionDisconnection;
        public static final /* enum */ ErrorCode PublisherCannotAccessCamera;
        public static final /* enum */ ErrorCode PublisherCameraAccessDenied;
        public static final /* enum */ ErrorCode ConnectionTimedOut;
        public static final /* enum */ ErrorCode SubscriberWebRTCError;
        public static final /* enum */ ErrorCode SubscriberServerCannotFindStream;
        public static final /* enum */ ErrorCode SubscriberStreamLimitExceeded;
        public static final /* enum */ ErrorCode SubscriberInternalError;
        public static final /* enum */ ErrorCode UnknownPublisherInstance;
        public static final /* enum */ ErrorCode UnknownSubscriberInstance;
        public static final /* enum */ ErrorCode SessionNullOrInvalidParameter;
        public static final /* enum */ ErrorCode VideoCaptureFailed;
        public static final /* enum */ ErrorCode CameraFailed;
        public static final /* enum */ ErrorCode VideoRenderFailed;
        public static final /* enum */ ErrorCode SessionSubscriberNotFound;
        public static final /* enum */ ErrorCode SessionPublisherNotFound;
        public static final /* enum */ ErrorCode PublisherTimeout;
        public static final /* enum */ ErrorCode SessionBlockedCountry;
        public static final /* enum */ ErrorCode SessionConnectionLimitExceeded;
        public static final /* enum */ ErrorCode SessionUnexpectedGetSessionInfoResponse;
        public static final /* enum */ ErrorCode SessionIllegalState;
        private static final /* synthetic */ ErrorCode[] $VALUES;
        private int code;

        public static ErrorCode[] values() {
            return (ErrorCode[])$VALUES.clone();
        }

        public static ErrorCode valueOf(String string) {
            return Enum.valueOf(ErrorCode.class, string);
        }

        private ErrorCode(int n2) {
            this.code = n2;
        }

        public static ErrorCode fromTypeCode(int n) {
            for (ErrorCode errorCode : ErrorCode.values()) {
                if (errorCode.getErrorCode() != n) continue;
                return errorCode;
            }
            return UnknownError;
        }

        static {
            ErrorCode errorCode;
            UnknownError = new ErrorCode(-1);
            AuthorizationFailure = new ErrorCode(1004);
            InvalidSessionId = new ErrorCode(1005);
            ConnectionFailed = new ErrorCode(1006);
            NoMessagingServer = new ErrorCode(1503);
            ConnectionRefused = new ErrorCode(1023);
            SessionStateFailed = new ErrorCode(1020);
            P2PSessionMaxParticipants = new ErrorCode(1403);
            SessionConnectionTimeout = new ErrorCode(1021);
            SessionInternalError = new ErrorCode(2000);
            SessionInvalidSignalType = new ErrorCode(1461);
            SessionSignalDataTooLong = new ErrorCode(1413);
            SessionSignalTypeTooLong = new ErrorCode(1414);
            SessionUnableToForceMute = new ErrorCode(1540);
            ConnectionDropped = new ErrorCode(1022);
            SessionDisconnected = new ErrorCode(1010);
            PublisherInternalError = new ErrorCode(2000);
            PublisherWebRTCError = new ErrorCode(1610);
            PublisherUnableToPublish = new ErrorCode(1500);
            PublisherUnexpectedPeerConnectionDisconnection = new ErrorCode(1710);
            PublisherCannotAccessCamera = new ErrorCode(1650);
            PublisherCameraAccessDenied = new ErrorCode(1670);
            ConnectionTimedOut = new ErrorCode(1542);
            SubscriberWebRTCError = new ErrorCode(1600);
            SubscriberServerCannotFindStream = new ErrorCode(1604);
            SubscriberStreamLimitExceeded = new ErrorCode(1605);
            SubscriberInternalError = new ErrorCode(2000);
            UnknownPublisherInstance = new ErrorCode(2003);
            UnknownSubscriberInstance = new ErrorCode(2004);
            SessionNullOrInvalidParameter = new ErrorCode(1011);
            VideoCaptureFailed = new ErrorCode(3000);
            CameraFailed = new ErrorCode(3010);
            VideoRenderFailed = new ErrorCode(4000);
            SessionSubscriberNotFound = new ErrorCode(1112);
            SessionPublisherNotFound = new ErrorCode(1113);
            PublisherTimeout = new ErrorCode(1541);
            SessionBlockedCountry = new ErrorCode(1026);
            SessionConnectionLimitExceeded = new ErrorCode(1027);
            SessionUnexpectedGetSessionInfoResponse = new ErrorCode(2001);
            ErrorCode errorCode2 = errorCode;
            SessionIllegalState = new ErrorCode(1015);
            $VALUES = new ErrorCode[]{UnknownError, AuthorizationFailure, InvalidSessionId, ConnectionFailed, NoMessagingServer, ConnectionRefused, SessionStateFailed, P2PSessionMaxParticipants, SessionConnectionTimeout, SessionInternalError, SessionInvalidSignalType, SessionSignalDataTooLong, SessionSignalTypeTooLong, SessionUnableToForceMute, ConnectionDropped, SessionDisconnected, PublisherInternalError, PublisherWebRTCError, PublisherUnableToPublish, PublisherUnexpectedPeerConnectionDisconnection, PublisherCannotAccessCamera, PublisherCameraAccessDenied, ConnectionTimedOut, SubscriberWebRTCError, SubscriberServerCannotFindStream, SubscriberStreamLimitExceeded, SubscriberInternalError, UnknownPublisherInstance, UnknownSubscriberInstance, SessionNullOrInvalidParameter, VideoCaptureFailed, CameraFailed, VideoRenderFailed, SessionSubscriberNotFound, SessionPublisherNotFound, PublisherTimeout, SessionBlockedCountry, SessionConnectionLimitExceeded, SessionUnexpectedGetSessionInfoResponse, errorCode2};
        }

        public int getErrorCode() {
            return this.code;
        }
    }
}

